/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import com.uhf.api.cls.JniModuleAPI;

public class Reader {
    public static final int MAXANTCNT = 16;
    public static final int MAXIPSTRLEN = 50;
    public static final int HOPTABLECNT = 100;
    public static final int MAXEPCBYTESCNT = 62;
    public static final int MAXEMBDATALEN = 128;
    public static final int MAXINVPOTLSCNT = 6;
    JniModuleAPI japi;
    int[] hReader = new int[1];

    public Reader() {
        this.japi = new JniModuleAPI();
    }

    public void Hex2Str(byte[] buf, int len, char[] out) {
        char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = 0;
        while (i < len) {
            out[i * 2] = hexc[(buf[i] & 0xFF) / 16];
            out[i * 2 + 1] = hexc[(buf[i] & 0xFF) % 16];
            ++i;
        }
    }

    private char[] bytestochars(byte[] bdata) {
        char[] cdata = new char[bdata.length];
        int i = 0;
        while (i < bdata.length) {
            cdata[i] = (char)bdata[i];
            ++i;
        }
        return cdata;
    }

    private byte[] charstobytes(char[] cdata) {
        if (cdata == null) {
            return null;
        }
        int len = 0;
        int i = 0;
        while (i < cdata.length) {
            if (cdata[i] == '\u0000') break;
            ++len;
            ++i;
        }
        byte[] bdata = new byte[len];
        i = 0;
        while (i < len) {
            bdata[i] = (byte)cdata[i];
            ++i;
        }
        return bdata;
    }

    public READER_ERR InitReader(String src, Reader_Type rtype) {
        int re = this.japi.InitReader(this.hReader, src, rtype.value());
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR InitReader_Notype(String src, int rtype) {
        int re = this.japi.InitReader_Notype(this.hReader, src, rtype);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public void CloseReader() {
        this.japi.CloseReader(this.hReader[0]);
    }

    public READER_ERR GetTagData(int ant, char bank, int address, int blkcnt, byte[] data, byte[] accesspasswd, short timeout) {
        int re = this.japi.GetTagData(this.hReader[0], ant, bank, address, blkcnt, data, accesspasswd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR WriteTagData(int ant, char bank, int address, byte[] data, int datalen, byte[] accesspasswd, short timeout) {
        int re = this.japi.WriteTagData(this.hReader[0], ant, bank, address, data, datalen, accesspasswd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR WriteTagEpcEx(int ant, byte[] Epc, int epclen, byte[] accesspwd, short timeout) {
        int re = this.japi.WriteTagEpcEx(this.hReader[0], ant, Epc, epclen, accesspwd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR TagInventory(int[] ants, int antcnt, short timeout, TAGINFO[] pTInfo, int[] tagcnt) {
        int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
        READER_ERR ERR = READER_ERR.valueOf(re);
        if (ERR == READER_ERR.MT_OK_ERR) {
            int i = 0;
            while (i < tagcnt[0]) {
                TAGINFO pTInfoa = new TAGINFO();
                READER_ERR er = this.GetNextTag(pTInfoa);
                if (er == READER_ERR.MT_OK_ERR) {
                    pTInfo[i] = pTInfoa;
                }
                ++i;
            }
        }
        return ERR;
    }

    public READER_ERR TagInventory_Raw(int[] ants, int antcnt, short timeout, int[] tagcnt) {
        int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR TagInventory_BaseType(int[] ants, int antcnt, short timeout, char[] outbuf, int[] tagcnt) {
        int re = this.japi.TagInventory_BaseType(this.hReader[0], ants, antcnt, timeout, outbuf, tagcnt);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR GetNextTag(TAGINFO TI) {
        byte[] tagbuf = new byte[230];
        int pos = 0;
        int re = this.japi.GetNextTag_BaseType(this.hReader[0], tagbuf);
        READER_ERR ERR = READER_ERR.valueOf(re);
        if (ERR == READER_ERR.MT_OK_ERR) {
            TI.ReadCnt = tagbuf[pos++];
            TI.RSSI = tagbuf[pos++];
            TI.AntennaID = tagbuf[pos++];
            TI.Frequency = tagbuf[pos] << 24 | tagbuf[pos + 1] << 16 | tagbuf[pos + 2] << 8 | tagbuf[pos + 3];
            TI.TimeStamp = tagbuf[pos += 4] << 24 | tagbuf[pos + 1] << 16 | tagbuf[pos + 2] << 8 | tagbuf[pos + 3];
            pos += 4;
            TI.Res[0] = tagbuf[pos++];
            TI.Res[1] = tagbuf[pos++];
            int epclen = tagbuf[pos] << 8 | tagbuf[pos + 1];
            pos += 2;
            TI.PC[0] = tagbuf[pos++];
            TI.PC[1] = tagbuf[pos++];
            TI.EpcId = new byte[epclen];
            System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
            pos += epclen;
            TI.CRC[0] = tagbuf[pos++];
            TI.CRC[1] = tagbuf[pos++];
            int emddatalen = tagbuf[pos] << 8 | tagbuf[pos + 1];
            pos += 2;
            TI.EmbededData = new byte[emddatalen];
            if (emddatalen > 0) {
                System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
            }
        }
        return ERR;
    }

    public READER_ERR GetNextTag_BaseType(byte[] outbuf) {
        int re = this.japi.GetNextTag_BaseType(this.hReader[0], outbuf);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR LockTag(int ant, byte lockobjects, short locktypes, byte[] accesspasswd, short timeout) {
        int re = this.japi.LockTag(this.hReader[0], ant, lockobjects, locktypes, accesspasswd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR KillTag(int ant, byte[] killpasswd, short timeout) {
        int re = this.japi.KillTag(this.hReader[0], ant, killpasswd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR Lock180006BTag(int ant, int startblk, int blkcnt, short timeout) {
        int re = this.japi.Lock180006BTag(this.hReader[0], ant, startblk, blkcnt, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR BlockPermaLock(int ant, int readlock, int startblk, int blkrange, byte[] mask, byte[] pwd, short timeout) {
        int re = this.japi.BlockPermaLock(this.hReader[0], ant, readlock, startblk, blkrange, mask, pwd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR BlockErase(int ant, int bank, int wordaddr, int wordcnt, byte[] pwd, short timeout) {
        int re = this.japi.BlockErase(this.hReader[0], ant, bank, wordaddr, wordcnt, pwd, timeout);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR EraseDataOnReader() {
        int re = this.japi.EraseDataOnReader(this.hReader[0]);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR SaveDataOnReader(int address, byte[] data, int datalen) {
        int re = this.japi.SaveDataOnReader(this.hReader[0], address, data, datalen);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR ReadDataOnReader(int address, byte[] data, int datalen) {
        int re = this.japi.ReadDataOnReader(this.hReader[0], address, data, datalen);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR CustomCmd(int ant, CustomCmdType cmdtype, Object CustomPara, Object CustomRet) {
        byte[] para = null;
        byte[] ret = null;
        switch (cmdtype) {
            case IMPINJ_M4_Qt: {
                Object CustomPara2 = (IMPINJM4QtPara)CustomPara;
                para = new byte[10];
                ret = new byte[10];
                System.arraycopy(((IMPINJM4QtPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                para[4] = (byte)((IMPINJM4QtPara)CustomPara2).CmdType;
                para[5] = (byte)((IMPINJM4QtPara)CustomPara2).MemType;
                para[6] = (byte)((IMPINJM4QtPara)CustomPara2).PersistType;
                para[7] = (byte)((IMPINJM4QtPara)CustomPara2).RangeType;
                para[8] = (byte)((((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                para[9] = (byte)(((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF);
                break;
            }
            case ALIEN_Higgs3_BlockReadLock: {
                para = new byte[7];
                ret = new byte[7];
                Object CustomPara2 = (ALIENHiggs3BlockReadLockPara)CustomPara;
                System.arraycopy(((ALIENHiggs3BlockReadLockPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                para[4] = ((ALIENHiggs3BlockReadLockPara)CustomPara2).BlkBits;
                para[5] = (byte)((((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                para[6] = (byte)(((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF);
                break;
            }
            case NXP_ChangeEAS: {
                para = new byte[7];
                ret = new byte[7];
                Object CustomPara2 = (NXPChangeEASPara)CustomPara;
                System.arraycopy(((NXPChangeEASPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                para[4] = (byte)((NXPChangeEASPara)CustomPara2).isSet;
                para[5] = (byte)((((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                para[6] = (byte)(((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF);
                break;
            }
            case NXP_EASAlarm: {
                para = new byte[5];
                ret = new byte[5];
                Object CustomPara2 = (NXPEASAlarmPara)CustomPara;
                para[0] = ((NXPEASAlarmPara)CustomPara2).DR;
                ((NXPEASAlarmPara)CustomPara2).MC = (byte)11;
                para[1] = 11;
                para[2] = ((NXPEASAlarmPara)CustomPara2).TrExt;
                para[3] = (byte)((((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                para[4] = (byte)(((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF);
            }
        }
        int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype.ordinal(), para, ret);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR CustomCmd_BaseType(int ant, int cmdtype, byte[] CustomPara, byte[] CustomRet) {
        int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype, CustomPara, CustomRet);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR SetGPO(int gpoid, int val) {
        int re = this.japi.SetGPO(this.hReader[0], gpoid, val);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR GetGPI(int gpoid, int[] val) {
        int re = this.japi.GetGPI(this.hReader[0], gpoid, val);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR ParamGet(Mtr_Param key, Object val) {
        int re = -1;
        switch (key) {
            case MTR_PARAM_RF_ANTPOWER: {
                Object[] data = new byte[81];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((AntPowerConf)val).antcnt = data[0];
                int i = 0;
                while (i < data[0]) {
                    AntPower apcf = new AntPower();
                    apcf.antid = data[i * 5 + 1];
                    apcf.readPower = (short)(data[i * 5 + 2] << 8 | data[i * 5 + 3] & 0xFF);
                    apcf.writePower = (short)(data[i * 5 + 4] << 8 | data[i * 5 + 5] & 0xFF);
                    ((AntPowerConf)val).Powers[i] = apcf;
                    ++i;
                }
                break;
            }
            case MTR_PARAM_TAG_FILTER: {
                Object[] data = new byte[266];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((TagFilter_ST)val).bank = data[0];
                ((TagFilter_ST)val).startaddr = (data[1] & 0xFF) << 24 | data[2] << 16 | data[3] << 8 | data[4] & 0xFF;
                ((TagFilter_ST)val).flen = data[5] << 24 | data[6] << 16 | data[7] << 8 | data[8] & 0xFF;
                System.arraycopy(data, 9, ((TagFilter_ST)val).fdata, 0, ((TagFilter_ST)val).flen);
                ((TagFilter_ST)val).isInvert = data[9 + ((TagFilter_ST)val).flen];
                break;
            }
            case MTR_PARAM_TAG_EMBEDEDDATA: {
                Object[] data = new byte[14];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((EmbededData_ST)val).bank = data[1];
                ((EmbededData_ST)val).startaddr = data[2] << 24 | data[3] << 16 | data[4] << 8 | data[5] & 0xFF;
                ((EmbededData_ST)val).bytecnt = data[6] << 24 | data[7] << 16 | data[8] << 8 | data[9] & 0xFF;
                if (data[0] != 14) break;
                System.arraycopy(data, 10, ((EmbededData_ST)val).accesspwd, 0, 4);
                break;
            }
            case MTR_PARAM_TAG_INVPOTL: {
                Object[] data = new byte[31];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((Inv_Potls_ST)val).potlcnt = data[0];
                ((Inv_Potls_ST)val).potls = new Inv_Potl[data[0]];
                int i = 0;
                while (i < data[0]) {
                    ((Inv_Potls_ST)val).potls[i] = new Inv_Potl();
                    ((Inv_Potls_ST)val).potls[i].potl = SL_TagProtocol.valueOf(data[i * 5 + 1]);
                    ((Inv_Potls_ST)val).potls[i].weight = data[i * 5 + 1] << 24 | data[i * 5 + 2] << 16 | data[i * 5 + 3] << 8 | data[i * 5 + 4] & 0xFF;
                    ++i;
                }
                break;
            }
            case MTR_PARAM_READER_CONN_ANTS: {
                Object[] data = new byte[17];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((ConnAnts_ST)val).antcnt = data[0];
                int i = 0;
                while (i < data[0]) {
                    ((ConnAnts_ST)val).connectedants[i] = data[i + 1];
                    ++i;
                }
                break;
            }
            case MTR_PARAM_FREQUENCY_REGION: {
                Object[] data = new int[1];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((Region_Conf[])val)[0] = Region_Conf.valueOf(data[0]);
                break;
            }
            case MTR_PARAM_FREQUENCY_HOPTABLE: {
                Object[] data = new byte[401];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((HoptableData_ST)val).lenhtb = data[0];
                int i = 0;
                while (i < data[0]) {
                    ((HoptableData_ST)val).htb[i] = (data[i * 4 + 1] & 0xFF) << 24 | (data[i * 4 + 2] & 0xFF) << 16 | (data[i * 4 + 3] & 0xFF) << 8 | data[i * 4 + 4] & 0xFF;
                    ++i;
                }
                break;
            }
            case MTR_PARAM_TAG_EMDSECUREREAD: {
                Object[] data = new int[8];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((EmbededSecureRead_ST)val).tagtype = data[0];
                ((EmbededSecureRead_ST)val).pwdtype = data[1];
                ((EmbededSecureRead_ST)val).ApIndexStartBitsInEpc = data[2];
                ((EmbededSecureRead_ST)val).ApIndexBitsNumInEpc = data[3];
                ((EmbededSecureRead_ST)val).bank = data[4];
                ((EmbededSecureRead_ST)val).address = data[5];
                ((EmbededSecureRead_ST)val).blkcnt = data[6];
                ((EmbededSecureRead_ST)val).accesspwd = data[7];
                break;
            }
            case MTR_PARAM_READER_IP: {
                Object[] data = new byte[48];
                re = this.japi.ParamGet(this.hReader[0], key.value(), data);
                if (re != 0) break;
                ((Reader_Ip)val).ip = new byte[data[0]];
                ((Reader_Ip)val).mask = new byte[data[1]];
                ((Reader_Ip)val).gateway = new byte[data[2]];
                System.arraycopy(data, 3, ((Reader_Ip)val).ip, 0, data[0]);
                System.arraycopy(data, 3 + data[0], ((Reader_Ip)val).mask, 0, data[1]);
                System.arraycopy(data, 3 + data[0] + data[1], ((Reader_Ip)val).gateway, 0, data[2]);
                break;
            }
            default: {
                re = this.japi.ParamGet(this.hReader[0], key.value(), val);
            }
        }
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public READER_ERR ParamSet(Mtr_Param key, Object val) {
        int re = -1;
        switch (key) {
            case MTR_PARAM_RF_ANTPOWER: {
                byte[] data = new byte[81];
                data[0] = (byte)((AntPowerConf)val).antcnt;
                int i = 0;
                while (i < data[0]) {
                    data[i * 5 + 1] = (byte)((AntPowerConf)val).Powers[i].antid;
                    data[i * 5 + 2] = (byte)((((AntPowerConf)val).Powers[i].readPower & 0xFF00) >> 8);
                    data[i * 5 + 3] = (byte)(((AntPowerConf)val).Powers[i].readPower & 0xFF);
                    data[i * 5 + 4] = (byte)((((AntPowerConf)val).Powers[i].writePower & 0xFF00) >> 8);
                    data[i * 5 + 5] = (byte)(((AntPowerConf)val).Powers[i].writePower & 0xFF);
                    ++i;
                }
                re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                break;
            }
            case MTR_PARAM_TAG_FILTER: {
                if ((TagFilter_ST)val != null) {
                    byte[] data = new byte[266];
                    data[0] = (byte)((TagFilter_ST)val).bank;
                    data[1] = (byte)((((TagFilter_ST)val).startaddr & 0xFF000000) >> 24);
                    data[2] = (byte)((((TagFilter_ST)val).startaddr & 0xFF0000) >> 16);
                    data[3] = (byte)((((TagFilter_ST)val).startaddr & 0xFF00) >> 8);
                    data[4] = (byte)(((TagFilter_ST)val).startaddr & 0xFF);
                    data[5] = (byte)((((TagFilter_ST)val).flen & 0xFF000000) >> 24);
                    data[6] = (byte)((((TagFilter_ST)val).flen & 0xFF0000) >> 16);
                    data[7] = (byte)((((TagFilter_ST)val).flen & 0xFF00) >> 8);
                    data[8] = (byte)(((TagFilter_ST)val).flen & 0xFF);
                    System.arraycopy(((TagFilter_ST)val).fdata, 0, data, 9, ((TagFilter_ST)val).flen);
                    data[9 + ((TagFilter_ST)val).flen] = (byte)((TagFilter_ST)val).isInvert;
                    re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                    break;
                }
                re = this.japi.ParamSet(this.hReader[0], key.value(), null);
                break;
            }
            case MTR_PARAM_TAG_EMBEDEDDATA: {
                if ((EmbededData_ST)val != null) {
                    byte[] data = new byte[14];
                    data[0] = ((EmbededData_ST)val).accesspwd == null ? 10 : 14;
                    data[1] = (byte)((EmbededData_ST)val).bank;
                    data[2] = (byte)((((EmbededData_ST)val).startaddr & 0xFF000000) >> 24);
                    data[3] = (byte)((((EmbededData_ST)val).startaddr & 0xFF0000) >> 16);
                    data[4] = (byte)((((EmbededData_ST)val).startaddr & 0xFF00) >> 8);
                    data[5] = (byte)(((EmbededData_ST)val).startaddr & 0xFF);
                    data[6] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF000000) >> 24);
                    data[7] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF0000) >> 16);
                    data[8] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF00) >> 8);
                    data[9] = (byte)(((EmbededData_ST)val).bytecnt & 0xFF);
                    if (((EmbededData_ST)val).accesspwd != null) {
                        System.arraycopy(((EmbededData_ST)val).accesspwd, 0, data, 10, 4);
                    }
                    re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                    break;
                }
                re = this.japi.ParamSet(this.hReader[0], key.value(), null);
                break;
            }
            case MTR_PARAM_TAG_INVPOTL: {
                byte[] data = new byte[31];
                data[0] = (byte)((Inv_Potls_ST)val).potlcnt;
                int i = 0;
                while (i < data[0]) {
                    data[i * 5 + 1] = (byte)((Inv_Potls_ST)val).potls[i].potl.value();
                    data[i * 5 + 2] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF000000) >> 24);
                    data[i * 5 + 3] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF0000) >> 16);
                    data[i * 5 + 4] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF00) >> 8);
                    data[i * 5 + 5] = (byte)(((Inv_Potls_ST)val).potls[i].weight & 0xFF);
                    ++i;
                }
                re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                break;
            }
            case MTR_PARAM_FREQUENCY_REGION: {
                byte[] data = new byte[]{(byte)((Region_Conf)((Object)val)).ordinal()};
                re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                break;
            }
            case MTR_PARAM_FREQUENCY_HOPTABLE: {
                byte[] data = new byte[((HoptableData_ST)val).lenhtb * 4 + 1];
                data[0] = (byte)((HoptableData_ST)val).lenhtb;
                int i = 0;
                while (i < data[0]) {
                    data[i * 4 + 1] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF000000) >> 24);
                    data[i * 4 + 2] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF0000) >> 16);
                    data[i * 4 + 3] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF00) >> 8);
                    data[i * 4 + 4] = (byte)(((HoptableData_ST)val).htb[i] & 0xFF);
                    ++i;
                }
                re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                break;
            }
            case MTR_PARAM_TAG_EMDSECUREREAD: {
                if ((EmbededSecureRead_ST)val == null) {
                    re = this.japi.ParamSet(this.hReader[0], key.value(), null);
                    break;
                }
                int[] data = new int[]{((EmbededSecureRead_ST)val).tagtype, ((EmbededSecureRead_ST)val).pwdtype, ((EmbededSecureRead_ST)val).ApIndexStartBitsInEpc, ((EmbededSecureRead_ST)val).ApIndexBitsNumInEpc, ((EmbededSecureRead_ST)val).bank, ((EmbededSecureRead_ST)val).address, ((EmbededSecureRead_ST)val).blkcnt, ((EmbededSecureRead_ST)val).accesspwd};
                re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                break;
            }
            case MTR_PARAM_READER_IP: {
                int ipl = ((Reader_Ip)val).ip.length;
                int ml = ((Reader_Ip)val).mask.length;
                int gl = ((Reader_Ip)val).gateway.length;
                byte[] data = new byte[3 + ipl + ml + gl];
                data[0] = (byte)ipl;
                data[1] = (byte)ml;
                data[2] = (byte)gl;
                System.arraycopy(((Reader_Ip)val).ip, 0, data, 3, ipl);
                System.arraycopy(((Reader_Ip)val).mask, 0, data, 3 + ipl, ml);
                System.arraycopy(((Reader_Ip)val).ip, 0, data, 3 + ipl + ml, gl);
                re = this.japi.ParamSet(this.hReader[0], key.value(), data);
                break;
            }
            default: {
                re = this.japi.ParamSet(this.hReader[0], key.value(), val);
            }
        }
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public static String bytes_Hexstr(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public void Str2Hex(String buf, int len, byte[] hexbuf) {
        String chex = "0123456789ABCDEF";
        if (len % 2 != 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            byte hnx = (byte)chex.indexOf(buf.toUpperCase().substring(i, i + 1));
            byte lnx = (byte)chex.indexOf(buf.toUpperCase().substring(i + 1, i + 2));
            hexbuf[i / 2] = (byte)(hnx << 4 & 0xFF | lnx & 0xFF);
            i += 2;
        }
    }

    public void Str2Binary(String buf, int len, byte[] binarybuf) {
        if (len % 8 != 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            byte temp = 0;
            int j = 0;
            while (j < 8) {
                temp = (byte)(temp | (byte)(Byte.parseByte(buf.substring(i + j, i + j + 1)) << 7 - j));
                ++j;
            }
            int n = i / 8;
            binarybuf[n] = (byte)(binarybuf[n] | temp);
            i += 8;
        }
    }

    public class ALIENHiggs3BlockReadLockPara {
        public byte[] AccessPwd = new byte[4];
        public byte BlkBits;
        public short TimeOut;
    }

    public class AntLinkVSWR {
        public int andid;
        public float vswr;
    }

    public class AntPortsVSWR {
        public int antcnt;
        public AntLinkVSWR[] AntVSWRS = new AntLinkVSWR[16];
    }

    public class AntPower {
        public int antid;
        public short readPower;
        public short writePower;
    }

    public class AntPowerConf {
        public int antcnt;
        public AntPower[] Powers = new AntPower[16];
    }

    public class ConnAnts_ST {
        public int antcnt;
        public int[] connectedants = new int[16];
    }

    public static enum CustomCmdType {
        NXP_SetReadProtect(0),
        NXP_ResetReadProtect(1),
        NXP_ChangeEAS(2),
        NXP_EASAlarm(3),
        NXP_Calibrate(4),
        ALIEN_Higgs2_PartialLoadImage(5),
        ALIEN_Higgs2_FullLoadImage(6),
        ALIEN_Higgs3_FastLoadImage(7),
        ALIEN_Higgs3_LoadImage(8),
        ALIEN_Higgs3_BlockReadLock(9),
        ALIEN_Higgs3_BlockPermaLock(10),
        IMPINJ_M4_Qt(11);

        private int value = 0;

        private CustomCmdType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static CustomCmdType valueOf(String string) {
            return Enum.valueOf(CustomCmdType.class, string);
        }
    }

    public class EmbededData_ST {
        public int bank;
        public int startaddr;
        public int bytecnt;
        public byte[] accesspwd;
    }

    public class EmbededSecureRead_ST {
        public int tagtype;
        public int pwdtype;
        public int ApIndexStartBitsInEpc;
        public int ApIndexBitsNumInEpc;
        public int bank;
        public int address;
        public int blkcnt;
        public int accesspwd;
    }

    public class HardwareDetails {
        public Module_Type module;
        public MaindBoard_Type board;
        public Reader_Type logictype;
    }

    public class HoptableData_ST {
        public int[] htb = new int[100];
        public int lenhtb;
    }

    public class IMPINJM4QtPara {
        public byte[] AccessPwd = new byte[4];
        public int CmdType;
        public int MemType;
        public int PersistType;
        public int RangeType;
        public short TimeOut;
    }

    public class IMPINJM4QtResult {
        public int MemType;
        public int RangeType;
    }

    public class Inv_Potl {
        public SL_TagProtocol potl;
        public int weight;
    }

    public class Inv_Potls_ST {
        public int potlcnt;
        public Inv_Potl[] potls = new Inv_Potl[6];
    }

    public static enum Lock_Obj {
        LOCK_OBJECT_KILL_PASSWORD(1),
        LOCK_OBJECT_ACCESS_PASSWD(2),
        LOCK_OBJECT_BANK1(4),
        LOCK_OBJECT_BANK2(8),
        LOCK_OBJECT_BANK3(16);

        int p_v;

        private Lock_Obj(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Type {
        KILL_PASSWORD_UNLOCK(0),
        KILL_PASSWORD_LOCK(512),
        KILL_PASSWORD_PERM_LOCK(768),
        ACCESS_PASSWD_UNLOCK(0),
        ACCESS_PASSWD_LOCK(128),
        ACCESS_PASSWD_PERM_LOCK(192),
        BANK1_UNLOCK(0),
        BANK1_LOCK(32),
        BANK1_PERM_LOCK(48),
        BANK2_UNLOCK(0),
        BANK2_LOCK(8),
        BANK2_PERM_LOCK(12),
        BANK3_UNLOCK(0),
        BANK3_LOCK(2),
        BANK3_PERM_LOCK(3);

        int p_v;

        private Lock_Type(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum MaindBoard_Type {
        MAINBOARD_NONE,
        MAINBOARD_ARM7,
        MAINBOARD_SERIAL,
        MAINBOARD_WIFI,
        MAINBOARD_ARM9,
        MAINBOARD_ARM9_WIFI;

    }

    public static enum Module_Type {
        MODOULE_NONE(0),
        MODOULE_R902_M1S(1),
        MODOULE_R902_M2S(2),
        MODOULE_M5E(3),
        MODOULE_M5E_C(4),
        MODOULE_M6E(5),
        MODOULE_PR9000(6),
        MODOULE_M5E_PRC(7),
        MODOULE_M6E_PRC(8),
        MODOULE_M6E_MICRO(9),
        MODOULE_SLR1100(10),
        MODOULE_SLR1200(11),
        MODOULE_SLR1300(12),
        MODOULE_SLR3000(13),
        MODOULE_SLR5100(14),
        MODOULE_SLR5200(15);

        private int value = 0;

        private Module_Type(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Module_Type valueOf(String string) {
            return Enum.valueOf(Module_Type.class, string);
        }
    }

    public static enum Mtr_Param {
        MTR_PARAM_POTL_GEN2_SESSION(0),
        MTR_PARAM_POTL_GEN2_Q(1),
        MTR_PARAM_POTL_GEN2_TAGENCODING(2),
        MTR_PARAM_POTL_GEN2_MAXEPCLEN(3),
        MTR_PARAM_RF_ANTPOWER(4),
        MTR_PARAM_RF_MAXPOWER(5),
        MTR_PARAM_RF_MINPOWER(6),
        MTR_PARAM_TAG_FILTER(7),
        MTR_PARAM_TAG_EMBEDEDDATA(8),
        MTR_PARAM_TAG_INVPOTL(9),
        MTR_PARAM_READER_CONN_ANTS(10),
        MTR_PARAM_READER_AVAILABLE_ANTPORTS(11),
        MTR_PARAM_READER_IS_CHK_ANT(12),
        MTR_PARAM_READER_VERSION(13),
        MTR_PARAM_READER_IP(14),
        MTR_PARAM_FREQUENCY_REGION(15),
        MTR_PARAM_FREQUENCY_HOPTABLE(16),
        MTR_PARAM_POTL_GEN2_BLF(17),
        MTR_PARAM_POTL_GEN2_WRITEMODE(18),
        MTR_PARAM_POTL_GEN2_TARGET(19),
        MTR_PARAM_TAGDATA_UNIQUEBYANT(20),
        MTR_PARAM_TAGDATA_UNIQUEBYEMDDATA(21),
        MTR_PARAM_TAGDATA_RECORDHIGHESTRSSI(22),
        MTR_PARAM_RF_TEMPERATURE(23),
        MTR_PARAM_RF_HOPTIME(24),
        MTR_PARAM_RF_LBT_ENABLE(25),
        MTR_PARAM_RF_SUPPORTEDREGIONS(26),
        MTR_PARAM_POTL_SUPPORTEDPROTOCOLS(27),
        MTR_PARAM_POTL_ISO180006B_BLF(28),
        MTR_PARAM_POTL_GEN2_TARI(29),
        MTR_PARAM_TRANS_TIMEOUT(30),
        MTR_PARAM_TAG_EMDSECUREREAD(31),
        MTR_PARAM_TRANSMIT_MODE(32),
        MTR_PARAM_POWERSAVE_MODE(33),
        MTR_PARAM_TAG_SEARCH_MODE(34),
        MTR_PARAM_POTL_ISO180006B_MODULATION_DEPTH(35),
        MTR_PARAM_POTL_ISO180006B_DELIMITER(36),
        MTR_PARAM_MAXINDEX(37);

        private int value = 0;

        private Mtr_Param(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Mtr_Param valueOf(String string) {
            return Enum.valueOf(Mtr_Param.class, string);
        }
    }

    public class NXPChangeEASPara {
        public byte[] AccessPwd = new byte[4];
        public int isSet;
        public short TimeOut;
    }

    public class NXPEASAlarmPara {
        public byte DR;
        public byte MC;
        public byte TrExt;
        public short TimeOut;
    }

    public class NXPEASAlarmResult {
        public byte[] EASdata = new byte[8];
    }

    public static enum READER_ERR {
        MT_OK_ERR(0),
        MT_IO_ERR(1),
        MT_INTERNAL_DEV_ERR(2),
        MT_CMD_FAILED_ERR(3),
        MT_CMD_NO_TAG_ERR(4),
        MT_M5E_FATAL_ERR(5),
        MT_OP_NOT_SUPPORTED(6),
        MT_INVALID_PARA(7),
        MT_INVALID_READER_HANDLE(8),
        MT_HARDWARE_ALERT_ERR_BY_HIGN_RETURN_LOSS(9),
        MT_HARDWARE_ALERT_ERR_BY_TOO_MANY_RESET(10),
        MT_HARDWARE_ALERT_ERR_BY_NO_ANTENNAS(11),
        MT_HARDWARE_ALERT_ERR_BY_HIGH_TEMPERATURE(12),
        MT_HARDWARE_ALERT_ERR_BY_READER_DOWN(13),
        MT_HARDWARE_ALERT_ERR_BY_UNKNOWN_ERR(14),
        M6E_INIT_FAILED(15),
        MT_OP_EXECING(16),
        MT_UNKNOWN_READER_TYPE(17),
        MT_OP_INVALID(18),
        MT_HARDWARE_ALERT_BY_FAILED_RESET_MODLUE(19),
        MT_MAX_ERR_NUM(20),
        MT_MAX_INT_NUM(21);

        private int value = 0;

        private READER_ERR(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static READER_ERR valueOf(String string) {
            return Enum.valueOf(READER_ERR.class, string);
        }
    }

    public class Reader_Ip {
        public byte[] ip;
        public byte[] mask;
        public byte[] gateway;
    }

    public static enum Reader_Type {
        MODULE_TWO_ANTS(0),
        MODULE_FOUR_ANTS(1),
        MODULE_THREE_ANTS(3),
        MODULE_ONE_ANT(4),
        PR9000(5),
        MODULE_ARM7_TWO_ANTS(6),
        MODULE_ARM7_FOUR_ANTS(7),
        M6E_ARM7_FOUR_ANTS(8),
        M56_ARM7_FOUR_ANTS(9),
        R902_M1S(10),
        R902_M2S(11),
        ARM7_16ANTS(12),
        SL_COMMN_READER(13);

        private int value = 0;

        private Reader_Type(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Reader_Type valueOf(String string) {
            return Enum.valueOf(Reader_Type.class, string);
        }
    }

    public class Reader_Ver {
        public char[] ver = new char[50];
    }

    public static enum Region_Conf {
        RG_NONE(0),
        RG_NA(1),
        RG_EU(2),
        RG_EU2(7),
        RG_EU3(8),
        RG_KR(3),
        RG_PRC(6),
        RG_PRC2(10),
        RG_OPEN(255);

        int p_v;

        private Region_Conf(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static Region_Conf valueOf(String string) {
            return Enum.valueOf(Region_Conf.class, string);
        }
    }

    public static enum SL_TagProtocol {
        SL_TAG_PROTOCOL_NONE(0),
        SL_TAG_PROTOCOL_ISO180006B(3),
        SL_TAG_PROTOCOL_GEN2(5),
        SL_TAG_PROTOCOL_ISO180006B_UCODE(6),
        SL_TAG_PROTOCOL_IPX64(7),
        SL_TAG_PROTOCOL_IPX256(8);

        int p_v;

        private SL_TagProtocol(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static SL_TagProtocol valueOf(String string) {
            return Enum.valueOf(SL_TagProtocol.class, string);
        }
    }

    public class TAGINFO
    implements Cloneable {
        public byte AntennaID;
        public int Frequency;
        public int TimeStamp;
        public short EmbededDatalen;
        public byte[] EmbededData = new byte[128];
        public byte[] Res = new byte[2];
        public short Epclen;
        public byte[] PC = new byte[2];
        public byte[] CRC = new byte[2];
        public byte[] EpcId = new byte[62];
        public int Phase;
        public SL_TagProtocol protocol;
        public int ReadCnt;
        public int RSSI;

        public Object clone() {
            TAGINFO o = null;
            try {
                o = (TAGINFO)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            return o;
        }
    }

    public class TagFilter_ST {
        public int bank;
        public int startaddr;
        public int flen;
        public byte[] fdata = new byte[255];
        public int isInvert;
    }
}

