/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.Barcode1D;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import cn.pda.serialport.SerialPort;
import com.handheld.Barcode1D.Barcode1DManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;

public class ScanThread
extends Thread {
    private SerialPort mSerialPort;
    private InputStream is;
    private OutputStream os;
    private int flags = 0;
    private Handler handler;
    private String CodedFormat = "";
    private final byte START = (byte)2;
    private final byte END = (byte)3;
    Timer mtimer = null;

    public ScanThread(Handler handler, int Port, int BaudRate, int Power, String codedformat) throws SecurityException, IOException {
        this.handler = handler;
        this.mSerialPort = new SerialPort();
        this.CodedFormat = codedformat;
        switch (Power) {
            case 2: {
                this.mSerialPort.scaner_poweron();
                break;
            }
            case 0: {
                this.mSerialPort.power3v3on();
                break;
            }
            case 1: {
                this.mSerialPort.power_5Von();
                break;
            }
            case 3: {
                this.mSerialPort.psam_poweron();
                break;
            }
            case 4: {
                this.mSerialPort.rfid_poweron();
            }
        }
        this.mSerialPort.scaner_trigoff();
        this.mSerialPort = new SerialPort(Port, BaudRate, this.flags);
        this.is = this.mSerialPort.getInputStream();
        this.os = this.mSerialPort.getOutputStream();
        this.is.read(new byte[4960]);
    }

    @Override
    public void run() {
        try {
            int size = 0;
            byte[] buffer = new byte[4096];
            int available = 0;
            while (!this.isInterrupted()) {
                available = this.is.available();
                if (available <= 0) continue;
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                size = this.is.read(buffer);
                if (size <= 1) continue;
                this.sendMessege(buffer, size, Barcode1DManager.Barcode1D);
                if (this.mtimer == null) continue;
                this.mtimer.cancel();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.run();
    }

    private void sendMessege(byte[] data, int dataLen, int mode) {
        String dataStr = "";
        if (this.CodedFormat.equals("")) {
            dataStr = new String(data, 0, dataLen);
        } else {
            try {
                dataStr = new String(data, 0, dataLen, this.CodedFormat);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString("data", dataStr);
        Message msg = new Message();
        msg.what = mode;
        msg.setData(bundle);
        this.handler.sendMessage(msg);
    }

    public void scan() {
        if (this.mtimer != null) {
            this.mtimer.cancel();
        }
        this.mtimer = new Timer();
        this.mtimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ScanThread.this.mSerialPort.scaner_trigoff();
            }
        }, 5000L);
        if (this.mSerialPort.scaner_trig_stat()) {
            this.mSerialPort.scaner_trigoff();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.mSerialPort.scaner_trigon();
    }

    public void close(int Power, int Port) {
        if (this.mSerialPort != null) {
            switch (Power) {
                case 2: {
                    this.mSerialPort.scaner_poweroff();
                    break;
                }
                case 0: {
                    this.mSerialPort.power3v3off();
                    break;
                }
                case 1: {
                    this.mSerialPort.power_5Voff();
                    break;
                }
                case 3: {
                    this.mSerialPort.psam_poweroff();
                    break;
                }
                case 4: {
                    this.mSerialPort.rfid_poweroff();
                }
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mSerialPort.close(Port);
        }
    }
}

