/*
 * Decompiled with CFR 0.152.
 */
package sdk;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utility {
    private static final Logger LOG = Logger.getLogger(Utility.class.getName());
    public static String timeFormatString = "yyyy/MM/dd HH:mm:ss";
    public static SimpleDateFormat timeFormat = new SimpleDateFormat(timeFormatString);

    public static byte[] convert2HexArray(String hexString) {
        int len = hexString.length() / 2;
        char[] chars = hexString.toCharArray();
        String[] hexes = new String[len];
        byte[] bytes = new byte[len];
        int i = 0;
        for (int j = 0; j < len; ++j) {
            hexes[j] = "" + chars[i] + chars[i + 1];
            bytes[j] = (byte)Integer.parseInt(hexes[j], 16);
            i += 2;
        }
        return bytes;
    }

    public static String bytes2HexString(byte[] b, int count) {
        String ret = "";
        for (int i = 0; i < count; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret = ret + hex.toUpperCase();
        }
        return ret;
    }

    public static String bytes2HexString(byte[] b) {
        String ret = "";
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret = ret + hex.toUpperCase();
        }
        return ret;
    }

    public static byte BYTE(int i) {
        return (byte)i;
    }

    public static boolean isHexString(String str, int bits) {
        String patten = "[abcdefABCDEF0123456789]{" + bits + "}";
        return str.matches(patten);
    }

    public static boolean isHexString(String str) {
        String patten = "[abcdefABCDEF0123456789]{1,}";
        return str.matches(patten);
    }

    public static boolean isNumber(String str) {
        String patten = "[-]{0,1}[0123456789]{0,}";
        return str.matches(patten);
    }

    public static boolean isValiadTimeString(String dateString) {
        timeFormat.setLenient(false);
        try {
            timeFormat.parse(dateString);
        }
        catch (Exception ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
            LOG.info(dateString + " bad format");
            return false;
        }
        LOG.info(dateString);
        return true;
    }

    public static void main(String[] args) {
        timeFormat.setLenient(false);
        try {
            Date date = timeFormat.parse("2012/11/0a 12:34:07");
            System.err.println(date.toLocaleString());
        }
        catch (Exception ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.err.println(Utility.isValiadTimeString("1984/10/13 19:45:40"));
    }
}

