﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using G2W_Camera_Ctrl_Net;

namespace G2W_Camera_Test_Net
{
    public partial class Form1 : Form
    {
        public G2W_Camera_Ctrl_Net.CameraCtrlNet m_cameractrl;
        public int nselectcam = 0;
        public Form1()
        {
            InitializeComponent();
            m_cameractrl = new CameraCtrlNet();
            button_flashon.Enabled = false;
            button_flashoff.Enabled = false;
            button_take_picture.Enabled = false;
            button_start_record.Enabled = false;
            button_stop_record.Enabled = false;
            button_preview_stop.Enabled = false;
            comboBox2_type.SelectedIndex = 0;
            comboBox_resolution.SelectedIndex = 3;
        }

        private void button_preview_start_Click(object sender, EventArgs e)
        {
            m_cameractrl.G2W_Camera_Ctrl_Init_Net(pictureBox1.Handle, comboBox2_type.SelectedIndex);
            m_cameractrl.G2W_Camera_Ctrl_SetResolution_Net((CameraCtrlNet._CAM_RESOLUTION_BACK)comboBox_resolution.SelectedIndex+1);
            m_cameractrl.G2W_Camera_Ctrl_StartPreview_Net();
            button_flashon.Enabled = true;
            button_preview_stop.Enabled = true;
            button_preview_start.Enabled = false;
            button_take_picture.Enabled = true;
            button_start_record.Enabled = true;

            comboBox_resolution.Enabled = false;
            comboBox2_type.Enabled = false;


        }
        

        private void button_preview_stop_Click(object sender, EventArgs e)
        {
            m_cameractrl.G2W_Camera_Ctrl_StopPreveiw_Net();
            m_cameractrl.G2W_Camera_Ctrl_DeInit_Net();

            button_flashon.Enabled = false;
            button_flashoff.Enabled = false;
            button_take_picture.Enabled = false;
            button_start_record.Enabled = false;
            button_stop_record.Enabled = false;
            button_preview_stop.Enabled = false;
            button_preview_start.Enabled = true;

            comboBox_resolution.Enabled = true;
            comboBox2_type.Enabled = true;
        }

        private void button_take_picture_Click(object sender, EventArgs e)
        {
           
            m_cameractrl.G2W_Camera_Ctrl_TakePicture_Net(null);
            string stfilename;
            byte[] filename = new byte[1024];

            m_cameractrl.G2W_Camera_Ctrl_GetFilename_Net(filename);
            stfilename = Encoding.Default.GetString(filename);
            MessageBox.Show(stfilename);


        }
       
        private void button_start_record_Click(object sender, EventArgs e)
        {
            button_start_record.Enabled = false;
            button_stop_record.Enabled = true;
            m_cameractrl.G2W_Camera_Ctrl_StartRecord_Net(null);
        }

        private void button_stop_record_Click(object sender, EventArgs e)
        {
            button_start_record.Enabled = true;
            button_stop_record.Enabled = false;
            m_cameractrl.G2W_Camera_Ctrl_StopRecord_Net();
        }

        private void button_flashon_Click(object sender, EventArgs e)
        {
            button_flashon.Enabled = false;
            button_flashoff.Enabled = true;
            m_cameractrl.G2W_Camera_Ctrl_Flash_OnNoff_Net(true);
        }

        private void button_flashoff_Click(object sender, EventArgs e)
        {
            button_flashon.Enabled = true;
            button_flashoff.Enabled = false;
            m_cameractrl.G2W_Camera_Ctrl_Flash_OnNoff_Net(false);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_cameractrl.G2W_Camera_Ctrl_Flash_OnNoff_Net(false);
            m_cameractrl.G2W_Camera_Ctrl_DeInit_Net();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_cameractrl.G2W_Camera_Ctrl_SetResolution_Net((CameraCtrlNet._CAM_RESOLUTION_BACK)comboBox_resolution.SelectedIndex);
        }

        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            nselectcam = comboBox2_type.SelectedIndex+1;
        }
    }
}
