
// G2W_Camera_TestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "G2W_Camera_Test.h"
#include "G2W_Camera_TestDlg.h"
#include "afxdialogex.h"
#include "G2W_Camera_Ctrl.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

const UINT WM_APP_CAPTURE_EVENT = WM_APP + 1;
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CG2W_Camera_TestDlg dialog



CG2W_Camera_TestDlg::CG2W_Camera_TestDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_G2W_CAMERA_TEST_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CG2W_Camera_TestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION, m_ctrl_combo_resolution);
	DDX_Control(pDX, IDC_COMBO_FRONTREAR, m_ctrl_combo_frontrear);
}

BEGIN_MESSAGE_MAP(CG2W_Camera_TestDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_MESSAGE(WM_APP_CAPTURE_EVENT, OnCaptureEvent)
	ON_BN_CLICKED(IDC_BUTTON_START_PREVIEW, &CG2W_Camera_TestDlg::OnBnClickedButtonStartPreview)
	ON_BN_CLICKED(IDC_BUTTON_STOP_PREVIEW, &CG2W_Camera_TestDlg::OnBnClickedButtonStopPreview)
	ON_BN_CLICKED(IDC_BUTTON_TAKE_PICTURE, &CG2W_Camera_TestDlg::OnBnClickedButtonTakePicture)
	ON_BN_CLICKED(IDC_BUTTON_START_RECORD, &CG2W_Camera_TestDlg::OnBnClickedButtonStartRecord)
	ON_BN_CLICKED(IDC_BUTTON_STOP_RECORD, &CG2W_Camera_TestDlg::OnBnClickedButtonStopRecord)
	ON_WM_DESTROY()
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUTION, &CG2W_Camera_TestDlg::OnCbnSelchangeComboResolution)
	
	
	ON_BN_CLICKED(IDC_BUTTON_FLASH_ON, &CG2W_Camera_TestDlg::OnBnClickedButtonFlashOn)
	ON_BN_CLICKED(IDC_BUTTON_FLASH_OFF, &CG2W_Camera_TestDlg::OnBnClickedButtonFlashOff)
	ON_CBN_SELCHANGE(IDC_COMBO_FRONTREAR, &CG2W_Camera_TestDlg::OnCbnSelchangeComboFrontrear)
END_MESSAGE_MAP()


// CG2W_Camera_TestDlg message handlers

BOOL CG2W_Camera_TestDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	InitValue();
	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

LRESULT CG2W_Camera_TestDlg::OnCaptureEvent(WPARAM wParam, LPARAM lParam)
{

	G2W_Camera_Ctrl_CameraEvent(wParam, lParam);

	return true;
}
void CG2W_Camera_TestDlg::InitValue()
{
	CString cstrData;
	TCHAR szbuf[MAX_PATH] = { 0, };
	CString cFront_rear[2];
	CString cResolution[10];

	cFront_rear[0] = "Rear";
	cFront_rear[1] = "Front";
	

	cResolution[0] = "Resolution";
	cResolution[1] = "320x240";
	cResolution[2] = "640x480";
	cResolution[3] = "800x600";
	cResolution[4] = "1280x720";
	cResolution[5] = "1280x800";
	cResolution[6] = "1600x1200";
	cResolution[7] = "1920x1680",
	cResolution[8] = "2592x1944";
	cResolution[9] = "3264x2488";

	
	int i = 0;

	for (i = 0; i < 2; i++)
	{
		
		m_ctrl_combo_frontrear.AddString(cFront_rear[i]);
		m_ctrl_combo_frontrear.SetItemData(i, i);

	}

	for (i = 0; i < 10; i++)
	{		
		m_ctrl_combo_resolution.AddString(cResolution[i]);
		m_ctrl_combo_resolution.SetItemData(i, i);

	}
	m_ctrl_combo_frontrear.SetCurSel(0);
//	G2W_Camera_Ctrl_SetChooseCam(m_ctrl_combo_frontrear.GetCurSel());
	m_ctrl_combo_resolution.SetCurSel(4);
	G2W_Camera_Ctrl_SetResolution(m_ctrl_combo_resolution.GetCurSel());
	
	GetDlgItem(IDC_BUTTON_STOP_PREVIEW)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_TAKE_PICTURE)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_START_RECORD)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_STOP_RECORD)->EnableWindow(false);
}
void CG2W_Camera_TestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CG2W_Camera_TestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CG2W_Camera_TestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CG2W_Camera_TestDlg::OnBnClickedButtonStartPreview()
{
	//Camera Init
	HWND hpreview = GetDlgItem(IDC_STATIC_PREVIEW)->m_hWnd;
	UpdateData();
	G2W_Camera_Ctrl_Init(m_hWnd, hpreview, m_ctrl_combo_frontrear.GetCurSel());
	
	G2W_Camera_Ctrl_StartPreview();

	GetDlgItem(IDC_BUTTON_START_PREVIEW)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_STOP_PREVIEW)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON_TAKE_PICTURE)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON_START_RECORD)->EnableWindow(true);

	GetDlgItem(IDC_COMBO_RESOLUTION)->EnableWindow(false);
	GetDlgItem(IDC_COMBO_FRONTREAR)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_FLASH_ON)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON_FLASH_OFF)->EnableWindow(false);
}


void CG2W_Camera_TestDlg::OnBnClickedButtonStopPreview()
{
	G2W_Camera_Ctrl_StopPreveiw();
	G2W_Camera_Ctrl_DeInit();

	GetDlgItem(IDC_BUTTON_START_PREVIEW)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON_STOP_PREVIEW)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_TAKE_PICTURE)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_START_RECORD)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_STOP_RECORD)->EnableWindow(false);

	GetDlgItem(IDC_COMBO_RESOLUTION)->EnableWindow(true);
	GetDlgItem(IDC_COMBO_FRONTREAR)->EnableWindow(true);

	GetDlgItem(IDC_STATIC_PREVIEW)->Invalidate();

	GetDlgItem(IDC_BUTTON_FLASH_ON)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_FLASH_OFF)->EnableWindow(false);
}


void CG2W_Camera_TestDlg::OnBnClickedButtonTakePicture()
{
	G2W_Camera_Ctrl_TakePicture();

	BYTE data[1024] = { 0, };
	G2W_Camera_Ctrl_GetFilename(data);

	AfxMessageBox(CString(data));
}


void CG2W_Camera_TestDlg::OnBnClickedButtonStartRecord()
{
	G2W_Camera_Ctrl_StartRecord();
	GetDlgItem(IDC_BUTTON_START_RECORD)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_STOP_RECORD)->EnableWindow(true);
	BYTE data[1024] = { 0, };
	G2W_Camera_Ctrl_GetFilename(data);

	AfxMessageBox(CString(data));
}


void CG2W_Camera_TestDlg::OnBnClickedButtonStopRecord()
{
	G2W_Camera_Ctrl_StopRecord();
	GetDlgItem(IDC_BUTTON_START_RECORD)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON_STOP_RECORD)->EnableWindow(false);
}


void CG2W_Camera_TestDlg::OnDestroy()
{
	CDialogEx::OnDestroy();
	G2W_Camera_Ctrl_Flash_OnNoff(false);
	G2W_Camera_Ctrl_DeInit();
}


void CG2W_Camera_TestDlg::OnCbnSelchangeComboResolution()
{
	UpdateData();
	G2W_Camera_Ctrl_SetResolution(m_ctrl_combo_resolution.GetCurSel());
}





void CG2W_Camera_TestDlg::OnBnClickedButtonFlashOn()
{

	G2W_Camera_Ctrl_Flash_OnNoff(true);

	GetDlgItem(IDC_BUTTON_FLASH_ON)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON_FLASH_OFF)->EnableWindow(true);

}


void CG2W_Camera_TestDlg::OnBnClickedButtonFlashOff()
{
	G2W_Camera_Ctrl_Flash_OnNoff(false);

	GetDlgItem(IDC_BUTTON_FLASH_ON)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON_FLASH_OFF)->EnableWindow(false);
}


void CG2W_Camera_TestDlg::OnCbnSelchangeComboFrontrear()
{
	if (m_ctrl_combo_frontrear.GetCurSel() == 0)
	{
		GetDlgItem(IDC_BUTTON_FLASH_ON)->EnableWindow(true);
		GetDlgItem(IDC_BUTTON_FLASH_OFF)->EnableWindow(false);
	}
	else
	{
		GetDlgItem(IDC_BUTTON_FLASH_ON)->EnableWindow(false);
		GetDlgItem(IDC_BUTTON_FLASH_OFF)->EnableWindow(false);
		
	}
}
