﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using G2W_HScan_Ctrl_Net;
namespace G2W_Hscan_Test_Net
{
    public partial class Symbologies_Form : Form
    {
        string[] arrbarcode = {		                           
	                            "Codabar",			
	                            "Code 39",
	                            "Interleaved 2of5",				
	                            "NEC 2of5",
	                            "Code 93",				//5
	                            "Straight 2of5 Industrial",   
	                            "Straight 2of5 IATA",					
	                            "Matrix 2of5",
	                            "Code 11",					
	                            "Code 128",//10
	                            "ISBT",						
	                            "GS1-128",
	                            "UPCA",					
	                            "UPCE",
	                            "EAN13",//15				
	                            "EAN8",						
	                            "MSI",
	                            "PDF417",
	                            "Micro PDF417",
	                            "QR Code",					//20
	                            "Data Matrix",
	                            "Maxi Code",
	                            "Aztec Code",				// 46
                            };
        public ID_SYM[] symnum ={                
	            ID_SYM.ID_CODABAR,
	            ID_SYM.ID_CODE39,
	            ID_SYM.ID_INT25,
	            ID_SYM.ID_NEC25,
	            ID_SYM.ID_CODE93,		//5
	            ID_SYM.ID_STRAIGHT25_IND,
	            ID_SYM.ID_STRAIGHT25,
	            ID_SYM.ID_MATRIX25,
	            ID_SYM.ID_CODE11,
	            ID_SYM.ID_CODE128,		//10
	            ID_SYM.ID_ISBT,
	            ID_SYM.ID_GS1_128,		
	            ID_SYM.ID_UPCA,		
	            ID_SYM.ID_UPCE,		
	            ID_SYM.ID_EAN13,		//15
	            ID_SYM.ID_EAN8,
	            ID_SYM.ID_MSI,
	            ID_SYM.ID_PDF417,	
	            ID_SYM.ID_MICRO417,
	            ID_SYM.ID_QRCODE,		//20	
	            ID_SYM.ID_DATAMATRIX,
	            ID_SYM.ID_MAXICODE,
	            ID_SYM.ID_AZTEC,
        };

        //	0~45	
        string[]NL_BARCODE_TYPE = {            
            "Code 128",
            "EAN8",
            "EAN13",
            "UPCE",
            "UPCA",				//5
	        "COUPON",
            "Intereaberd 2of5",
            "ITF-14",
            "ITF-6",
            "Matrix 2 of 5",
            "Code 39",//10
	        "Codabar",
            "Code 93",
            "GS1-128",
            "ISBN",
            "ISSN",//15				
	        "PDF 417",
            "Micro pdf417",
            "QRCode",
            "Micro QRcode",
            "Aztec",					//20
	        "Data Matrix",
            "Maxi Code",

        };

        public ID_NL_SYM[] NL_barcodeindex = {
    ID_NL_SYM.ID_NL_CODE128,
    ID_NL_SYM.ID_NL_EAN8,
    ID_NL_SYM.ID_NL_EAN13,
    ID_NL_SYM.ID_NL_UPCE,
    ID_NL_SYM.ID_NL_UPCA,		//5
	ID_NL_SYM.ID_NL_COUPON,
    ID_NL_SYM.ID_NL_INT25,
    ID_NL_SYM.ID_NL_ITF14,
    ID_NL_SYM.ID_NL_ITF6,
    ID_NL_SYM.ID_NL_MATRIX25,		//10
	ID_NL_SYM.ID_NL_CODE39,
    ID_NL_SYM.ID_NL_CODABAR,
    ID_NL_SYM.ID_NL_CODE93,
    ID_NL_SYM.ID_NL_GS1_128,
    ID_NL_SYM.ID_NL_ISBN,		//15
	ID_NL_SYM.ID_NL_ISSN,
    ID_NL_SYM.ID_NL_PDF417,   
    ID_NL_SYM.ID_NL_MICORPDF417,
    ID_NL_SYM.ID_NL_QRCODE,		//20	
	ID_NL_SYM.ID_NL_MICROQRCODE,
    ID_NL_SYM.ID_NL_AZTEC,
    ID_NL_SYM.ID_NL_DATAMATRIX,
    ID_NL_SYM.ID_NL_MAXICODE,
};

        private HScanCtrlNet m_Hscan;
        private bool binit = false;

        public Symbologies_Form(HScanCtrlNet hscan)
        {
            InitializeComponent();
            m_Hscan = hscan;
        }

        private void Symbologies_Form_Load(object sender, EventArgs e)
        {
            Listview_Init();
        }
        private void Listview_Init()
        {
           bool benable = false;
            int nscantype = m_Hscan.G2W_ScanType_net();
            for (int i = 0; i < 23; i++)
            {
                ListViewItem data = new ListViewItem();
                if (nscantype == 0)
                    data.Text = arrbarcode[i];
                else if (nscantype == 1)
                    data.Text = NL_BARCODE_TYPE[i];
                this.listView_symbologies.Items.Add(data);
            }
            Cursor.Current = Cursors.WaitCursor;
            for (int j = 0; j < 23; j++)
            {
                // int nvalue= m_Hscan.G2W_GetSymValue_net((int)symnum[j],(int)ID_SYM_OPTION.ID_SYM_ENABLE_N_DISABLE);
                int nvalue = 0;
                if (nscantype == 0)
                {
                    nvalue = m_Hscan.G2W_GetSymValue_net(symnum[j], ID_SYM_OPTION.ID_SYM_ENABLE_N_DISABLE);
                }
                else if (nscantype == 1)
                {
                    nvalue = m_Hscan.G2W_GetSymValue_net(NL_barcodeindex[j], ID_NL_SYM_OPTION.ID_NL_SYM_ENA);
                   
                }         
                if (nvalue==1)
                    benable =true;
                else
                    benable = false;
                this.listView_symbologies.Items[j].Checked = benable;
            }
            Cursor.Current = Cursors.Default;
            binit = true;
        }

        private void listView_symbologies_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            int index = e.Index;

            int nscantype = m_Hscan.G2W_ScanType_net();

            if (nscantype == 0)
            {
                if (e.NewValue == CheckState.Checked)
                {
                    if (binit)
                        m_Hscan.G2W_SetSymValue_net(symnum[index], ID_SYM_OPTION.ID_SYM_ENABLE_N_DISABLE, 1);
                }
                else
                {
                    if (binit)
                        m_Hscan.G2W_SetSymValue_net(symnum[index], ID_SYM_OPTION.ID_SYM_ENABLE_N_DISABLE, 0);
                }
            }else if(nscantype ==1)
            {
                if (e.NewValue == CheckState.Checked)
                {
                    if (binit)
                        m_Hscan.G2W_SetSymValue_net(NL_barcodeindex[index], ID_NL_SYM_OPTION.ID_NL_SYM_ENA, 1);
                }
                else
                {
                    if (binit)
                        m_Hscan.G2W_SetSymValue_net(NL_barcodeindex[index], ID_NL_SYM_OPTION.ID_NL_SYM_ENA, 0);
                }
            }
        }
    }
}
