// G2W_HScan_Symbologys.cpp :  Դϴ.
//

#include "stdafx.h"
#include "G2W_HScan_Test.h"
#include "G2W_HScan_Symbologys.h"
#include "G2W_HScan_Ctrl.h"

// global
typedef struct _barcode_check{
	int		num;			// HHP  Ǿ ִ ڵ庰 ȣ 
	BOOL	status;			// ش ڵ尡 Ȱִ° ƴѰ?
	BOOL	ch;				// ʱ ڵ   Ǿ°? ƴѰ?
}Barcode_Check;




//	0~45	
CString BARCODE_TYPE[]= {	
	"All",
	"Codabar",			
	"Code 39",
	"Interleaved 2of5",				
	"NEC 2of5",
	"Code 93",				//5
	"Straight 2of5 Industrial",   
	"Straight 2of5 IATA",					
	"Matrix 2of5",
	"Code 11",					
	"Code 128",//10
	"ISBT",						
	"GS1-128",
	"UPCA",					
	"UPCE",
	"EAN13",//15				
	"EAN8",						
	"MSI",
	"PDF417",
	"Micro PDF417",
	"QR Code",					//20
	"Data Matrix",
	"Maxi Code",
	"Aztec Code",				// 46
};



//	0~45	
CString NL_BARCODE_TYPE[] = {
	"All",
	"Code 128",
	"EAN8",
	"EAN13",
	"UPCE",
	"UPCA",				//5
	"CODE 11",
	"Intereaberd 2of5",
	"Industrial 25",
	"Standard 25",
	"Matrix 2 of 5"
	"Code 39",//10
	"Codabar",
	"Code 93",
	"GS1-128",
	"ISBN",
	"ISSN",//15				
	"PDF 417",
	"Micro pdf417",
	"QRCode",
	"Micro QRcode",
	"Aztec",					//20
	"Data Matrix",
	"Maxi Code"
					
};

int barcodeindex[]={
	ID_ALL,
	ID_CODABAR,
	ID_CODE39,
	ID_INT25,
	ID_NEC25,
	ID_CODE93,		//5
	ID_STRAIGHT25_IND,
	ID_STRAIGHT25,
	ID_MATRIX25,
	ID_CODE11,
	ID_CODE128,		//10
	ID_ISBT,
	ID_GS1_128,		
	ID_UPCA,		
	ID_UPCE,		
	ID_EAN13,		//15
	ID_EAN8,
	ID_MSI,
	ID_PDF417,	
	ID_MICRO417,
	ID_QRCODE,		//20	
	ID_DATAMATRIX,
	ID_MAXICODE,
	ID_AZTEC,
};

int NL_barcodeindex[] = {
	ID_NL_ALL,
	ID_NL_CODE128,
	ID_NL_EAN8,
	ID_NL_EAN13,
	ID_NL_UPCE,
	ID_NL_UPCA,		//5
	ID_NL_CODE11,
	ID_NL_INT25,
	ID_NL_INDUSTRIAL25,
	ID_NL_STANDARD25,
	ID_NL_MATRIX25,		//10
	ID_NL_CODE39,
	ID_NL_CODABAR,
	ID_NL_CODE93,
	ID_NL_GS1_128,
	ID_NL_ISBN,		//15
	ID_NL_ISSN,
	ID_NL_PDF417,
	ID_PDF417,
	ID_NL_MICORPDF417,
	ID_NL_QRCODE,		//20	
	ID_NL_MICROQRCODE,
	ID_NL_AZTEC,
	ID_NL_MAXICODE,
};

// CG2W_HScan_Symbologys ȭ Դϴ.

IMPLEMENT_DYNAMIC(CG2W_HScan_Symbologys, CDialog)

CG2W_HScan_Symbologys::CG2W_HScan_Symbologys(CWnd* pParent /*=NULL*/)
	: CDialog(CG2W_HScan_Symbologys::IDD, pParent)
{

}

CG2W_HScan_Symbologys::~CG2W_HScan_Symbologys()
{
}

void CG2W_HScan_Symbologys::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SYMBOLOGY, m_ctrl_symbology);
}


BEGIN_MESSAGE_MAP(CG2W_HScan_Symbologys, CDialog)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SYMBOLOGY, &CG2W_HScan_Symbologys::OnNMClickListSymbology)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_LIST_SYMBOLOGY, &CG2W_HScan_Symbologys::OnNMCustomdrawListSymbology)
END_MESSAGE_MAP()


// CG2W_HScan_Symbologys ޽ óԴϴ.

BOOL CG2W_HScan_Symbologys::OnInitDialog()
{
	CDialog::OnInitDialog();

	


	ListView_SetExtendedListViewStyle(m_ctrl_symbology.GetSafeHwnd(),LVS_EX_CHECKBOXES);	
	m_ctrl_symbology.InsertColumn(1,"BarCode Type",LVCFMT_LEFT,430);

	int index;
	for(index = 23 ; index > 0; index--)		//	1 ϹǷ -1, ocr  -1
	{	
		m_ctrl_symbology.InsertItem(0,BARCODE_TYPE[index]);		
	}	
	for(index = 0; index < 23; index++)		
	{
		m_ctrl_symbology.SetCheck(index,G2W_GetSymValue(barcodeindex[index+1],ID_SYM_ENABLE_N_DISABLE));
		
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// : OCX Ӽ  FALSE ȯؾ մϴ.
}

void CG2W_HScan_Symbologys::OnNMClickListSymbology(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMListView =  (NM_LISTVIEW*)pNMHDR;

	
	int nSel = pNMListView->iItem;

	if(nSel == -1)				
	{							
		AfxMessageBox("Retry Select");
	}
	else
	{
		G2W_SetSymValue(barcodeindex[nSel+1],ID_SYM_ENABLE_N_DISABLE,!m_ctrl_symbology.GetCheck(nSel));
	}
	
	*pResult = 0;
}

void CG2W_HScan_Symbologys::OnNMCustomdrawListSymbology(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVCUSTOMDRAW* pLVCD = reinterpret_cast<NMLVCUSTOMDRAW*>( pNMHDR );
	*pResult = 0;
	
	BOOL check= false;
										

	if ( CDDS_PREPAINT == pLVCD->nmcd.dwDrawStage )
	{
		*pResult = CDRF_NOTIFYITEMDRAW;
	}
	else 
	{
		if ( CDDS_ITEMPREPAINT == pLVCD->nmcd.dwDrawStage )
		{
			if(m_ctrl_symbology.GetCheck(pLVCD->nmcd.dwItemSpec) ==TRUE)
			{
				pLVCD->clrText   = RGB(0, 0, 200);            
				pLVCD->clrTextBk = RGB(255,255,255);
				m_ctrl_symbology.SetCheck(pLVCD->nmcd.dwItemSpec, TRUE);
			}
			else
			{
				pLVCD->clrText   = RGB(200, 0, 0);          
				pLVCD->clrTextBk = RGB(255, 255, 255);
				m_ctrl_symbology.SetCheck(pLVCD->nmcd.dwItemSpec, FALSE);
			}

			*pResult = CDRF_DODEFAULT;
		}
	}
}
