
#ifdef G2W_HSCAN_CTRL_EXPORTS
#define G2W_HSCAN_CTRL_API __declspec(dllexport)
#else
#define G2W_HSCAN_CTRL_API __declspec(dllimport)
#endif



//ERROR CORD
#define ERROR_NONE			 0
#define POWER_ON_ERROR      -1
#define POWER_OFF_ERROR     -2
#define PORT_OPEN_ERROR     -3
#define PORT_CLOSE_ERROR    -4
#define READ_ERROR          -5
#define READ_CANCEL_ERROR   -6

#define WM_SCAN_READ		WM_USER+1000

typedef enum {
	ID_ALL = 0,
	ID_CODABAR,
	ID_CODE39,
	ID_INT25,
	ID_NEC25,
	ID_CODE93,		//5
	ID_STRAIGHT25_IND,
	ID_STRAIGHT25,
	ID_MATRIX25,
	ID_CODE11,
	ID_CODE128,		//10
	ID_ISBT,
	ID_GS1_128,	
	ID_UPCA_OP,
	ID_UPCA,		
	ID_UPCE,		//15
	ID_EAN13,
	ID_EAN8,
	ID_MSI,
	ID_GS1_DATABAR_OMNI,
	ID_GS1_DATABAR_LIMIT, //20
	ID_GS1_DATABAR_EXPAND,
	ID_TRIOPTIC_CODE,
	ID_CODABLOCK_A,
	ID_CODABLOCK_F,
	ID_PDF417,				//25
	ID_MICRO417,
	ID_GS1_COMPOSITE_CODE,
	ID_GS1_EMULATION,
	ID_TCIF,
	ID_QRCODE,				//30
	ID_DATAMATRIX,
	ID_MAXICODE,
	ID_AZTEC,
	ID_HANXIN,
	ID_COUPON,				//35
	ID_POSTAL_2D,
	ID_PLNET_CODE_CHECK,
	ID_POSTNET_CHECK,
	ID_AUS_INTERPRETATION,
	ID_CHINA_POST,			//40
	ID_KOREA_POST	
}ID_SYM;

typedef enum {
	ID_SYM_2DIGIT_ADDENDA = 0,		//0
	ID_SYM_5DIGIT_ADDENDA,
	ID_SYM_ADDENDA_SEPARATOR,
	ID_SYM_ADDENDA_REQUIRED,
	ID_SYM_APPEND,
	ID_SYM_CODE39_FULL_ASCII,		//5
	ID_SYM_CODE32_PHARMACEUTICAL,
	ID_SYM_CONCATENATION,
	ID_SYM_CHECK_DIGIT,
	ID_SYM_CHECK_CHAR,
	ID_SYM_DEFAULT,					//10
	ID_SYM_GS1_EMULATION,
	ID_SYM_ENABLE_N_DISABLE,
	ID_SYM_UPCE0_ENABLE,
	ID_SYM_UPCE1_ENABLE,
	ID_SYM_EXPAND,					//15
	ID_SYM_GS1_DATBAR_OUTPUT,
	ID_SYM_AUS_POST_INT,
	ID_SYM_ISBN,
	ID_SYM_MACRO_PDF,
	ID_SYM_MINIMUM,					//20
	ID_SYM_MAXIMUM,
	ID_SYM_NUMBER_SYSTEM,
	ID_SYM_START_STOP,
	ID_SYM_POSTAL_CODE
}ID_SYM_OPTION;

typedef enum {
	ID_NL_ALL=0,//all		//0	
	ID_NL_CODE128,//code 128 	
	ID_NL_EAN8,//EAN8	
	ID_NL_EAN13,//EAN13	
	ID_NL_UPCE,//UPCE
	ID_NL_UPCA,// UPCA		//5
	ID_NL_COUPON,//COUPON
	ID_NL_INT25,//Intereaberd 2of5
	ID_NL_ITF14,//ITF-14
	ID_NL_ITF6,//ITF-6
	ID_NL_MATRIX25,//Matrix 2of 5	//10
	ID_NL_CODE39,//code 39
	ID_NL_CODABAR,//Codabar
	ID_NL_CODE93,//code 93
	ID_NL_CHIANPOST25,//china post 25
	ID_NL_GS1_128,//GS1-128			//15
	ID_NL_RSS,//GS1 Databar(RSS)
	ID_NL_CPT,//GS1 Composite(EAN-UCC Composite)
	ID_NL_CODE11,//code 11
	ID_NL_ISBN,//ISBN
	ID_NL_ISSN,//ISSN			//20
	ID_NL_INDUSTRIAL25,//Industrial 25
	ID_NL_STANDARD25,//Standard 25
	ID_NL_PLESSEYLY,//Plessey
	ID_NL_MSI_PLESSEY,//MSI-Plessey
	ID_NL_AIM128,//AIM 128			//25
	ID_NL_ISBT128,//ISBT 128
	ID_NL_CODE49,//Code49
	ID_NL_CODE16k,//code 16k
	ID_NL_PDF417,//PDF 417
	ID_NL_MICORPDF417,//Micro pdf417	//30
	ID_NL_QRCODE,//QRCode
	ID_NL_MICROQRCODE,//Micro QR code
	ID_NL_AZTEC,//Aztec
	ID_NL_DATAMATRIX,//Data Matrix
	ID_NL_MAXICODE,//Maxicode		//35
	ID_NL_CHINESSS_SESIBLE_CODE,//Chinese Sensible code
	ID_NL_GMCODE,//GM Code
	ID_NL_CODEONE,//Code one
	ID_NL_USPSPOSTNET,//USPS Postnet
	ID_NL_USPSINTELL_MAIL,//USPS Intelligent Mail	//40
	ID_NL_ROYAL_MAIL,//Royal Mail
	ID_NL_PLANET,//USPS Planet
	ID_NL_KIX_POST,//KIX post
	ID_NL_AUSTRALIAN_POSTTAL,//Australian Postal
	ID_NL_SPECIFIC_OCR_B,//Specific OCR-B			//45
	ID_NL_PASSPORT_OCR//Passport OCR
}ID_NL_SYM;





typedef enum {
	ID_NL_SYM_ENA=0,//enable   //0	
	ID_NL_SYM_DEF,//default
	ID_NL_SYM_1DC,//1D	
	ID_NL_SYM_2DC,//2D	
	ID_NL_SYM_PST,//postal 	
	ID_NL_SYM_MIN,//min			//5
	ID_NL_SYM_MAX,//max
	ID_NL_SYM_CHK,//check
	ID_NL_SYM_AD2,//2digit addenda
	ID_NL_SYM_AD5,//5digit addenda
	ID_NL_SYM_EXP,//EAN8 to EAN13 convert			//10
	ID_NL_SYM_REQ,//Add on Code Required	
	ID_NL_SYM_290,//Add on 290 Code
	ID_NL_SYM_378,//378 add on code
	ID_NL_SYM_414,//414 add on code
	ID_NL_SYM_434,//434 add on code		//15
	ID_NL_SYM_977,//977 add on code
	ID_NL_SYM_978,//978 add on code
	ID_NL_SYM_979,// 979 add on code
	ID_NL_SYM_EN0,//UPCE0
	ID_NL_SYM_EN1,//UPCE1						//20
	ID_NL_SYM_PRE,//Transmit Preamble Character
	ID_NL_SYM_GS1,//Coupon GS1 Databar Output
	ID_NL_SYM_TSC,//code39 ,codabar  transmit start/stop character
	ID_NL_SYM_ASC,//code 39 Full ASCII
	ID_NL_SYM_E32,//code 39 Italian Pharma Code		//25
	ID_NL_SYM_S32,//code 39 Prefix
	ID_NL_SYM_T32,//code39 Transmit code32 start/stop character
	ID_NL_SYM_C32,//code32 Transmit code32 Check character	
	ID_NL_SYM_SCF,//codabar start/stop character		//30
	ID_NL_SYM_UPC,//GS1 composite  UPC /EAN composite
	ID_NL_SYM_TCK,//code11 transmit check character
	ID_NL_SYM_T10,//ISBN format
	ID_NL_SYM_DOU,//(PDF417,QR code,Data matrix,chinese sensible code) Twin code
	ID_NL_SYM_INV,//(PDF417,QR code,Data matrix,,chinese sensible code) Inverse		//35
	ID_NL_SYM_ENC,//(PDF417,QR code,Aztec,Data matrix)  Encoding
	ID_NL_SYM_ECI,//(PDF417,QR code,Aztec,Data matrix)  ECI Output
	ID_NL_SYM_MOD,//(Aztec Read Multi barcodes on an image
	ID_NL_SYM_MUL,//(Aztec) Set the number of barcodes
	ID_NL_SYM_REC //Data matrix Rectangular barcode		//40
}ID_NL_SYM_OPTION;



typedef enum {
	ID_MO_TIMEOUT= 0,
	ID_MO_ILLUMINATION_BRIGHT,
	ID_MO_ILLUMINATION_N_AIMER_ENABLE,	
	ID_MO_POOR_QULITY_1D,
	ID_MO_POOR_QULITY_PDF,
	ID_MO_VERSION_INF

}ID_MODULE;

typedef enum {
	ID_MO_OPT_TIMEOUT= 0,
	ID_MO_OPT_ILLUMINATION_BRIGHT,
	ID_MO_OPT_ILLUMINATION_ENABLE,
	ID_MO_OPT_AIMER_ENABLE,
	ID_MO_OPT_POOR_QULITY_1D,
	ID_MO_OPT_POOR_QULITY_PDF,
	ID_MO_OPT_VERSION_INF

}ID_MODULE_OPTION;

typedef enum{
	ID_IMBRIGHT_LOW = 15,
	ID_IMBRIGHT_MEDIUM = 50,
	ID_IMBRIGHT_HIGH = 150
}ID_IMMUMINATION_BRIGHT_VALUE;


typedef enum {
	ID_VALUE_OFF =0,		//0
	ID_VALUE_ON
}ID_VALUE;


class G2W_HSCAN_CTRL_API CG2W_HScan_Ctrl {
public :
	//char m_Barcode_Data[2711];
	//char m_Barcode_Type[32];
	//int  m_nBarcode_Type;
public:
	CG2W_HScan_Ctrl(void);

	int G2W_InitScanner();
	int G2W_ScanType();
	int G2W_CloseScanner();
	int G2W_Read();
	int G2W_ReadCancel();
	void G2W_ScanWakeup(int nvalue);
	
	void G2W_RegisterWindow(HWND hWnd);	
	void G2W_GetScanDataByte(BYTE *sBarData, BYTE *sBarType);
	
	
	void G2W_GetVersionInfo(BYTE *version);

	void G2W_SetSymValue(int nsymbology,int nsuboption,int value);
	int	 G2W_GetSymValue(int nsymbology,int nsuboption);
	void G2W_SetOptValue(int noption,int nsuboption,int value);
	int	 G2W_GetOptValue(int noption,int nsuboption);
	
};

extern G2W_HSCAN_CTRL_API int nG2W_HScan_Ctrl;

G2W_HSCAN_CTRL_API int fnG2W_HScan_Ctrl(void);

EXTERN_C G2W_HSCAN_CTRL_API		int G2W_InitScanner();
EXTERN_C G2W_HSCAN_CTRL_API		int G2W_ScanType();
EXTERN_C G2W_HSCAN_CTRL_API 	int G2W_CloseScanner();
EXTERN_C G2W_HSCAN_CTRL_API 	int G2W_Read();
EXTERN_C G2W_HSCAN_CTRL_API 	int G2W_ReadCancel();
EXTERN_C G2W_HSCAN_CTRL_API 	void G2W_ScanWakeup(int nvalue);
EXTERN_C G2W_HSCAN_CTRL_API 	void G2W_RegisterWindow(HWND hWnd);
EXTERN_C G2W_HSCAN_CTRL_API 	void G2W_GetScanDataByte(BYTE *sBarData, BYTE *sBarType);
EXTERN_C G2W_HSCAN_CTRL_API		void G2W_SetSymValue(int nsymbology, int nsuboption, int value);
EXTERN_C G2W_HSCAN_CTRL_API		int	 G2W_GetSymValue(int nsymbology, int nsuboption);
EXTERN_C G2W_HSCAN_CTRL_API		void G2W_SetOptValue(int noption, int nsuboption, int value);
EXTERN_C G2W_HSCAN_CTRL_API		int	 G2W_GetOptValue(int noption, int nsuboption);
EXTERN_C G2W_HSCAN_CTRL_API 	void G2W_GetVersionInfo(BYTE *version);
