﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using G2W_HScan_Ctrl_Net;
using System.Runtime.InteropServices;
namespace G2W_Hscan_Test_Net
{
    public partial class Main_Form : Form
    {
        public G2W_HScan_Ctrl_Net.HScanCtrlNet G2w_scan;
        public bool bButtFlag = false;
        public bool bsound = true;

        [DllImport("winmm.dll", EntryPoint = "PlaySound", CharSet = CharSet.Auto)]
        private static extern int PlaySound(String pszSound, int hmod, int falgs);
        public enum SND
        {
            SND_SYNC = 0x0000,/* play synchronously (default) */
            SND_ASYNC = 0x0001, /* play asynchronously */
            SND_NODEFAULT = 0x0002, /* silence (!default) if sound not found */
            SND_MEMORY = 0x0004, /* pszSound points to a memory file */
            SND_LOOP = 0x0008, /* loop the sound until next sndPlaySound */
            SND_NOSTOP = 0x0010, /* don't stop any currently playing sound */
            SND_NOWAIT = 0x00002000, /* don't wait if the driver is busy */
            SND_ALIAS = 0x00010000,/* name is a registry alias */
            SND_ALIAS_ID = 0x00110000, /* alias is a pre d ID */
            SND_FILENAME = 0x00020000, /* name is file name */
            SND_RESOURCE = 0x00040004, /* name is resource name or atom */
            SND_PURGE = 0x0040,  /* purge non-static events for task */
            SND_APPLICATION = 0x0080  /* look for application specific association */
        }
        public Main_Form()
        {
            InitializeComponent();
            G2w_scan = new HScanCtrlNet();
            G2w_scan.G2WScannerDataEvent += new G2WScannerDataDelegate(OnScanData);            
            G2w_scan.G2W_InitScanner_net();
            
        }
        
        private void OnScanData(object o, G2WScannerDataArgs args)
        {
            if (listView_ScanData.Items.Count > 10)
                listView_ScanData.Items.Clear();

            ListViewItem BarcodeItem = new ListViewItem();
            BarcodeItem.Text = args.ScanType;
            BarcodeItem.SubItems.Add(args.ScanData);

            listView_ScanData.Items.Add(BarcodeItem);
            string Path = System.Environment.CurrentDirectory+ "\\Scanbeep.wav";
           

            PlaySound(Path, 0, (int)(SND.SND_ASYNC | SND.SND_FILENAME));// | SND.SND_NOWAIT));
        }

        private void button_scan_Click(object sender, EventArgs e)
        {
            G2w_scan.G2W_Read_net();
            
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            G2w_scan.G2W_ReadCancel_net();
            G2w_scan.G2W_CloseScanner_net();
        }

        private void Form1_KeyUp(object sender, KeyEventArgs e)
        {
            
            if (!bButtFlag)
            {
                switch (e.KeyCode)
                {
                    
                    case Keys.F22://front F1
                    case Keys.F23://front F2

                        G2w_scan.G2W_Read_net();
                        break;
                }
                bButtFlag = true;
            }
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (bButtFlag)
            {
                switch (e.KeyCode)
                {
                    case Keys.F22:
                    case Keys.F23:

                        G2w_scan.G2W_ReadCancel_net();
                        break;

                }

                bButtFlag = false;

            }
        }

        private void Symbologies_Click(object sender, EventArgs e)
        {
            Symbologies_Form symform;
            symform = new Symbologies_Form(G2w_scan);
            symform.Show();
        }

        private void Option_Click(object sender, EventArgs e)
        {
            Option_Form optionform;           
            optionform = new Option_Form(G2w_scan);
            optionform.bsound = bsound;
           
             DialogResult reg =  optionform.ShowDialog();
            bsound=optionform.bsound;
        }

        private void About_Click(object sender, EventArgs e)
        {
            byte [] byversion= new byte[2048];
            G2w_scan.G2W_GetVersionInfo_net(byversion);

            String strversion = Encoding.Default.GetString(byversion);
            MessageBox.Show(strversion);
        }


        
    }
}
