
// G2W_HScan_TestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "G2W_HScan_Test.h"
#include "G2W_HScan_TestDlg.h"
#include "afxdialogex.h"
#include "G2W_HScan_Symbologys.h"
#include "G2W_HScan_Option.h"
#include <windows.h>
#include <mmsystem.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
#pragma comment(lib, "winmm.lib")

int g_ncount = 0;
bool g_bkeydown = false;
bool g_bsync = true;
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg(CString strversion);
	CString str_version;
// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg(CString strversion) : CDialogEx(IDD_ABOUTBOX)
{
	str_version = strversion;
	GetDlgItem(IDC_EDIT_VERSION)->SetWindowText(strversion);
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


BOOL CAboutDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	str_version.Find("ddd");

	return TRUE;  // return TRUE unless you set the focus to a control
				  // : OCX Ӽ  FALSE ȯؾ մϴ.
}

// CG2W_HScan_TestDlg dialog



CG2W_HScan_TestDlg::CG2W_HScan_TestDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_G2W_HSCAN_TEST_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CG2W_HScan_TestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SCAN_DATA, m_ListCtrl_ScanData);
}

BEGIN_MESSAGE_MAP(CG2W_HScan_TestDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_MESSAGE(WM_SCAN_READ, OnScanRead)
	ON_BN_CLICKED(IDC_BUTTON_SCAN, &CG2W_HScan_TestDlg::OnBnClickedButtonScan)
	ON_BN_CLICKED(IDC_BUTTON_OPTION, &CG2W_HScan_TestDlg::OnBnClickedButtonOption)
	ON_BN_CLICKED(IDC_BUTTON_ABOUT, &CG2W_HScan_TestDlg::OnBnClickedButtonAbout)
	ON_BN_CLICKED(IDC_BUTTON_SYMBOLOGY, &CG2W_HScan_TestDlg::OnBnClickedButtonSymbology)
END_MESSAGE_MAP()


LRESULT CG2W_HScan_TestDlg::OnScanRead(WPARAM wParam, LPARAM lParam)
{
	BYTE data[512] = { 0, };
	BYTE codetype[128] = { 0, };


	m_gScan.G2W_GetScanDataByte(data, codetype);

	if (CString(data).GetLength() != 0)
	{
		
		m_ListCtrl_ScanData.InsertItem(0, CString(codetype), 0);
		m_ListCtrl_ScanData.SetItemText(0, 1, CString(data));
		HINSTANCE hInst = AfxGetInstanceHandle();
		if (m_bsound)
			PlaySound(MAKEINTRESOURCE(IDR_WAVE_SCAN), hInst, SND_RESOURCE | SND_ASYNC);
		g_ncount++;
		if (g_ncount == 100)
		{
			m_ListCtrl_ScanData.DeleteAllItems();
			g_ncount = 0;
		}
	}

	return true;
}
// CG2W_HScan_TestDlg message handlers

BOOL CG2W_HScan_TestDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	Initlist();



	if (0 != G2W_InitScanner())
	{
		AfxMessageBox("Port Open Error");
		return FALSE;
	}


	G2W_RegisterWindow(this->m_hWnd);




	m_bsound = true;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CG2W_HScan_TestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CString strversion;
		CAboutDlg dlgAbout(strversion);
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CG2W_HScan_TestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CG2W_HScan_TestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CG2W_HScan_TestDlg::OnClose()
{

	G2W_ReadCancel();
	Sleep(100);
	G2W_CloseScanner();

	CDialog::OnClose();
}
void CG2W_HScan_TestDlg::OnBnClickedButtonScan()
{
	G2W_Read();
}
// listctrl init
void CG2W_HScan_TestDlg::Initlist(void)
{
	ListView_SetExtendedListViewStyle(m_ListCtrl_ScanData.GetSafeHwnd(), LVS_EX_FULLROWSELECT);


	m_ListCtrl_ScanData.InsertColumn(0, "Code_Type", LVCFMT_LEFT, 150);
	m_ListCtrl_ScanData.InsertColumn(1, "Code_Data", LVCFMT_LEFT, 390);

}

void CG2W_HScan_TestDlg::OnBnClickedButtonOption()
{
	CG2W_HScan_Option optdlg;

	optdlg.m_nasync = g_bsync;
	optdlg.m_bvalue_check_scansound = m_bsound;
	optdlg.m_bvalue_check_1d = (G2W_GetOptValue(ID_MO_POOR_QULITY_1D, ID_MO_OPT_POOR_QULITY_1D) == 1) ? true : false;
	optdlg.m_bvalue_check_pdf = (G2W_GetOptValue(ID_MO_POOR_QULITY_PDF, ID_MO_OPT_POOR_QULITY_PDF) == 1) ? true : false;
	if (optdlg.DoModal() == IDOK)
	{
		m_bsound = (optdlg.m_bvalue_check_scansound == 1) ? true : false;
		G2W_SetOptValue(ID_MO_POOR_QULITY_1D, ID_MO_OPT_POOR_QULITY_1D, (optdlg.m_bvalue_check_1d == TRUE) ? 1 : 0);
		G2W_SetOptValue(ID_MO_POOR_QULITY_PDF, ID_MO_OPT_POOR_QULITY_PDF, (optdlg.m_bvalue_check_pdf == TRUE) ? 1 : 0);
		g_bsync = (optdlg.m_nasync == 1) ? true : false;

	}
}

BOOL CG2W_HScan_TestDlg::PreTranslateMessage(MSG* pMsg)
{
	CString str;

	if (pMsg->message == WM_KEYDOWN)
	{

		str.Format("WM_KEYDOWN :%d", pMsg->wParam);
		SetWindowText(str);
		if (pMsg->wParam == VK_F22 && g_bkeydown == false)
		{
			//G2W_Triger_OnNOff(false);
			g_bkeydown = true;
			G2W_Read();
		}
	}
	else if (pMsg->message == WM_KEYUP)
	{

		str.Format("WM_KEYUP :%d", pMsg->wParam);
		SetWindowText(str);
		if (pMsg->wParam == VK_F22  && g_bkeydown == true)
		{
			g_bkeydown = false;
			//G2W_Triger_OnNOff(true);
			if (g_bsync == false)
				G2W_ReadCancel();
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CG2W_HScan_TestDlg::OnBnClickedButtonAbout()
{
	BYTE data[512] = { 0, };
	m_gScan.G2W_GetVersionInfo(data);

	AfxMessageBox(CString(data));
}


void CG2W_HScan_TestDlg::OnBnClickedButtonSymbology()
{
	CG2W_HScan_Symbologys symdlg;

	symdlg.DoModal();
}



