package com.gen2wave.g2w_scan_demo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;

import com.amarula.barcodescanner.sdk.BarcodeScanner;
import com.amarula.barcodescanner.sdk.BarcodeScannerConnection;
import com.amarula.barcodescanner.sdk.BarcodeScannerConnectionInterface;
import com.amarula.barcodescanner.sdk.IBarcodeServiceCallback;
import com.gen2wave.device.util.barcode.BeepManager;
import com.gen2wave.device.util.barcode.Settings;
import com.google.zxing.client.android.Intents;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ScanDemoActivity extends Activity implements BarcodeScannerConnectionInterface {

	private static String TAG = "ScanDemoActivity";
	private BeepManager mBeepManager;
	private BarcodeScannerConnection mConnection = null;
	private boolean mWaitingForActivityResult = false;

	private boolean isMarshMallow = false;
	private int modelType;
	private final int MODEL_1100 = 0;
	private final int MODEL_1200 = 1;
	private final int MODEL_1300 = 2;
	private final int MODEL_1400 = 3;
	private final int MODEL_1500 = 4;
	private final int MODEL_1600 = 5;

	private boolean mScanning = false;
	private boolean mScanMultiple = false;
	private TextView m_tv_result;

	IBarcodeServiceCallback mCallbcak = new IBarcodeServiceCallback.Stub() {
		@Override
		public void reqReInitialize() throws RemoteException {
			Log.d(TAG, "reqReInitialize : Callback from server !!!!");
			rebindStatus = false;
			disconnect();
			delayMsec(500);
			connect();
		}
	};

	private void delayMsec(int millisec) {
		try {
			Thread.sleep(millisec);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	public void disconnect() {
		Log.d(TAG, "disconnect method called");
		if (mScanning) {
			mConnection.stopScanning();
		}
		mScanning = false;
		mScanMultiple = false;
		mConnection.unregisterServerCallback(mCallbcak);
		mConnection.unbindFromBarcodeScannerService();
		mConnection = null;
	}

	public void connect() {
		Log.d(TAG, "connect method called");
		if (mConnection == null) {
			mConnection = new BarcodeScannerConnection(this, this);
			mConnection.bindToBarcodeScannerService();
		}
		BarcodeScanner.directInputForceStatus(this, false);
	}

	private BarcodeAdapter mAdapter;
	private TextView listSizeTxt = null;
	private Button autoBtn = null;
	private EditText numEdit = null;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_scan_demo);

		mAdapter = new BarcodeAdapter(this, new ArrayList<BarcodeItem>());
		((ListView) findViewById(R.id.lvScanResult)).setAdapter(mAdapter);
		listSizeTxt = (TextView) findViewById(R.id.list_size);
		numEdit = (EditText) findViewById(R.id.auto_num);
		initValue();

		autoBtn = (Button) findViewById(R.id.auto_btn);
		autoBtn.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				initValue();
				if (!autoMode) {
					autoMode = true;
					autoBtn.setText(getResources().getString(R.string.auto_reset_btn_msg));
					// findViewById(R.id.btnScanStart).setEnabled(false);
					// findViewById(R.id.btnScanStart).setVisibility(View.GONE);
					String num = numEdit.getText().toString();
					if (!num.equals("") && num != null) {
						userAutoNum = Integer.parseInt(num);
						/*
						 * if (userAutoNum > MAX_AUTO_NUM) {
						 * Toast.makeText(getApplicationContext(),
						 * "Lower than 5000", 1000).show(); autoMode = false;
						 * userAutoNum = 0;
						 * autoBtn.setText(getResources().getString
						 * (R.string.auto_btn_msg)); return; }
						 */
					} else {
						numEdit.setText("30");
						userAutoNum = 30;
					}
					handler.sendEmptyMessage(0);
				} else {
					autoMode = false;
					autoBtn.setText(getResources().getString(R.string.auto_btn_msg));
					findViewById(R.id.btnScanStart).setVisibility(View.VISIBLE);
				}
			}
		});

		// m_tv_result = (TextView) findViewById(R.id.tv_command);

		String thisModel = getProperty("ro.product.model").toLowerCase();
		Log.d(TAG, "Model : " + Build.MODEL);
		if (thisModel.equals("rp1100")) {
			modelType = MODEL_1100;
		} else if (thisModel.equals("rp1200")) {
			modelType = MODEL_1200;
		} else if (thisModel.equals("rp1300")) {
			modelType = MODEL_1300;
		} else if (thisModel.equals("rp1400")) {
			modelType = MODEL_1400;
		} else if (thisModel.equals("rp1500")) {
			modelType = MODEL_1500;
		} else if (thisModel.equals("rp1600")) {
			modelType = MODEL_1600;
		}

		String thisVer = getProperty("ro.build.version.release");
		Log.d(TAG, "thisVer = " + thisVer);
		if (thisVer.startsWith("6")) {
			isMarshMallow = true;
		} else {
			isMarshMallow = false;
		}

		mBeepManager = new BeepManager(this);
		setVolumeControlStream(AudioManager.STREAM_MUSIC);

		IntentFilter f = new IntentFilter();
		f.addAction(BarcodeScanner.DECODE_RESULTS_ACTION);
		registerReceiver(mScanResultReceiver, f);

		findViewById(R.id.btnScanStart).setOnTouchListener(new View.OnTouchListener() {
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				if (event.getAction() == MotionEvent.ACTION_DOWN) {
					setScanEnabled(true, false);
				} else if (event.getAction() == MotionEvent.ACTION_UP) {
					setScanEnabled(false, false);
				}
				return false;
			}
		});
	}

	private void initValue() {
		ncount = 0;
		failNum = 0;
		successNum = 0;
		userAutoNum = 0;
		autoScanNum = 0;
		listSizeTxt.setText("0");
		mAdapter.clear();
		mAdapter.notifyDataSetChanged();
	}

	@Override
	protected void onResume() {
		Log.v(TAG, "onResume() connection: " + mConnection);
		if (mConnection == null) {
			mConnection = new BarcodeScannerConnection(this, this);
			mConnection.bindToBarcodeScannerService();
		}
		BarcodeScanner.directInputForceStatus(this, false);
		super.onResume();
	}

	@Override
	protected void onPause() {
		Log.v(TAG, "onPause() through activity: " + mWaitingForActivityResult);
		if (!mWaitingForActivityResult) {

			if (mScanning) {
				mConnection.stopScanning();
			}
			mScanning = false;
			mScanMultiple = false;
		}
		super.onPause();
	}

	private BroadcastReceiver mScanResultReceiver = new BroadcastReceiver() {
		@Override
		public void onReceive(Context ctx, Intent data) {
			/* Do not double read while scanning with activity */

			Log.v(TAG, "onReceive()");
			if (mWaitingForActivityResult)
				return;
			if (data != null && BarcodeScanner.DECODE_RESULTS_ACTION.equals(data.getAction())) {
				parseReceivedIntent(data);
			}
		}
	};

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		Log.v(TAG, "onActivityResult()");
		if (mScanning)
			setScanEnabled(false, false);

		if (resultCode != RESULT_OK) {
			Log.w(TAG, "Result not OK");
			return;
		}

		if (data != null && Intents.Scan.ACTION.equals(data.getAction())) {
			parseReceivedIntent(data);
		}
		mWaitingForActivityResult = false;
	}

	@Override
	protected void onDestroy() {
		unregisterReceiver(mScanResultReceiver);
		super.onDestroy();

		mConnection.unregisterServerCallback(mCallbcak);
		mConnection.unbindFromBarcodeScannerService();
		mConnection = null;
	}

	private void parseReceivedIntent(Intent data) {
		if (mScanning && !mScanMultiple)
			setScanEnabled(false, false);

		long endtime = System.currentTimeMillis() - mTimeToScan;
		String tag = data.getStringExtra(Intents.Scan.RESULT);
		String extra = "" + endtime + "ms";
		// EAN_8 EAN_13
		String format = data.getStringExtra(Intents.Scan.RESULT_FORMAT);
		Bitmap bitmap = (Bitmap) data.getExtras().get(Intents.Scan.RESULT_BITMAP);
		String fileDir = data.getStringExtra("dir");
		String fileName = data.getStringExtra("filename");
		if (fileDir != null && fileName != null) {
			Log.d(TAG, "fileDir = " + fileDir + ", fileName = " + fileName);
		} else {
			Log.d(TAG, "fileDir = null, fileName = null");
		}

		if (autoMode) {
			if (endtime > MIN_DELAY_TIME) {
				failNum++;
				addScanData(tag, extra, format, FAIL);
			} else {
				successNum++;
				addScanData(tag, extra, format, SUCCESS);
			}
		} else {
			addScanData(tag, extra, format, SUCCESS);

			if (bitmap != null) {
				Intent intent = new Intent(ScanDemoActivity.this, ImageViewActivity.class);
				intent.putExtra("bm", bitmap);
				startActivity(intent);
			} else {
				Log.e("Test", "bitmap is null");
			}
		}
	}

	private void setScanEnabled(boolean en, boolean throughStartActivity) {
		if (en == mScanning) {
			Log.w(TAG, "setScanEnabled: Already " + en);
			return;
		}
		if (en) {
			if (throughStartActivity) {

				try {
					startActivityForResult(new Intent(Intents.Scan.ACTION), 0);
					mWaitingForActivityResult = true;
				} catch (Exception e) {
					Log.e(TAG, "Cannot find the barcode scanner");
					return;
				}
			} else {
				mTimeToScan = System.currentTimeMillis();
				if (mScanMultiple) {
					if (mConnection.scanMultipleBarcodes() != 0) {
						Log.e(TAG, "Cannot start multiple scan");
						return;
					}
				} else if (mConnection.scanOneBarcode() != 0) {
					Log.e(TAG, "Cannot start scan");
					return;
				}
			}

		} else {

			mConnection.stopScanning();
			mScanMultiple = false;
		}

		mScanning = en;
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.scan_demo, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			startActivity(new Intent(this, Settings.class));
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	/*
	 * (non-Javadoc)
	 * @see android.app.Activity#onKeyDown(int, android.view.KeyEvent)
	 * @see android.app.Activity#onKeyUp(int, android.view.KeyEvent)
	 * RP1100: Left Scan(226) Right Scan(220) Middle Scan(66)
	 * RP1200: Left Scan(226) Right Scan(221) Middle Scan(183)
	 * RP1300: Left Scan(226) Right Scan(220)
	 * RP1400: Left Scan(224) Right Scan(23) Middle Scan(57)
	 * RP1500: Left Scan(265) Right Scan(23) Middle Scan(57)
	 * RP1600_KK: Left Scan(224) Right Scan(223)
	 * RP1600_MM: Left Scan(265) Right Scan(264)
	 */

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		/* Discard key repeating */
		if (event.getRepeatCount() != 0)
			return super.onKeyDown(keyCode, event);

		Log.d(TAG, "keyCode = "+keyCode);
		switch (modelType) {
		case MODEL_1100:
			if (keyCode == 226 || keyCode == 220 || keyCode == 66) {
				setScanEnabled(true, false);
				return true;
			}
			break;
		case MODEL_1200:
			if (keyCode == 226 || keyCode == 221 || keyCode == 183) {
				setScanEnabled(true, false);
				return true;
			}
			break;
		case MODEL_1300:
			if (keyCode == 226 || keyCode == 220) {
				setScanEnabled(true, false);
				return true;
			}
			break;
		case MODEL_1400:
			if (keyCode == 224 || keyCode == 23 || keyCode == 57) {
				setScanEnabled(true, false);
				return true;
			}
			break;
		case MODEL_1500:
			if (keyCode == 265 || keyCode == 23 || keyCode == 57) {
				setScanEnabled(true, false);
				return true;
			}
			break;
		case MODEL_1600:
			if(isMarshMallow){
				if (keyCode == BarcodeScanner.KEYCODE_SCAN || keyCode == 265 || keyCode == 264) {
					setScanEnabled(true, false);
					return true;
				}
			}else{
				if (keyCode == BarcodeScanner.KEYCODE_SCAN || keyCode == 223 || keyCode == 224) {
					setScanEnabled(true, false);
					return true;
				}
			}
			break;
		}

		return super.onKeyDown(keyCode, event);
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		/* Discard key repeating */
		if (event.getRepeatCount() != 0)
			return super.onKeyDown(keyCode, event);

		switch (modelType) {
		case MODEL_1100:
			if (keyCode == 226 || keyCode == 220 || keyCode == 66) {
				mScanMultiple = false;
				setScanEnabled(false, false);
				return true;
			}
			break;
		case MODEL_1200:
			if (keyCode == 226 || keyCode == 221 || keyCode == 183) {
				mScanMultiple = false;
				setScanEnabled(false, false);
				return true;
			}
			break;
		case MODEL_1300:
			if (keyCode == 226 || keyCode == 220) {
				mScanMultiple = false;
				setScanEnabled(false, false);
				return true;
			}
			break;
		case MODEL_1400:
			if (keyCode == 224 || keyCode == 23 || keyCode == 57) {
				mScanMultiple = false;
				setScanEnabled(false, false);
				return true;
			}
			break;
		case MODEL_1500:
			if (keyCode == 265 || keyCode == 23 || keyCode == 57) {
				mScanMultiple = false;
				setScanEnabled(false, false);
				return true;
			}
			break;
		case MODEL_1600:
			if(isMarshMallow){
				if (keyCode == BarcodeScanner.KEYCODE_SCAN || keyCode == 265 || keyCode == 264) {
					mScanMultiple = false;
					setScanEnabled(false, false);
					return true;
				}
			}else{
				if (keyCode == BarcodeScanner.KEYCODE_SCAN || keyCode == 223 || keyCode == 224) {
					mScanMultiple = false;
					setScanEnabled(false, false);
					return true;
				}
			}
			break;
		}
		return super.onKeyUp(keyCode, event);
	}

	public static String getProperty(String prop) {
		String serialnum = "";

		try {
			Class<?> c = Class.forName("android.os.SystemProperties");
			Method get = c.getMethod("get", String.class, String.class);
			serialnum = (String) (get.invoke(c, prop, "-"));
		} catch (Exception ignored) {
		}
		return serialnum;
	}

	@Override
	public void onServiceConnected(int arg0) {
		// TODO Auto-generated method stub
		Log.d(TAG, "[Test] onServiceConnected method called");
		mConnection.registerServerCallback(mCallbcak);
		rebindStatus = true;

		mConnection.setEnableIDC(true);
		mConnection.setParameter(594, 1); // Set IDC Mode to Anchor
		mConnection.setParameter(596, -60); // Set X
		mConnection.setParameter(597, 20); // Set Y
		mConnection.setParameter(598, 120); // Set width
		mConnection.setParameter(599, 60); // Set height
		mConnection.setParameter(829, 1); // border color - black
		mConnection.setParameter(655, 1); // Set anchor barcode type: 1 (Code
											// 128 | Aztec)
	}

	@Override
	public void onServiceDisconnected() {
		//Log.d(TAG, "onServiceDisconnected method called");
		// TODO Auto-generated method stub

	}

	private int ncount = 0;

	private void addScanData(String tag, String extra, String format, String result) {
		BarcodeItem barcodeItem = new BarcodeItem(tag, extra, format, result);
		mAdapter.add(barcodeItem);
		ncount++;

		listSizeTxt.setText(noneTemp + ncount);

		// mBeepManager.playBeepSoundAndVibrate();

		if (autoMode) {
			if (autoScanNum >= userAutoNum) {
				// end auto
				showAlertDialog(null, null);
			} else {
				if (rebindStatus) {
					handler.sendEmptyMessage(0);
				} else {
					handler.sendEmptyMessageDelayed(0, MIN_DELAY_TIME);
				}
			}
		}
	}

	private void showAlertDialog(String format, String content) {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setIcon(android.R.drawable.ic_dialog_alert);
		builder.setTitle("Result");
		builder.setCancelable(false);
		View view = getLayoutInflater().inflate(R.layout.scanner_result_dialog, null);
		builder.setView(view);
		// String result = getResult();
		String result = null;
		if (failNum > 0) {
			result = "Success = " + successNum + "    Fail = " + failNum;
		} else {
			result = "P A S S";
		}
		TextView resultTv = (TextView) view.findViewById(R.id.result_msg);
		if (result.equals("P A S S")) {
			resultTv.setTextColor(getResources().getColor(R.color.light_blue));
		} else {
			resultTv.setTextColor(getResources().getColor(R.color.red));
		}
		resultTv.setText(result);
		builder.setPositiveButton(R.string.alert_btn_positive, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int whichButton) {
				ncount = 0;
				failNum = 0;
				successNum = 0;
				userAutoNum = 0;
				autoScanNum = 0;

				autoMode = false;
				autoBtn.setText(getResources().getString(R.string.auto_btn_msg));
				findViewById(R.id.btnScanStart).setVisibility(View.VISIBLE);
			}
		});
		builder.create().show();
	}

	private final int ADD_FAIL_MSG = 777;
	private final int STOP_SCANNING_MSG = 888;
	private final int RECEIVE_INTENT_MSG = 999;
	private final int MAX_AUTO_NUM = 5000;
	private final int MIN_DELAY_TIME = 500;
	public final String NO_DATA = "NO READ DATA";
	public final String UNKNOWN = "Unknown";
	public final String NONE = "-";
	public final String noneTemp = "";
	public final String SUCCESS = "T";
	public final String FAIL = "F";
	int failNum = 0, successNum = 0;
	boolean autoMode = false;
	boolean rebindStatus = false;
	int autoScanNum = 0, userAutoNum = 0;
	private long mTimeToScan = 0;

	public void handleMessage(Message msg) {
		switch (msg.what) {
		case ADD_FAIL_MSG:
			addScanData(NO_DATA, NONE, UNKNOWN, FAIL);
			failNum++;
			break;
		case STOP_SCANNING_MSG:
			// if(mConnection != null){
			// mConnection.stopScanning();
			// }
			setScanEnabled(false, false);
			break;
		case RECEIVE_INTENT_MSG:
			Intent data = (Intent) msg.obj;
			parseReceivedIntent(data);
			break;
		default:
			if (autoScanNum < userAutoNum) {
				autoScanNum++;
				if (rebindStatus) {
					setScanEnabled(true, false);
					createTimeCheckThread(autoScanNum);
				} else {
					addScanData(NO_DATA, NONE, UNKNOWN, FAIL);
					failNum++;
				}
			}
			break;
		}
	}

	TimeCheckThread timeCheckThread = null;

	private void createTimeCheckThread(int currentIndex) {
		timeCheckThread = new TimeCheckThread("TimeCheckThread", currentIndex);
		timeCheckThread.start();
	}

	synchronized public int getCurrentIndex() {
		return autoScanNum;
	}

	public class TimeCheckThread implements Runnable {
		Thread actionThread = null;
		int index = 0;

		private TimeCheckThread(String name, int index) {
			this.actionThread = new Thread(this, name);
			this.index = index;
		}

		public void start() {
			this.actionThread.start();
		}

		@Override
		public void run() {
			// TODO Auto-generated method stub
			try {
				while (index == getCurrentIndex() && getCurrentIndex() < userAutoNum) {
					if ((System.currentTimeMillis() - mTimeToScan) > 1000) {
						if (mScanning && !mScanMultiple) {
							setScanEnabled(false, false);
						}

						handler.sendEmptyMessage(ADD_FAIL_MSG);
						break;
					}
					Thread.sleep(100);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	WeakHandler handler = new WeakHandler(this);

	public static class WeakHandler extends Handler {
		private final WeakReference<ScanDemoActivity> weakActivity;

		public WeakHandler(ScanDemoActivity activity) {
			this.weakActivity = new WeakReference<ScanDemoActivity>(activity);
		}

		@Override
		public void handleMessage(Message msg) {
			super.handleMessage(msg);

			ScanDemoActivity activity = weakActivity.get();
			if (activity != null) {
				activity.handleMessage(msg);
			}
		}
	}

}
