package com.gen2wave.g2w_scan_demo;

import java.util.ArrayList;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class BarcodeAdapter extends BaseAdapter {

    private final LayoutInflater mInflater;
    private ArrayList<BarcodeItem> list = null;

    public BarcodeAdapter(Context ctx, ArrayList<BarcodeItem> list) {
        mInflater = (LayoutInflater) ctx.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        this.list = list;
    }

    public void add(BarcodeItem bi){
        this.list.add(bi);
    }

    public void clear(){
        this.list.clear();
    }

    @Override
    public int getCount() {
        return list.size();
    }

    @Override
    public BarcodeItem getItem(int position) {
        return this.list.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;

        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.list_scan_item2, null);

            holder = new ViewHolder();
            holder.tag = (TextView) convertView.findViewById(R.id.tvBarcodeTag);
            holder.extra = (TextView) convertView.findViewById(R.id.tvBarcodeExtra);
            holder.format = (TextView) convertView.findViewById(R.id.tvFormat);
            holder.result = (TextView) convertView.findViewById(R.id.barcode_result);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        BarcodeItem current = getItem(position);
        if (current == null) {
            holder.tag.setText("");
            holder.extra.setText("");
            holder.format.setText("");
            holder.result.setText("");
            return convertView;
        }
        holder.tag.setText(current.tag);
        holder.extra.setText(current.extra);
        holder.format.setText(current.format);
        holder.result.setText(current.result);

        return convertView;
    }

    private class ViewHolder {
        TextView tag;
        TextView extra;
        TextView format;
        TextView result;
    }
}