/*-------------------------------------------------------------------------*
 *                                                                         *
 *   THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY   *
 *   INFORMATION.  IF PUBLICATION OCCURS, THE FOLLOWING NOTICE APPLIES:    *
 *        "COPYRIGHT 2012 AMARULA SOLUTIONS, ALL RIGHTS RESERVED"          *
 *                                                                         *
 *   NO DERIVATIVE WORKS ARE ALLOWED WITHOUT OUR EXPLICIT CONSENSOUS.      *
 *                                                                         *
 *   Amarula Solutions BV                                Cruquiuskade 47   *
 *   www.amarulasolutions.com                       Amsterdam 1018 AM NL   *
 *                                                                         *
 *-------------------------------------------------------------------------*/

package com.amarula.barcodescanner.sdk;
import com.amarula.barcodescanner.sdk.IBarcodeServiceCallback;
/**
 * <p>Interface which must be implemented when developing a {@link BarcodeScannerService}
 * specialisation.</p>
 *
 * <p>All implementations have to support the state-machine gave by the following
 * states:</p>
 * <ul>
 * <li>{@link BarcodeScannerService#STATUS_UNPREPARED}: Initial state which tells that no resources are held at all</li>
 * <li>{@link BarcodeScannerService#STATUS_PREPARED}: The implementation is ready for scan</li>
 * <li>{@link BarcodeScannerService#STATUS_SCANNING_SINGLE}: The implementation is attempting to scan a single barcode</li>
 * <li>{@link BarcodeScannerService#STATUS_SCANNING_MULTI}: The implementation is scanning barcodes and will not stop until someone told to do this</li>
 * </ul>
 *
 * <p>When the current implementation has read a barcode, it will fire an Intent with action
 * {@link BarcodeScannerService#DECODE_RESULTS_ACTION} which will contains the barcode description in the ZXing way.</p>
 * <p>Have a look at {@link CameraBarcodeScannerServiceStub#constructResultIntentZXingWay}
 * to understand how to construct the result intent</p>
 * <p>For security purposes the result intent must be fired enforcing the permission:
 * {@link BarcodeScannerService#DECODE_RESULTS_PERMISSION}</p>
 *
 * @author Alberto Panizzo alberto@amarulasolutions.com
 *
 */
interface IBarcodeScannerService {
	/**
	 * <p>Setup and start the hardware with default parameters.</p>
	 * <p>TODO: Enable the customisation of hardware parameters in some ways..</p>
	 */
	int prepare();

	/**
	 * Return the current status of the service as described above
	 */
	int getStatus();

	/**
	 * <p>Start the barcode scanner library to scan a single barcode</p>
	 * <p>A general rule is that the implementation should be on status
	 * {@link BarcodeScannerService#STATUS_PREPARED} to allow the call of this function<p>
	 */
	int readBarcodeSingle();

	/**
	 * Start the barcode scanner library to scan multiple barcodes
	 * <p>A general rule is that the implementation should be on status
	 * {@link BarcodeScannerService#STATUS_PREPARED} to allow the call of this function<p>
	 */
	int readBarcodeMulti();

	/**
	 * Abort reading barcodes
	 */
	int stopReading();

	/**
	 * Release all resources
	 */
	int release();
	
	boolean registerCallback(IBarcodeServiceCallback callback);
	boolean unregisterCallback(IBarcodeServiceCallback callback);
	
	/**
     * set using IDC or not
     */
    void setEnableIDC(boolean enable);

    /**
     * set Parameter
     */
    void setParameter(int key, int value);
}