/*-------------------------------------------------------------------------*
 *                                                                         *
 *   THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY   *
 *   INFORMATION.  IF PUBLICATION OCCURS, THE FOLLOWING NOTICE APPLIES:    *
 *        "COPYRIGHT 2012 AMARULA SOLUTIONS, ALL RIGHTS RESERVED"          *
 *                                                                         *
 *   NO DERIVATIVE WORKS ARE ALLOWED WITHOUT OUR EXPLICIT CONSENSOUS.      *
 *                                                                         *
 *   Amarula Solutions BV                                Cruquiuskade 47   *
 *   www.amarulasolutions.com                       Amsterdam 1018 AM NL   *
 *                                                                         *
 *-------------------------------------------------------------------------*/

package com.amarula.barcodescanner.sdk;

import android.content.Context;
import android.content.Intent;

public class BarcodeScanner {

	public static final int VERSION = 3;

	public static final int KEYCODE_SCAN = 220;

	private static final String ACTION_BASE = "com.amarula.barcodescanner";

	/** Action to use to bind to BarcodeScanner service */
	public static final String BARCODESCANNER_ACTION = ACTION_BASE+".BARCODESCANNER_SERVICE";
	/** Action to use to force an update of scanner settings on the hardware */
	public static final String BARCODESCANNER_UPDATE_SCANNER_SETTING_ACTION = ACTION_BASE+".UPDATE_SCANNER_SETTINGS";
	/** Category which tells the BarcodeScanner service to start in caching mode */
	public static final String BARCODESCANNER_CACHE_STATE_CATEGORY = ACTION_BASE+".CACHE_STATE_CATEGORY";

	/** Permission to hold to be able to receive barcode results */
	public static final String DECODE_RESULTS_PERMISSION = ACTION_BASE+".RECEIVE_DECODE_RESULTS";

	/** Action fired when a barcode is scanned */
	public static final String DECODE_RESULTS_ACTION = ACTION_BASE+".DECODE_RESULTS";
	/** If chosen to get the barcode bitmap, you can get it using with this keyword. */
	public static final String KEY_BARCODE_BITMAP	= "bitmap";

	/** The hardware is not prepared */
	public static final int STATUS_UNPREPARED		= 0;
	/** The hardware is prepared and running */
	public static final int STATUS_PREPARED			= 1;
	/** The decoding chain is started to scan a single barcode */
	public static final int STATUS_SCANNING_SINGLE	= 2;
	/** The decoding chain is started but the first scan do not stop the scanner */
	public static final int STATUS_SCANNING_MULTI	= 3;

	/** Action to use to start Direct input service (use startService() with this) */
	public static final String DIRECT_INPUT = ACTION_BASE+".DIRECT_INPUT";
	/** Use this key to force the status of DirectInput service (boolean) */
	public static final String KEY_SET_DIRECTINPUT_ENABLED = "direct_input_enable";
	/** Use this key to force the status of "Screen On warm scanner" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_SCREEN_ON_WARM_SCANNER = "direct_input_warm_screen_on";
	/** Use this key to force the status of "Scan multiple barcodes" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_SCAN_MULTIPLE = "direct_input_scan_multiple";
	/** Use this key to force the status of "Beep on Scan" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_BEEP_ON_SCAN = "direct_input_beep";
	/** Use this key to force the status of "Vibrate on Scan" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_VIBRATE_ON_SCAN = "direct_input_vibrate";
	/** Use this key to force the status of "Append ENTER to tags" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_APPEND_ENTER_TO_TAGS = "direct_input_enter_after_tag";
	/** Use this key to force the status of "Send TAB keyevent" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_APPEND_TAB_TO_TAGS = "direct_input_tab_after_tag";
	/** Use this key to force the status of "Floating button" (boolean) */
	public static final String KEY_SET_DIRECTINPUT_FLOATING_BUTTON="direct_input_floating_button";
	/** Use this key to force the Tag prefix String (String)*/
	public static final String KEY_SET_DIRECTINPUT_TAG_PREFIX = "direct_input_tag_prefix";
	/** Use this key to force the Tag suffix String (String)*/
	public static final String KEY_SET_DIRECTINPUT_TAG_SUFFIX = "direct_input_tag_suffix";
	public static final String KEY_SET_DIRECTINPUT_DATA_OUT = "direct_input_data_out";

	/**
	 * Convenience method to Enable/Disable DirectInput functionality
	 * @param ctx Current context
	 * @param enabled
	 */
	public static void directInputForceStatus(Context ctx, boolean enabled) {
		Intent directInputIntent = new Intent(DIRECT_INPUT);
		directInputIntent.putExtra(KEY_SET_DIRECTINPUT_ENABLED, enabled);
		ctx.startService(directInputIntent);
	}
}
