//
//  UIView+LQKit.swift
//  DuanZi
//
//  Created by lequwuxian1 on 2018/8/31.
//  Copyright © 2018年 lequwuxian. All rights reserved.
//

import UIKit

extension UIView {
    
    /// 圆角
    func round()  {
        round(radius: frame.width * 0.5)
    }
    
    func round(radius:CGFloat)  {
        layer.masksToBounds = true
        layer.cornerRadius = radius
    }
    
    func round(radius:CGFloat, corners: UIRectCorner) {
        round(radius: radius, bounds: bounds, corners: corners)
    }
    
    func round(radius:CGFloat, bounds:CGRect, corners: UIRectCorner)  {
        let bezierPath = UIBezierPath(roundedRect: bounds, byRoundingCorners: corners, cornerRadii: CGSize(width: radius, height: radius))
        let maskLayer = CAShapeLayer()
        maskLayer.frame = bounds
        maskLayer.path = bezierPath.cgPath
        layer.mask = maskLayer
    }
    

    /// 边框
    func setCornerRadius(radius: CGFloat, borderColor:UIColor, borderWidth: CGFloat) {
        round(radius: radius)
        layer.borderColor = borderColor.cgColor
        layer.borderWidth = borderWidth
    }
    
    func border(width: CGFloat, color: UIColor) {
        layer.borderColor = color.cgColor
        layer.borderWidth = width
    }
    
}


// render
extension UIView {
    
    // 截图
    func screenShot(_ rect : CGRect) -> UIImage {
        var imageRet : UIImage?
        UIGraphicsBeginImageContextWithOptions(rect.size, false, 0)
        layer.render(in: UIGraphicsGetCurrentContext()!)
        imageRet = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return imageRet!
    }
    
}
