//
//  UIColor+Standard.swift
//  DuanZi
//
//  Created by lequwuxian1 on 2018/7/17.
//  Copyright © 2018年 lequwuxian. All rights reserved.
//

import UIKit

extension UIColor {

    static let lqsMain  = UIColor.rgb(rgb: 0x0e3193) //UIColor.rgb(rgb: 0x54BA8E)
    static let lqsLine  = UIColor.rgb(rgb: 0x545d84)
    static let lqsSpaceLine  = UIColor.rgb(rgb: 0xdcdcdc)
    static let lqsGrayLine  = UIColor.rgb(rgb: 0xa2a2a2)
    static let lqsMainTitle  = UIColor.rgb(rgb: 0x292929) //UIColor.rgb(rgb: 0xcdcdcd)
    static let lqsSubTitle  = UIColor.rgb(rgb: 0x919398)
    static let lqsCancle  = UIColor.rgb(rgb: 0x999999)
    static let lqsTint  = UIColor.rgb(rgb: 0xec5281)
    static let lqsBackground  = UIColor.white //UIColor.rgb(rgb: 0x313853)
    static let lqsSecondaryBackground = UIColor.rgb(rgb: 0x3a5795)
    static let lqsEmphasisBackground = UIColor.rgb(rgb: 0x2d304c)
    static let lqsBarBackground = UIColor.rgb(rgb: 0x090a1c)
    
    class func rgba(rgb:Int, alpha: CGFloat) -> UIColor {
        return UIColor(red: ((CGFloat)((rgb & 0xFF0000) >> 16)) / 255.0,
                       green: ((CGFloat)((rgb & 0xFF00) >> 8)) / 255.0,
                       blue: ((CGFloat)(rgb & 0xFF)) / 255.0,
                       alpha: alpha)
    }
    
    class func rgb(rgb:Int) -> UIColor {
        return rgba(rgb: rgb, alpha: 1.0)
    }
    
    
    class func lq_Color(color:UIColor!, dark:UIColor! = nil) -> UIColor{
        if #available(iOS 13.0, *) {
            return UIColor(dynamicProvider: { (trait) -> UIColor in
                if trait.userInterfaceStyle == .dark {
                    return dark
                }else {
                    return color
                }
            })
        }
        return color
    }
    
}


extension UIColor {
    
    static func transform(_ original: UIColor, to target: UIColor, progress: CGFloat) ->UIColor {
        
        var ored: CGFloat = 0
        var ogreen: CGFloat = 0
        var oblue: CGFloat = 0
        var oalpha: CGFloat = 0
        original.getRed(&ored, green: &ogreen, blue: &oblue, alpha: &oalpha)
        
        var tred: CGFloat = 0
        var tgreen: CGFloat = 0
        var tblue: CGFloat = 0
        var talpha: CGFloat = 0
        target.getRed(&tred, green: &tgreen, blue: &tblue, alpha: &talpha)

        var r: CGFloat = 0
        var g: CGFloat = 0
        var b: CGFloat = 0
        var a: CGFloat = 0

        r = ored - (ored - tred) * abs(progress);
        g = ogreen - (ogreen - tgreen) * abs(progress);
        b = oblue - (oblue - tblue) * abs(progress);
        a = oalpha - (oalpha - talpha) * abs(progress);

        return UIColor(red: max(min(r, 1), 0), green: max(min(g, 1), 0), blue: max(min(b, 1), 0), alpha: max(min(a, 1), 0))
    }
    
    func isEqualTo(_ color:UIColor) -> Bool {
        if color == self {
            return true
        }
        
        var ored: CGFloat = 0
        var ogreen: CGFloat = 0
        var oblue: CGFloat = 0
        var oalpha: CGFloat = 0
        color.getRed(&ored, green: &ogreen, blue: &oblue, alpha: &oalpha)
        
        var tred: CGFloat = 0
        var tgreen: CGFloat = 0
        var tblue: CGFloat = 0
        var talpha: CGFloat = 0
        self.getRed(&tred, green: &tgreen, blue: &tblue, alpha: &talpha)

        if NSString(format: "%.2f", ored).isEqual(to: NSString(format: "%.2f", tred) as String) == false {
            return false
        }
        
        if NSString(format: "%.2f", ogreen).isEqual(to: NSString(format: "%.2f", tgreen) as String) == false {
            return false
        }
        
        if NSString(format: "%.2f", oblue).isEqual(to: NSString(format: "%.2f", tblue) as String) == false {
            return false
        }
        
        if NSString(format: "%.2f", oalpha).isEqual(to: NSString(format: "%.2f", talpha) as String) == false {
            return false
        }
        return true
    }
    
}
