//
//  NSString+Standard.swift
//  DuanZi
//
//  Created by lequwuxian1 on 2018/8/8.
//  Copyright © 2018年 lequwuxian. All rights reserved.
//

import UIKit

// MARK: - Calculation
extension NSString {
    
    func sizeWithFont(font: UIFont, width: Float) -> CGSize {
        return self.calculateSize(size: CGSize.init(width: CGFloat(width), height: 999999.0), font: font)
    }
    
    func sizeWithFont(font: UIFont, height: Float) -> CGSize {
        return self.calculateSize(size: CGSize.init(width: 999999.0, height: CGFloat(height)), font: font)
    }
    
    func calculateSize(size:CGSize, font: UIFont) -> CGSize {
        return self.calculateSize(size: size, font: font, lineBreak: NSLineBreakMode.byWordWrapping)
    }
    
    func calculateSize(size:CGSize, font: UIFont, lineBreak:NSLineBreakMode) -> CGSize {
        var expectedLabelSize = CGSize.zero
        
        let paragraphStyle = NSMutableParagraphStyle.init()
        paragraphStyle.lineBreakMode = lineBreak
        expectedLabelSize = self.boundingRect(with: size,
                                              options: NSStringDrawingOptions.usesLineFragmentOrigin,
                                              attributes: [NSAttributedString.Key.font : font, NSAttributedString.Key.paragraphStyle : paragraphStyle],
                                              context: nil).size
        
        return CGSize.init(width: CGFloat(ceilf(Float(expectedLabelSize.width))), height: CGFloat(ceilf(Float(expectedLabelSize.height))))
    }
    
}

extension String {
    
    func sizeWithFont(font: UIFont, width: CGFloat) -> CGSize {
        return NSString(string: self).calculateSize(size: CGSize(width: width, height: 999999.0), font: font, lineBreak: .byWordWrapping)
    }
    
    func sizeWithFont(font: UIFont, height: CGFloat) -> CGSize {
        return NSString(string: self).calculateSize(size: CGSize(width: 999999.0, height: height), font: font)
    }
    
}


// MARK: - Determination
extension String {
    
    func isTelephone() -> Bool {
        let mobil = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$"
        let cm =  "^1(34[0-8]|(3[5-9]|5[017-9]|8[278])\\d)\\d{7}$"
        let cu = "^1(3[0-2]|5[256]|8[56])\\d{8}$"
        let ct = "^1((33|53|8[09])[0-9]|349)\\d{7}$"
        let phs = "^0(10|2[0-5789]|\\d{3})\\d{7,8}$"
        
        let regextestmobile = NSPredicate(format: "SELF MATCHES %@", mobil)
        let regextestcm = NSPredicate(format: "SELF MATCHES %@", cm)
        let regextestcu = NSPredicate(format: "SELF MATCHES %@", cu)
        let regextestct = NSPredicate(format: "SELF MATCHES %@", ct)
        let regextestphs = NSPredicate(format: "SELF MATCHES %@", phs)

        
        return
            regextestmobile.evaluate(with: self)
            || regextestcm.evaluate(with: self)
            || regextestcu.evaluate(with: self)
            || regextestct.evaluate(with: self)
            || regextestphs.evaluate(with: self)
    }
    
    //将十六进制字符串转化为 Data
        static func data(from hexStr: String) -> Data {
            let bytes = self.bytes(from: hexStr)
            return Data(bytes: bytes)
        }

        // 将16进制字符串转化为 [UInt8]
        // 使用的时候直接初始化出 Data
        // Data(bytes: Array<UInt8>)
       static func bytes(from hexStr: String) -> [UInt8] {
            assert(hexStr.count % 2 == 0, "输入字符串格式不对，8位代表一个字符")
            var bytes = [UInt8]()
            var sum = 0
            // 整形的 utf8 编码范围
            let intRange = 48...57
            // 小写 a~f 的 utf8 的编码范围
            let lowercaseRange = 97...102
            // 大写 A~F 的 utf8 的编码范围
            let uppercasedRange = 65...70
            for (index, c) in hexStr.utf8CString.enumerated() {
                var intC = Int(c.byteSwapped)
                if intC == 0 {
                    break
                } else if intRange.contains(intC) {
                    intC -= 48
                } else if lowercaseRange.contains(intC) {
                    intC -= 87
                } else if uppercasedRange.contains(intC) {
                    intC -= 55
                } else {
                    assertionFailure("输入字符串格式不对，每个字符都需要在0~9，a~f，A~F内")
                }
                sum = sum * 16 + intC
                // 每两个十六进制字母代表8位，即一个字节
                if index % 2 != 0 {
                    bytes.append(UInt8(sum))
                    sum = 0
                }
            }
            return bytes
        }
    
}


extension String {
    var localization:String {
        return NSLocalizedString(self, comment: "")
    }
}
