//
//  MDCompatible.swift
//  MillionDollarFile
//
//  Created by ifeng on 2021/3/8.
//

import UIKit


// MARK: - 自定义连接协议
extension UIViewController : MDCompatible {}
extension UIView : MDCompatible {}
public protocol MDCompatible {
    associatedtype CompatibleType
    
    var md : MDExtension<CompatibleType> {get set}
}

public extension MDCompatible {
    var md : MDExtension<Self> {
        get { return MDExtension(self) }
        set {}
    }
}

public class MDExtension <Base>{
    public let base : Base
    init(_ base: Base) {
        self.base = base
    }
    
    @objc fileprivate func innerTouchUpInsidAction(){
        print("...")
    }

}

extension MDExtension where  Base : NSObject {
        
    public var id: String? {
        get { return objc_getAssociatedObject(base, &type(of: base).PropertyKeys.dzID) as? String }
        set { objc_setAssociatedObject(base, &type(of: base).PropertyKeys.dzID, newValue, .OBJC_ASSOCIATION_RETAIN_NONATOMIC) }
    }
    
    public var associatedObj: Any? {
        get { return objc_getAssociatedObject(base, &type(of: base).PropertyKeys.dzAssociatedObj) }
        set { objc_setAssociatedObject(base, &type(of: base).PropertyKeys.dzAssociatedObj, newValue, .OBJC_ASSOCIATION_RETAIN_NONATOMIC) }
    }
    
}

extension MDExtension where  Base : UIControl {

    public var action: (()->Void)? {
        get { return objc_getAssociatedObject(base, &type(of: base).PropertyKeys.dzAction) as? (() -> Void)  }
        set { objc_setAssociatedObject(base, &type(of: base).PropertyKeys.dzAction, newValue, .OBJC_ASSOCIATION_RETAIN_NONATOMIC) }
    }
    
    
    func touchUpInsidAction(_ action:@escaping (()->Void)) {
        self.action = action
        base.addTarget(base, action: #selector(self.innerTouchUpInsidAction), for: .touchUpInside)
    }
    
    
}

extension UIControl {
    
}

extension NSObject : MDCompatible {
    
}

extension NSObject {
    fileprivate struct PropertyKeys {
        static var dzID    = "dzID"
        static var dzAction    = "dzAction"
        static var dzAssociatedObj    = "dzAssociatedObj"
    }
}
