//
//  LQJargon.swift
//  DuanZi
//
//  Created by lequwuxian1 on 2018/9/3.
//  Copyright © 2018年 lequwuxian. All rights reserved.
//

import UIKit

private var jargon : UIView? = nil
private var timer : DispatchSourceTimer? = nil

class LQJargon {
    
    private init() { }
    
    public class func showJargon(message: String) {

        let contentEdgeInsets = UIEdgeInsets(top: 15, left: 15, bottom: 15, right: 15)
        let contentSize = (message as NSString).sizeWithFont(font: UIFont.systemFont(ofSize: 15), width: 200)
        let jargonframe = CGRect(x: 0, y: 0, width: contentSize.width + contentEdgeInsets.left + contentEdgeInsets.right, height: contentSize.height + contentEdgeInsets.top + contentEdgeInsets.bottom)
        
        if jargon == nil {
            jargon = UIView()
        }
        jargon?.frame = jargonframe
        jargon?.round(radius: 3)
        
        mainWindow?.addSubview(jargon!)
        jargon?.center = CGPoint(x: UIScreen_Width * 0.5, y: UIScreen_Height * 0.5)
        jargon?.backgroundColor = UIColor.lq_Color(color: UIColor.black.withAlphaComponent(0.8), dark: .lqsMain.withAlphaComponent(0.5))
        
        let contentLabel = UILabel(frame: CGRect(x: contentEdgeInsets.left, y: contentEdgeInsets.top, width: contentSize.width, height: contentSize.height))
        contentLabel.textColor = UIColor.white
        contentLabel.font = UIFont.systemFont(ofSize: 15)
        contentLabel.text = message
        contentLabel.numberOfLines = 0
        jargon?.addSubview(contentLabel)
    }
    
    public class func hiddenJargon(message: String, delay: TimeInterval) {
        
        removeJargon()
        showJargon(message: message)
        
        var isStart = false
        
        timer = DispatchSource.makeTimerSource(flags: [], queue: DispatchQueue.main)
        timer?.schedule(wallDeadline: DispatchWallTime.now(), repeating: DispatchTimeInterval.seconds(Int(delay)), leeway : DispatchTimeInterval.seconds(0))
        timer?.setEventHandler {
            DispatchQueue.main.async {
                if isStart {
                    removeJargon()
                }
                isStart = true
            }
        }
        timer?.resume()
    }
    
    public class func hiddenJargon(message: String) {
        hiddenJargon(message: message, delay: 2)
    }
    
    public class func hiddenJargon() {
        removeJargon()
    }
    
    private class func removeJargon() {
        if jargon != nil {
            jargon?.removeFromSuperview()
            jargon = nil
        }
        
        if timer != nil {
            timer?.cancel()
            timer = nil
        }
    }

    
}
