//
//  LQBaseViewCtrl+LQKit.swift
//  DuanZi
//
//  Created by lequwuxian1 on 2019/1/12.
//  Copyright © 2019年 lequwuxian. All rights reserved.
//

import Foundation
import UIKit

extension UIViewController {
    
    
    /// <#Description#>
    ///
    /// - Parameters:
    ///   - title: <#title description#>
    ///   - message: <#message description#>
    ///   - cancel: <#cancel description#>
    ///   - comfirm: <#comfirm description#>
    ///   - clickComfirm: <#clickComfirm description#>
    ///   - clickCancel: <#clickCancel description#>
    /// - Returns: <#return value description#>
    @discardableResult
    public func alertShow(withTitle title:String?, message:String?, cancel: String?, comfirm:String?, clickComfirm:(() -> Void)?, clickCancel: (() -> Void)? = nil) -> UIAlertController? {
        
        return alertShow(withTitle: title, message: message, cancel: cancel, others: comfirm == nil ? nil : [comfirm!], clickOther: { (idx) in
            if clickComfirm != nil{
                clickComfirm!()
            }
        }, clickCancel: clickCancel)
    }

    
    /// <#Description#>
    ///
    /// - Parameters:
    ///   - title: <#title description#>
    ///   - message: <#message description#>
    ///   - cancel: <#cancel description#>
    ///   - others: <#others description#>
    ///   - clickOther: <#clickOther description#>
    ///   - clickCancel: <#clickCancel description#>
    /// - Returns: <#return value description#>
    @discardableResult
    public func alertShow(withTitle title:String?, message:String?, cancel: String?, others:[String]?, clickOther:((_ idx: Int) -> Void)?, clickCancel: (() -> Void)?) -> UIAlertController? {
        let alert = UIAlertController(title: title,
                                      message: message,
                                      preferredStyle: .alert)
        
        if cancel != nil {
            alert.addAction(UIAlertAction(title: cancel,
                                          style: .cancel) { (action) in
                                            if clickCancel != nil{
                                                clickCancel!()
                                            }
            })
        }
        
        if others != nil {
            for (idx, other) in others!.enumerated() {
                alert.addAction(UIAlertAction(title: other,
                                              style: .default,
                                              handler: { (action) in
                                                if clickOther != nil {
                                                    clickOther!(idx)
                                                }
                }))
            }
        }
        
        present(alert, animated: true, completion: nil)
        
        return alert
    }
    
    
    /// <#Description#>
    ///
    /// - Parameters:
    ///   - title: <#title description#>
    ///   - message: <#message description#>
    ///   - cancel: <#cancel description#>
    ///   - others: <#others description#>
    ///   - clickOther: <#clickOther description#>
    ///   - clickCancel: <#clickCancel description#>
    /// - Returns: <#return value description#>
    @discardableResult
    public func sheetShow(withTitle title:String?, message:String?, cancel: String?, others:[String]?, clickOther:((_ idx: Int) -> Void)?, clickCancel: (() -> Void)? = nil) -> UIAlertController? {
        let sheet = UIAlertController(title: title,
                                      message: message,
                                      preferredStyle: .actionSheet)

        if cancel != nil {
            sheet.addAction(UIAlertAction(title: cancel,
                                          style: .cancel) { (action) in
                                            if clickCancel != nil{
                                                clickCancel!()
                                            }
            })
        }
        
        
        if others != nil {
            for (idx, other) in others!.enumerated() {
                sheet.addAction(UIAlertAction(title: other,
                                              style: .default,
                                              handler: { (action) in
                                                if clickOther != nil {
                                                    clickOther!(idx)
                                                }
                }))
            }
        }
        
        present(sheet, animated: true, completion: nil)
        
        return sheet
    }
    
}


extension UIViewController {
    
    public class func top_() ->UIViewController {
        var result : UIViewController?  = top_(vc: (mainWindow?.rootViewController)!)
        
        while result!.presentedViewController != nil {
            result = top_(vc: result!.presentedViewController!)
        }
        return result!
    }
    
    public class func top_(vc: UIViewController) -> UIViewController {
        
        if vc.isKind(of: UINavigationController.self) {
            return top_(vc:(vc as! UINavigationController).topViewController!)
        }else if vc.isKind(of: UITabBarController.self) {
            return top_(vc:(vc as! UITabBarController).selectedViewController!)
        }else{
            return vc
        }
    }
    
    class var stackTop: UIViewController? {
        return top_(vc: (mainWindow?.rootViewController)!)
    }
    
    
    static func popToRoot(viewCtrl aClass:AnyClass) {
        let top = self.top_()
        if top.navigationController != nil && top.navigationController!.viewControllers.count > 1 && top.navigationController!.viewControllers.first!.isKind(of: aClass)   {
            top.navigationController?.popViewController(animated: true)
        }
    }
    
    
    /// 清除栈中某一类控制器，除了当前
    func cleanNavSub(_ viewCtrlClass:AnyClass) {
        if navigationController == nil { return }
        var viewCtrls = navigationController!.viewControllers
        viewCtrls.removeAll { (viewCtrl) -> Bool in
            return viewCtrl.isKind(of: viewCtrlClass) && viewCtrl != self
        }

        navigationController!.viewControllers = viewCtrls
    }
    
    func cleanNavSubs(_ viewCtrlClasses:[AnyClass]) {
        if navigationController == nil { return }
        let viewCtrls = navigationController!.viewControllers        

        navigationController!.viewControllers = viewCtrls.filter({ (viewCtrl) -> Bool in
            
            if viewCtrlClasses.contains(where: { viewCtrl.isKind(of:$0) }) && viewCtrl != self {
                return false
            }
            
            return true
        })
    }
    
    /// 清除栈中除了当前页和栈底之外的所有控制器
    func cleanNavSubNotMe() {
        if navigationController == nil { return }
        var viewCtrls = navigationController!.viewControllers
        viewCtrls.removeAll { (viewCtrl) -> Bool in
            let idx = navigationController!.viewControllers.firstIndex(of: viewCtrl)!
            return idx > 0 && viewCtrl != self
        }
        navigationController!.viewControllers = viewCtrls
    }
    
    func foreverProson(_ brotherClass:AnyClass = UIViewController.self) {
        if navigationController == nil { return }
        var viewCtrls = navigationController!.viewControllers
        viewCtrls.removeAll { (viewCtrl) -> Bool in
            let idx = navigationController!.viewControllers.firstIndex(of: viewCtrl)!
            return idx > 0 && self != viewCtrl && viewCtrl.isKind(of: brotherClass)
        }
        navigationController!.viewControllers = viewCtrls
    }
    
    /// 移除当前栈中某些类别控制器
    func foreverProsons(_ brotherClass:[AnyClass]) {
        if navigationController == nil { return }
        var viewCtrls = navigationController!.viewControllers
        viewCtrls.removeAll { (viewCtrl) -> Bool in
            let idx = navigationController!.viewControllers.firstIndex(of: viewCtrl)!
            var contains = false
            for brother in brotherClass {
                if viewCtrl.isKind(of: brother) {
                    contains = true
                    break
                }
            }
            return idx > 0 && self != viewCtrl && contains
        }
        navigationController!.viewControllers = viewCtrls
    }

    func contains(_ brotherClass:AnyClass) -> Bool {
        if navigationController == nil { return false }
        var isContains = NO
        navigationController!.viewControllers.forEach { vc in
            if vc.isKind(of: brotherClass) {
                isContains = YES
            }
        }
       return isContains
    }
    
    
}
