//
//  FBHeader.swift
//  FruitBox
//
//  Created by lequwuxian1 on 2020/4/16.
//  Copyright © 2020 luowenx. All rights reserved.
//

import Foundation
import UIKit

let YES = true
let NO = false

/// 长度常量
let UIScreen_Width = UIScreen.main.bounds.width
let UIScreen_Height = UIScreen.main.bounds.height

let is_iPhoneX : Bool = (UIScreen.main.bounds.width == 375.0 && UIScreen.main.bounds.height == 812.0)
let is_iPhoneXR : Bool = (UIScreen.instancesRespond(to: NSSelectorFromString("currentMode")) ? (UIScreen.main.currentMode?.size.equalTo(CGSize(width: 828, height: 1792)))! : false)
let is_iPhoneXS : Bool = (UIScreen.instancesRespond(to: NSSelectorFromString("currentMode")) ? (UIScreen.main.currentMode?.size.equalTo(CGSize(width: 1125, height: 2436)))! : false)
let is_iPhoneXS_Max : Bool = (UIScreen.instancesRespond(to: NSSelectorFromString("currentMode")) ? (UIScreen.main.currentMode?.size.equalTo(CGSize(width: 1242, height: 2688)))! : false)

let is_iPhone678 : Bool = (UIScreen.instancesRespond(to: NSSelectorFromString("currentMode")) ? (UIScreen.main.currentMode?.size.equalTo(CGSize(width: 750, height: 1334)))! : false)

let is_iPhonePlus : Bool = (UIScreen.instancesRespond(to: NSSelectorFromString("currentMode")) ? (UIScreen.main.currentMode?.size.equalTo(CGSize(width: 1242, height: 2208)))! : false)

let is_iPhoneX_X : Bool = {
    var _is_iPhoneX_ = false
    if #available(iOS 11.0, *){
        if UIApplication.shared.delegate != nil {
            _is_iPhoneX_ = (UIApplication.shared.delegate!.window!)?.safeAreaInsets.bottom ?? CGFloat(0) > CGFloat(0)
        }
    }
    return _is_iPhoneX_
}()

let kLQNavHeight : CGFloat = (44)
let kLQTabarHeight : CGFloat = (is_iPhoneX_X ? 83 : 49)
let kLQSafeBottomHeight : CGFloat = (is_iPhoneX_X ? 34 : 0)
let kLQStatusBarHeight : CGFloat = (is_iPhoneX_X ? 44 : 20)
let kLQNavANDStatusBarHeight : CGFloat = (kLQNavHeight + kLQStatusBarHeight)

let mainWindow: UIWindow? = {
    if #available(iOS 13.0, *){
        return UIApplication.shared.windows.first
    }
    return UIApplication.shared.keyWindow
}()


let kLQSIconLargeSize = CGSize.init(width: 60, height: 60)
let kLQSIconNormalSize = CGSize.init(width: 40, height: 40)
let kLQSIconSmallSize = CGSize.init(width: 36, height: 36)
let kLQSIconMinSize = CGSize.init(width: 24, height: 24)
let kLQSIconTinySize = CGSize.init(width: 20, height: 20)

//外边距
let kLQSMarginSuper     : CGFloat               = 70.0;
let kLQSMarginMax    : CGFloat                  = 60.0;
let kLQSMarginHuge    : CGFloat                 = 50.0;
let kLQSMarginLarge       : CGFloat             = 40.0;
let kLQSMarginNormal     : CGFloat              = 30.0;
let kLQSMarginSmall       : CGFloat             = 20.0;
let kLQSMarginMin      : CGFloat                = 15.0;
let kLQSMarginTiny      : CGFloat               = 10.0;
//内边距
let kLQSPaddingSuper     : CGFloat              = 30.0;
let kLQSPaddingMax     : CGFloat                = 25.0;
let kLQSPaddingHuge     : CGFloat               = 20.0;
let kLQSPaddingSpecial   : CGFloat              = 17.0;
let kLQSPaddingLarge : CGFloat                  = 15.0;
let kLQSPaddingNormal   : CGFloat               = 10.0;
let kLQSPaddingSmall     : CGFloat              = 5.0;
let kLQSPaddingMin     : CGFloat                = 2.0;
let kLQSPaddingTiny        : CGFloat            = 1.0;

/// 文件路径
let PathDocuments = "\(NSHomeDirectory())/Documents"
let PathLibrary = "\(NSHomeDirectory())/Library"
let PathTemp = "\(NSHomeDirectory())/tmp"
let PathPreferences = "\(PathLibrary)/Preferences"
let PathCaches = "\(PathLibrary)/Caches"

/// 用户信息
let kFBPathWithUserInfo = "\(PathPreferences)/kFBPathWithUserInfo.plist"
/// 应用信息
let kFBPathWithAppConfiger = "\(PathPreferences)/kFBPathWithAppConfiger.plist"


@discardableResult
public func DispatchTimer(timeInterval: Double, handler:@escaping (DispatchSourceTimer?)->()) ->DispatchSourceTimer
{
    let timer = DispatchSource.makeTimerSource(flags: [], queue: DispatchQueue.main)
    timer.schedule(deadline: .now(), repeating: timeInterval)
    timer.setEventHandler {
        DispatchQueue.main.async {
            handler(timer)
        }
    }
    timer.resume()
    return timer
}


func plus(fontSize: CGFloat)-> UIFont{
    return UIFont.systemFont(ofSize: fontSize * (UIScreen_Width/375))
}

func md_log<T>(_ message:T) {
    
    #if DEBUG
    
    print(message)

    #endif
    
    if let msg = message as? String {
        LogsManager.shared.logs.append(msg)
    }
}



func md_string(form data: Data) -> String {
    return String(format: "%@", data as CVarArg)
}

func md_int(_ hex:String) -> Int {
    var sum = 0
    // 整形的 utf8 编码范围
    let intRange = 48...57
    // 小写 a~f 的 utf8 的编码范围
    let lowercaseRange = 97...102
    // 大写 A~F 的 utf8 的编码范围
    let uppercasedRange = 65...70
    for c in hex.utf8CString {
        var intC = Int(c.byteSwapped)
        if intC == 0 {
            break
        } else if intRange.contains(intC) {
            intC -= 48
        } else if lowercaseRange.contains(intC) {
            intC -= 87
        } else if uppercasedRange.contains(intC) {
            intC -= 55
        } else {
            assertionFailure("输入字符串格式不对，每个字符都需要在0~9，a~f，A~F内")
        }
        sum = sum * 16 + intC
    }
    return sum
}
