//
//  SViewController.swift
//  Gloves
//
//  Created by ifeng on 2021/12/2.
//

import UIKit

enum LampIns {
    case redOpen
    case redClose
    case greenOpen
    case greenClose
}

class SViewController: UIViewController {
    
    let settingesButton = UIButton(type: .custom)
    let panButton = UIButton(type: .custom)
    
    let settingsView = UIView()
    let sessionModelButton = UIButton(type: .custom)
    let powerButton = UIButton(type: .custom)
    let pdButton = UIButton(type: .custom)
    let disconnectButton = UIButton(type: .custom)

    let panView = UIView()
    let inventoryButton = UIButton(type: .custom)
    let inventoryLabel = UILabel()
    let stopButton = UIButton(type: .custom)
    let clearButton = UIButton(type: .custom)

    let lampLabel = UILabel()

    
    var tagsMap : [String : BLETag] = [:]
    var tagsTableView : UITableView!
    
    var isPanding = NO
    
    var lampHander:((LampIns)->Void)?
    

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        
        settingesButton.setTitle("参数设置".localization, for: .normal)
        settingesButton.titleLabel?.font = .lqsSmaller
        settingesButton.backgroundColor = .lqsMain
        settingesButton.setTitleColor(.white, for: .normal)
        settingesButton.setTitleColor(.lqsCancle, for: .highlighted)
        settingesButton.frame = CGRect(x: 0, y: kLQStatusBarHeight, width: view.frame.width * 0.5, height: 40)
        settingesButton.addTarget(self, action: #selector(settingesButtonAction(_:)), for: .touchUpInside)
        view.addSubview(settingesButton)

        panButton.setTitle("盘点".localization, for: .normal)
        panButton.titleLabel?.font = .lqsSmaller
        panButton.backgroundColor = .lqsSpaceLine
        panButton.setTitleColor(.white, for: .normal)
        panButton.setTitleColor(.lqsCancle, for: .highlighted)
        panButton.frame = CGRect(x: settingesButton.frame.maxX, y: kLQStatusBarHeight, width: view.frame.width * 0.5, height: 40)
        panButton.addTarget(self, action: #selector(panButtonAction(_:)), for: .touchUpInside)
        view.addSubview(panButton)

        settingsView.frame = CGRect(x: 0, y: settingesButton.frame.maxY, width: view.frame.width, height:view.frame.height - settingesButton.frame.maxY - kLQSafeBottomHeight )
        view.addSubview(settingsView)
        
        sessionModelButton.setTitle("配置会话模式".localization, for: .normal)
        sessionModelButton.backgroundColor = .lqsSpaceLine
        sessionModelButton.titleLabel?.font = .lqsSmaller
        sessionModelButton.frame = CGRect(x: 15, y: 15, width: 130, height: 42)
//        sessionModelButton.round(radius: 21)
        sessionModelButton.isEnabled = NO
        sessionModelButton.setTitleColor(.white, for: .normal)
        sessionModelButton.setTitleColor(.lqsCancle, for: .highlighted)
        settingsView.addSubview(sessionModelButton)
        
        powerButton.setTitle("设置功率".localization, for: .normal)
        powerButton.backgroundColor = .lqsMain
        powerButton.titleLabel?.font = .lqsSmaller
        powerButton.frame = CGRect(x: sessionModelButton.frame.minX, y: sessionModelButton.frame.maxY + 10, width: 130, height: 42)
        powerButton.round(radius: 21)
        powerButton.setTitleColor(.white, for: .normal)
        powerButton.setTitleColor(.lqsCancle, for: .highlighted)
        settingsView.addSubview(powerButton)
        
        
        pdButton.setTitle("设置频段".localization, for: .normal)
        pdButton.backgroundColor = .lqsMain
        pdButton.titleLabel?.font = .lqsSmaller
        pdButton.frame = CGRect(x: sessionModelButton.frame.minX, y: powerButton.frame.maxY + 10, width: 130, height: 42)
        pdButton.round(radius: 21)
        pdButton.setTitleColor(.white, for: .normal)
        pdButton.setTitleColor(.lqsCancle, for: .highlighted)
        settingsView.addSubview(pdButton)
        
        
        disconnectButton.setTitle("断开连接".localization, for: .normal)
        disconnectButton.backgroundColor = .lqsMain
        disconnectButton.titleLabel?.font = .lqsSmaller
        disconnectButton.frame = CGRect(x: pdButton.frame.minX, y: pdButton.frame.maxY + 10, width: 130, height: 42)
        disconnectButton.round(radius: 21)
        disconnectButton.setTitleColor(.white, for: .normal)
        disconnectButton.setTitleColor(.lqsCancle, for: .highlighted)
        settingsView.addSubview(disconnectButton)
        
        
        panView.frame = CGRect(x: 0, y: settingesButton.frame.maxY, width: view.frame.width, height:view.frame.height - settingesButton.frame.maxY - kLQSafeBottomHeight )
        panView.isHidden = YES
        view.addSubview(panView)

        inventoryButton.setTitle("开始盘点".localization, for: .normal)
        inventoryButton.backgroundColor = .lqsMain
        inventoryButton.titleLabel?.font = .lqsSmaller
        inventoryButton.frame = CGRect(x: 15, y: 15, width: 130, height: 42)
        inventoryButton.round(radius: 21)
        inventoryButton.setTitleColor(.white, for: .normal)
        inventoryButton.setTitleColor(.lqsCancle, for: .highlighted)
        panView.addSubview(inventoryButton)
        
        inventoryLabel.textColor = .lqsCancle
        inventoryLabel.textAlignment = .right
        inventoryLabel.font = .lqsSmaller
        inventoryLabel.frame = CGRect(x: view.frame.width - 130, y: inventoryButton.frame.maxY + 20, width: 120, height: 32)
        panView.addSubview(inventoryLabel)
        
        
        stopButton.setTitle("停止盘点".localization, for: .normal)
        stopButton.backgroundColor = .lqsMain
        stopButton.titleLabel?.font = .lqsSmaller
        stopButton.frame = CGRect(x: inventoryButton.frame.maxX + 20, y: inventoryButton.frame.minY, width: 130, height: 42)
        stopButton.round(radius: 21)
        stopButton.setTitleColor(.white, for: .normal)
        stopButton.setTitleColor(.lqsCancle, for: .highlighted)
        stopButton.addTarget(self, action: #selector(stopPanAction(_:)), for: .touchUpInside)
        panView.addSubview(stopButton)
        
        
        clearButton.setTitle("清空标签".localization, for: .normal)
        clearButton.backgroundColor = .lqsMain
        clearButton.titleLabel?.font = .lqsSmaller
        clearButton.frame = CGRect(x: inventoryButton.frame.minX, y: inventoryButton.frame.maxY + 20, width: 130, height: 42)
        clearButton.round(radius: 21)
        clearButton.setTitleColor(.white, for: .normal)
        clearButton.setTitleColor(.lqsCancle, for: .highlighted)
        clearButton.addTarget(self, action: #selector(clearTagsAction(_:)), for: .touchUpInside)
        panView.addSubview(clearButton)

        
        lampLabel.textColor = .lqsCancle
        lampLabel.textAlignment = .left
        lampLabel.font = .lqsSmaller
        lampLabel.frame = CGRect(x: 15, y: clearButton.frame.maxY + 20, width: 120, height: 32)
        panView.addSubview(lampLabel)

        
        tagsTableView = UITableView(frame: CGRect(x: 15 , y: lampLabel.frame.maxY + 20, width: view.frame.width - 30, height: panView.frame.height - (lampLabel.frame.maxY + 20)))
        tagsTableView.delegate = self
        tagsTableView.dataSource = self
//        tagsTableView.setCornerRadius(radius: 8, borderColor: .lqsSpaceLine, borderWidth: 1)
        tagsTableView.tableFooterView = UIView(frame: .zero)
        tagsTableView.separatorStyle = .none
        panView.addSubview(tagsTableView)


        NotificationCenter.default.addObserver(self, selector: #selector(applicationDidEnterBackground(_:)), name: UIApplication.didEnterBackgroundNotification, object:nil)
    }
    
    
    @objc func settingesButtonAction(_ sender:UIButton) {
        if isPanding {
            return
        }
        sender.backgroundColor = .lqsMain
        panButton.backgroundColor = .lqsSpaceLine
        settingsView.isHidden = NO
        panView.isHidden = YES

    }
    
    @objc func panButtonAction(_ sender:UIButton) {
        sender.backgroundColor = .lqsMain
        settingesButton.backgroundColor = .lqsSpaceLine
        settingsView.isHidden = YES
        panView.isHidden = NO

    }
    
    @objc func stopPanAction(_ sender:UIButton) {
        isPanding =  NO
        inventoryButton.isEnabled = YES
        inventoryButton.backgroundColor = .lqsMain
    }
    
    @objc func clearTagsAction(_ sender:UIButton) {
        tagsMap.removeAll()
        inventoryLabel.text = "共读到".localization + "\(tagsMap.count)" + "个标签".localization
        tagsTableView.reloadData()
    }
    
    
    func append(_ tags:[BLETag]) {
        for tag in tags {
            if let t = tagsMap[tag.id] {
                t.number += tag.number
            } else {
                tagsMap[tag.id] = tag
            }
        }
        
//        if isPanding {
//            inventoryLabel.text = "\(tags.count)个标签"
//        } else {
        inventoryLabel.text = "共读到".localization + "\(tagsMap.count)" + "个标签".localization
//        }
        
        tagsTableView.reloadData()
    }
    
    @objc private func applicationDidEnterBackground(_ notif:NSNotification) {
        isPanding =  NO
        inventoryButton.isEnabled = YES
        inventoryButton.backgroundColor = .lqsMain
    }

}


extension SViewController : UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return tagsMap.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {

        var cell = tableView.dequeueReusableCell(withIdentifier: Scell.description()) as? Scell
        if cell == nil {
            cell = Scell(style: .subtitle, reuseIdentifier: Scell.description())
        }
        let tags = Array(tagsMap.values)
        let tag = tags[indexPath.row]
        cell?.epcLabel.text = tag.id
        cell?.numLabel.text = "\(tag.number)"
        return cell!
        }
    
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return SHeaderView(frame: CGRect(x: 0, y: 0, width: view.frame.width, height: 40))
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 40
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 40
    }

    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if isPanding {
            LQJargon.hiddenJargon(message: "请停止后操作".localization)
            return
        }
        
        sheetShow(withTitle: "设置GPO".localization, message: nil, cancel: "取消".localization, others: []) {[weak self] idx in
            if self == nil { return }
  
            
            
        }
        
    }

}


class Scell: UITableViewCell {
    
    let epcLabel = UILabel()
    let numLabel = UILabel()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        epcLabel.textAlignment = .center
        epcLabel.textColor = .lqsMainTitle
        epcLabel.font = .lqsSmall
//        epcLabel.backgroundColor = .lqsMain.withAlphaComponent(0.5)
        epcLabel.border(width: 0.5, color: .lqsSpaceLine)
        addSubview(epcLabel)
        
        numLabel.textAlignment = .center
        numLabel.textColor = .lqsMainTitle
        numLabel.font = .lqsSmall
//        numLabel.backgroundColor = .lqsMain.withAlphaComponent(0.5)
        numLabel.border(width: 0.5, color: .lqsSpaceLine)
        addSubview(numLabel)

    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        epcLabel.frame = CGRect(x: 0, y: 0, width: frame.width * 0.75, height: frame.height)
        numLabel.frame = CGRect(x: frame.width * 0.75, y: 0, width: frame.width * 0.25, height: frame.height)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

class SHeaderView: UIView {
    
    let epcLabel = UILabel()
    let numLabel = UILabel()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        epcLabel.text = "标签号".localization
        epcLabel.textAlignment = .center
        epcLabel.textColor = .lqsMainTitle
        epcLabel.font = .lqsMain
        epcLabel.backgroundColor = .lqsMain.withAlphaComponent(0.5)
        addSubview(epcLabel)
        
        numLabel.text = "次数".localization
        numLabel.textAlignment = .center
        numLabel.textColor = .lqsMainTitle
        numLabel.font = .lqsMain
        numLabel.backgroundColor = .lqsMain.withAlphaComponent(0.5)
        addSubview(numLabel)

        
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        epcLabel.frame = CGRect(x: 0, y: 0, width: frame.width * 0.75, height: frame.height)
        numLabel.frame = CGRect(x: frame.width * 0.75, y: 0, width: frame.width * 0.25, height: frame.height)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
