//
//  LogsViewController.swift
//  Gloves
//
//  Created by ifeng on 2021/12/15.
//

import UIKit

let logsPath = PathTemp + "/logs.plist"

class LogsViewController: UIViewController {

    var logsTableView : UITableView!

    var logs:[String] = LogsManager.shared.logs
    
    let shareButton = UIButton(type: .custom)
    
    var dissmissComplet:((URL)->())?

    override func viewDidLoad() {
        super.viewDidLoad()
        
        view.backgroundColor = .white

        logsTableView = UITableView(frame: CGRect(x: 15 , y: 100, width: view.frame.width - 30, height: view.frame.height - 100))
        logsTableView.delegate = self
        logsTableView.dataSource = self
        logsTableView.tableFooterView = UIView(frame: .zero)
        logsTableView.separatorStyle = .none
        view.addSubview(logsTableView)
        
        
        shareButton.setTitle("下载".localization, for: .normal)
        shareButton.backgroundColor = .lqsMain
        shareButton.frame = CGRect(x: view.frame.width - 120, y: kLQStatusBarHeight, width: 100, height: 32)
        shareButton.addTarget(self, action: #selector(sharedLogs(_:)), for: .touchUpInside)
        view.addSubview(shareButton)

        
        LQSandbox.removeAllItem(inPath: logsPath)
    }
    
    
    @objc func sharedLogs(_ sender:UIButton) {
        
        LQJargon.showJargon(message: "正在下载...".localization)
        let res = logs.jsonString()
        if res.count == 0 {
            LQJargon.hiddenJargon(message: "失败".localization)
            return
        }
        
        let url = URL(fileURLWithPath: logsPath)

        try? res.write(to:url , atomically: YES, encoding: .utf8)
        
        
        if LQSandbox.fileExists(path: logsPath) == NO {
            LQJargon.hiddenJargon(message: "失败".localization)
            return
        }
        
        LQJargon.hiddenJargon(message: "成功".localization)

        dismiss(animated: YES) {[weak self] in
            self?.dissmissComplet?(url)
        }
        
    }
        

}



extension LogsViewController : UITableViewDelegate, UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return logs.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {

        var cell = tableView.dequeueReusableCell(withIdentifier: UITableViewCell.description())
        if cell == nil {
            cell = UITableViewCell(style: .subtitle, reuseIdentifier: UITableViewCell.description())
        }
        cell?.textLabel?.text = logs[indexPath.row]
        return cell!
    }
    
}



extension Dictionary {
    
    func jsonString () -> String {
        if  JSONSerialization.isValidJSONObject(self) == false {
            print("无法解析出JSONString")
            return ""
        }
        
        do {
            let data = try JSONSerialization.data(withJSONObject: self, options: [])
            
            let JSONString = String(data: data, encoding: String.Encoding.utf8)
            
            if (JSONString != nil) {
                return JSONString!
            }
        }catch {
            
        }
        
        print("无法解析出JSONString")
        return ""
    }
    
}


extension Array {
    
    func jsonString () -> String {
        if  JSONSerialization.isValidJSONObject(self) == false {
            print("无法解析出JSONString")
            return ""
        }
        
        do {
            let data = try JSONSerialization.data(withJSONObject: self, options: [])
            
            let JSONString = String(data: data, encoding: String.Encoding.utf8)
            
            if (JSONString != nil) {
                return JSONString!
            }
        }catch {
            
        }
        
        print("无法解析出JSONString")
        return ""
    }
    
}

