/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.LF134K;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import cn.pda.serialport.SerialPort;
import cn.pda.serialport.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class LF134KManager {
    private SerialPort mSerialport = new SerialPort(Port, BaudRate, 0);
    private InputStream mIn;
    private OutputStream mOut;
    public static int Port = 14;
    public static int BaudRate = 9600;
    public static int Power = 3;
    public static final int MSG_RFID_134K = 1101;
    public static final String KEY_134K_ID = "134k_id";
    public static final String KEY_134K_COUNTRY = "134k_country";
    private Handler handler = null;
    private boolean running = true;
    private boolean startFlag = false;
    private String tag = "Rfid134k";
    ReadThread readThread;

    public LF134KManager() throws SecurityException, IOException {
        Log.e((String)"port", (String)(String.valueOf(Port) + ":" + BaudRate + ":" + Power));
        switch (Power) {
            case 2: {
                this.mSerialport.scaner_poweron();
                break;
            }
            case 0: {
                this.mSerialport.power3v3on();
                break;
            }
            case 1: {
                this.mSerialport.power_5Von();
                break;
            }
            case 3: {
                this.mSerialport.psam_poweron();
                break;
            }
            case 4: {
                this.mSerialport.rfid_poweron();
            }
        }
        this.mIn = this.mSerialport.getInputStream();
        this.mOut = this.mSerialport.getOutputStream();
        LF134KManager.sleep(500);
        byte[] temp = new byte[16];
        this.mIn.read(temp);
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    private byte[] getRecv() {
        byte[] buffer = new byte[512];
        byte[] recv = null;
        int size = 0;
        int available = 0;
        try {
            available = this.mIn.available();
            if (available > 0) {
                LF134KManager.sleep(40);
                size = this.mIn.read(buffer);
                if (size > 0) {
                    recv = new byte[size];
                    System.arraycopy(buffer, 0, recv, 0, size);
                    if (recv != null) {
                        this.resolveData(recv);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recv;
    }

    private Map<Integer, Integer> resolveData(byte[] recv) {
        Log.e((String)"resolve", (String)Tools.Bytes2HexString(recv, recv.length));
        HashMap<Integer, Integer> map = null;
        if (recv.length > 7) {
            map = new HashMap<Integer, Integer>();
            int countryCode = (recv[0] & 0xFF) + (recv[1] & 0xFF) * 256;
            int id = (recv[2] & 0xFF) + (recv[3] & 0xFF) * 256 + (recv[4] & 0xFF) * 256 * 256 + (recv[5] & 0xFF) * 256 * 256 * 256 + (recv[6] & 0xFF) * 256 * 256 * 256 * 256;
            this.sendMsg(countryCode, id);
            map.put(id, countryCode);
        }
        return map;
    }

    private void sendMsg(int countryCode, int id) {
        if (this.handler != null) {
            Message msg = new Message();
            Bundle bundle = new Bundle();
            msg.what = 1101;
            bundle.putInt(KEY_134K_ID, id);
            bundle.putInt(KEY_134K_COUNTRY, countryCode);
            msg.setData(bundle);
            this.handler.sendMessage(msg);
        }
    }

    private void findCardCMD() {
        byte[] cmd = new byte[]{-86};
        try {
            this.mOut.write(cmd);
            this.mOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startRead() {
        this.startFlag = true;
        this.mSerialport.rfidPoweron();
    }

    public void stopRead() {
        this.startFlag = false;
        this.mSerialport.rfidPoweroff();
    }

    public void close() {
        try {
            this.running = false;
            this.startFlag = false;
            this.readThread.interrupt();
            LF134KManager.sleep(100);
            if (this.mOut != null) {
                this.mOut.close();
            }
            if (this.mIn != null) {
                this.mIn.close();
            }
            if (this.mSerialport != null) {
                switch (Power) {
                    case 2: {
                        this.mSerialport.scaner_poweroff();
                        break;
                    }
                    case 0: {
                        this.mSerialport.power3v3off();
                        break;
                    }
                    case 1: {
                        this.mSerialport.power_5Voff();
                        break;
                    }
                    case 3: {
                        this.mSerialport.psam_poweroff();
                        break;
                    }
                    case 4: {
                        this.mSerialport.rfid_poweroff();
                    }
                }
                this.mSerialport.close(Port);
                Log.e((String)"134k", (String)("Close" + Port));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            while (LF134KManager.this.running) {
                if (!LF134KManager.this.startFlag) continue;
                LF134KManager.sleep(10);
                LF134KManager.this.findCardCMD();
                LF134KManager.this.getRecv();
            }
        }
    }
}

