/*
 * Decompiled with CFR 0.152.
 */
package com.android.rfid;

import android.util.Log;
import com.android.rfid.PSAM;
import com.android.rfid.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RfidManager {
    private PSAM psam = null;
    private InputStream in = null;
    private OutputStream out = null;
    private static RfidManager manager = null;

    private RfidManager(int port, int baudRate) throws IOException {
        this.psam = new PSAM(port, baudRate);
        if (this.psam == null) {
            throw new IOException();
        }
        this.in = this.psam.getInputStream();
        this.out = this.psam.getOutputStream();
    }

    public static RfidManager getRfidMananger(int port, int baudRate) throws IOException {
        if (manager == null) {
            manager = new RfidManager(port, baudRate);
        }
        return manager;
    }

    public void powerOnMCU() {
        if (this.psam != null) {
            this.psam.PowerOn_HFPsam();
        }
    }

    public void powerOffMCU() {
        if (this.psam != null) {
            this.psam.PowerOff_HFPsam();
        }
    }

    public byte[] getVersion() {
        byte[] version = null;
        byte[] recv = null;
        byte[] cmd = this.psam.getversion();
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (version = this.psam.resolveDataFromDevice(recv)) != null) {
            Log.i((String)"getVersion", (String)Tools.Bytes2HexString(version, version.length));
        }
        return version;
    }

    public byte[] inventoryM1() {
        byte[] uid = null;
        byte[] recv = null;
        byte[] cmd = this.psam.rf_card();
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (uid = this.psam.resolveDataFromDevice(recv)) != null) {
            Log.i((String)"getVersion", (String)Tools.Bytes2HexString(uid, uid.length));
        }
        return uid;
    }

    public boolean authM1(int passwordType, int sector, byte[] password) {
        byte[] recv = null;
        byte[] cmd = null;
        boolean flag = false;
        byte[] info = new byte[8];
        info[0] = (byte)passwordType;
        info[1] = (byte)sector;
        System.arraycopy(password, 0, info, 2, 6);
        cmd = this.psam.rf_authentication_cmd(info);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && this.psam.rf_check_data(recv) == 0) {
            flag = true;
        }
        return flag;
    }

    public byte[] readM1(int block) {
        byte[] data = null;
        byte[] recv = null;
        byte[] cmd = null;
        byte[] blocks = new byte[]{(byte)block};
        cmd = this.psam.rf_read_cmd(blocks);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null) {
            data = this.psam.resolveDataFromDevice(recv);
        }
        return data;
    }

    public boolean writeM1(int block, byte[] data) {
        boolean flag = false;
        byte[] recv = null;
        byte[] cmd = null;
        byte[] info = new byte[17];
        info[0] = (byte)block;
        System.arraycopy(data, 0, info, 1, 16);
        cmd = this.psam.rf_write_cmd(info);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && this.psam.rf_check_data(recv) == 0) {
            flag = true;
        }
        return flag;
    }

    public byte[] activeICcard() {
        byte[] uid = null;
        byte[] recv = null;
        byte[] data = null;
        byte[] cmd = this.psam.ucpu_open();
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (data = this.psam.resolveDataFromDevice(recv)) != null && data.length > 6) {
            Log.i((String)"getVersion", (String)Tools.Bytes2HexString(data, data.length));
            byte uidLen = data[1];
            if (uidLen >= data.length) {
                return null;
            }
            uid = new byte[uidLen];
            System.arraycopy(data, 2, uid, 0, uidLen);
        }
        return uid;
    }

    public boolean closeICcard() {
        int aa;
        boolean closeFlag = false;
        byte[] recv = null;
        Object data = null;
        byte[] cmd = this.psam.ucpu_close();
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (aa = this.psam.rf_check_data(recv)) == 0) {
            closeFlag = true;
        }
        return closeFlag;
    }

    public byte[] icCardAPDU(byte[] apdu) {
        Object recvData = null;
        byte[] recv = null;
        byte[] data = null;
        byte[] cmd = this.psam.ucpu_send_cmd(apdu);
        Log.i((String)"CPU APDU", (String)Tools.Bytes2HexString(cmd, cmd.length));
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (data = this.psam.resolveDataFromDevice(recv)) != null) {
            Log.i((String)"CPU APDU", (String)Tools.Bytes2HexString(data, data.length));
        }
        return data;
    }

    public boolean samReset(int samCard) {
        boolean resetFlag = false;
        byte[] recv = null;
        byte[] data = null;
        byte[] sam = Tools.HexString2Bytes("0" + samCard);
        byte[] cmd = this.psam.sam_reset(sam);
        Log.i((String)"SAM RESET CMD", (String)Tools.Bytes2HexString(cmd, cmd.length));
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (data = this.psam.resolveDataFromDevice(recv)) != null) {
            Log.i((String)"SAM RESET RETURN", (String)Tools.Bytes2HexString(data, data.length));
            resetFlag = true;
        }
        return resetFlag;
    }

    public byte[] samAPDU(byte[] apdu) {
        byte[] recv = null;
        byte[] data = null;
        byte[] cmd = this.psam.sam_send_cmd(apdu);
        Log.i((String)"SAM APDU", (String)Tools.Bytes2HexString(cmd, cmd.length));
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (data = this.psam.resolveDataFromDevice(recv)) != null) {
            Log.i((String)"SAM APDU", (String)Tools.Bytes2HexString(data, data.length));
        }
        return data;
    }

    public void samShutDown(int sam) {
        byte[] recv = null;
        byte[] data = null;
        byte[] samBytes = Tools.HexString2Bytes("0" + sam);
        byte[] cmd = this.psam.sam_shut_dowm(samBytes);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && (data = this.psam.resolveDataFromDevice(recv)) != null) {
            Log.i((String)"SAM shut down", (String)Tools.Bytes2HexString(data, data.length));
        }
    }

    public byte[] inventory15693() {
        byte[] uid = null;
        byte[] recv = null;
        byte[] cmd = null;
        cmd = this.psam.ISO15693_Inventory();
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null) {
            uid = this.psam.resolveDataFromDevice(recv);
        }
        return uid;
    }

    public boolean select15693(byte[] uid) {
        boolean flag = false;
        byte[] recv = null;
        byte[] cmd = null;
        cmd = this.psam.ISO15693_Select(uid);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && this.psam.rf_check_data(recv) == 0) {
            flag = true;
        }
        return flag;
    }

    public byte[] read15693(int address, int length) {
        byte[] data = null;
        byte[] recv = null;
        byte[] cmd = null;
        byte[] addr = new byte[]{(byte)address};
        byte[] len = new byte[]{(byte)length};
        cmd = this.psam.ISO15693_Read(addr, len);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null) {
            data = this.psam.resolveDataFromDevice(recv);
        }
        return data;
    }

    public boolean write15693(int address, int length, byte[] data) {
        boolean flag = false;
        byte[] recv = null;
        byte[] add = new byte[]{(byte)address};
        byte[] len = new byte[]{(byte)(length /= 2)};
        byte[] cmd = null;
        cmd = this.psam.ISO15693_Write(add, len, data);
        try {
            this.write(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recv = this.read();
        if (recv != null && this.psam.rf_check_data(recv) == 0) {
            flag = true;
        }
        return flag;
    }

    public void close(int port) {
        if (this.psam == null) {
            return;
        }
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.psam.close(port);
        manager = null;
    }

    private void write(byte[] cmd) throws IOException {
        this.out.write(cmd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] read() {
        byte[] recv = null;
        int count = 0;
        int index = 0;
        try {
            while (true) {
                if (count >= 3) {
                    Thread.sleep(30L);
                    count = this.in.available();
                    recv = new byte[count];
                    this.in.read(recv);
                    if (recv == null) return recv;
                    Log.i((String)"read recv", (String)Tools.Bytes2HexString(recv, recv.length));
                    return recv;
                }
                count = this.in.available();
                if (index > 50) {
                    return null;
                }
                ++index;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return recv;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return recv;
    }
}

