/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import android.util.Log;
import com.uhf.api.cls.BackReadOption;
import com.uhf.api.cls.ErrInfo;
import com.uhf.api.cls.GPITrigger;
import com.uhf.api.cls.GpiInfo_ST;
import com.uhf.api.cls.GpiTriggerBoundaryListener;
import com.uhf.api.cls.GpiTriggerBoundaryReasonType;
import com.uhf.api.cls.GpiTriggerBoundaryType;
import com.uhf.api.cls.GpiTriggerListener;
import com.uhf.api.cls.GpiTrigger_Type;
import com.uhf.api.cls.JniModuleAPI;
import com.uhf.api.cls.R2000_calibration;
import com.uhf.api.cls.ReadExceptionListener;
import com.uhf.api.cls.ReadListener;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Reader {
    public static final int MAXANTCNT = 16;
    public static final int MAXIPSTRLEN = 50;
    public static final int HOPTABLECNT = 100;
    public static final int MAXEPCBYTESCNT = 62;
    public static final int MAXEMBDATALEN = 128;
    public static final int MAXINVPOTLSCNT = 6;
    private final int JniBytesBufferLength = 500;
    JniModuleAPI japi;
    int[] hReader;
    int m_gError;
    String addr;
    Thread m_ThreadForAll;
    long m_ThreadForAllid;
    boolean m_IsReadingForAll;
    boolean m_IsReadThRunning;
    BackReadOption m_BackReadOp;
    int m_FastReadOption;
    int[] m_BackReadAnts = new int[16];
    int m_BackReadAntsCnt;
    protected List<ReadListener> readListeners;
    protected List<ReadExceptionListener> readExceptionListeners;
    protected List<GpiTriggerListener> gpitriListener;
    protected List<GpiTriggerBoundaryListener> gpitriboundListener;
    protected int IT_CT_m1_keep = 15;
    protected int IT_CT_m1_toma = 5;
    protected int IT_CT_m1_cycle = 1000;
    protected int IT_CT_m2_keepcount = 10;
    protected int IT_CT_m2_cycle = 500;
    protected int IT_CT_m2_toma = 20;
    protected int IT_CT_m2_tomc = 10;
    protected int IT_CT_m3_cycleread = 300;
    protected int IT_CT_m3_cyclestop = 200;
    protected int IT_CT_m3_toma = 1;
    boolean isIT_CT_run;
    protected final int IT_CT_M1_STEP1 = 0;
    final int IT_CT_M1_STEP2 = 1;
    final int IT_CT_M2_STEP1 = 2;
    final int IT_CT_M2_STEP2 = 3;
    final int IT_CT_M3 = 4;
    protected final int IT_CT_M1_TESTFORDJ_STEP1 = 5;
    final int IT_CT_M1_TESTFORDJ_STEP2 = 6;
    long IT_CT_start;
    int IT_CT_step;
    protected int IT_CT_step_init = 0;
    int IT_CT_c;
    int totalcountlast = 0;
    int totalcount;
    long vstaticstarttick;
    Thread IT_CT_thread;
    IT_MODE it_mode_V;
    Thread IT_S2_thread;
    boolean isIT_S2_run;
    long IT_S2_start;
    int IT_S2_step;
    boolean IT_S2_istargetA;
    protected final int IT_S2_M1_STEP1 = 0;
    final int IT_S2_M1_STEP2 = 1;
    protected int IT_S2_m1_cycle = 500;
    protected int IT_S2_ctagcount = 50;
    protected int IT_S2_m1_cycle2 = 100;
    protected int IT_S2_ctagcount2 = 2;
    Thread IT_E7_thread;
    boolean isIT_E7_run;
    long IT_E7_start;
    int IT_E7_step;
    boolean IT_E7_istargetA;
    protected final int IT_E7_M1_STEP1 = 0;
    final int IT_E7_M1_STEP2 = 1;
    final int IT_E7_M1_STEP3 = 2;
    final int IT_E7_M1_STEP4 = 3;
    final int IT_E7_M1_STEP5 = 4;
    protected int IT_E7_rfm = 101;
    protected int IT_E7_m1_cycle = 500;
    protected int IT_E7_ctagcount = 50;
    protected int IT_E7_m1_cycle2 = 100;
    protected int IT_E7_ctagcount2 = 2;
    protected int IT_E7_m1_cycle3 = 70;
    protected int IT_E7_ctagcount3 = 1;
    Region_Conf IT_E7_rg;
    int IT_E7_centrefre = 915250;
    int IT_E7_lowfre = 902250;
    int IT_E7_highfre = 927250;
    int IT_E7_pow = 3300;
    int[] pants;
    int pantcnt;
    int poption;
    Lock lockobj_newadd = new ReentrantLock();
    Vector<String> quetagstr = new Vector();
    int[] IT_CT_fres_NA = new int[]{915750, 927250, 902750, 914250, 925250, 904750, 916250, 926750, 903250, 913250, 921250, 906250, 917250, 924250, 905750, 915250, 923750, 907750, 919250, 926250, 908750, 910250, 922750, 912250};
    int[] IT_CT_fres_cn = new int[]{922625, 924375, 920625, 922375, 924125, 920875, 922875, 923875, 921125, 922125, 923625, 921375, 923375, 921875, 923125, 921625};
    boolean isfilterpw = false;
    AntPowerConf setpower;

    private void CLOGS() {
    }

    private void ALOGS(String mess) {
    }

    private void toDlogAPI(String mess) {
        Log.d((String)"ModuleAPI", (String)mess);
    }

    private void toDlog(String mess) {
        Log.d((String)"MYINFO", (String)mess);
    }

    public boolean Set_IT_Params(IT_MODE it_mode, Object[] objs) throws Exception {
        if (it_mode == IT_MODE.IT_MODE_CT) {
            try {
                int p = 0;
                this.IT_CT_m1_keep = (Integer)objs[p++];
                this.IT_CT_m1_toma = (Integer)objs[p++];
                this.IT_CT_m3_cycleread = (Integer)objs[p++];
                this.IT_CT_m3_cyclestop = (Integer)objs[p++];
                this.IT_CT_m3_toma = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("Length must be 5 and type must be Integer.");
            }
            return true;
        }
        if (it_mode == IT_MODE.IT_MODE_S2) {
            try {
                int p = 0;
                this.IT_S2_m1_cycle = (Integer)objs[p++];
                this.IT_S2_ctagcount = (Integer)objs[p++];
                this.IT_S2_m1_cycle2 = (Integer)objs[p++];
                this.IT_S2_ctagcount2 = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("Length must be 4 and type must be Integer.");
            }
            return true;
        }
        if (it_mode == IT_MODE.IT_MODE_E7 || it_mode == IT_MODE.IT_MODE_E7v2) {
            try {
                int p = 0;
                this.IT_E7_m1_cycle = (Integer)objs[p++];
                this.IT_E7_ctagcount = (Integer)objs[p++];
                this.IT_E7_m1_cycle2 = (Integer)objs[p++];
                this.IT_E7_ctagcount2 = (Integer)objs[p++];
                this.IT_E7_rfm = (Integer)objs[p++];
            }
            catch (Exception ex) {
                throw new Exception("Length must be 4 and type must be Integer.");
            }
            return true;
        }
        return false;
    }

    public void Setdutycycle(int option) {
        if (option < 0 || option > 11) {
            return;
        }
        this.IT_CT_m3_cyclestop = (int)((double)option * 0.05 * 500.0);
        this.IT_CT_m3_cycleread = 500 - this.IT_CT_m3_cyclestop;
    }

    public Reader() {
        this.hReader = new int[1];
        this.japi = new JniModuleAPI();
        this.readListeners = new Vector<ReadListener>();
        this.readExceptionListeners = new Vector<ReadExceptionListener>();
        this.gpitriListener = new Vector<GpiTriggerListener>();
        this.gpitriboundListener = new Vector<GpiTriggerBoundaryListener>();
    }

    public void Hex2Str(byte[] buf, int len, char[] out) {
        char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < len; ++i) {
            out[i * 2] = hexc[(buf[i] & 0xFF) / 16];
            if (i * 2 + 1 >= out.length) continue;
            out[i * 2 + 1] = hexc[(buf[i] & 0xFF) % 16];
        }
    }

    private char[] bytestochars(byte[] bdata) {
        char[] cdata = new char[bdata.length];
        for (int i = 0; i < bdata.length; ++i) {
            cdata[i] = (char)bdata[i];
        }
        return cdata;
    }

    private byte[] charstobytes(char[] cdata) {
        int i;
        if (cdata == null) {
            return null;
        }
        int len = 0;
        for (i = 0; i < cdata.length && cdata[i] != '\u0000'; ++i) {
            ++len;
        }
        byte[] bdata = new byte[len];
        for (i = 0; i < len; ++i) {
            bdata[i] = (byte)cdata[i];
        }
        return bdata;
    }

    public READER_ERR InitReader(String src, Reader_Type rtype) {
        int re = this.japi.InitReader(this.hReader, src, rtype.value());
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR InitReader_Notype(String src, int rtype) {
        this.toDlogAPI("InitReader_Notype-" + src + " " + String.valueOf(rtype));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.InitReader_Notype(this.hReader, src, rtype);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                this.addr = src;
                Inv_Potls_ST ipst = new Inv_Potls_ST();
                ipst.potlcnt = 1;
                ipst.potls = new Inv_Potl[1];
                ipst.potls[0] = new Inv_Potl();
                ipst.potls[0].weight = 30;
                ipst.potls[0].potl = SL_TagProtocol.SL_TAG_PROTOCOL_GEN2;
                this.ParamSet(Mtr_Param.MTR_PARAM_TAG_INVPOTL, ipst);
            } else {
                this.hReader[0] = 0;
            }
            return ERR;
        }
    }

    public String GetReaderAddress() {
        return this.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetHardwareDetails(HardwareDetails val) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[500];
            int re = this.japi.GetHardwareDetails_BaseType(this.hReader[0], data);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                val.module = Module_Type.valueOf(data[0]);
                switch (data[1]) {
                    case 0: {
                        val.board = MaindBoard_Type.MAINBOARD_NONE;
                        break;
                    }
                    case 1: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM7;
                        break;
                    }
                    case 2: {
                        val.board = MaindBoard_Type.MAINBOARD_SERIAL;
                        break;
                    }
                    case 3: {
                        val.board = MaindBoard_Type.MAINBOARD_WIFI;
                        break;
                    }
                    case 4: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM9;
                        break;
                    }
                    case 5: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM9_WIFI;
                    }
                }
                val.logictype = Reader_Type.valueOf(data[2]);
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CloseReader() {
        this.toDlogAPI("CloseReader-");
        Reader reader = this;
        synchronized (reader) {
            this.japi.CloseReader(this.hReader[0]);
            this.addr = "";
            this.hReader[0] = 0;
            this.readListeners.clear();
            this.readExceptionListeners.clear();
            this.gpitriListener.clear();
            this.gpitriboundListener.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetTagData(int ant, char bank, int address, int blkcnt, byte[] data, byte[] accesspasswd, short timeout) {
        this.toDlogAPI("GetTagData-" + String.valueOf(ant) + " " + String.valueOf(bank) + " " + String.valueOf(address) + " " + String.valueOf(blkcnt));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetTagData(this.hReader[0], ant, bank, address, blkcnt, data, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR WriteTagData(int ant, char bank, int address, byte[] data, int datalen, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.WriteTagData(this.hReader[0], ant, bank, address, data, datalen, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR WriteTagEpcEx(int ant, byte[] Epc, int epclen, byte[] accesspwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.WriteTagEpcEx(this.hReader[0], ant, Epc, epclen, accesspwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory(int[] ants, int antcnt, short timeout, TAGINFO[] pTInfo, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                for (int i = 0; i < tagcnt[0]; ++i) {
                    TAGINFO pTInfoa = new TAGINFO();
                    READER_ERR er = this.GetNextTag(pTInfoa);
                    if (er != READER_ERR.MT_OK_ERR) continue;
                    pTInfo[i] = pTInfoa;
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_Raw(int[] ants, int antcnt, short timeout, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_Single(int[] ants, int antcnt, short timeout, int[] tagcnt, TAGINFO TI) {
        EmbededData_ST edst2 = new EmbededData_ST();
        READER_ERR err = this.ParamGet(Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, edst2);
        boolean isemd = false;
        if (err == READER_ERR.MT_OK_ERR && edst2 != null && edst2.bytecnt != 0) {
            isemd = true;
        }
        Reader reader = this;
        synchronized (reader) {
            long st = System.currentTimeMillis();
            READER_ERR ERR = READER_ERR.MT_OK_ERR;
            boolean isbreak = false;
            while (true) {
                int re;
                if (((ERR = READER_ERR.valueOf(re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, (short)20, tagcnt))) != READER_ERR.MT_OK_ERR || tagcnt[0] <= 0) && System.currentTimeMillis() - st < (long)timeout) {
                    continue;
                }
                if (ERR == READER_ERR.MT_OK_ERR) {
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO pTInfoa = new TAGINFO();
                        READER_ERR er = this.GetNextTag(pTInfoa);
                        if (er != READER_ERR.MT_OK_ERR) continue;
                        if (isemd) {
                            if (pTInfoa.EmbededDatalen <= 0) continue;
                            TI.ReadCnt = pTInfoa.ReadCnt;
                            TI.RSSI = pTInfoa.RSSI;
                            TI.AntennaID = pTInfoa.AntennaID;
                            TI.Frequency = pTInfoa.Frequency;
                            TI.TimeStamp = pTInfoa.TimeStamp;
                            System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                            System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                            TI.EpcId = new byte[pTInfoa.Epclen];
                            TI.Epclen = pTInfoa.Epclen;
                            System.arraycopy(pTInfoa.EpcId, 0, TI.EpcId, 0, TI.Epclen);
                            System.arraycopy(pTInfoa.CRC, 0, TI.CRC, 0, 2);
                            TI.EmbededData = new byte[pTInfoa.EmbededDatalen];
                            TI.EmbededDatalen = pTInfoa.EmbededDatalen;
                            System.arraycopy(pTInfoa.EmbededData, 0, TI.EmbededData, 0, TI.EmbededDatalen);
                            tagcnt[0] = 1;
                            isbreak = true;
                            break;
                        }
                        TI.ReadCnt = pTInfoa.ReadCnt;
                        TI.RSSI = pTInfoa.RSSI;
                        TI.AntennaID = pTInfoa.AntennaID;
                        TI.Frequency = pTInfoa.Frequency;
                        TI.TimeStamp = pTInfoa.TimeStamp;
                        System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                        System.arraycopy(pTInfoa.PC, 0, TI.PC, 0, 2);
                        TI.EpcId = new byte[pTInfoa.Epclen];
                        TI.Epclen = pTInfoa.Epclen;
                        System.arraycopy(pTInfoa.EpcId, 0, TI.EpcId, 0, TI.Epclen);
                        System.arraycopy(pTInfoa.CRC, 0, TI.CRC, 0, 2);
                        TI.EmbededData = new byte[pTInfoa.EmbededDatalen];
                        TI.EmbededDatalen = pTInfoa.EmbededDatalen;
                        if (pTInfoa.EmbededDatalen > 0) {
                            System.arraycopy(pTInfoa.EmbededData, 0, TI.EmbededData, 0, TI.EmbededDatalen);
                        }
                        tagcnt[0] = 1;
                        isbreak = true;
                        break;
                    }
                }
                if (isbreak || System.currentTimeMillis() - st >= (long)timeout) break;
            }
            if (!isbreak) {
                tagcnt[0] = 0;
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_BaseType(int[] ants, int antcnt, short timeout, byte[] outbuf, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_BaseType(this.hReader[0], ants, antcnt, timeout, outbuf, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetNextTag(TAGINFO TI) {
        Reader reader = this;
        synchronized (reader) {
            byte[] tagbuf = new byte[230];
            int pos = 0;
            int re = this.japi.GetNextTag_BaseType(this.hReader[0], tagbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                TI.ReadCnt = tagbuf[pos++] & 0xFF;
                TI.RSSI = tagbuf[pos++];
                TI.AntennaID = tagbuf[pos++];
                TI.Frequency = (tagbuf[pos] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                TI.TimeStamp = (tagbuf[pos += 4] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                pos += 4;
                TI.Res[0] = tagbuf[pos++];
                TI.Res[1] = tagbuf[pos++];
                int epclen = tagbuf[pos] << 8 | tagbuf[pos + 1];
                pos += 2;
                TI.PC[0] = tagbuf[pos++];
                TI.PC[1] = tagbuf[pos++];
                TI.EpcId = new byte[epclen];
                TI.Epclen = (short)epclen;
                System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
                pos += epclen;
                TI.CRC[0] = tagbuf[pos++];
                TI.CRC[1] = tagbuf[pos++];
                int emddatalen = tagbuf[pos] << 8 | tagbuf[pos + 1];
                pos += 2;
                TI.EmbededData = new byte[emddatalen];
                TI.EmbededDatalen = (short)emddatalen;
                if (emddatalen > 0) {
                    System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetNextTag_BaseType(byte[] outbuf) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetNextTag_BaseType(this.hReader[0], outbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR LockTag(int ant, byte lockobjects, short locktypes, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.LockTag(this.hReader[0], ant, lockobjects, locktypes, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR KillTag(int ant, byte[] killpasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.KillTag(this.hReader[0], ant, killpasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR Lock180006BTag(int ant, int startblk, int blkcnt, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.Lock180006BTag(this.hReader[0], ant, startblk, blkcnt, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR BlockPermaLock(int ant, int readlock, int startblk, int blkrange, byte[] mask, byte[] pwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.BlockPermaLock(this.hReader[0], ant, readlock, startblk, blkrange, mask, pwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR BlockErase(int ant, int bank, int wordaddr, int wordcnt, byte[] pwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.BlockErase(this.hReader[0], ant, bank, wordaddr, wordcnt, pwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR EraseDataOnReader() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.EraseDataOnReader(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SaveDataOnReader(int address, byte[] data, int datalen) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.SaveDataOnReader(this.hReader[0], address, data, datalen);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadDataOnReader(int address, byte[] data, int datalen) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.ReadDataOnReader(this.hReader[0], address, data, datalen);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR CustomCmd(int ant, CustomCmdType cmdtype, Object CustomPara, Object CustomRet) {
        Reader reader = this;
        synchronized (reader) {
            byte[] para = null;
            byte[] ret = null;
            switch (cmdtype) {
                case IMPINJ_M4_Qt: {
                    Object CustomPara2 = (IMPINJM4QtPara)CustomPara;
                    para = new byte[22];
                    ret = new byte[10];
                    System.arraycopy(((IMPINJM4QtPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF000000) >> 24);
                    para[5] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF0000) >> 16);
                    para[6] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF00) >> 8);
                    para[7] = (byte)(((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF);
                    para[8] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF000000) >> 24);
                    para[9] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF0000) >> 16);
                    para[10] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF00) >> 8);
                    para[11] = (byte)(((IMPINJM4QtPara)CustomPara2).MemType & 0xFF);
                    para[12] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF000000) >> 24);
                    para[13] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF0000) >> 16);
                    para[14] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF00) >> 8);
                    para[15] = (byte)(((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF);
                    para[16] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF000000) >> 24);
                    para[17] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF0000) >> 16);
                    para[18] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF00) >> 8);
                    para[19] = (byte)(((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF);
                    para[20] = (byte)((((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[21] = (byte)(((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case ALIEN_Higgs3_BlockReadLock: {
                    para = new byte[7];
                    ret = new byte[7];
                    Object CustomPara2 = (ALIENHiggs3BlockReadLockPara)CustomPara;
                    System.arraycopy(((ALIENHiggs3BlockReadLockPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = ((ALIENHiggs3BlockReadLockPara)CustomPara2).BlkBits;
                    para[5] = (byte)((((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[6] = (byte)(((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_ChangeEAS: {
                    para = new byte[7];
                    ret = new byte[7];
                    Object CustomPara2 = (NXPChangeEASPara)CustomPara;
                    System.arraycopy(((NXPChangeEASPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = (byte)((NXPChangeEASPara)CustomPara2).isSet;
                    para[5] = (byte)((((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[6] = (byte)(((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_EASAlarm: {
                    para = new byte[5];
                    ret = new byte[5];
                    Object CustomPara2 = (NXPEASAlarmPara)CustomPara;
                    para[0] = ((NXPEASAlarmPara)CustomPara2).DR;
                    ((NXPEASAlarmPara)CustomPara2).MC = (byte)11;
                    para[1] = 11;
                    para[2] = ((NXPEASAlarmPara)CustomPara2).TrExt;
                    para[3] = (byte)((((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[4] = (byte)(((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_U8_InventoryMode: {
                    NXP_U8_InventoryModePara ctpara = (NXP_U8_InventoryModePara)CustomPara;
                    para = ctpara.Mode;
                    ret = new byte[1];
                    break;
                }
                default: {
                    return READER_ERR.MT_OP_NOT_SUPPORTED;
                }
            }
            int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype.value(), para, ret);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR CustomCmd_BaseType(int ant, int cmdtype, byte[] CustomPara, byte[] CustomRet) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype, CustomPara, CustomRet);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SetGPO(int gpoid, int val) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.SetGPO(this.hReader[0], gpoid, val);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetGPI(int gpoid, int[] val) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetGPI(this.hReader[0], gpoid, val);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetGPIEx(GpiInfo_ST gpist) {
        Reader reader = this;
        synchronized (reader) {
            byte[] gpibytes = new byte[500];
            int re = this.japi.GetGPIEx_BaseType(this.hReader[0], gpibytes);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                gpist.gpiCount = gpibytes[0];
                for (int i = 0; i < gpist.gpiCount; ++i) {
                    gpist.gpiStats[i].GpiId = gpibytes[1 + 2 * i];
                    gpist.gpiStats[i].State = gpibytes[2 + 2 * i];
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR PsamTransceiver(int soltid, int coslen, byte[] cos, int[] cosresplen, byte[] cosresp, byte[] errcode, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.PsamTransceiver(this.hReader[0], soltid, coslen, cos, cosresplen, cosresp, errcode, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    private int GetIntFrByteArray(byte[] byarray, int offset) {
        return (byarray[offset] & 0xFF) << 24 | (byarray[offset + 1] & 0xFF) << 16 | (byarray[offset + 2] & 0xFF) << 8 | byarray[offset + 3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ParamGet(Mtr_Param key, Object val) {
        Reader reader = this;
        synchronized (reader) {
            int re = -1;
            byte[] data = new byte[500];
            switch (key) {
                case MTR_PARAM_RF_ANTPOWER: {
                    int i;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((AntPowerConf)val).antcnt = data[0];
                    for (i = 0; i < data[0]; ++i) {
                        AntPower apcf = new AntPower();
                        apcf.antid = data[i * 5 + 1];
                        apcf.readPower = (short)(data[i * 5 + 2] << 8 | data[i * 5 + 3] & 0xFF);
                        apcf.writePower = (short)(data[i * 5 + 4] << 8 | data[i * 5 + 5] & 0xFF);
                        ((AntPowerConf)val).Powers[i] = apcf;
                    }
                    if (!this.isfilterpw || this.setpower == null) break;
                    ((AntPowerConf)val).antcnt = this.setpower.antcnt;
                    for (i = 0; i < this.setpower.antcnt; ++i) {
                        ((AntPowerConf)val).Powers[i].writePower = this.setpower.Powers[i].writePower;
                        ((AntPowerConf)val).Powers[i].readPower = this.setpower.Powers[i].readPower;
                    }
                    break;
                }
                case MTR_PARAM_TAG_FILTER: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((TagFilter_ST)val).bank = data[0];
                    ((TagFilter_ST)val).startaddr = (data[1] & 0xFF) << 24 | data[2] << 16 | data[3] << 8 | data[4] & 0xFF;
                    ((TagFilter_ST)val).flen = data[5] << 24 | data[6] << 16 | data[7] << 8 | data[8] & 0xFF;
                    int ilen = ((TagFilter_ST)val).flen / 8;
                    if (((TagFilter_ST)val).flen % 8 != 0) {
                        ++ilen;
                    }
                    System.arraycopy(data, 9, ((TagFilter_ST)val).fdata, 0, ilen);
                    ((TagFilter_ST)val).isInvert = data[9 + ilen];
                    break;
                }
                case MTR_PARAM_TAG_EMBEDEDDATA: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((EmbededData_ST)val).bank = data[1];
                    ((EmbededData_ST)val).startaddr = data[2] << 24 | data[3] << 16 | data[4] << 8 | data[5] & 0xFF;
                    ((EmbededData_ST)val).bytecnt = data[6] << 24 | data[7] << 16 | data[8] << 8 | data[9] & 0xFF;
                    if (data[0] == 14) {
                        System.arraycopy(data, 10, ((EmbededData_ST)val).accesspwd, 0, 4);
                        break;
                    }
                    if (data[0] != 10) break;
                    ((EmbededData_ST)val).accesspwd = null;
                    break;
                }
                case MTR_PARAM_TAG_INVPOTL: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((Inv_Potls_ST)val).potlcnt = data[0];
                    ((Inv_Potls_ST)val).potls = new Inv_Potl[data[0]];
                    for (int i = 0; i < data[0]; ++i) {
                        ((Inv_Potls_ST)val).potls[i] = new Inv_Potl();
                        ((Inv_Potls_ST)val).potls[i].potl = SL_TagProtocol.valueOf(data[i * 5 + 1]);
                        ((Inv_Potls_ST)val).potls[i].weight = this.GetIntFrByteArray(data, i * 5 + 2);
                    }
                    break;
                }
                case MTR_PARAM_READER_CONN_ANTS: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((ConnAnts_ST)val).antcnt = data[0];
                    for (int i = 0; i < data[0]; ++i) {
                        ((ConnAnts_ST)val).connectedants[i] = data[i + 1];
                    }
                    break;
                }
                case MTR_PARAM_READER_VERSION: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ReaderVersion rdrver = (ReaderVersion)val;
                    if (data[0] == 1 && data[1] == 0 && data[2] == 0) {
                        rdrver.hardwareVer = data[0] + ".";
                        rdrver.hardwareVer = rdrver.hardwareVer + data[1] + ".";
                        rdrver.hardwareVer = rdrver.hardwareVer + data[2] + ".";
                        rdrver.hardwareVer = rdrver.hardwareVer + data[3];
                        rdrver.softwareVer = data[4] + ".";
                        rdrver.softwareVer = rdrver.softwareVer + data[5] + ".";
                        rdrver.softwareVer = rdrver.softwareVer + data[6] + ".";
                        rdrver.softwareVer = rdrver.softwareVer + data[7];
                        break;
                    }
                    byte[] v1by = new byte[]{data[0]};
                    rdrver.hardwareVer = Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[1];
                    rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[2];
                    rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[3];
                    rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by);
                    v1by[0] = data[4];
                    rdrver.softwareVer = Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[5];
                    rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[6];
                    rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[7];
                    rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by);
                    break;
                }
                case MTR_PARAM_FREQUENCY_REGION: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int rgint = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    ((Region_Conf[])val)[0] = Region_Conf.valueOf(rgint);
                    break;
                }
                case MTR_PARAM_FREQUENCY_HOPTABLE: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((HoptableData_ST)val).lenhtb = data[0];
                    for (int i = 0; i < data[0]; ++i) {
                        ((HoptableData_ST)val).htb[i] = (data[i * 4 + 1] & 0xFF) << 24 | (data[i * 4 + 2] & 0xFF) << 16 | (data[i * 4 + 3] & 0xFF) << 8 | data[i * 4 + 4] & 0xFF;
                    }
                    break;
                }
                case MTR_PARAM_RF_ANTPORTS_VSWR: {
                    int i;
                    AntPortsVSWR apvswr = (AntPortsVSWR)val;
                    data[0] = (byte)apvswr.andid;
                    data[1] = (byte)apvswr.region.value();
                    data[2] = (byte)((apvswr.power & 0xFF00) >> 8);
                    data[3] = (byte)(apvswr.power & 0xFF);
                    data[4] = (byte)(apvswr.frecount >> 24 & 0xFF);
                    data[5] = (byte)(apvswr.frecount >> 16 & 0xFF);
                    data[6] = (byte)(apvswr.frecount >> 8 & 0xFF);
                    data[7] = (byte)(apvswr.frecount & 0xFF);
                    boolean islbt = (apvswr.frecount & 0xFFFFFF00) > 0;
                    int count = apvswr.frecount & 0xFF;
                    for (i = 0; i < count; ++i) {
                        data[8 + i * 4] = (byte)(apvswr.vswrs[i].frequency >> 24 & 0xFF);
                        data[8 + i * 4 + 1] = (byte)(apvswr.vswrs[i].frequency >> 16 & 0xFF);
                        data[8 + i * 4 + 2] = (byte)(apvswr.vswrs[i].frequency >> 8 & 0xFF);
                        data[8 + i * 4 + 3] = (byte)(apvswr.vswrs[i].frequency >> 0 & 0xFF);
                    }
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    apvswr.frecount = data[0] & 0xFF;
                    for (i = 0; i < apvswr.frecount; ++i) {
                        float rl;
                        apvswr.vswrs[i].frequency = (data[1 + i * 5] & 0xFF) << 24 | (data[1 + i * 5 + 1] & 0xFF) << 16 | (data[1 + i * 5 + 2] & 0xFF) << 8 | data[1 + i * 5 + 3] & 0xFF;
                        if (islbt) {
                            apvswr.vswrs[i].vswr = rl = (float)data[1 + i * 5 + 4];
                            continue;
                        }
                        rl = (float)Math.pow(10.0, (float)(data[1 + i * 5 + 4] & 0xFF) / 10.0f / 20.0f);
                        apvswr.vswrs[i].vswr = (1.0f + rl) / (rl - 1.0f);
                    }
                    break;
                }
                case MTR_PARAM_READER_IP: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((Reader_Ip)val).ip = new byte[data[0]];
                    ((Reader_Ip)val).mask = new byte[data[1]];
                    ((Reader_Ip)val).gateway = new byte[data[2]];
                    System.arraycopy(data, 3, ((Reader_Ip)val).ip, 0, data[0]);
                    System.arraycopy(data, 3 + data[0], ((Reader_Ip)val).mask, 0, data[1]);
                    System.arraycopy(data, 3 + data[0] + data[1], ((Reader_Ip)val).gateway, 0, data[2]);
                    break;
                }
                case MTR_PARAM_CUSTOM: {
                    CustomParam_ST cpst = (CustomParam_ST)val;
                    byte[] tmppname = null;
                    try {
                        tmppname = cpst.ParamName.getBytes("US-ASCII");
                    }
                    catch (Exception count) {
                        // empty catch block
                    }
                    System.arraycopy(tmppname, 0, data, 0, tmppname.length);
                    data[tmppname.length] = 0;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int CParamlen = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    cpst.ParamVal = new byte[CParamlen - 50];
                    System.arraycopy(data, 50, cpst.ParamVal, 0, CParamlen - 50);
                    break;
                }
                case MTR_PARAM_READER_WATCHDOG: 
                case MTR_PARAM_READER_ERRORDATA: {
                    byte[] retdata = (byte[])val;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), retdata);
                    break;
                }
                case MTR_PARAM_SAVEINMODULE: {
                    int i;
                    Default_Param dp = (Default_Param)val;
                    int mtspos = 0;
                    data[mtspos++] = (byte)dp.key.value();
                    data[mtspos++] = (byte)(dp.isdefault ? 1 : 0);
                    if (dp.key != Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD && dp.key != Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION && dp.key != Mtr_Param.MTR_PARAM_POTL_GEN2_Q && dp.key != Mtr_Param.MTR_PARAM_RF_ANTPOWER && dp.key != Mtr_Param.MTR_PARAM_FREQUENCY_REGION) {
                        if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE) {
                            byte[] subb = dp.subkey.getBytes();
                            data[mtspos++] = (byte)subb.length;
                            for (i = 0; i < subb.length; ++i) {
                                data[mtspos++] = subb[i];
                            }
                        } else {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                    }
                    if ((re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data)) != 0) break;
                    if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_Q) {
                        int valint = (data[mtspos] & 0xFF) << 24 | (data[mtspos + 1] & 0xFF) << 16 | (data[mtspos + 2] & 0xFF) << 8 | data[mtspos + 3] & 0xFF;
                        dp.val = valint;
                        break;
                    }
                    if (dp.key == Mtr_Param.MTR_PARAM_RF_ANTPOWER) {
                        AntPowerConf apc = new AntPowerConf();
                        apc.antcnt = data[mtspos++];
                        AntPower[] ap = new AntPower[apc.antcnt];
                        for (int i2 = 0; i2 < apc.antcnt; ++i2) {
                            ap[i2] = new AntPower();
                            ap[i2].antid = data[mtspos++];
                            ap[i2].readPower = (short)((data[mtspos] & 0xFF) << 8 | data[mtspos + 1] & 0xFF);
                            ap[i2].writePower = (short)((data[mtspos += 2] & 0xFF) << 8 | data[mtspos + 1] & 0xFF);
                            mtspos += 2;
                            mtspos += 2;
                        }
                        apc.Powers = ap;
                        dp.val = apc;
                        break;
                    }
                    if (dp.key == Mtr_Param.MTR_PARAM_FREQUENCY_REGION) {
                        dp.val = data[mtspos++];
                        break;
                    }
                    if (dp.key != Mtr_Param.MTR_PARAM_SAVEINMODULE) break;
                    mtspos += dp.subkey.getBytes().length + 1;
                    if (dp.subkey.equals("modulesave/hpupload")) {
                        int[] pval = new int[6];
                        for (i = 0; i < 6; ++i) {
                            data[mtspos++] = (byte)((pval[i] & 0xFF000000) >> 24);
                            data[mtspos++] = (byte)((pval[i] & 0xFF0000) >> 16);
                            data[mtspos++] = (byte)((pval[i] & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(pval[i] & 0xFF);
                        }
                        dp.val = pval;
                        break;
                    }
                    return READER_ERR.MT_INVALID_PARA;
                }
                default: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int[] resint = (int[])val;
                    resint[0] = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public READER_ERR ParamSet(Mtr_Param key, Object val) {
        Reader reader = this;
        synchronized (reader) {
            int re = -1;
            byte[] data = new byte[500];
            switch (key) {
                case MTR_PARAM_RF_ANTPOWER: {
                    AntPowerConf acf = (AntPowerConf)val;
                    if (this.isfilterpw) {
                        int i;
                        boolean issave = false;
                        for (i = 0; i < acf.antcnt; ++i) {
                            if (acf.Powers[i].readPower >= 500 && acf.Powers[i].writePower >= 500) continue;
                            issave = true;
                            break;
                        }
                        if (issave) {
                            this.setpower = new AntPowerConf();
                            this.setpower.antcnt = acf.antcnt;
                            for (i = 0; i < acf.antcnt; ++i) {
                                this.setpower.Powers[i] = new AntPower();
                                this.setpower.Powers[i].readPower = acf.Powers[i].readPower;
                                this.setpower.Powers[i].writePower = acf.Powers[i].writePower;
                            }
                            for (i = 0; i < acf.antcnt; ++i) {
                                if (acf.Powers[i].readPower < 500) {
                                    acf.Powers[i].readPower = (short)500;
                                }
                                if (acf.Powers[i].writePower >= 500) continue;
                                acf.Powers[i].writePower = (short)500;
                            }
                            val = acf;
                        } else {
                            this.setpower = null;
                        }
                    }
                    data[0] = (byte)((AntPowerConf)val).antcnt;
                    for (int i = 0; i < data[0]; ++i) {
                        data[i * 5 + 1] = (byte)((AntPowerConf)val).Powers[i].antid;
                        data[i * 5 + 2] = (byte)((((AntPowerConf)val).Powers[i].readPower & 0xFF00) >> 8);
                        data[i * 5 + 3] = (byte)(((AntPowerConf)val).Powers[i].readPower & 0xFF);
                        data[i * 5 + 4] = (byte)((((AntPowerConf)val).Powers[i].writePower & 0xFF00) >> 8);
                        data[i * 5 + 5] = (byte)(((AntPowerConf)val).Powers[i].writePower & 0xFF);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_TAG_FILTER: {
                    if ((TagFilter_ST)val != null) {
                        data[0] = (byte)((TagFilter_ST)val).bank;
                        data[1] = (byte)((((TagFilter_ST)val).startaddr & 0xFF000000) >> 24);
                        data[2] = (byte)((((TagFilter_ST)val).startaddr & 0xFF0000) >> 16);
                        data[3] = (byte)((((TagFilter_ST)val).startaddr & 0xFF00) >> 8);
                        data[4] = (byte)(((TagFilter_ST)val).startaddr & 0xFF);
                        data[5] = (byte)((((TagFilter_ST)val).flen & 0xFF000000) >> 24);
                        data[6] = (byte)((((TagFilter_ST)val).flen & 0xFF0000) >> 16);
                        data[7] = (byte)((((TagFilter_ST)val).flen & 0xFF00) >> 8);
                        data[8] = (byte)(((TagFilter_ST)val).flen & 0xFF);
                        int ilen = ((TagFilter_ST)val).flen / 8;
                        if (((TagFilter_ST)val).flen % 8 != 0) {
                            ++ilen;
                        }
                        System.arraycopy(((TagFilter_ST)val).fdata, 0, data, 9, ilen);
                        data[9 + ilen] = (byte)((TagFilter_ST)val).isInvert;
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                        return READER_ERR.valueOf(re);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_TAG_EMBEDEDDATA: {
                    if ((EmbededData_ST)val != null) {
                        data[0] = ((EmbededData_ST)val).accesspwd == null ? 10 : 14;
                        data[1] = (byte)((EmbededData_ST)val).bank;
                        data[2] = (byte)((((EmbededData_ST)val).startaddr & 0xFF000000) >> 24);
                        data[3] = (byte)((((EmbededData_ST)val).startaddr & 0xFF0000) >> 16);
                        data[4] = (byte)((((EmbededData_ST)val).startaddr & 0xFF00) >> 8);
                        data[5] = (byte)(((EmbededData_ST)val).startaddr & 0xFF);
                        data[6] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF000000) >> 24);
                        data[7] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF0000) >> 16);
                        data[8] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF00) >> 8);
                        data[9] = (byte)(((EmbededData_ST)val).bytecnt & 0xFF);
                        if (((EmbededData_ST)val).accesspwd != null) {
                            System.arraycopy(((EmbededData_ST)val).accesspwd, 0, data, 10, 4);
                        }
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                        return READER_ERR.valueOf(re);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_TAG_INVPOTL: {
                    data[0] = (byte)((Inv_Potls_ST)val).potlcnt;
                    for (int i = 0; i < data[0]; ++i) {
                        data[i * 5 + 1] = (byte)((Inv_Potls_ST)val).potls[i].potl.value();
                        data[i * 5 + 2] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF000000) >> 24);
                        data[i * 5 + 3] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF0000) >> 16);
                        data[i * 5 + 4] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF00) >> 8);
                        data[i * 5 + 5] = (byte)(((Inv_Potls_ST)val).potls[i].weight & 0xFF);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_FREQUENCY_REGION: {
                    int rgint = ((Region_Conf)((Object)val)).value();
                    data[0] = (byte)((rgint & 0xFF000000) >> 24);
                    data[1] = (byte)((rgint & 0xFF0000) >> 16);
                    data[2] = (byte)((rgint & 0xFF00) >> 8);
                    data[3] = (byte)(rgint & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_FREQUENCY_HOPTABLE: {
                    data[0] = (byte)((HoptableData_ST)val).lenhtb;
                    for (int i = 0; i < data[0]; ++i) {
                        data[i * 4 + 1] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF000000) >> 24);
                        data[i * 4 + 2] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF0000) >> 16);
                        data[i * 4 + 3] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF00) >> 8);
                        data[i * 4 + 4] = (byte)(((HoptableData_ST)val).htb[i] & 0xFF);
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_READER_IP: {
                    int ipl = ((Reader_Ip)val).ip.length;
                    int ml = ((Reader_Ip)val).mask.length;
                    int gl = ((Reader_Ip)val).gateway.length;
                    data[0] = (byte)ipl;
                    data[1] = (byte)ml;
                    data[2] = (byte)gl;
                    System.arraycopy(((Reader_Ip)val).ip, 0, data, 3, ipl);
                    System.arraycopy(((Reader_Ip)val).mask, 0, data, 3 + ipl, ml);
                    System.arraycopy(((Reader_Ip)val).gateway, 0, data, 3 + ipl + ml, gl);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_READER_WATCHDOG: {
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), (byte[])val);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_TAG_MULTISELECTORS: {
                    String[] epcs = (String[])val;
                    if (epcs == null) {
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                        return READER_ERR.valueOf(re);
                    }
                    MultiTagSelectors_ST mts = new MultiTagSelectors_ST();
                    if (epcs.length == 0) return READER_ERR.MT_INVALID_PARA;
                    if (epcs.length > 16) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    mts.tagselectorcnt = epcs.length;
                    for (int i = 0; i < epcs.length; ++i) {
                        if (epcs[i] == null) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        if (epcs[i].length() > 48) return READER_ERR.MT_INVALID_PARA;
                        if (epcs[i].length() % 4 != 0) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        mts.tagselectors[i].bank = 1;
                        if (epcs[i].length() == 0) {
                            mts.tagselectors[i].startaddr = 16;
                            mts.tagselectors[i].slen = 5;
                            mts.tagselectors[i].sdata[0] = 0;
                            continue;
                        }
                        mts.tagselectors[i].startaddr = 32;
                        mts.tagselectors[i].slen = epcs[i].length() * 4;
                        this.Str2Hex(epcs[i], epcs[i].length(), mts.tagselectors[i].sdata);
                    }
                    int mtspos = 0;
                    int sbytedatalen = 0;
                    data[mtspos++] = (byte)mts.tagselectorcnt;
                    for (int i = 0; i < mts.tagselectorcnt; ++i) {
                        data[mtspos++] = (byte)mts.tagselectors[i].bank;
                        data[mtspos++] = (byte)((mts.tagselectors[i].startaddr & 0xFF000000) >> 24);
                        data[mtspos++] = (byte)((mts.tagselectors[i].startaddr & 0xFF0000) >> 16);
                        data[mtspos++] = (byte)((mts.tagselectors[i].startaddr & 0xFF00) >> 8);
                        data[mtspos++] = (byte)(mts.tagselectors[i].startaddr & 0xFF);
                        data[mtspos++] = (byte)mts.tagselectors[i].slen;
                        sbytedatalen = mts.tagselectors[i].slen % 8 == 0 ? mts.tagselectors[i].slen / 8 : mts.tagselectors[i].slen / 8 + 1;
                        System.arraycopy(mts.tagselectors[i].sdata, 0, data, mtspos, sbytedatalen);
                        mtspos += sbytedatalen;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_CUSTOM: {
                    CustomParam_ST cpst = (CustomParam_ST)val;
                    byte[] tmppname = null;
                    try {
                        tmppname = cpst.ParamName.getBytes("US-ASCII");
                    }
                    catch (Exception mtspos) {
                        // empty catch block
                    }
                    System.arraycopy(tmppname, 0, data, 0, tmppname.length);
                    data[tmppname.length] = 0;
                    data[48] = (byte)((cpst.ParamVal.length & 0xFF00) >> 8);
                    data[49] = (byte)(cpst.ParamVal.length & 0xFF);
                    System.arraycopy(cpst.ParamVal, 0, data, 50, cpst.ParamVal.length);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                case MTR_PARAM_SAVEINMODULE: {
                    Default_Param dp = (Default_Param)val;
                    int mtspos = 0;
                    data[mtspos++] = (byte)dp.key.value();
                    data[mtspos++] = (byte)(dp.isdefault ? 1 : 0);
                    if (dp.key == Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION || dp.key == Mtr_Param.MTR_PARAM_POTL_GEN2_Q) {
                        int valint = (Integer)dp.val;
                        data[mtspos++] = (byte)((valint & 0xFF000000) >> 24);
                        data[mtspos++] = (byte)((valint & 0xFF0000) >> 16);
                        data[mtspos++] = (byte)((valint & 0xFF00) >> 8);
                        data[mtspos++] = (byte)(valint & 0xFF);
                    } else if (dp.key == Mtr_Param.MTR_PARAM_RF_ANTPOWER) {
                        AntPowerConf apc = (AntPowerConf)dp.val;
                        data[mtspos++] = (byte)apc.antcnt;
                        for (int i = 0; i < apc.antcnt; ++i) {
                            data[mtspos++] = (byte)apc.Powers[i].antid;
                            data[mtspos++] = (byte)((apc.Powers[i].readPower & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(apc.Powers[i].readPower & 0xFF);
                            data[mtspos++] = (byte)((apc.Powers[i].writePower & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(apc.Powers[i].writePower & 0xFF);
                            data[mtspos++] = 0;
                            data[mtspos++] = 0;
                        }
                    } else if (dp.key == Mtr_Param.MTR_PARAM_FREQUENCY_REGION) {
                        data[mtspos++] = (Byte)dp.val;
                    } else {
                        if (dp.key != Mtr_Param.MTR_PARAM_SAVEINMODULE) return READER_ERR.MT_INVALID_PARA;
                        byte[] subb = dp.subkey.getBytes();
                        data[mtspos++] = (byte)subb.length;
                        for (int i = 0; i < subb.length; ++i) {
                            data[mtspos++] = subb[i];
                        }
                        if (!dp.subkey.equals("modulesave/hpupload")) return READER_ERR.MT_INVALID_PARA;
                        int[] pval = (int[])dp.val;
                        for (int i = 0; i < 6; ++i) {
                            data[mtspos++] = (byte)((pval[i] & 0xFF000000) >> 24);
                            data[mtspos++] = (byte)((pval[i] & 0xFF0000) >> 16);
                            data[mtspos++] = (byte)((pval[i] & 0xFF00) >> 8);
                            data[mtspos++] = (byte)(pval[i] & 0xFF);
                        }
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    return READER_ERR.valueOf(re);
                }
                default: {
                    int valint = ((int[])val)[0];
                    data[0] = (byte)((valint & 0xFF000000) >> 24);
                    data[1] = (byte)((valint & 0xFF0000) >> 16);
                    data[2] = (byte)((valint & 0xFF00) >> 8);
                    data[3] = (byte)(valint & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                }
            }
            return READER_ERR.valueOf(re);
        }
    }

    public static String bytes_Hexstr(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public void Str2Hex(String buf, int len, byte[] hexbuf) {
        String chex = "0123456789ABCDEF";
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; i += 2) {
            byte hnx = (byte)chex.indexOf(buf.toUpperCase().substring(i, i + 1));
            byte lnx = 0;
            if (i + 2 <= len) {
                lnx = (byte)chex.indexOf(buf.toUpperCase().substring(i + 1, i + 2));
            }
            hexbuf[i % 2 == 0 ? i / 2 : i / 2 + 1] = (byte)(hnx << 4 & 0xFF | lnx & 0xFF);
        }
    }

    public void Str2Binary(String buf, int len, byte[] binarybuf) {
        if (len % 8 != 0) {
            return;
        }
        for (int i = 0; i < len; i += 8) {
            byte temp = 0;
            for (int j = 0; j < 8; ++j) {
                temp = (byte)(temp | (byte)(Byte.parseByte(buf.substring(i + j, i + j + 1)) << 7 - j));
            }
            int n = i / 8;
            binarybuf[n] = (byte)(binarybuf[n] | temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStartReading(int[] ants, int antcnt, int option) {
        this.toDlogAPI("AsyncStartReading- [] " + String.valueOf(antcnt) + " " + String.valueOf(option));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStartReading(this.hReader[0], ants, antcnt, option);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStartReadingEx(int[] ants, int antcnt, int option, byte[] bdata) {
        this.toDlogAPI("AsyncStartReadingEx- [] " + String.valueOf(antcnt) + " " + String.valueOf(option));
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStartReadingEx(this.hReader[0], ants, antcnt, option, bdata);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStopReading() {
        this.toDlogAPI("AsyncStopReading");
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStopReading(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStopReadingEx() {
        this.toDlogAPI("AsyncStopReadingEx");
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStopReadingEx(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncGetTagCount(int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncGetTagCount(this.hReader[0], tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncGetNextTag(TAGINFO TI) {
        Reader reader = this;
        synchronized (reader) {
            byte[] tagbuf = new byte[500];
            int pos = 0;
            int re = this.japi.AsyncGetNextTag_BaseType(this.hReader[0], tagbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                TI.ReadCnt = tagbuf[pos++];
                TI.RSSI = tagbuf[pos++];
                TI.AntennaID = tagbuf[pos++];
                TI.Frequency = (tagbuf[pos] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                TI.TimeStamp = (tagbuf[pos += 4] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                pos += 4;
                TI.Res[0] = tagbuf[pos++];
                TI.Res[1] = tagbuf[pos++];
                int epclen = (tagbuf[pos] & 0xFF) << 8 | tagbuf[pos + 1] & 0xFF;
                pos += 2;
                TI.PC[0] = tagbuf[pos++];
                TI.PC[1] = tagbuf[pos++];
                TI.EpcId = new byte[epclen];
                TI.Epclen = (short)epclen;
                System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
                pos += epclen;
                TI.CRC[0] = tagbuf[pos++];
                TI.CRC[1] = tagbuf[pos++];
                TI.protocol = SL_TagProtocol.valueOf(tagbuf[pos++]);
                int emddatalen = (tagbuf[pos] & 0xFF) << 8 | tagbuf[pos + 1] & 0xFF;
                pos += 2;
                TI.EmbededData = new byte[emddatalen];
                TI.EmbededDatalen = (short)emddatalen;
                if (emddatalen > 0) {
                    System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
                }
            }
            return ERR;
        }
    }

    public static String GetSDKVersion() {
        String ver = "jarVersion:20220322";
        ver = ver + "soVersion:" + JniModuleAPI.GetSDKVersion();
        return ver;
    }

    public static READER_ERR GetDeviceVersion(String serialpath, deviceVersion rdrver) {
        byte[] verdata = new byte[9];
        int ret = JniModuleAPI.GetDeviceVersion(serialpath, verdata);
        READER_ERR err = READER_ERR.valueOf(ret);
        if (err == READER_ERR.MT_OK_ERR) {
            if (verdata[0] == 1) {
                rdrver.hardwareVer = verdata[1] + ".";
                rdrver.hardwareVer = rdrver.hardwareVer + verdata[2] + ".";
                rdrver.hardwareVer = rdrver.hardwareVer + verdata[3] + ".";
                rdrver.hardwareVer = rdrver.hardwareVer + verdata[4];
                rdrver.softwareVer = verdata[5] + ".";
                rdrver.softwareVer = rdrver.softwareVer + verdata[6] + ".";
                rdrver.softwareVer = rdrver.softwareVer + verdata[7] + ".";
                rdrver.softwareVer = rdrver.softwareVer + verdata[8];
            } else {
                byte[] v1by = new byte[]{verdata[1]};
                rdrver.hardwareVer = Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[2];
                rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[3];
                rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[4];
                rdrver.hardwareVer = rdrver.hardwareVer + Reader.bytes_Hexstr(v1by);
                v1by[0] = verdata[5];
                rdrver.softwareVer = Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[6];
                rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[7];
                rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by) + ".";
                v1by[0] = verdata[8];
                rdrver.softwareVer = rdrver.softwareVer + Reader.bytes_Hexstr(v1by);
            }
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetSerialNumber(DeviceSerialNumber devsn) {
        Reader reader = this;
        synchronized (reader) {
            String sn = "";
            CustomParam_ST cpara = new CustomParam_ST();
            cpara.ParamName = "reader/rdrdetails";
            READER_ERR ret = this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpara);
            if (ret != READER_ERR.MT_OK_ERR) {
                return ret;
            }
            byte[] binhv = new byte[4];
            System.arraycopy(cpara.ParamVal, 28, binhv, 0, 4);
            sn = sn + Reader.bytes_Hexstr(binhv);
            for (int i = 0; i < 12; ++i) {
                sn = sn + cpara.ParamVal[16 + i];
            }
            HardwareDetails hd = new HardwareDetails();
            this.GetHardwareDetails(hd);
            sn = hd.board == MaindBoard_Type.MAINBOARD_ARM9 ? "A9" + sn : (hd.board == MaindBoard_Type.MAINBOARD_ARM7 ? "A7" + sn : "SE" + sn);
            devsn.serailNumber = sn;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetLastDetailError(ErrInfo ei) {
        Reader reader = this;
        synchronized (reader) {
            byte[] resbuf = new byte[500];
            int re = this.japi.GetLastDetailError_BaseType(this.hReader[0], resbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                ei.derrcode = (resbuf[0] & 0xFF) << 24 | (resbuf[1] & 0xFF) << 16 | (resbuf[2] & 0xFF) << 8 | resbuf[3] & 0xFF;
                byte[] estrbytes = new byte[resbuf[4]];
                System.arraycopy(resbuf, 5, estrbytes, 0, resbuf[4]);
                try {
                    ei.errstr = new String(estrbytes, "ascii");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ResetRfidModule() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.ResetRfidModule(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    public static READER_ERR FirmwareLoadFromSerialPort(String serialportPath, String firmwarePath) {
        int re = JniModuleAPI.FirmwareLoadFromSerialPort(serialportPath, firmwarePath);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public static READER_ERR RebootReader(String readeraddr) {
        int re = JniModuleAPI.RebootReader(readeraddr);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DataTransportSend(byte[] data, int datalen, int timeout) {
        Reader reader = this;
        synchronized (reader) {
            return this.japi.DataTransportSend(this.hReader[0], data, datalen, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DataTransportRecv(byte[] data, int datalen, int timeout) {
        Reader reader = this;
        synchronized (reader) {
            return this.japi.DataTransportRecv(this.hReader[0], data, datalen, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadTagTemperature(int ant, char bank, int address, int wordcnt, int timeout, int timeselwait, int timereadwait, short metaflag, byte[] accesspasswd, R2000_calibration.Tagtemperture_DATA tagtemp) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[300];
            int[] datalen = new int[1];
            int re = this.japi.ReadTagTemperature(this.hReader[0], ant, bank, address, wordcnt, timeout + timeselwait + timereadwait, timeselwait, timereadwait, metaflag, accesspasswd, data, datalen);
            if (re == 0) {
                R2000_calibration.Tagtemperture_DATA tagtemp2 = new R2000_calibration().new R2000_calibration.Tagtemperture_DATA(data, wordcnt);
                tagtemp.pvtAntenna = tagtemp2.pvtAntenna;
                tagtemp.pvtFrequency = tagtemp2.pvtFrequency;
                tagtemp.pvtLqi = tagtemp2.pvtLqi;
                tagtemp.pvtPhase = tagtemp2.pvtPhase;
                tagtemp.pvtPro = tagtemp2.pvtPro;
                tagtemp.pvtReadCount = tagtemp2.pvtReadCount;
                tagtemp.pvtTsmp = tagtemp2.pvtTsmp;
                tagtemp.tagcrc = new byte[2];
                tagtemp.tagpc = new byte[2];
                tagtemp.tagepc = new byte[tagtemp2.tagepc.length];
                System.arraycopy(tagtemp2.tagcrc, 0, tagtemp.tagcrc, 0, 2);
                System.arraycopy(tagtemp2.tagepc, 0, tagtemp.tagepc, 0, tagtemp2.tagepc.length);
                System.arraycopy(tagtemp2.tagpc, 0, tagtemp.tagpc, 0, 2);
                if (tagtemp2.BankData != null) {
                    tagtemp.BankData = new byte[tagtemp2.BankData.length];
                    System.arraycopy(tagtemp2.BankData, 0, tagtemp.BankData, 0, tagtemp2.BankData.length);
                }
                tagtemp.temperdata = new byte[tagtemp2.temperdata.length];
                System.arraycopy(tagtemp2.temperdata, 0, tagtemp.temperdata, 0, tagtemp2.temperdata.length);
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadTagLED(int ant, short timeout, short metaflag, R2000_calibration.TagLED_DATA tagled) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[300];
            int[] datalen = new int[1];
            int re = this.japi.ReadTagLED(this.hReader[0], ant, metaflag, timeout, data, datalen);
            if (re == 0) {
                R2000_calibration.TagLED_DATA tagled2 = new R2000_calibration().new R2000_calibration.TagLED_DATA(data, datalen[0]);
                tagled.pvtAntenna = tagled2.pvtAntenna;
                tagled.pvtFrequency = tagled2.pvtFrequency;
                tagled.pvtLqi = tagled2.pvtLqi;
                tagled.pvtPhase = tagled2.pvtPhase;
                tagled.pvtPro = tagled2.pvtPro;
                tagled.pvtReadCount = tagled2.pvtReadCount;
                tagled.pvtTsmp = tagled2.pvtTsmp;
                tagled.tagcrc = new byte[2];
                tagled.tagpc = new byte[2];
                tagled.tagepc = new byte[tagled2.tagepc.length];
                System.arraycopy(tagled2.tagcrc, 0, tagled.tagcrc, 0, 2);
                System.arraycopy(tagled2.tagepc, 0, tagled.tagepc, 0, tagled2.tagepc.length);
                System.arraycopy(tagled2.tagpc, 0, tagled.tagpc, 0, 2);
                if (tagled2.BankData != null) {
                    tagled.BankData = new byte[tagled2.BankData.length];
                    System.arraycopy(tagled2.BankData, 0, tagled.BankData, 0, tagled2.BankData.length);
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    int SetFilterSessioninTargetA(int[] ants, int fre, int power) {
        MsgObj hMsg;
        R2000_calibration r2cb = new R2000_calibration();
        R2000_calibration.FilterS2inA_DATA fsa = new R2000_calibration().new R2000_calibration.FilterS2inA_DATA(ants, fre, power);
        byte[] data = r2cb.GetSendCmd(R2000_calibration.R2000cmd.S2TA, fsa.ToByteData());
        int re = this.SendandRev(data, 1000, hMsg = new MsgObj());
        if (re != 0) {
            return re;
        }
        return hMsg.status[0] << 8 | hMsg.status[1];
    }

    READER_ERR FlushDummyData2Mod() {
        byte[] zerobuf = new byte[255];
        zerobuf[0] = -1;
        zerobuf[1] = -6;
        zerobuf[2] = 0;
        for (int i = 3; i < 255; ++i) {
            zerobuf[i] = 0;
        }
        this.DataTransportSend(zerobuf, 255, 2000);
        return READER_ERR.MT_OK_ERR;
    }

    READER_ERR TestModLive() {
        READER_ERR err = READER_ERR.MT_OK_ERR;
        byte[] cmd = new byte[]{-1, 0, 3, 29, 12};
        byte[] resp = new byte[50];
        byte[] resp2 = new byte[50];
        this.DataTransportSend(cmd, cmd.length, 1000);
        if (this.DataTransportRecv(resp, 5, 1000) == -1) {
            return READER_ERR.MT_CMD_FAILED_ERR;
        }
        if (this.DataTransportRecv(resp2, resp[1] + 2, 1000) == -1) {
            return READER_ERR.MT_CMD_FAILED_ERR;
        }
        return err;
    }

    private int SendandRev(byte[] data, int timeout, MsgObj hMsg) {
        int COMM_NON_FATAL_ERR = 65277;
        int MODULE_NEED_RESTART = 65278;
        short MSG_CRC_INIT = -1;
        this.toDlogAPI("send:" + Reader.bytes_Hexstr(data));
        int re = this.DataTransportSend(data, data.length, timeout);
        if (re != 0) {
            return COMM_NON_FATAL_ERR;
        }
        READER_ERR err = READER_ERR.MT_OK_ERR;
        int ret = 0;
        String revstr = "";
        ret = this.DataTransportRecv(hMsg.soh, 1, 1000);
        revstr = revstr + Reader.bytes_Hexstr(hMsg.soh);
        if (ret == -2 || ret == -3) {
            return COMM_NON_FATAL_ERR;
        }
        if (ret == -1) {
            return READER_ERR.MT_IO_ERR.value();
        }
        if (ret == -4) {
            if (this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
                return READER_ERR.MT_IO_ERR.value();
            }
            if (this.TestModLive() == READER_ERR.MT_OK_ERR) {
                return COMM_NON_FATAL_ERR;
            }
            return MODULE_NEED_RESTART;
        }
        if ((hMsg.soh[0] & 0xFF) != 255) {
            if (this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
                return READER_ERR.MT_IO_ERR.value();
            }
            return 65277;
        }
        short scrc = MSG_CRC_INIT;
        if (this.DataTransportRecv(hMsg.dataLen, 1, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        revstr = revstr + Reader.bytes_Hexstr(hMsg.dataLen);
        if (this.DataTransportRecv(hMsg.opCode, 1, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        revstr = revstr + Reader.bytes_Hexstr(hMsg.opCode);
        if (this.DataTransportRecv(hMsg.status, 2, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        revstr = revstr + Reader.bytes_Hexstr(hMsg.status);
        if (hMsg.dataLen[0] > 0) {
            if (this.DataTransportRecv(hMsg.data, hMsg.dataLen[0], 1000) == -1) {
                return COMM_NON_FATAL_ERR;
            }
            byte[] fdata = new byte[hMsg.dataLen[0]];
            System.arraycopy(hMsg.data, 0, fdata, 0, hMsg.dataLen[0]);
            revstr = revstr + Reader.bytes_Hexstr(fdata);
        }
        if (this.DataTransportRecv(hMsg.crc, 2, 1000) == -1) {
            return COMM_NON_FATAL_ERR;
        }
        this.toDlogAPI("revd:" + revstr + Reader.bytes_Hexstr(hMsg.crc));
        scrc = (short)((hMsg.crc[0] & 0xFF) << 8 | hMsg.crc[1] & 0xFF);
        if (R2000_calibration.calcCrc_short(hMsg.getcheckcrcdata()) != scrc) {
            if (this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
                return READER_ERR.MT_IO_ERR.value();
            }
            return COMM_NON_FATAL_ERR;
        }
        if (err != READER_ERR.MT_OK_ERR && this.FlushDummyData2Mod() != READER_ERR.MT_OK_ERR) {
            return READER_ERR.MT_IO_ERR.value();
        }
        return 0;
    }

    public void addReadListener(ReadListener listener) {
        this.readListeners.add(listener);
    }

    public void removeReadListener(ReadListener listener) {
        this.readListeners.remove(listener);
    }

    public void addReadExceptionListener(ReadExceptionListener listener) {
        this.readExceptionListeners.add(listener);
    }

    public void removeReadExceptionListener(ReadExceptionListener listener) {
        this.readExceptionListeners.remove(listener);
    }

    public void addGpiTriggerListener(GpiTriggerListener listener) {
        this.gpitriListener.add(listener);
    }

    public void removeGpiTriggerListener(GpiTriggerListener listener) {
        this.gpitriListener.remove(listener);
    }

    public void addGpiTriggerBoundaryListener(GpiTriggerBoundaryListener listener) {
        this.gpitriboundListener.add(listener);
    }

    public void removeGpiTriggerBoundaryListener(GpiTriggerBoundaryListener listener) {
        this.gpitriboundListener.remove(listener);
    }

    private boolean GpiTriContains(GpiInfo_ST littleGInfo, GpiInfo_ST bigGInfo) {
        for (int i = 0; i < littleGInfo.gpiCount; ++i) {
            if (bigGInfo.gpiStats[littleGInfo.gpiStats[i].GpiId - 1].State == littleGInfo.gpiStats[i].State) continue;
            return false;
        }
        return true;
    }

    public READER_ERR StartReading(int[] ants, int antcnt, BackReadOption pBRO) {
        this.toDlogAPI("StartReading- [] " + String.valueOf(antcnt) + " " + (pBRO.IsFastRead ? "t" : "f"));
        this.CLOGS();
        READER_ERR ERR = READER_ERR.MT_OK_ERR;
        if (this.m_IsReadingForAll) {
            return READER_ERR.MT_OP_EXECING;
        }
        this.m_IsReadingForAll = true;
        this.m_BackReadOp = pBRO;
        if (pBRO.IsGPITrigger) {
            int i;
            if ((pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TIMEOUTSTOP || pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP) && pBRO.GpiTrigger.StopTriggerTimeout < 5) {
                return READER_ERR.MT_INVALID_PARA;
            }
            HardwareDetails hd = new HardwareDetails();
            this.GetHardwareDetails(hd);
            int maxgpiid = hd.logictype == Reader_Type.MODULE_ARM7_FOUR_ANTS || hd.logictype == Reader_Type.M6E_ARM7_FOUR_ANTS || hd.logictype == Reader_Type.MODULE_ARM7_TWO_ANTS || hd.logictype == Reader_Type.SL_COMMN_READER ? 4 : 2;
            if (pBRO.GpiTrigger.GpiTrigger1States.gpiCount > maxgpiid) {
                return READER_ERR.MT_INVALID_PARA;
            }
            for (i = 0; i < pBRO.GpiTrigger.GpiTrigger1States.gpiCount; ++i) {
                if (pBRO.GpiTrigger.GpiTrigger1States.gpiStats[i].GpiId >= 1 && pBRO.GpiTrigger.GpiTrigger1States.gpiStats[i].GpiId <= maxgpiid) continue;
                return READER_ERR.MT_INVALID_PARA;
            }
            if (pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TRI2STOP) {
                if (pBRO.GpiTrigger.GpiTrigger2States.gpiCount > maxgpiid) {
                    return READER_ERR.MT_INVALID_PARA;
                }
                for (i = 0; i < pBRO.GpiTrigger.GpiTrigger2States.gpiCount; ++i) {
                    if (pBRO.GpiTrigger.GpiTrigger2States.gpiStats[i].GpiId >= 1 && pBRO.GpiTrigger.GpiTrigger2States.gpiStats[i].GpiId <= maxgpiid) continue;
                    return READER_ERR.MT_INVALID_PARA;
                }
            }
        }
        if (this.m_BackReadOp.IsFastRead) {
            int re;
            short flags = 0;
            if (this.m_BackReadOp.TMFlags.IsReadCnt) {
                flags = (short)(flags | 1);
            }
            if (this.m_BackReadOp.TMFlags.IsRSSI) {
                flags = (short)(flags | 2);
            }
            if (this.m_BackReadOp.TMFlags.IsAntennaID) {
                flags = (short)(flags | 4);
            }
            if (this.m_BackReadOp.TMFlags.IsFrequency) {
                flags = (short)(flags | 8);
            }
            if (this.m_BackReadOp.TMFlags.IsTimestamp) {
                flags = (short)(flags | 0x10);
            }
            if (this.m_BackReadOp.TMFlags.IsRFU) {
                flags = (short)(flags | 0x20);
            }
            if (this.m_BackReadOp.TMFlags.IsEmdData) {
                flags = (short)(flags | 0x80);
            }
            this.m_BackReadOp.ReadDuration = 0;
            this.m_BackReadOp.ReadInterval = 50;
            this.m_FastReadOption = flags << 8 | this.m_BackReadOp.FastReadDutyRation | 0x80;
            if (!this.m_BackReadOp.IsGPITrigger && (ERR = this.errhandle(re = this.japi.AsyncStartReading(this.hReader[0], ants, antcnt, this.m_FastReadOption))) != READER_ERR.MT_OK_ERR) {
                return ERR;
            }
        }
        this.m_BackReadAntsCnt = antcnt;
        for (int i = 0; i < antcnt; ++i) {
            this.m_BackReadAnts[i] = ants[i];
        }
        Tagnotify tf = new Tagnotify(this);
        this.m_ThreadForAll = new Thread(tf);
        this.m_ThreadForAllid = this.m_ThreadForAll.getId();
        this.m_ThreadForAll.start();
        return ERR;
    }

    public READER_ERR StopReading() {
        READER_ERR ERR;
        this.toDlogAPI("StopReading");
        if (!this.m_IsReadingForAll) {
            return READER_ERR.MT_OK_ERR;
        }
        this.m_IsReadingForAll = false;
        Thread current = Thread.currentThread();
        this.m_ThreadForAllid = current.getId();
        if (this.m_ThreadForAllid == this.m_ThreadForAll.getId()) {
            READER_ERR ERR2;
            if (this.m_BackReadOp.IsFastRead && (ERR2 = this.AsyncStopReading()) != READER_ERR.MT_OK_ERR) {
                this.ALOGS("err 1892" + ERR2.toString());
                return ERR2;
            }
            return READER_ERR.MT_OK_ERR;
        }
        while (this.m_IsReadThRunning) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.m_ThreadForAll = null;
        if (this.m_BackReadOp.IsFastRead && (ERR = this.AsyncStopReading()) != READER_ERR.MT_OK_ERR) {
            this.ALOGS("err 1920" + ERR.toString());
            return ERR;
        }
        return READER_ERR.MT_OK_ERR;
    }

    private READER_ERR errhandle(int re) {
        READER_ERR err = READER_ERR.valueOf(re);
        if (err != READER_ERR.MT_OK_ERR) {
            this.m_gError = re;
            if (this.m_BackReadOp.IsFastRead) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.AsyncStopReading();
            }
            this.m_IsReadingForAll = false;
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    private READER_ERR errhandle2(READER_ERR err) {
        if (err != READER_ERR.MT_OK_ERR) {
            if (this.m_BackReadOp.IsFastRead) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.AsyncStopReading();
            }
            this.m_IsReadingForAll = false;
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    public READER_ERR AsyncStartReading_IT(IT_MODE it_mode, int[] ants, int antcnt, int option) {
        this.it_mode_V = it_mode;
        if (this.it_mode_V == IT_MODE.IT_MODE_CT) {
            return this.AsyncStartReading_IT_CT(ants, antcnt, option);
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7) {
            return this.AsyncStartReading_IT_E7(ants, antcnt, option);
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
            return this.AsyncStartReading_IT_E7v2(ants, antcnt, option);
        }
        return this.AsyncStartReading_IT_S2(ants, antcnt, option);
    }

    public READER_ERR AsyncStartReading_IT_CT(int[] ants, int antcnt, int option) {
        Region_Conf[] rcf2 = new Region_Conf[1];
        READER_ERR er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, rcf2);
        if (er == READER_ERR.MT_OK_ERR && (rcf2[0] == Region_Conf.RG_NA || rcf2[0] == Region_Conf.RG_PRC)) {
            HoptableData_ST hdst2 = new HoptableData_ST();
            er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
            boolean isrestart = false;
            if (er == READER_ERR.MT_OK_ERR) {
                if (rcf2[0] == Region_Conf.RG_NA) {
                    if (hdst2.lenhtb == 50) {
                        isrestart = true;
                    } else if (hdst2.lenhtb == this.IT_CT_fres_NA.length) {
                        for (int i = 0; i < hdst2.lenhtb; ++i) {
                            boolean iscontain = false;
                            for (int j = 0; j < this.IT_CT_fres_NA.length; ++j) {
                                if (hdst2.htb[i] != this.IT_CT_fres_NA[j]) continue;
                                iscontain = true;
                                break;
                            }
                            if (!iscontain) break;
                            if (i != hdst2.lenhtb - 1) continue;
                            isrestart = true;
                        }
                    }
                    if (isrestart) {
                        HoptableData_ST hdst = new HoptableData_ST();
                        hdst.lenhtb = this.IT_CT_fres_NA.length;
                        hdst.htb = this.IT_CT_fres_NA;
                        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst);
                        if (er != READER_ERR.MT_OK_ERR) {
                            return er;
                        }
                    }
                } else if (rcf2[0] == Region_Conf.RG_PRC) {
                    if (hdst2.lenhtb == 16) {
                        isrestart = true;
                    } else if (hdst2.lenhtb == this.IT_CT_fres_cn.length) {
                        for (int i = 0; i < hdst2.lenhtb; ++i) {
                            boolean iscontain = false;
                            for (int j = 0; j < this.IT_CT_fres_NA.length; ++j) {
                                if (hdst2.htb[i] != this.IT_CT_fres_NA[j]) continue;
                                iscontain = true;
                                break;
                            }
                            if (!iscontain) break;
                            if (i != hdst2.lenhtb - 1) continue;
                            isrestart = true;
                        }
                    }
                    if (isrestart) {
                        HoptableData_ST hdst = new HoptableData_ST();
                        hdst.lenhtb = this.IT_CT_fres_cn.length;
                        hdst.htb = this.IT_CT_fres_cn;
                        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst);
                        if (er != READER_ERR.MT_OK_ERR) {
                            return er;
                        }
                    }
                }
                if (er != READER_ERR.MT_OK_ERR) {
                    return er;
                }
            }
        }
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        er = this.AsyncStartReading(ants, antcnt, option);
        this.Reset_IT_CT();
        this.isIT_CT_run = true;
        IT_CT_notify tf = new IT_CT_notify(this);
        this.IT_CT_thread = new Thread(tf);
        this.IT_CT_step = this.IT_CT_step_init;
        this.IT_CT_thread.start();
        return er;
    }

    private READER_ERR AsyncStartReading_IT_S2(int[] ants, int antcnt, int option) {
        Region_Conf[] rcf2 = new Region_Conf[1];
        READER_ERR er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, rcf2);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)rcf2[0]);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] vala = new int[]{0};
        er = this.ParamGet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        if (vala[0] == 0 || vala[0] == 1) {
            this.toDlog("set S2");
            vala[0] = 2;
            er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, vala);
            if (er != READER_ERR.MT_OK_ERR) {
                return er;
            }
        } else if (vala[0] == 2) {
            this.toDlog("set S3");
            vala[0] = 3;
            er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, vala);
            if (er != READER_ERR.MT_OK_ERR) {
                return er;
            }
        } else if (vala[0] == 3) {
            this.toDlog("set S2");
            vala[0] = 2;
            er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, vala);
            if (er != READER_ERR.MT_OK_ERR) {
                return er;
            }
        }
        vala[0] = 0;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.IT_S2_istargetA = true;
        vala[0] = 19;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        er = this.AsyncStartReading(ants, antcnt, option);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.Reset_IT();
        this.isIT_S2_run = true;
        this.toDlog("---init");
        IT_S2_notify tf = new IT_S2_notify(this);
        this.IT_S2_thread = new Thread(tf);
        this.IT_S2_step = 0;
        this.IT_S2_thread.start();
        return er;
    }

    int[] Sort(int[] array, int len) {
        int tmpIntValue = 0;
        for (int xIndex = 0; xIndex < len; ++xIndex) {
            for (int yIndex = 0; yIndex < len; ++yIndex) {
                if (array[xIndex] >= array[yIndex]) continue;
                tmpIntValue = array[xIndex];
                array[xIndex] = array[yIndex];
                array[yIndex] = tmpIntValue;
            }
        }
        int[] reary = new int[len];
        System.arraycopy(array, 0, reary, 0, len);
        return reary;
    }

    private READER_ERR AsyncStartReading_IT_E7(int[] ants, int antcnt, int option) {
        Region_Conf[] rcf2 = new Region_Conf[1];
        READER_ERR er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, rcf2);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)rcf2[0]);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] vala = new int[]{0};
        this.toDlog("set S2,tarA,gen2code 107");
        vala[0] = 2;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        vala[0] = 0;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.IT_E7_istargetA = true;
        vala[0] = 107;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] mp = new int[1];
        String msg = ":\ufffd\ufffd\ufffd0,";
        er = this.ParamGet(Mtr_Param.MTR_PARAM_RF_MAXPOWER, mp);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        HoptableData_ST hdst2 = new HoptableData_ST();
        er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
        this.toDlog("set S2,tarA, pw " + String.valueOf(this.IT_E7_pow) + " frec " + String.valueOf(this.IT_E7_centrefre) + " rf " + String.valueOf(this.IT_E7_rfm) + " set gen2code:" + String.valueOf(this.IT_E7_rfm));
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] tablefre = this.Sort(hdst2.htb, hdst2.lenhtb);
        this.IT_E7_centrefre = tablefre[tablefre.length / 2];
        this.IT_E7_pow = mp[0];
        this.SetFilterSessioninTargetA(ants, this.IT_E7_centrefre, this.IT_E7_pow);
        vala[0] = this.IT_E7_rfm;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        er = this.AsyncStartReading(ants, antcnt, option);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.Reset_IT();
        this.isIT_E7_run = true;
        this.toDlog("---init");
        IT_E7_notify tf = new IT_E7_notify(this);
        this.IT_E7_thread = new Thread(tf);
        this.IT_E7_step = 0;
        this.IT_E7_thread.start();
        return er;
    }

    private READER_ERR AsyncStartReading_IT_E7v2(int[] ants, int antcnt, int option) {
        Region_Conf[] rcf2 = new Region_Conf[1];
        READER_ERR er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, rcf2);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.IT_E7_rg = rcf2[0];
        er = this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)rcf2[0]);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] vala = new int[]{0};
        this.toDlog("set S2,tarA,gen2code 107");
        vala[0] = 2;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        vala[0] = -1;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_Q, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        vala[0] = 0;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.IT_E7_istargetA = true;
        vala[0] = 107;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] mp = new int[1];
        String msg = ":\ufffd\ufffd\ufffd0,";
        er = this.ParamGet(Mtr_Param.MTR_PARAM_RF_MAXPOWER, mp);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        HoptableData_ST hdst2 = new HoptableData_ST();
        er = this.ParamGet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        int[] tablefre = this.Sort(hdst2.htb, hdst2.lenhtb);
        this.IT_E7_highfre = tablefre[tablefre.length - 1];
        this.IT_E7_lowfre = tablefre[0];
        this.IT_E7_centrefre = tablefre[tablefre.length / 2];
        this.IT_E7_pow = mp[0];
        this.toDlog("set S2,tarA, pw " + String.valueOf(this.IT_E7_pow) + " frec " + String.valueOf(this.IT_E7_centrefre) + " frel " + String.valueOf(this.IT_E7_lowfre) + " freh " + String.valueOf(this.IT_E7_highfre) + " rf " + String.valueOf(this.IT_E7_rfm));
        this.SetFilterSessioninTargetA(ants, this.IT_E7_centrefre, this.IT_E7_pow);
        this.SetFilterSessioninTargetA(ants, this.IT_E7_lowfre, this.IT_E7_pow);
        this.SetFilterSessioninTargetA(ants, this.IT_E7_highfre, this.IT_E7_pow);
        vala[0] = this.IT_E7_rfm;
        er = this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.pants = ants;
        this.pantcnt = antcnt;
        this.poption = option;
        er = this.AsyncStartReading(ants, antcnt, option);
        if (er != READER_ERR.MT_OK_ERR) {
            return er;
        }
        this.Reset_IT();
        this.isIT_E7_run = true;
        this.toDlog("---init");
        IT_E7v2_notify tf = new IT_E7v2_notify(this);
        this.IT_E7_thread = new Thread(tf);
        this.IT_E7_step = 0;
        this.IT_E7_thread.start();
        return er;
    }

    public READER_ERR AsyncStopReading_IT_CT() {
        this.isIT_CT_run = false;
        READER_ERR err = this.AsyncStopReading();
        if (this.IT_CT_thread != null) {
            try {
                this.IT_CT_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return err;
    }

    public READER_ERR AsyncStopReading_IT() {
        if (this.it_mode_V == IT_MODE.IT_MODE_CT) {
            return this.AsyncStopReading_IT_CT();
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_E7 || this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
            this.isIT_E7_run = false;
            READER_ERR err = this.AsyncStopReading();
            if (this.IT_E7_thread != null) {
                try {
                    this.IT_E7_thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.SetFilterSessioninTargetA(this.pants, this.IT_E7_centrefre, this.IT_E7_pow);
            if (this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
                this.SetFilterSessioninTargetA(this.pants, this.IT_E7_lowfre, this.IT_E7_pow);
                this.SetFilterSessioninTargetA(this.pants, this.IT_E7_highfre, this.IT_E7_pow);
            }
            return err;
        }
        if (this.it_mode_V == IT_MODE.IT_MODE_S2) {
            this.isIT_S2_run = false;
            READER_ERR err = this.AsyncStopReading();
            if (this.IT_S2_thread != null) {
                try {
                    this.IT_S2_thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return err;
        }
        return READER_ERR.MT_OP_INVALID;
    }

    public void Reset_IT_CT() {
        this.quetagstr.clear();
        this.totalcount = 0;
        this.totalcountlast = 0;
        this.IT_CT_step = this.IT_CT_step_init != -1 ? this.IT_CT_step_init : 0;
        this.IT_CT_c = 0;
        this.IT_CT_start = System.currentTimeMillis();
        this.vstaticstarttick = System.currentTimeMillis() - this.IT_CT_start;
    }

    public void Reset_IT() {
        if (this.it_mode_V == IT_MODE.IT_MODE_CT) {
            this.Reset_IT_CT();
        } else if (this.it_mode_V == IT_MODE.IT_MODE_E7 || this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
            this.IT_E7_start = System.currentTimeMillis();
            this.vstaticstarttick = System.currentTimeMillis() - this.IT_E7_start;
        } else if (this.it_mode_V == IT_MODE.IT_MODE_S2) {
            this.IT_S2_start = System.currentTimeMillis();
            this.vstaticstarttick = System.currentTimeMillis() - this.IT_S2_start;
        }
    }

    private READER_ERR errhandle_IT(READER_ERR err) {
        if (err != READER_ERR.MT_OK_ERR) {
            if (this.it_mode_V == IT_MODE.IT_MODE_CT) {
                this.isIT_CT_run = false;
            } else if (this.it_mode_V == IT_MODE.IT_MODE_S2) {
                this.isIT_S2_run = false;
            } else if (this.it_mode_V == IT_MODE.IT_MODE_E7 || this.it_mode_V == IT_MODE.IT_MODE_E7v2) {
                this.isIT_E7_run = false;
            }
            this.AsyncStopReading();
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    public static enum READER_ERR {
        MT_OK_ERR(0),
        MT_IO_ERR(1),
        MT_INTERNAL_DEV_ERR(2),
        MT_CMD_FAILED_ERR(3),
        MT_CMD_NO_TAG_ERR(4),
        MT_M5E_FATAL_ERR(5),
        MT_OP_NOT_SUPPORTED(6),
        MT_INVALID_PARA(7),
        MT_INVALID_READER_HANDLE(8),
        MT_HARDWARE_ALERT_ERR_BY_HIGN_RETURN_LOSS(9),
        MT_HARDWARE_ALERT_ERR_BY_TOO_MANY_RESET(10),
        MT_HARDWARE_ALERT_ERR_BY_NO_ANTENNAS(11),
        MT_HARDWARE_ALERT_ERR_BY_HIGH_TEMPERATURE(12),
        MT_HARDWARE_ALERT_ERR_BY_READER_DOWN(13),
        MT_HARDWARE_ALERT_ERR_BY_UNKNOWN_ERR(14),
        M6E_INIT_FAILED(15),
        MT_OP_EXECING(16),
        MT_UNKNOWN_READER_TYPE(17),
        MT_OP_INVALID(18),
        MT_HARDWARE_ALERT_BY_FAILED_RESET_MODLUE(19),
        MT_MAX_ERR_NUM(20),
        MT_MAX_INT_NUM(21),
        MT_TEST_DEV_FAULT_1(51),
        MT_TEST_DEV_FAULT_2(52),
        MT_TEST_DEV_FAULT_3(53),
        MT_TEST_DEV_FAULT_4(54),
        MT_TEST_DEV_FAULT_5(55),
        MT_UPDFWFROMSP_OPENFILE_FAILED(80),
        MT_UPDFWFROMSP_FILE_FORMAT_ERR(81),
        MT_JNI_INVALID_PARA(101),
        MT_OTHER_ERR(-268435457);

        private int value = 0;

        private READER_ERR(int value) {
            this.value = value;
        }

        public static READER_ERR valueOf(int value) {
            switch (value) {
                case 0: {
                    return MT_OK_ERR;
                }
                case 1: {
                    return MT_IO_ERR;
                }
                case 2: {
                    return MT_INTERNAL_DEV_ERR;
                }
                case 3: {
                    return MT_CMD_FAILED_ERR;
                }
                case 4: {
                    return MT_CMD_NO_TAG_ERR;
                }
                case 5: {
                    return MT_M5E_FATAL_ERR;
                }
                case 6: {
                    return MT_OP_NOT_SUPPORTED;
                }
                case 7: {
                    return MT_INVALID_PARA;
                }
                case 8: {
                    return MT_INVALID_READER_HANDLE;
                }
                case 9: {
                    return MT_HARDWARE_ALERT_ERR_BY_HIGN_RETURN_LOSS;
                }
                case 10: {
                    return MT_HARDWARE_ALERT_ERR_BY_TOO_MANY_RESET;
                }
                case 11: {
                    return MT_HARDWARE_ALERT_ERR_BY_NO_ANTENNAS;
                }
                case 12: {
                    return MT_HARDWARE_ALERT_ERR_BY_HIGH_TEMPERATURE;
                }
                case 13: {
                    return MT_HARDWARE_ALERT_ERR_BY_READER_DOWN;
                }
                case 14: {
                    return MT_HARDWARE_ALERT_ERR_BY_UNKNOWN_ERR;
                }
                case 15: {
                    return M6E_INIT_FAILED;
                }
                case 16: {
                    return MT_OP_EXECING;
                }
                case 17: {
                    return MT_UNKNOWN_READER_TYPE;
                }
                case 18: {
                    return MT_OP_INVALID;
                }
                case 19: {
                    return MT_HARDWARE_ALERT_BY_FAILED_RESET_MODLUE;
                }
                case 80: {
                    return MT_UPDFWFROMSP_OPENFILE_FAILED;
                }
                case 81: {
                    return MT_UPDFWFROMSP_FILE_FORMAT_ERR;
                }
                case 20: {
                    return MT_OTHER_ERR;
                }
                case 21: {
                    return MT_OTHER_ERR;
                }
                case 51: {
                    return MT_TEST_DEV_FAULT_1;
                }
                case 52: {
                    return MT_TEST_DEV_FAULT_2;
                }
                case 53: {
                    return MT_TEST_DEV_FAULT_3;
                }
                case 54: {
                    return MT_TEST_DEV_FAULT_4;
                }
                case 55: {
                    return MT_TEST_DEV_FAULT_5;
                }
                case 101: {
                    return MT_JNI_INVALID_PARA;
                }
            }
            return MT_OTHER_ERR;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum IT_MODE {
        IT_MODE_CT,
        IT_MODE_S2,
        IT_MODE_E7,
        IT_MODE_E7v2;

    }

    public static enum Reader_Type {
        MODULE_TWO_ANTS(0),
        MODULE_FOUR_ANTS(1),
        MODULE_THREE_ANTS(3),
        MODULE_ONE_ANT(4),
        PR9000(5),
        MODULE_ARM7_TWO_ANTS(6),
        MODULE_ARM7_FOUR_ANTS(7),
        M6E_ARM7_FOUR_ANTS(8),
        M56_ARM7_FOUR_ANTS(9),
        R902_M1S(10),
        R902_M2S(11),
        ARM7_16ANTS(12),
        SL_COMMN_READER(13);

        private int value = 0;

        private Reader_Type(int value) {
            this.value = value;
        }

        public static Reader_Type valueOf(int value) {
            switch (value) {
                case 0: {
                    return MODULE_TWO_ANTS;
                }
                case 1: {
                    return MODULE_FOUR_ANTS;
                }
                case 2: {
                    return MODULE_THREE_ANTS;
                }
                case 3: {
                    return MODULE_ONE_ANT;
                }
                case 4: {
                    return PR9000;
                }
                case 5: {
                    return MODULE_ARM7_TWO_ANTS;
                }
                case 6: {
                    return MODULE_ARM7_FOUR_ANTS;
                }
                case 7: {
                    return M6E_ARM7_FOUR_ANTS;
                }
                case 8: {
                    return M56_ARM7_FOUR_ANTS;
                }
                case 9: {
                    return R902_M1S;
                }
                case 10: {
                    return R902_M2S;
                }
                case 11: {
                    return ARM7_16ANTS;
                }
                case 12: {
                    return SL_COMMN_READER;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public class Inv_Potls_ST {
        public int potlcnt;
        public Inv_Potl[] potls = new Inv_Potl[6];
    }

    public class Inv_Potl {
        public SL_TagProtocol potl;
        public int weight;
    }

    public static enum SL_TagProtocol {
        SL_TAG_PROTOCOL_NONE(0),
        SL_TAG_PROTOCOL_ISO180006B(3),
        SL_TAG_PROTOCOL_GEN2(5),
        SL_TAG_PROTOCOL_ISO180006B_UCODE(6),
        SL_TAG_PROTOCOL_IPX64(7),
        SL_TAG_PROTOCOL_IPX256(8);

        int p_v;

        private SL_TagProtocol(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static SL_TagProtocol valueOf(int value) {
            switch (value) {
                case 0: {
                    return SL_TAG_PROTOCOL_NONE;
                }
                case 3: {
                    return SL_TAG_PROTOCOL_ISO180006B;
                }
                case 5: {
                    return SL_TAG_PROTOCOL_GEN2;
                }
                case 6: {
                    return SL_TAG_PROTOCOL_ISO180006B_UCODE;
                }
                case 7: {
                    return SL_TAG_PROTOCOL_IPX64;
                }
                case 8: {
                    return SL_TAG_PROTOCOL_IPX256;
                }
            }
            return null;
        }
    }

    public static enum Mtr_Param {
        MTR_PARAM_POTL_GEN2_SESSION(0),
        MTR_PARAM_POTL_GEN2_Q(1),
        MTR_PARAM_POTL_GEN2_TAGENCODING(2),
        MTR_PARAM_POTL_GEN2_MAXEPCLEN(3),
        MTR_PARAM_RF_ANTPOWER(4),
        MTR_PARAM_RF_MAXPOWER(5),
        MTR_PARAM_RF_MINPOWER(6),
        MTR_PARAM_TAG_FILTER(7),
        MTR_PARAM_TAG_EMBEDEDDATA(8),
        MTR_PARAM_TAG_INVPOTL(9),
        MTR_PARAM_READER_CONN_ANTS(10),
        MTR_PARAM_READER_AVAILABLE_ANTPORTS(11),
        MTR_PARAM_READER_IS_CHK_ANT(12),
        MTR_PARAM_READER_VERSION(13),
        MTR_PARAM_READER_IP(14),
        MTR_PARAM_FREQUENCY_REGION(15),
        MTR_PARAM_FREQUENCY_HOPTABLE(16),
        MTR_PARAM_POTL_GEN2_BLF(17),
        MTR_PARAM_POTL_GEN2_WRITEMODE(18),
        MTR_PARAM_POTL_GEN2_TARGET(19),
        MTR_PARAM_TAGDATA_UNIQUEBYANT(20),
        MTR_PARAM_TAGDATA_UNIQUEBYEMDDATA(21),
        MTR_PARAM_TAGDATA_RECORDHIGHESTRSSI(22),
        MTR_PARAM_RF_TEMPERATURE(23),
        MTR_PARAM_RF_HOPTIME(24),
        MTR_PARAM_RF_LBT_ENABLE(25),
        MTR_PARAM_RF_SUPPORTEDREGIONS(26),
        MTR_PARAM_POTL_SUPPORTEDPROTOCOLS(27),
        MTR_PARAM_POTL_ISO180006B_BLF(28),
        MTR_PARAM_POTL_GEN2_TARI(29),
        MTR_PARAM_TRANS_TIMEOUT(30),
        MTR_PARAM_TAG_EMDSECUREREAD(31),
        MTR_PARAM_TRANSMIT_MODE(32),
        MTR_PARAM_POWERSAVE_MODE(33),
        MTR_PARAM_TAG_SEARCH_MODE(34),
        MTR_PARAM_POTL_ISO180006B_MODULATION_DEPTH(35),
        MTR_PARAM_POTL_ISO180006B_DELIMITER(36),
        MTR_PARAM_RF_ANTPORTS_VSWR(37),
        MTR_PARAM_MAXINDEX(39),
        MTR_PARAM_CUSTOM(41),
        MTR_PARAM_READER_WATCHDOG(42),
        MTR_PARAM_READER_ERRORDATA(43),
        MTR_PARAM_RF_HOPANTTIME(44),
        MTR_PARAM_TAG_MULTISELECTORS(45),
        MTR_PARAM_SAVEINMODULE(46),
        MTR_PARAM_SAVEINMODULE_BAUD(47);

        private int value = 0;

        private Mtr_Param(int value) {
            this.value = value;
        }

        public static Mtr_Param valueOf(int value) {
            switch (value) {
                case 0: {
                    return MTR_PARAM_POTL_GEN2_SESSION;
                }
                case 1: {
                    return MTR_PARAM_POTL_GEN2_Q;
                }
                case 2: {
                    return MTR_PARAM_POTL_GEN2_TAGENCODING;
                }
                case 3: {
                    return MTR_PARAM_POTL_GEN2_MAXEPCLEN;
                }
                case 4: {
                    return MTR_PARAM_RF_ANTPOWER;
                }
                case 5: {
                    return MTR_PARAM_RF_MAXPOWER;
                }
                case 6: {
                    return MTR_PARAM_RF_MINPOWER;
                }
                case 7: {
                    return MTR_PARAM_TAG_FILTER;
                }
                case 8: {
                    return MTR_PARAM_TAG_EMBEDEDDATA;
                }
                case 9: {
                    return MTR_PARAM_TAG_INVPOTL;
                }
                case 10: {
                    return MTR_PARAM_READER_CONN_ANTS;
                }
                case 11: {
                    return MTR_PARAM_READER_AVAILABLE_ANTPORTS;
                }
                case 12: {
                    return MTR_PARAM_READER_IS_CHK_ANT;
                }
                case 13: {
                    return MTR_PARAM_READER_VERSION;
                }
                case 14: {
                    return MTR_PARAM_READER_IP;
                }
                case 15: {
                    return MTR_PARAM_FREQUENCY_REGION;
                }
                case 16: {
                    return MTR_PARAM_FREQUENCY_HOPTABLE;
                }
                case 17: {
                    return MTR_PARAM_POTL_GEN2_BLF;
                }
                case 18: {
                    return MTR_PARAM_POTL_GEN2_WRITEMODE;
                }
                case 19: {
                    return MTR_PARAM_POTL_GEN2_TARGET;
                }
                case 20: {
                    return MTR_PARAM_TAGDATA_UNIQUEBYANT;
                }
                case 21: {
                    return MTR_PARAM_TAGDATA_UNIQUEBYEMDDATA;
                }
                case 22: {
                    return MTR_PARAM_TAGDATA_RECORDHIGHESTRSSI;
                }
                case 23: {
                    return MTR_PARAM_RF_TEMPERATURE;
                }
                case 24: {
                    return MTR_PARAM_RF_HOPTIME;
                }
                case 25: {
                    return MTR_PARAM_RF_LBT_ENABLE;
                }
                case 26: {
                    return MTR_PARAM_RF_SUPPORTEDREGIONS;
                }
                case 27: {
                    return MTR_PARAM_POTL_SUPPORTEDPROTOCOLS;
                }
                case 28: {
                    return MTR_PARAM_POTL_ISO180006B_BLF;
                }
                case 29: {
                    return MTR_PARAM_POTL_GEN2_TARI;
                }
                case 30: {
                    return MTR_PARAM_TRANS_TIMEOUT;
                }
                case 31: {
                    return MTR_PARAM_TAG_EMDSECUREREAD;
                }
                case 32: {
                    return MTR_PARAM_TRANSMIT_MODE;
                }
                case 33: {
                    return MTR_PARAM_POWERSAVE_MODE;
                }
                case 34: {
                    return MTR_PARAM_TAG_SEARCH_MODE;
                }
                case 35: {
                    return MTR_PARAM_POTL_ISO180006B_MODULATION_DEPTH;
                }
                case 36: {
                    return MTR_PARAM_POTL_ISO180006B_DELIMITER;
                }
                case 37: {
                    return MTR_PARAM_RF_ANTPORTS_VSWR;
                }
                case 39: {
                    return MTR_PARAM_MAXINDEX;
                }
                case 41: {
                    return MTR_PARAM_CUSTOM;
                }
                case 42: {
                    return MTR_PARAM_READER_WATCHDOG;
                }
                case 43: {
                    return MTR_PARAM_READER_ERRORDATA;
                }
                case 44: {
                    return MTR_PARAM_RF_HOPANTTIME;
                }
                case 45: {
                    return MTR_PARAM_TAG_MULTISELECTORS;
                }
                case 46: {
                    return MTR_PARAM_SAVEINMODULE;
                }
                case 47: {
                    return MTR_PARAM_SAVEINMODULE_BAUD;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Module_Type {
        MODOULE_NONE(0),
        MODOULE_R902_M1S(1),
        MODOULE_R902_M2S(2),
        MODOULE_M5E(3),
        MODOULE_M5E_C(4),
        MODOULE_M6E(5),
        MODOULE_PR9000(6),
        MODOULE_M5E_PRC(7),
        MODOULE_M6E_PRC(8),
        MODOULE_M6E_MICRO(9),
        MODOULE_SLR1100(10),
        MODOULE_SLR1200(11),
        MODOULE_SLR1300(12),
        MODOULE_SLR3000(13),
        MODOULE_SLR5100(14),
        MODOULE_SLR5200(15),
        MODOULE_SLR3100(16),
        MODOULE_SLR3200(17),
        MODOULE_SLR5300(18),
        MODOULE_SLR5900(19),
        MODOULE_SLR5800(20),
        MODOULE_SLR6000(21),
        MODOULE_SLR6100(22),
        MODOULE_SIM7100(23),
        MODOULE_SIM7200(24),
        MODOULE_SIM7300(25),
        MODOULE_SIM7400(26),
        MODOULE_SIM7500(27),
        MODOULE_SIM3100(28),
        MODOULE_SIM3200(29),
        MODOULE_SIM3300(30),
        MODOULE_SIM3400(31),
        MODOULE_SIM3500(32),
        MODOULE_SIM3600(33),
        MODOULE_SIM5100(34),
        MODOULE_SIM5200(35),
        MODOULE_SIM5300(36),
        MODOULE_SIM5400(37),
        MODOULE_SIM5500(38),
        MODOULE_SIM5600(39);

        private int value = 0;

        private Module_Type(int value) {
            this.value = value;
        }

        public static Module_Type valueOf(int value) {
            switch (value) {
                case 0: {
                    return MODOULE_NONE;
                }
                case 1: {
                    return MODOULE_R902_M1S;
                }
                case 2: {
                    return MODOULE_R902_M2S;
                }
                case 3: {
                    return MODOULE_M5E;
                }
                case 4: {
                    return MODOULE_M5E_C;
                }
                case 5: {
                    return MODOULE_M6E;
                }
                case 6: {
                    return MODOULE_PR9000;
                }
                case 7: {
                    return MODOULE_M5E_PRC;
                }
                case 8: {
                    return MODOULE_M6E_PRC;
                }
                case 9: {
                    return MODOULE_M6E_MICRO;
                }
                case 10: {
                    return MODOULE_SLR1100;
                }
                case 11: {
                    return MODOULE_SLR1200;
                }
                case 12: {
                    return MODOULE_SLR1300;
                }
                case 13: {
                    return MODOULE_SLR3000;
                }
                case 14: {
                    return MODOULE_SLR5100;
                }
                case 15: {
                    return MODOULE_SLR5200;
                }
                case 16: {
                    return MODOULE_SLR3100;
                }
                case 17: {
                    return MODOULE_SLR3200;
                }
                case 18: {
                    return MODOULE_SLR5300;
                }
                case 19: {
                    return MODOULE_SLR5900;
                }
                case 20: {
                    return MODOULE_SLR5800;
                }
                case 21: {
                    return MODOULE_SLR6000;
                }
                case 22: {
                    return MODOULE_SLR6100;
                }
                case 23: {
                    return MODOULE_SIM7100;
                }
                case 24: {
                    return MODOULE_SIM7200;
                }
                case 25: {
                    return MODOULE_SIM7300;
                }
                case 26: {
                    return MODOULE_SIM7400;
                }
                case 27: {
                    return MODOULE_SIM7500;
                }
                case 28: {
                    return MODOULE_SIM3100;
                }
                case 29: {
                    return MODOULE_SIM3200;
                }
                case 30: {
                    return MODOULE_SIM3300;
                }
                case 31: {
                    return MODOULE_SIM3400;
                }
                case 32: {
                    return MODOULE_SIM3500;
                }
                case 33: {
                    return MODOULE_SIM3600;
                }
                case 34: {
                    return MODOULE_SIM5100;
                }
                case 35: {
                    return MODOULE_SIM5200;
                }
                case 36: {
                    return MODOULE_SIM5300;
                }
                case 37: {
                    return MODOULE_SIM5400;
                }
                case 38: {
                    return MODOULE_SIM5500;
                }
                case 39: {
                    return MODOULE_SIM5600;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public class HardwareDetails {
        public Module_Type module;
        public MaindBoard_Type board;
        public Reader_Type logictype;
    }

    public static enum MaindBoard_Type {
        MAINBOARD_NONE,
        MAINBOARD_ARM7,
        MAINBOARD_SERIAL,
        MAINBOARD_WIFI,
        MAINBOARD_ARM9,
        MAINBOARD_ARM9_WIFI;

    }

    public class TAGINFO
    implements Cloneable {
        public byte AntennaID;
        public int Frequency;
        public int TimeStamp;
        public short EmbededDatalen;
        public byte[] EmbededData = null;
        public byte[] Res = new byte[2];
        public short Epclen;
        public byte[] PC = new byte[2];
        public byte[] CRC = new byte[2];
        public byte[] EpcId = null;
        public int Phase;
        public SL_TagProtocol protocol;
        public int ReadCnt;
        public int RSSI;

        public Object clone() {
            TAGINFO o = null;
            try {
                o = (TAGINFO)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            return o;
        }
    }

    public class EmbededData_ST {
        public int bank;
        public int startaddr;
        public int bytecnt;
        public byte[] accesspwd;
    }

    public static enum CustomCmdType {
        NXP_SetReadProtect(0),
        NXP_ResetReadProtect(1),
        NXP_ChangeEAS(2),
        NXP_EASAlarm(3),
        NXP_Calibrate(4),
        ALIEN_Higgs2_PartialLoadImage(5),
        ALIEN_Higgs2_FullLoadImage(6),
        ALIEN_Higgs3_FastLoadImage(7),
        ALIEN_Higgs3_LoadImage(8),
        ALIEN_Higgs3_BlockReadLock(9),
        ALIEN_Higgs3_BlockPermaLock(10),
        IMPINJ_M4_Qt(11),
        NXP_U8_InventoryMode(20);

        private int value = 0;

        private CustomCmdType(int value) {
            this.value = value;
        }

        public static CustomCmdType valueOf(int value) {
            switch (value) {
                case 0: {
                    return NXP_SetReadProtect;
                }
                case 1: {
                    return NXP_ResetReadProtect;
                }
                case 2: {
                    return NXP_ChangeEAS;
                }
                case 3: {
                    return NXP_EASAlarm;
                }
                case 4: {
                    return NXP_Calibrate;
                }
                case 5: {
                    return ALIEN_Higgs2_PartialLoadImage;
                }
                case 6: {
                    return ALIEN_Higgs2_FullLoadImage;
                }
                case 7: {
                    return ALIEN_Higgs3_FastLoadImage;
                }
                case 8: {
                    return ALIEN_Higgs3_LoadImage;
                }
                case 9: {
                    return ALIEN_Higgs3_BlockReadLock;
                }
                case 10: {
                    return ALIEN_Higgs3_BlockPermaLock;
                }
                case 11: {
                    return IMPINJ_M4_Qt;
                }
                case 20: {
                    return NXP_U8_InventoryMode;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public class IMPINJM4QtPara {
        public byte[] AccessPwd = new byte[4];
        public int CmdType;
        public int MemType;
        public int PersistType;
        public int RangeType;
        public short TimeOut;
    }

    public class ALIENHiggs3BlockReadLockPara {
        public byte[] AccessPwd = new byte[4];
        public byte BlkBits;
        public short TimeOut;
    }

    public class NXPChangeEASPara {
        public byte[] AccessPwd = new byte[4];
        public int isSet;
        public short TimeOut;
    }

    public class NXPEASAlarmPara {
        public byte DR;
        public byte MC;
        public byte TrExt;
        public short TimeOut;
    }

    public class NXP_U8_InventoryModePara {
        public byte[] Mode = new byte[1];
    }

    public class AntPowerConf {
        public int antcnt;
        public AntPower[] Powers = new AntPower[16];
    }

    public class AntPower {
        public int antid;
        public short readPower;
        public short writePower;
    }

    public class TagFilter_ST {
        public int bank;
        public int startaddr;
        public int flen;
        public byte[] fdata = new byte[255];
        public int isInvert;
    }

    public class ConnAnts_ST {
        public int antcnt;
        public int[] connectedants = new int[16];
    }

    public class ReaderVersion {
        public String hardwareVer = "";
        public String softwareVer = "";
    }

    public static enum Region_Conf {
        RG_NONE(0),
        RG_NA(1),
        RG_EU(2),
        RG_EU2(7),
        RG_EU3(8),
        RG_KR(3),
        RG_PRC(6),
        RG_PRC2(10),
        RG_OPEN(255);

        int p_v;

        private Region_Conf(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static Region_Conf valueOf(int value) {
            switch (value) {
                case 0: {
                    return RG_NONE;
                }
                case 1: {
                    return RG_NA;
                }
                case 2: {
                    return RG_EU;
                }
                case 7: {
                    return RG_EU2;
                }
                case 8: {
                    return RG_EU3;
                }
                case 3: {
                    return RG_KR;
                }
                case 6: {
                    return RG_PRC;
                }
                case 10: {
                    return RG_PRC2;
                }
                case 255: {
                    return RG_OPEN;
                }
            }
            return null;
        }
    }

    public class HoptableData_ST {
        public int[] htb = new int[100];
        public int lenhtb;
    }

    public class AntPortsVSWR {
        public int andid;
        public short power;
        public Region_Conf region;
        public int frecount;
        public FrequencyVSWR[] vswrs = new FrequencyVSWR[100];

        public AntPortsVSWR() {
            for (int i = 0; i < 100; ++i) {
                this.vswrs[i] = new FrequencyVSWR();
            }
        }

        public String toString() {
            String ret = "";
            for (int i = 0; i < this.frecount; ++i) {
                ret = ret + this.vswrs[i].frequency + ":" + String.format("%.2f", Float.valueOf(this.vswrs[i].vswr)) + " ";
            }
            return ret;
        }
    }

    public class FrequencyVSWR {
        public int frequency;
        public float vswr;
    }

    public class Reader_Ip {
        public byte[] ip;
        public byte[] mask;
        public byte[] gateway;
    }

    public class CustomParam_ST {
        public String ParamName;
        public byte[] ParamVal;
    }

    public class Default_Param {
        public Mtr_Param key;
        public String subkey;
        public boolean isdefault;
        public Object val;
    }

    public class MultiTagSelectors_ST {
        public TagSelector_ST[] tagselectors = new TagSelector_ST[16];
        public int tagselectorcnt;

        public MultiTagSelectors_ST() {
            for (int i = 0; i < 16; ++i) {
                this.tagselectors[i] = new TagSelector_ST();
            }
        }
    }

    public class TagSelector_ST {
        public int bank;
        public int startaddr;
        public int slen;
        public byte[] sdata = new byte[24];
    }

    public static class deviceVersion {
        public String hardwareVer = "";
        public String softwareVer = "";
    }

    public class DeviceSerialNumber {
        public String serailNumber = "";
    }

    class MsgObj {
        public byte[] soh = new byte[1];
        public byte[] dataLen = new byte[1];
        public byte[] opCode = new byte[1];
        public byte[] status = new byte[2];
        public byte[] crc = new byte[2];
        public byte[] data = new byte[250];

        MsgObj() {
        }

        public byte[] getcheckcrcdata() {
            byte[] crcb = new byte[this.dataLen[0] + 4];
            int p = 0;
            crcb[p] = this.dataLen[0];
            int n = ++p;
            crcb[n] = this.opCode[0];
            int n2 = ++p;
            crcb[n2] = this.status[0];
            int n3 = ++p;
            ++p;
            crcb[n3] = this.status[1];
            for (int i = 0; i < this.dataLen[0]; ++i) {
                crcb[p++] = this.data[i];
            }
            return crcb;
        }
    }

    private class Tagnotify
    implements Runnable {
        Reader reader;

        public Tagnotify(Reader rd) {
            this.reader = rd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tagnotify tagnotify = this;
            synchronized (tagnotify) {
                int re = 0;
                TAGINFO[] tag = null;
                Reader.this.m_IsReadThRunning = true;
                boolean isGpiTrigger = false;
                boolean isGpiTriStop = false;
                int startgpitriid = 0;
                GPITrigger pGTrigger = Reader.this.m_BackReadOp.GpiTrigger;
                long dtwstart = System.currentTimeMillis();
                long timenow = System.currentTimeMillis();
                BackReadGpiTriState BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                if (Reader.this.m_BackReadOp.IsGPITrigger) {
                    isGpiTrigger = true;
                    if (Reader.this.m_BackReadOp.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TRI2STOP) {
                        isGpiTriStop = true;
                    }
                    pGTrigger = Reader.this.m_BackReadOp.GpiTrigger;
                }
                while (Reader.this.m_IsReadingForAll) {
                    block42: {
                        Object gstates;
                        block44: {
                            boolean isStop;
                            block43: {
                                if (!isGpiTrigger) break block42;
                                boolean isStart = true;
                                isStop = true;
                                if (BRGstate != BackReadGpiTriState.BackReadGpi_WaitStart) break block43;
                                gstates = new GpiInfo_ST();
                                re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], (GpiInfo_ST)gstates);
                                if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                                isStart = Reader.this.GpiTriContains(pGTrigger.GpiTrigger1States, (GpiInfo_ST)gstates);
                                if (isStart) {
                                    startgpitriid = 1;
                                    if (Reader.this.gpitriListener.size() > 0) {
                                        for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                            gpiTriggerListener.GpiTrigger(this.reader, (GpiInfo_ST)gstates, startgpitriid);
                                        }
                                    }
                                } else if (pGTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP && (isStart = Reader.this.GpiTriContains(pGTrigger.GpiTrigger2States, (GpiInfo_ST)gstates))) {
                                    startgpitriid = 2;
                                    if (Reader.this.gpitriListener.size() > 0) {
                                        for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                            gpiTriggerListener.GpiTrigger(this.reader, (GpiInfo_ST)gstates, startgpitriid);
                                        }
                                    }
                                }
                                if (!isStart) continue;
                                if (Reader.this.gpitriboundListener.size() > 0) {
                                    for (GpiTriggerBoundaryListener gpiTriggerBoundaryListener : Reader.this.gpitriboundListener) {
                                        gpiTriggerBoundaryListener.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StartInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByGpi);
                                    }
                                }
                                if (isGpiTriStop) {
                                    BRGstate = BackReadGpiTriState.BackReadGpi_WaitStop;
                                } else {
                                    dtwstart = System.currentTimeMillis();
                                    BRGstate = BackReadGpiTriState.BackReadGpi_WaitTimeout;
                                }
                                if (Reader.this.m_BackReadOp.IsFastRead) {
                                    re = Reader.this.japi.AsyncStartReading(Reader.this.hReader[0], Reader.this.m_BackReadAnts, Reader.this.m_BackReadAntsCnt, Reader.this.m_FastReadOption);
                                }
                                break block42;
                            }
                            if (BRGstate != BackReadGpiTriState.BackReadGpi_WaitStop) break block44;
                            gstates = new GpiInfo_ST();
                            re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], (GpiInfo_ST)gstates);
                            if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                            isStop = Reader.this.GpiTriContains(pGTrigger.GpiTrigger2States, (GpiInfo_ST)gstates);
                            if (isStop) {
                                if (Reader.this.gpitriListener.size() > 0) {
                                    for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                        gpiTriggerListener.GpiTrigger(this.reader, (GpiInfo_ST)gstates, 2);
                                    }
                                }
                                BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                                if (Reader.this.m_BackReadOp.IsFastRead && Reader.this.errhandle(re = Reader.this.japi.AsyncStopReading(Reader.this.hReader[0])) != READER_ERR.MT_OK_ERR || Reader.this.gpitriboundListener.size() <= 0) continue;
                                for (GpiTriggerBoundaryListener gpiTriggerBoundaryListener : Reader.this.gpitriboundListener) {
                                    gpiTriggerBoundaryListener.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StopInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByGpi);
                                }
                                continue;
                            }
                            break block42;
                        }
                        if (BRGstate != BackReadGpiTriState.BackReadGpi_WaitTimeout) break block42;
                        if (pGTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP) {
                            gstates = new GpiInfo_ST();
                            GpiInfo_ST ptmpgpiinfo = new GpiInfo_ST();
                            re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], (GpiInfo_ST)gstates);
                            if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                            if (startgpitriid == 1) {
                                ptmpgpiinfo = pGTrigger.GpiTrigger2States;
                            } else if (startgpitriid == 2) {
                                ptmpgpiinfo = pGTrigger.GpiTrigger1States;
                            }
                            if (Reader.this.GpiTriContains(ptmpgpiinfo, (GpiInfo_ST)gstates) && Reader.this.gpitriListener.size() > 0) {
                                for (GpiTriggerListener rl : Reader.this.gpitriListener) {
                                    rl.GpiTrigger(this.reader, (GpiInfo_ST)gstates, 3 - startgpitriid);
                                }
                            }
                        }
                        if ((timenow = System.currentTimeMillis()) - dtwstart > (long)Reader.this.m_BackReadOp.GpiTrigger.StopTriggerTimeout) {
                            BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                            if (Reader.this.m_BackReadOp.IsFastRead && Reader.this.errhandle(re = Reader.this.japi.AsyncStopReading(Reader.this.hReader[0])) != READER_ERR.MT_OK_ERR || Reader.this.gpitriboundListener.size() <= 0) continue;
                            for (GpiTriggerBoundaryListener rl : Reader.this.gpitriboundListener) {
                                rl.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StopInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByTimeout);
                            }
                        }
                        break block42;
                        continue;
                    }
                    int[] tagcnt = new int[1];
                    if (Reader.this.m_BackReadOp.IsFastRead) {
                        tagcnt[0] = 0;
                        re = Reader.this.japi.AsyncGetTagCount(Reader.this.hReader[0], tagcnt);
                        Reader.this.toDlogAPI("read tag:" + String.valueOf(tagcnt[0]));
                        if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) {
                            Reader.this.ALOGS(String.valueOf(re) + " 2209");
                            continue;
                        }
                    } else {
                        re = Reader.this.japi.TagInventory_Raw(Reader.this.hReader[0], Reader.this.m_BackReadAnts, Reader.this.m_BackReadAntsCnt, Reader.this.m_BackReadOp.ReadDuration, tagcnt);
                        if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                    }
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO stag = new TAGINFO();
                        if (Reader.this.m_IsReadingForAll) {
                            if (Reader.this.m_BackReadOp.IsFastRead) {
                                if (Reader.this.errhandle2(this.reader.AsyncGetNextTag(stag)) != READER_ERR.MT_OK_ERR) {
                                    Reader.this.ALOGS(String.valueOf(re) + " 2226");
                                    continue;
                                }
                            } else {
                                re = Reader.this.GetNextTag(stag).value;
                                if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                            }
                            tagv.add(stag);
                        }
                        if (!Reader.this.m_IsReadingForAll) break;
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            rl.tagRead(this.reader, tag);
                        }
                    }
                    try {
                        Thread.sleep(Reader.this.m_BackReadOp.ReadInterval);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Reader.this.m_IsReadThRunning = false;
            }
        }
    }

    private class Exceptionotify
    implements Runnable {
        Reader reader;
        READER_ERR re;

        public Exceptionotify(Reader rd, READER_ERR rer) {
            this.reader = rd;
            this.re = rer;
        }

        @Override
        public void run() {
            for (ReadExceptionListener rel : Reader.this.readExceptionListeners) {
                rel.tagReadException(this.reader, this.re);
            }
        }
    }

    private class IT_CT_notify
    implements Runnable {
        Reader reader;

        public IT_CT_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_CT_run) {
                int nowcyc;
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                if (er != READER_ERR.MT_OK_ERR) {
                    Reader.this.errhandle_IT(er);
                    break;
                }
                if (tagcnt[0] > 0) {
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er == READER_ERR.MT_OK_ERR) {
                            if (!Reader.this.quetagstr.contains(Reader.bytes_Hexstr(tfs.EpcId))) {
                                Reader.this.quetagstr.add(Reader.bytes_Hexstr(tfs.EpcId));
                                ++Reader.this.totalcount;
                            }
                        } else {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            rl.tagRead(this.reader, tag);
                        }
                    }
                }
                long readtime_spp = System.currentTimeMillis() - Reader.this.IT_CT_start;
                if (Reader.this.IT_CT_step == 0 && Reader.this.isIT_CT_run && readtime_spp >= (long)(Reader.this.IT_CT_m1_keep * 1000)) {
                    Reader.this.IT_CT_step = 1;
                    Reader.this.IT_CT_start = System.currentTimeMillis();
                    Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                }
                if (Reader.this.IT_CT_step == 5 && Reader.this.isIT_CT_run && readtime_spp >= (long)(Reader.this.IT_CT_m1_keep * 1000)) {
                    Reader.this.IT_CT_step = 6;
                    Reader.this.IT_CT_start = System.currentTimeMillis();
                    Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                }
                if (readtime_spp - Reader.this.vstaticstarttick >= (long)(nowcyc = Reader.this.IT_CT_step == 0 || Reader.this.IT_CT_step == 1 || Reader.this.IT_CT_step == 5 ? Reader.this.IT_CT_m1_cycle : (Reader.this.IT_CT_step == 2 || Reader.this.IT_CT_step == 3 ? Reader.this.IT_CT_m2_cycle : (Reader.this.IT_CT_step == 4 || Reader.this.IT_CT_step == 6 ? Reader.this.IT_CT_m3_cycleread : 1000)))) {
                    Reader.this.vstaticstarttick = readtime_spp;
                    if (Reader.this.IT_CT_step == 1 && Reader.this.isIT_CT_run) {
                        if (Reader.this.totalcount - Reader.this.totalcountlast < Reader.this.IT_CT_m1_toma) {
                            Reader.this.IT_CT_step = 4;
                            Reader.this.IT_CT_c = 0;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        }
                    } else if (Reader.this.IT_CT_step == 2 && Reader.this.isIT_CT_run) {
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        if (Reader.this.isIT_CT_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        if (++Reader.this.IT_CT_c >= Reader.this.IT_CT_m2_keepcount) {
                            Reader.this.IT_CT_step = 3;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        }
                    } else if (Reader.this.IT_CT_step == 3 && Reader.this.isIT_CT_run) {
                        if (Reader.this.totalcount - Reader.this.totalcountlast < Reader.this.IT_CT_m2_tomc) {
                            Reader.this.IT_CT_step = 4;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        } else if (Reader.this.totalcount - Reader.this.totalcountlast > Reader.this.IT_CT_m2_toma) {
                            Reader.this.IT_CT_step = 0;
                            Reader.this.IT_CT_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                        }
                    } else if ((Reader.this.IT_CT_step == 4 || Reader.this.IT_CT_step == 6) && Reader.this.isIT_CT_run) {
                        if (Reader.this.totalcount - Reader.this.totalcountlast > Reader.this.IT_CT_m3_toma) {
                            Reader.this.IT_CT_step = 0;
                        } else {
                            er = Reader.this.AsyncStopReading();
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            long st_time = System.currentTimeMillis();
                            do {
                                try {
                                    if (!Reader.this.isIT_CT_run) break;
                                    Thread.sleep(50L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            } while (System.currentTimeMillis() - st_time <= (long)Reader.this.IT_CT_m3_cyclestop);
                            if (Reader.this.isIT_CT_run) {
                                er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pantcnt, Reader.this.poption);
                            }
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                        }
                        Reader.this.IT_CT_start = System.currentTimeMillis();
                        Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_CT_start;
                    }
                    Reader.this.totalcountlast = Reader.this.totalcount;
                }
                if (Reader.this.isIT_CT_run) continue;
                break;
            }
        }
    }

    private class IT_S2_notify
    implements Runnable {
        Reader reader;

        public IT_S2_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_S2_run) {
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                if (er != READER_ERR.MT_OK_ERR) {
                    Reader.this.errhandle_IT(er);
                    break;
                }
                if (tagcnt[0] > 0) {
                    Reader.this.totalcount += tagcnt[0];
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            rl.tagRead(this.reader, tag);
                        }
                    }
                }
                long readtime_spp = System.currentTimeMillis() - Reader.this.IT_S2_start;
                int nowcyc = Reader.this.IT_S2_m1_cycle;
                if (Reader.this.IT_S2_step == 0) {
                    nowcyc = Reader.this.IT_S2_m1_cycle;
                } else if (Reader.this.IT_S2_step == 1) {
                    nowcyc = Reader.this.IT_S2_m1_cycle2;
                }
                if (readtime_spp - Reader.this.vstaticstarttick >= (long)nowcyc) {
                    int[] vala;
                    Reader.this.toDlog("Nowcyc:" + String.valueOf(nowcyc) + " tick:" + String.valueOf(readtime_spp - Reader.this.vstaticstarttick));
                    Reader.this.vstaticstarttick = readtime_spp;
                    if (Reader.this.IT_S2_step == 0 && Reader.this.isIT_S2_run) {
                        Reader.this.toDlog("IT_S2_M1_STEP1---" + String.valueOf(Reader.this.totalcount));
                        if (Reader.this.totalcount < Reader.this.IT_S2_ctagcount) {
                            Reader.this.toDlog("stop:" + String.valueOf(Reader.this.IT_S2_ctagcount));
                            er = Reader.this.AsyncStopReading();
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.toDlog("set pro1 to start");
                            vala = new int[]{17};
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            if (Reader.this.isIT_S2_run) {
                                er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                            }
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.IT_S2_step = 1;
                            Reader.this.IT_S2_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_S2_start;
                        }
                    } else if (Reader.this.IT_S2_step == 1 && Reader.this.isIT_S2_run && Reader.this.totalcount < Reader.this.IT_S2_ctagcount2) {
                        Reader.this.toDlog("stop:" + String.valueOf(Reader.this.IT_S2_ctagcount2));
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        vala = new int[]{0};
                        if (!Reader.this.IT_S2_istargetA) {
                            vala[0] = 1;
                            Reader.this.toDlog("set to B");
                        } else {
                            Reader.this.toDlog("set to A");
                        }
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, vala);
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.IT_S2_istargetA = !Reader.this.IT_S2_istargetA;
                        vala[0] = 19;
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.toDlog("set pro3 to start");
                        if (Reader.this.isIT_S2_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.IT_S2_step = 0;
                        Reader.this.IT_S2_start = System.currentTimeMillis();
                        Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_S2_start;
                    }
                    Reader.this.totalcountlast = Reader.this.totalcount;
                    Reader.this.totalcount = 0;
                }
                if (Reader.this.isIT_S2_run) continue;
                break;
            }
        }
    }

    private class IT_E7_notify
    implements Runnable {
        Reader reader;

        public IT_E7_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_E7_run) {
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                if (er != READER_ERR.MT_OK_ERR) {
                    Reader.this.errhandle_IT(er);
                    break;
                }
                if (tagcnt[0] > 0) {
                    Reader.this.toDlog("gettagcount:" + String.valueOf(tagcnt[0]));
                    Reader.this.totalcount += tagcnt[0];
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                            break;
                        }
                        tagv.add(tfs);
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            rl.tagRead(this.reader, tag);
                        }
                    }
                }
                long readtime_spp = System.currentTimeMillis() - Reader.this.IT_E7_start;
                int nowcyc = Reader.this.IT_E7_m1_cycle;
                if (Reader.this.IT_E7_step == 0) {
                    nowcyc = Reader.this.IT_E7_m1_cycle;
                } else if (Reader.this.IT_E7_step == 1) {
                    nowcyc = Reader.this.IT_E7_m1_cycle2;
                }
                if (readtime_spp - Reader.this.vstaticstarttick >= (long)nowcyc) {
                    int[] vala;
                    Reader.this.toDlog("Nowcyc:" + String.valueOf(nowcyc) + " tick:" + String.valueOf(readtime_spp - Reader.this.vstaticstarttick));
                    Reader.this.vstaticstarttick = readtime_spp;
                    if (Reader.this.IT_E7_step == 0 && Reader.this.isIT_E7_run) {
                        if (Reader.this.totalcount < Reader.this.IT_E7_ctagcount) {
                            Reader.this.toDlog("stop:IT_E7_M1_STEP1 " + String.valueOf(Reader.this.IT_E7_ctagcount));
                            er = Reader.this.AsyncStopReading();
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.toDlog("set gen2 code 107");
                            vala = new int[]{107};
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            if (Reader.this.isIT_E7_run) {
                                er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                            }
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.IT_E7_step = 1;
                            Reader.this.IT_E7_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_E7_start;
                        }
                    } else if (Reader.this.IT_E7_step == 1 && Reader.this.isIT_E7_run && Reader.this.totalcount < Reader.this.IT_E7_ctagcount2) {
                        Reader.this.toDlog("stop:IT_E7_M1_STEP2 " + String.valueOf(Reader.this.IT_E7_ctagcount2));
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.IT_E7_istargetA = !Reader.this.IT_E7_istargetA;
                        vala = new int[]{0};
                        if (Reader.this.IT_E7_istargetA) {
                            Reader.this.toDlog("set to A");
                        } else {
                            vala[0] = 1;
                            Reader.this.toDlog("set to B");
                        }
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, vala);
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        if (Reader.this.IT_E7_istargetA) {
                            Reader.this.toDlog("set to 107,S2 to A");
                            vala[0] = 107;
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.SetFilterSessioninTargetA(Reader.this.pants, Reader.this.IT_E7_centrefre, Reader.this.IT_E7_pow);
                        }
                        Reader.this.toDlog(" set gen2code:" + String.valueOf(Reader.this.IT_E7_rfm));
                        vala[0] = Reader.this.IT_E7_rfm;
                        er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.toDlog(" to start");
                        if (Reader.this.isIT_E7_run) {
                            er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.IT_E7_step = 0;
                        Reader.this.IT_E7_start = System.currentTimeMillis();
                        Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_E7_start;
                    }
                    Reader.this.totalcountlast = Reader.this.totalcount;
                    Reader.this.totalcount = 0;
                }
                if (Reader.this.isIT_E7_run) continue;
                break;
            }
        }
    }

    private class IT_E7v2_notify
    implements Runnable {
        Reader reader;

        public IT_E7v2_notify(Reader rd) {
            this.reader = rd;
        }

        @Override
        public void run() {
            while (Reader.this.isIT_E7_run) {
                TAGINFO[] tag = null;
                int[] tagcnt = new int[]{0};
                READER_ERR er = Reader.this.AsyncGetTagCount(tagcnt);
                boolean isautostop = false;
                if (er != READER_ERR.MT_OK_ERR) {
                    Reader.this.errhandle_IT(er);
                    break;
                }
                if (tagcnt[0] > 0) {
                    Reader.this.toDlog("gettagcount:" + String.valueOf(tagcnt[0]));
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    for (int i = 0; i < tagcnt[0]; ++i) {
                        TAGINFO tfs = new TAGINFO();
                        er = Reader.this.AsyncGetNextTag(tfs);
                        if (er == READER_ERR.MT_OK_ERR) {
                            if (tfs.Epclen % 2 == 0) {
                                tagv.add(tfs);
                                ++Reader.this.totalcount;
                                continue;
                            }
                            if (tfs.Epclen != 3) continue;
                            isautostop = true;
                            continue;
                        }
                        Reader.this.errhandle_IT(er);
                        break;
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            rl.tagRead(this.reader, tag);
                        }
                    }
                }
                long readtime_spp = System.currentTimeMillis() - Reader.this.IT_E7_start;
                int nowcyc = Reader.this.IT_E7_m1_cycle;
                if (Reader.this.IT_E7_step == 0) {
                    nowcyc = Reader.this.IT_E7_m1_cycle;
                } else if (Reader.this.IT_E7_step == 1) {
                    nowcyc = Reader.this.IT_E7_m1_cycle2;
                } else if (Reader.this.IT_E7_step == 2 || Reader.this.IT_E7_step == 3 || Reader.this.IT_E7_step == 4) {
                    nowcyc = Reader.this.IT_E7_m1_cycle3;
                }
                if (readtime_spp - Reader.this.vstaticstarttick >= (long)nowcyc) {
                    int[] vala;
                    Reader.this.toDlog("Nowcyc:" + String.valueOf(nowcyc) + " tick:" + String.valueOf(readtime_spp - Reader.this.vstaticstarttick));
                    Reader.this.vstaticstarttick = readtime_spp;
                    if (Reader.this.IT_E7_step == 0 && Reader.this.isIT_E7_run) {
                        Reader.this.toDlog("stop IT_E7_M1_STEP1---" + String.valueOf(Reader.this.totalcount));
                        if (Reader.this.totalcount < Reader.this.IT_E7_ctagcount) {
                            Reader.this.toDlog("stop:" + String.valueOf(Reader.this.IT_E7_ctagcount));
                            er = Reader.this.AsyncStopReading();
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.toDlog("set gen2 code 107");
                            vala = new int[]{107};
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            if (Reader.this.isIT_E7_run) {
                                er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                            }
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.IT_E7_step = 1;
                            Reader.this.IT_E7_start = System.currentTimeMillis();
                            Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_E7_start;
                        }
                    } else if (Reader.this.IT_E7_step == 1 && Reader.this.isIT_E7_run) {
                        if (Reader.this.totalcount < Reader.this.IT_E7_ctagcount2) {
                            int[] val;
                            Reader.this.toDlog("stop IT_E7_M1_STEP2---" + String.valueOf(Reader.this.IT_E7_ctagcount2));
                            er = Reader.this.AsyncStopReading();
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.toDlog("set gen2 code 113,fre " + String.valueOf(Reader.this.IT_E7_centrefre) + " Q 4");
                            vala = new int[]{113};
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            HoptableData_ST hdst2 = new HoptableData_ST();
                            hdst2.lenhtb = 1;
                            hdst2.htb[0] = Reader.this.IT_E7_lowfre;
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            if ((er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_Q, val = new int[]{4})) == READER_ERR.MT_OK_ERR) {
                                Reader.this.toDlog(" to start");
                                if (Reader.this.isIT_E7_run) {
                                    er = Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption);
                                }
                                if (er != READER_ERR.MT_OK_ERR) {
                                    Reader.this.errhandle_IT(er);
                                }
                                Reader.this.IT_E7_step = 2;
                                Reader.this.IT_E7_start = System.currentTimeMillis();
                                Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_E7_start;
                            }
                        }
                    } else if ((Reader.this.IT_E7_step == 2 || Reader.this.IT_E7_step == 3 || Reader.this.IT_E7_step == 4) && Reader.this.isIT_E7_run && (Reader.this.totalcount < Reader.this.IT_E7_ctagcount3 || isautostop)) {
                        HoptableData_ST hdst2;
                        Reader.this.toDlog("stop: IT_E7_M1_STEP" + String.valueOf(Reader.this.IT_E7_step + 1) + " " + String.valueOf(Reader.this.totalcount) + " autostop:" + String.valueOf(isautostop));
                        er = Reader.this.AsyncStopReading();
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        if (Reader.this.IT_E7_step == 2) {
                            Reader.this.toDlog("set fre " + String.valueOf(Reader.this.IT_E7_lowfre));
                            hdst2 = new HoptableData_ST();
                            hdst2.lenhtb = 1;
                            hdst2.htb[0] = Reader.this.IT_E7_lowfre;
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.IT_E7_step = 3;
                        } else if (Reader.this.IT_E7_step == 3) {
                            Reader.this.toDlog("set fre " + String.valueOf(Reader.this.IT_E7_highfre));
                            hdst2 = new HoptableData_ST();
                            hdst2.lenhtb = 1;
                            hdst2.htb[0] = Reader.this.IT_E7_highfre;
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, hdst2);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.IT_E7_step = 4;
                        } else if (Reader.this.IT_E7_step == 4) {
                            Reader.this.IT_E7_istargetA = !Reader.this.IT_E7_istargetA;
                            vala = new int[]{0};
                            vala[0] = -1;
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_Q, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            if ((er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)Reader.this.IT_E7_rg)) != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            vala[0] = 0;
                            if (Reader.this.IT_E7_istargetA) {
                                Reader.this.toDlog("set to A");
                            } else {
                                vala[0] = 1;
                                Reader.this.toDlog("set to B");
                            }
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            if (Reader.this.IT_E7_istargetA) {
                                Reader.this.toDlog("set to 107,S2 to A 3 fre");
                                vala[0] = 107;
                                er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                                if (er != READER_ERR.MT_OK_ERR) {
                                    Reader.this.errhandle_IT(er);
                                }
                                Reader.this.SetFilterSessioninTargetA(Reader.this.pants, Reader.this.IT_E7_centrefre, Reader.this.IT_E7_pow);
                                Reader.this.SetFilterSessioninTargetA(Reader.this.pants, Reader.this.IT_E7_lowfre, Reader.this.IT_E7_pow);
                                Reader.this.SetFilterSessioninTargetA(Reader.this.pants, Reader.this.IT_E7_highfre, Reader.this.IT_E7_pow);
                            }
                            Reader.this.toDlog("gen2ode " + String.valueOf(Reader.this.IT_E7_rfm));
                            vala[0] = Reader.this.IT_E7_rfm;
                            er = Reader.this.ParamSet(Mtr_Param.MTR_PARAM_POTL_GEN2_TAGENCODING, vala);
                            if (er != READER_ERR.MT_OK_ERR) {
                                Reader.this.errhandle_IT(er);
                            }
                            Reader.this.IT_E7_step = 0;
                        }
                        Reader.this.toDlog(" to start");
                        if (Reader.this.isIT_E7_run) {
                            er = Reader.this.IT_E7_step == 0 ? Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption) : Reader.this.AsyncStartReading(Reader.this.pants, Reader.this.pants.length, Reader.this.poption | 0x40);
                        }
                        if (er != READER_ERR.MT_OK_ERR) {
                            Reader.this.errhandle_IT(er);
                        }
                        Reader.this.IT_E7_start = System.currentTimeMillis();
                        Reader.this.vstaticstarttick = System.currentTimeMillis() - Reader.this.IT_E7_start;
                    }
                    Reader.this.totalcountlast = Reader.this.totalcount;
                    Reader.this.totalcount = 0;
                }
                if (Reader.this.isIT_E7_run) continue;
                break;
            }
        }
    }

    public class EmbededSecureRead_ST {
        public int tagtype;
        public int pwdtype;
        public int ApIndexStartBitsInEpc;
        public int ApIndexBitsNumInEpc;
        public int bank;
        public int address;
        public int blkcnt;
        public int accesspwd;
    }

    public class NXPEASAlarmResult {
        public byte[] EASdata = new byte[8];
    }

    public class IMPINJM4QtResult {
        public int MemType;
        public int RangeType;
    }

    public static enum BackReadGpiTriState {
        BackReadGpi_WaitStart(0),
        BackReadGpi_WaitStop(1),
        BackReadGpi_WaitTimeout(2);

        private int value = 0;

        private BackReadGpiTriState(int value) {
            this.value = value;
        }

        public static BackReadGpiTriState valueOf(int value) {
            switch (value) {
                case 0: {
                    return BackReadGpi_WaitStart;
                }
                case 1: {
                    return BackReadGpi_WaitStop;
                }
                case 2: {
                    return BackReadGpi_WaitTimeout;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Lock_Type {
        KILL_PASSWORD_UNLOCK(0),
        KILL_PASSWORD_LOCK(512),
        KILL_PASSWORD_PERM_LOCK(768),
        ACCESS_PASSWD_UNLOCK(0),
        ACCESS_PASSWD_LOCK(128),
        ACCESS_PASSWD_PERM_LOCK(192),
        BANK1_UNLOCK(0),
        BANK1_LOCK(32),
        BANK1_PERM_LOCK(48),
        BANK2_UNLOCK(0),
        BANK2_LOCK(8),
        BANK2_PERM_LOCK(12),
        BANK3_UNLOCK(0),
        BANK3_LOCK(2),
        BANK3_PERM_LOCK(3);

        int p_v;

        private Lock_Type(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Obj {
        LOCK_OBJECT_KILL_PASSWORD(1),
        LOCK_OBJECT_ACCESS_PASSWD(2),
        LOCK_OBJECT_BANK1(4),
        LOCK_OBJECT_BANK2(8),
        LOCK_OBJECT_BANK3(16);

        int p_v;

        private Lock_Obj(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }
}

