/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import java.util.ArrayList;

public final class FragmentContainerView
extends FrameLayout {
    private ArrayList<View> mDisappearingFragmentChildren;
    private ArrayList<View> mTransitioningFragmentViews;
    private boolean mDrawDisappearingViewsFirst = true;

    public FragmentContainerView(@NonNull Context context) {
        super(context);
    }

    public FragmentContainerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FragmentContainerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            throw new UnsupportedOperationException("FragmentContainerView must be within a FragmentActivity to be instantiated from XML.");
        }
    }

    FragmentContainerView(@NonNull Context context, @NonNull AttributeSet attrs, @NonNull FragmentManager fm) {
        super(context, attrs);
        String name = attrs.getClassAttribute();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FragmentContainerView);
        if (name == null) {
            name = a.getString(R.styleable.FragmentContainerView_android_name);
        }
        String tag = a.getString(R.styleable.FragmentContainerView_android_tag);
        a.recycle();
        int id2 = this.getId();
        Fragment existingFragment = fm.findFragmentById(id2);
        if (name != null && existingFragment == null) {
            if (id2 <= 0) {
                String tagMessage = tag != null ? " with tag " + tag : "";
                throw new IllegalStateException("FragmentContainerView must have an android:id to add Fragment " + name + tagMessage);
            }
            Fragment containerFragment = fm.getFragmentFactory().instantiate(context.getClassLoader(), name);
            containerFragment.onInflate(context, attrs, null);
            fm.beginTransaction().setReorderingAllowed(true).add((ViewGroup)this, containerFragment, tag).commitNowAllowingStateLoss();
        }
    }

    public void setLayoutTransition(@Nullable LayoutTransition transition) {
        if (Build.VERSION.SDK_INT < 18) {
            super.setLayoutTransition(transition);
            return;
        }
        throw new UnsupportedOperationException("FragmentContainerView does not support Layout Transitions or animateLayoutChanges=\"true\".");
    }

    @NonNull
    @RequiresApi(value=20)
    public WindowInsets onApplyWindowInsets(@NonNull WindowInsets insets) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.dispatchApplyWindowInsets(new WindowInsets(insets));
        }
        return insets;
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        if (this.mDrawDisappearingViewsFirst && this.mDisappearingFragmentChildren != null) {
            for (int i = 0; i < this.mDisappearingFragmentChildren.size(); ++i) {
                super.drawChild(canvas, this.mDisappearingFragmentChildren.get(i), this.getDrawingTime());
            }
        }
        super.dispatchDraw(canvas);
    }

    protected boolean drawChild(@NonNull Canvas canvas, @NonNull View child, long drawingTime) {
        if (this.mDrawDisappearingViewsFirst && this.mDisappearingFragmentChildren != null && this.mDisappearingFragmentChildren.size() > 0 && this.mDisappearingFragmentChildren.contains(child)) {
            return false;
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public void startViewTransition(@NonNull View view) {
        if (view.getParent() == this) {
            if (this.mTransitioningFragmentViews == null) {
                this.mTransitioningFragmentViews = new ArrayList();
            }
            this.mTransitioningFragmentViews.add(view);
        }
        super.startViewTransition(view);
    }

    public void endViewTransition(@NonNull View view) {
        if (this.mTransitioningFragmentViews != null) {
            this.mTransitioningFragmentViews.remove(view);
            if (this.mDisappearingFragmentChildren != null && this.mDisappearingFragmentChildren.remove(view)) {
                this.mDrawDisappearingViewsFirst = true;
            }
        }
        super.endViewTransition(view);
    }

    void setDrawDisappearingViewsLast(boolean drawDisappearingViewsFirst) {
        this.mDrawDisappearingViewsFirst = drawDisappearingViewsFirst;
    }

    public void addView(@NonNull View child, int index, @Nullable ViewGroup.LayoutParams params) {
        if (FragmentManager.getViewFragment(child) == null) {
            throw new IllegalStateException("Views added to a FragmentContainerView must be associated with a Fragment. View " + child + " is not associated with a Fragment.");
        }
        super.addView(child, index, params);
    }

    protected boolean addViewInLayout(@NonNull View child, int index, @Nullable ViewGroup.LayoutParams params, boolean preventRequestLayout) {
        if (FragmentManager.getViewFragment(child) == null) {
            throw new IllegalStateException("Views added to a FragmentContainerView must be associated with a Fragment. View " + child + " is not associated with a Fragment.");
        }
        return super.addViewInLayout(child, index, params, preventRequestLayout);
    }

    public void removeViewAt(int index) {
        View view = this.getChildAt(index);
        this.addDisappearingFragmentView(view);
        super.removeViewAt(index);
    }

    public void removeViewInLayout(@NonNull View view) {
        this.addDisappearingFragmentView(view);
        super.removeViewInLayout(view);
    }

    public void removeView(@NonNull View view) {
        this.addDisappearingFragmentView(view);
        super.removeView(view);
    }

    public void removeViews(int start, int count) {
        for (int i = start; i < start + count; ++i) {
            View view = this.getChildAt(i);
            this.addDisappearingFragmentView(view);
        }
        super.removeViews(start, count);
    }

    public void removeViewsInLayout(int start, int count) {
        for (int i = start; i < start + count; ++i) {
            View view = this.getChildAt(i);
            this.addDisappearingFragmentView(view);
        }
        super.removeViewsInLayout(start, count);
    }

    public void removeAllViewsInLayout() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            this.addDisappearingFragmentView(view);
        }
        super.removeAllViewsInLayout();
    }

    protected void removeDetachedView(@NonNull View child, boolean animate) {
        if (animate) {
            this.addDisappearingFragmentView(child);
        }
        super.removeDetachedView(child, animate);
    }

    private void addDisappearingFragmentView(@NonNull View v) {
        if (v.getAnimation() != null || this.mTransitioningFragmentViews != null && this.mTransitioningFragmentViews.contains(v)) {
            if (this.mDisappearingFragmentChildren == null) {
                this.mDisappearingFragmentChildren = new ArrayList();
            }
            this.mDisappearingFragmentChildren.add(v);
        }
    }
}

