/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.browser.browseractions.BrowserActionsFallbackMenuUi;
import androidx.browser.browseractions.BrowserServiceFileProvider;
import androidx.core.content.ContextCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public class BrowserActionsIntent {
    private static final String TAG = "BrowserActions";
    private static final String TEST_URL = "https://www.example.com";
    public static final String EXTRA_APP_ID = "androidx.browser.browseractions.APP_ID";
    public static final String ACTION_BROWSER_ACTIONS_OPEN = "androidx.browser.browseractions.browser_action_open";
    public static final String KEY_ICON_ID = "androidx.browser.browseractions.ICON_ID";
    private static final String KEY_ICON_URI = "androidx.browser.browseractions.ICON_URI";
    public static final String KEY_TITLE = "androidx.browser.browseractions.TITLE";
    public static final String KEY_ACTION = "androidx.browser.browseractions.ACTION";
    public static final String EXTRA_TYPE = "androidx.browser.browseractions.extra.TYPE";
    public static final String EXTRA_MENU_ITEMS = "androidx.browser.browseractions.extra.MENU_ITEMS";
    public static final String EXTRA_SELECTED_ACTION_PENDING_INTENT = "androidx.browser.browseractions.extra.SELECTED_ACTION_PENDING_INTENT";
    @SuppressLint(value={"MinMaxConstant"})
    public static final int MAX_CUSTOM_ITEMS = 5;
    public static final int URL_TYPE_NONE = 0;
    public static final int URL_TYPE_IMAGE = 1;
    public static final int URL_TYPE_VIDEO = 2;
    public static final int URL_TYPE_AUDIO = 3;
    public static final int URL_TYPE_FILE = 4;
    public static final int URL_TYPE_PLUGIN = 5;
    public static final int ITEM_INVALID_ITEM = -1;
    public static final int ITEM_OPEN_IN_NEW_TAB = 0;
    public static final int ITEM_OPEN_IN_INCOGNITO = 1;
    public static final int ITEM_DOWNLOAD = 2;
    public static final int ITEM_COPY = 3;
    public static final int ITEM_SHARE = 4;
    @NonNull
    private final Intent mIntent;
    @Nullable
    private static BrowserActionsFallDialogListener sDialogListenter;

    @NonNull
    public Intent getIntent() {
        return this.mIntent;
    }

    BrowserActionsIntent(@NonNull Intent intent) {
        this.mIntent = intent;
    }

    public static void openBrowserAction(@NonNull Context context, @NonNull Uri uri) {
        BrowserActionsIntent intent = new Builder(context, uri).build();
        BrowserActionsIntent.launchIntent(context, intent.getIntent());
    }

    public static void openBrowserAction(@NonNull Context context, @NonNull Uri uri, int type, @NonNull ArrayList<BrowserActionItem> items, @NonNull PendingIntent pendingIntent) {
        BrowserActionsIntent intent = new Builder(context, uri).setUrlType(type).setCustomItems(items).setOnItemSelectedAction(pendingIntent).build();
        BrowserActionsIntent.launchIntent(context, intent.getIntent());
    }

    public static void launchIntent(@NonNull Context context, @NonNull Intent intent) {
        List<ResolveInfo> handlers = BrowserActionsIntent.getBrowserActionsIntentHandlers(context);
        BrowserActionsIntent.launchIntent(context, intent, handlers);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @VisibleForTesting
    static void launchIntent(Context context, Intent intent, List<ResolveInfo> handlers) {
        if (handlers == null || handlers.size() == 0) {
            BrowserActionsIntent.openFallbackBrowserActionsMenu(context, intent);
            return;
        }
        if (handlers.size() == 1) {
            intent.setPackage(handlers.get((int)0).activityInfo.packageName);
        } else {
            Intent viewIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)TEST_URL));
            PackageManager pm = context.getPackageManager();
            ResolveInfo defaultHandler = pm.resolveActivity(viewIntent, 65536);
            if (defaultHandler != null) {
                String defaultPackageName = defaultHandler.activityInfo.packageName;
                for (int i = 0; i < handlers.size(); ++i) {
                    if (!defaultPackageName.equals(handlers.get((int)i).activityInfo.packageName)) continue;
                    intent.setPackage(defaultPackageName);
                    break;
                }
            }
        }
        ContextCompat.startActivity((Context)context, (Intent)intent, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static List<ResolveInfo> getBrowserActionsIntentHandlers(@NonNull Context context) {
        Intent intent = new Intent(ACTION_BROWSER_ACTIONS_OPEN, Uri.parse((String)TEST_URL));
        PackageManager pm = context.getPackageManager();
        return pm.queryIntentActivities(intent, 131072);
    }

    private static void openFallbackBrowserActionsMenu(Context context, Intent intent) {
        Uri uri = intent.getData();
        ArrayList bundles = intent.getParcelableArrayListExtra(EXTRA_MENU_ITEMS);
        List<BrowserActionItem> items = bundles != null ? BrowserActionsIntent.parseBrowserActionItems(bundles) : null;
        BrowserActionsIntent.openFallbackBrowserActionsMenu(context, uri, items);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @VisibleForTesting
    static void setDialogShownListenter(BrowserActionsFallDialogListener dialogListener) {
        sDialogListenter = dialogListener;
    }

    private static void openFallbackBrowserActionsMenu(Context context, Uri uri, List<BrowserActionItem> menuItems) {
        BrowserActionsFallbackMenuUi menuUi = new BrowserActionsFallbackMenuUi(context, uri, menuItems);
        menuUi.displayMenu();
        if (sDialogListenter != null) {
            sDialogListenter.onDialogShown();
        }
    }

    @NonNull
    public static List<BrowserActionItem> parseBrowserActionItems(@NonNull ArrayList<Bundle> bundles) {
        ArrayList<BrowserActionItem> mActions = new ArrayList<BrowserActionItem>();
        for (int i = 0; i < bundles.size(); ++i) {
            Bundle bundle = bundles.get(i);
            String title = bundle.getString(KEY_TITLE);
            PendingIntent action = (PendingIntent)bundle.getParcelable(KEY_ACTION);
            int iconId = bundle.getInt(KEY_ICON_ID);
            Uri iconUri = (Uri)bundle.getParcelable(KEY_ICON_URI);
            if (TextUtils.isEmpty((CharSequence)title) || action == null) {
                throw new IllegalArgumentException("Custom item should contain a non-empty title and non-null intent.");
            }
            BrowserActionItem item = iconId != 0 ? new BrowserActionItem(title, action, iconId) : new BrowserActionItem(title, action, iconUri);
            mActions.add(item);
        }
        return mActions;
    }

    @Nullable
    public static String getUntrustedCreatorPackageName(@NonNull Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_APP_ID);
        if (pendingIntent != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                return pendingIntent.getCreatorPackage();
            }
            return pendingIntent.getTargetPackage();
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static String getCreatorPackageName(@NonNull Intent intent) {
        return BrowserActionsIntent.getUntrustedCreatorPackageName(intent);
    }

    public static final class Builder {
        private final Intent mIntent = new Intent("androidx.browser.browseractions.browser_action_open");
        private Context mContext;
        private Uri mUri;
        private int mType = 0;
        private ArrayList<Bundle> mMenuItems = new ArrayList();
        @Nullable
        private PendingIntent mOnItemSelectedPendingIntent = null;
        private List<Uri> mImageUris = new ArrayList<Uri>();

        public Builder(@NonNull Context context, @NonNull Uri uri) {
            this.mContext = context;
            this.mUri = uri;
        }

        @NonNull
        public Builder setUrlType(int type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setCustomItems(@NonNull ArrayList<BrowserActionItem> items) {
            if (items.size() > 5) {
                throw new IllegalStateException("Exceeded maximum toolbar item count of 5");
            }
            for (int i = 0; i < items.size(); ++i) {
                if (TextUtils.isEmpty((CharSequence)items.get(i).getTitle()) || items.get(i).getAction() == null) {
                    throw new IllegalArgumentException("Custom item should contain a non-empty title and non-null intent.");
                }
                this.mMenuItems.add(this.getBundleFromItem(items.get(i)));
                if (items.get(i).getIconUri() == null) continue;
                this.mImageUris.add(items.get(i).getIconUri());
            }
            return this;
        }

        @NonNull
        public Builder setCustomItems(BrowserActionItem ... items) {
            return this.setCustomItems(new ArrayList<BrowserActionItem>(Arrays.asList(items)));
        }

        @NonNull
        public Builder setOnItemSelectedAction(@NonNull PendingIntent onItemSelectedPendingIntent) {
            this.mOnItemSelectedPendingIntent = onItemSelectedPendingIntent;
            return this;
        }

        @NonNull
        private Bundle getBundleFromItem(@NonNull BrowserActionItem item) {
            Bundle bundle = new Bundle();
            bundle.putString(BrowserActionsIntent.KEY_TITLE, item.getTitle());
            bundle.putParcelable(BrowserActionsIntent.KEY_ACTION, (Parcelable)item.getAction());
            if (item.getIconId() != 0) {
                bundle.putInt(BrowserActionsIntent.KEY_ICON_ID, item.getIconId());
            }
            if (item.getIconUri() != null) {
                bundle.putParcelable(BrowserActionsIntent.KEY_ICON_URI, (Parcelable)item.getIconUri());
            }
            return bundle;
        }

        @NonNull
        public BrowserActionsIntent build() {
            this.mIntent.setData(this.mUri);
            this.mIntent.putExtra(BrowserActionsIntent.EXTRA_TYPE, this.mType);
            this.mIntent.putParcelableArrayListExtra(BrowserActionsIntent.EXTRA_MENU_ITEMS, this.mMenuItems);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent(), (int)0);
            this.mIntent.putExtra(BrowserActionsIntent.EXTRA_APP_ID, (Parcelable)pendingIntent);
            if (this.mOnItemSelectedPendingIntent != null) {
                this.mIntent.putExtra(BrowserActionsIntent.EXTRA_SELECTED_ACTION_PENDING_INTENT, (Parcelable)this.mOnItemSelectedPendingIntent);
            }
            BrowserServiceFileProvider.grantReadPermission(this.mIntent, this.mImageUris, this.mContext);
            return new BrowserActionsIntent(this.mIntent);
        }
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    static interface BrowserActionsFallDialogListener {
        public void onDialogShown();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface BrowserActionsItemId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface BrowserActionsUrlType {
    }
}

