/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.a;
import com.rscja.deviceapi.entity.AnimalEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class RFIDWithLF {
    protected a config = com.rscja.deviceapi.a.g();
    private static RFIDWithLF a = null;

    private RFIDWithLF() throws ConfigurationException {
    }

    public static synchronized RFIDWithLF getInstance() throws ConfigurationException {
        if (a == null) {
            a = new RFIDWithLF();
        }
        return a;
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.a();
    }

    public synchronized boolean init() {
        int n = this.getDeviceAPI().EM125k_init(this.config.i(), this.config.j(), this.config.k());
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("init() err:" + n));
        return false;
    }

    public synchronized boolean free() {
        int n = this.getDeviceAPI().EM125k_free(this.config.i());
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("free() err:" + n));
        return false;
    }

    public synchronized String getHardwareVersion() {
        Object object = this.getDeviceAPI().HardwareVersion_125k();
        if (object[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("getHardwareVersion() err:" + Integer.valueOf(object[0])));
            return null;
        }
        String string = new String((char[])object).trim();
        object = string;
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readDataWithIDCard(int iMode) {
        void var1_1;
        char[] cArray = this.a((int)var1_1);
        if (cArray == null) {
            return null;
        }
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    private char[] a(int n) {
        if (n > 2 || n < 0) {
            return null;
        }
        char[] cArray = this.getDeviceAPI().EM125k_read(n);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("read() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized AnimalEntity readAnimalTags(int iMode) {
        void var1_1;
        char[] cArray = this.a((int)var1_1);
        if (cArray == null) {
            return null;
        }
        AnimalEntity animalEntity = new AnimalEntity();
        char[] cArray2 = new char[8];
        int n = 0;
        while (n < 8) {
            cArray2[n] = cArray[7 - n];
            ++n;
        }
        char[] cArray3 = new char[2];
        char[] cArray4 = cArray3;
        cArray3[0] = cArray[9];
        cArray4[1] = cArray[8];
        char[] cArray5 = new char[2];
        char[] cArray6 = cArray5;
        cArray5[0] = cArray[11];
        cArray6[1] = cArray[10];
        animalEntity.setNationalID(StringUtility.charArrayTolong(cArray2));
        animalEntity.setCountryID(StringUtility.charArrayTolong(cArray4));
        animalEntity.setReserved(StringUtility.charArrayTolong(cArray6));
        return animalEntity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readDataWithHitagS(int nPage) {
        void var1_1;
        char[] cArray = this.getDeviceAPI().EM125k_ReadHitag((int)var1_1);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("readWithHitagS() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean writeDataWithHitagS(int nPage, String hexData) {
        int n;
        char[] cArray;
        if (StringUtility.isEmpty(hexData) || !StringUtility.isHexNumberRex(hexData)) {
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        n = this.getDeviceAPI().EM125k_WriteHitagPage(n, cArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("writeDataWithHitagS() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readDataWith4305Card(int nPage) {
        void var1_1;
        char[] cArray = this.getDeviceAPI().EM125k_Read4305((int)var1_1);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("readDataWith4305Card() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean writeDataWith4305Card(int nPage, String hexData) {
        int n;
        char[] cArray;
        if (StringUtility.isEmpty(hexData) || !StringUtility.isHexNumberRex(hexData)) {
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        n = this.getDeviceAPI().EM125k_Write4305(n, cArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("writeDataWith4305Card() err:" + n));
        return false;
    }

    public synchronized String getUIDWithHitagS() {
        char[] cArray = this.getDeviceAPI().EM125k_UID_REQ();
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("getUIDWithHitagS() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized String getUIDWith4450Card() {
        char[] cArray = this.getDeviceAPI().EM125K_GetEm4450UID();
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("getUIDWith4450Card() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }
}

