/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.b;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.RFIDNotFoundException;
import com.rscja.deviceapi.exception.RFIDReadFailureException;
import com.rscja.deviceapi.exception.RFIDVerificationException;
import com.rscja.utility.StringUtility;

public class RFIDWithISO14443A
extends b {
    private static RFIDWithISO14443A a = null;

    protected RFIDWithISO14443A() throws ConfigurationException {
    }

    public static synchronized RFIDWithISO14443A getInstance() throws ConfigurationException {
        if (a == null) {
            a = new RFIDWithISO14443A();
        }
        return a;
    }

    public synchronized SimpleRFIDEntity request() {
        byte[] byArray = this.getDeviceAPI().ISO14443A_request(this.config.i(), 1);
        if (byArray == null || byArray[0] != 0 || byArray[4] == 0) {
            Log.e((String)"RFIDWithISO1443A", (String)("request() err:" + byArray[0]));
            return null;
        }
        byte[] byArray2 = new byte[byArray[4]];
        TagType tagType = TagType.Unknow;
        TagType tagType2 = TagType.Unknow;
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = byArray[n + 5];
            ++n;
        }
        byte by = byArray[5 + byArray2.length];
        n = by >> 2 & 1;
        int n2 = by >> 3 & 1;
        int n3 = by >> 4 & 1;
        int n4 = by >> 5 & 1;
        if (byArray[2] == 68 && byArray[3] == 0) {
            n = byArray[byArray[1] + 1];
            tagType2 = n == 0 ? TagType.Ultra_light : TagType.Mifare_plus;
            tagType = by == 0 ? TagType.Ultra_light : TagType.Mifare_plus;
        } else if (byArray[2] == 4 && byArray[3] == 0) {
            if (n2 == 1 || by == 0) {
                tagType = TagType.S50;
            }
        } else if (byArray[2] == 2 && byArray[3] == 0) {
            if (n2 == 1 && n3 == 1 || by == 0) {
                tagType = TagType.S70;
            }
        } else if (byArray[2] == 68 && byArray[3] == 3) {
            if (n4 == 1 || n4 == 1 && n == 1 || by == 0) {
                tagType = TagType.Mifare_DESFire;
            }
        } else {
            tagType = byArray[2] == 8 && byArray[3] == 0 ? TagType.Mifare_Pro : (byArray[2] == 4 && byArray[3] == 3 ? TagType.Mifare_ProX : TagType.Unknow);
        }
        String string = tagType2 != tagType && tagType2 != TagType.Unknow ? String.valueOf(tagType2.toString()) + " or " + tagType.toString() : tagType.toString();
        return new SimpleRFIDEntity(StringUtility.bytes2HexString(byArray2, byArray2.length), string);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized SimpleRFIDEntity read(String key, KeyType keyType, int sector, int block) throws RFIDVerificationException, RFIDReadFailureException {
        void var2_2;
        Object object;
        SimpleRFIDEntity simpleRFIDEntity = this.request();
        if (simpleRFIDEntity == null) {
            return null;
        }
        if (this.a(sector, (String)object, (KeyType)var2_2)) {
            Object object2;
            int n;
            void v0 = n;
            n = block;
            int n2 = v0;
            object = this;
            if (n2 < 0 || n2 > 40) {
                object2 = null;
            } else {
                n2 = n2 > 31 && n2 < 40 ? 128 + (n2 - 32 << 4) : (n2 <<= 2);
                char[] cArray = ((b)object).getDeviceAPI().ISO14443A_read((int)(n2 + n));
                object = cArray;
                if (cArray[0] != '\u0000') {
                    Log.e((String)"RFIDWithISO1443A", (String)("M1_ReadData() err:" + Integer.valueOf((int)object[0])));
                    throw new RFIDReadFailureException();
                }
                char[] cArray2 = new char[object[1]];
                n = 0;
                while (n < object[1]) {
                    cArray2[n] = (char)object[n + 2];
                    ++n;
                }
                object = cArray2;
                object2 = object;
            }
            if (object2 != null) {
                simpleRFIDEntity.setData(StringUtility.chars2HexString((char[])object, ((RFIDWithISO14443A)object).length));
            }
        } else {
            throw new RFIDVerificationException();
        }
        return simpleRFIDEntity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized SimpleRFIDEntity read(int block) throws RFIDReadFailureException {
        void var1_1;
        SimpleRFIDEntity simpleRFIDEntity = this.request();
        if (simpleRFIDEntity == null) {
            return null;
        }
        void var3_4 = var1_1;
        Object object = this;
        char[] cArray = ((b)object).getDeviceAPI().ISO14443A_ul_read((int)var3_4);
        object = cArray;
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithISO1443A", (String)("M1_ReadData() err:" + (char)object[0]));
            throw new RFIDReadFailureException();
        }
        char[] cArray2 = new char[object[1]];
        int n = 0;
        while (n < object[1]) {
            cArray2[n] = (char)object[n + 2];
            ++n;
        }
        object = cArray2;
        if (cArray2 != null) {
            simpleRFIDEntity.setData(StringUtility.chars2HexString((char[])object, ((Object)object).length));
        }
        return simpleRFIDEntity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean write(String key, KeyType keyType, int sector, int block, String hexData) throws RFIDVerificationException, RFIDNotFoundException {
        void var2_2;
        RFIDWithISO14443A rFIDWithISO14443A;
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        this.request();
        if (this.a(sector, (String)((Object)rFIDWithISO14443A), (KeyType)var2_2)) {
            int n;
            void v0 = n;
            Object object = hexData;
            n = block;
            int n2 = v0;
            rFIDWithISO14443A = this;
            if (n2 < 0 || n2 > 40) {
                return false;
            }
            char[] cArray = StringUtility.hexString2Chars((String)object);
            object = cArray;
            int n3 = cArray.length > 16 ? 16 : ((Object)object).length;
            char[] cArray2 = new char[16];
            int n4 = 0;
            while (n4 < 16) {
                cArray2[n4] = '\u0000';
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                cArray2[n4] = (char)object[n4];
                ++n4;
            }
            n2 = n2 > 31 && n2 < 40 ? 128 + (n2 - 32 << 4) : (n2 <<= 2);
            n4 = rFIDWithISO14443A.getDeviceAPI().ISO14443A_write((int)(n2 + n), cArray2, cArray2.length);
            if (n4 == 0) {
                return true;
            }
            Log.e((String)"RFIDWithISO1443A", (String)("M1_WriteData() err:" + n4));
            return false;
        }
        throw new RFIDVerificationException();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean write(int block, String hexData) throws RFIDNotFoundException {
        void var1_1;
        void var2_3;
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        Object object = this.request();
        if (object == null) {
            throw new RFIDNotFoundException();
        }
        object = var2_3;
        void var2_4 = var1_1;
        RFIDWithISO14443A rFIDWithISO14443A = this;
        char[] cArray = StringUtility.hexString2Chars((String)object);
        object = cArray;
        int n = cArray.length > 4 ? 4 : ((Object)object).length;
        char[] cArray2 = new char[4];
        int n2 = 0;
        while (n2 < 4) {
            cArray2[n2] = '\u0000';
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            cArray2[n2] = (char)object[n2];
            ++n2;
        }
        n2 = rFIDWithISO14443A.getDeviceAPI().ISO14443A_ul_write((int)var2_4, cArray2, cArray2.length);
        if (n2 == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("M1_WriteData() err:" + n2));
        return false;
    }

    private synchronized boolean a(int n, String string, KeyType keyType) {
        n = n > 31 && n < 40 ? 128 + (n - 32 << 4) : (n <<= 2);
        n = this.getDeviceAPI().ISO14443A_authentication(keyType.ordinal(), n, StringUtility.hexString2Chars(string), 6);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("VerifySector() err:" + n));
        return false;
    }

    public static /* bridge */ /* synthetic */ b getInstance() throws ConfigurationException {
        return RFIDWithISO14443A.getInstance();
    }

    public static enum KeyType {
        TypeA,
        TypeB,
        TypeDes;

    }

    public static enum TagType {
        Ultra_light,
        S50,
        S70,
        Mifare_DESFire,
        Mifare_Pro,
        Mifare_ProX,
        Mifare_plus,
        Mifare_plus_4k,
        Mifare_plus_2k,
        Mifare_Mini,
        Unknow;

    }
}

