/*
 * Decompiled with CFR 0.152.
 */
package com.android.hdhe.uhf.reader;

public class Tools {
    public static String bytesToHexString(byte[] bytes) {
        StringBuilder ret = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex.toUpperCase());
        }
        return ret.toString();
    }

    private static byte uniteBytes(byte src0, byte src1) {
        byte b0 = Byte.decode("0x" + new String(new byte[]{src0}));
        b0 = (byte)(b0 << 4);
        byte b1 = Byte.decode("0x" + new String(new byte[]{src1}));
        return (byte)(b0 ^ b1);
    }

    public static byte[] hexStringToBytes(String src) {
        int len = src.length() / 2;
        byte[] ret = new byte[len];
        byte[] tmp = src.getBytes();
        for (int i = 0; i < len; ++i) {
            ret[i] = Tools.uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
        }
        return ret;
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[0] & 0xFF;
        addr |= bytes[1] << 8 & 0xFF00;
        addr |= bytes[2] << 16 & 0xFF0000;
        return addr |= bytes[3] << 25 & 0xFF000000;
    }

    public static byte[] intToByte(int i) {
        return new byte[]{(byte)((0xFF0000 & i) >> 16), (byte)((0xFF00 & i) >> 8), (byte)(0xFF & i)};
    }
}

