/*
 * Decompiled with CFR 0.152.
 */
package com.android.hdhe.uhf.reader;

import cn.pda.serialport.Tools;
import com.android.hdhe.uhf.reader.LogUtils;
import com.android.hdhe.uhf.readerInterface.CommendManager;
import com.android.hdhe.uhf.readerInterface.TagModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SendCommendManager
implements CommendManager {
    private InputStream in;
    private OutputStream out;

    public SendCommendManager() {
    }

    public SendCommendManager(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public boolean setBaudrate() {
        byte[] cmd;
        boolean flag = false;
        cmd = new byte[]{-96, 4, -1, 113, 4, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null && this.isRecvData(recv) == 0 && Integer.valueOf(recv[3]) == 113 && Integer.valueOf(recv[4]) == 16) {
            flag = true;
        }
        return flag;
    }

    @Override
    public byte[] getFirmware() {
        byte[] cmd;
        cmd = new byte[]{-96, 3, 1, 114, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            System.out.println(new String(recv));
        }
        return recv;
    }

    public byte[] getFrequency() {
        byte[] cmd = new byte[]{-96, 3, 1, 121, -29};
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            System.out.println(Tools.bytesToHexString((byte[])recv));
        }
        return null;
    }

    @Override
    public int setFrequency(int startFrequency, int freqSpace, int freqQuality) {
        byte[] cmd;
        cmd = new byte[]{-96, 9, 1, 120, 4, (byte)(freqSpace / 10), (byte)freqQuality, (byte)((0xFF0000 & startFrequency) >> 16), (byte)((0xFF00 & startFrequency) >> 8), (byte)(0xFF & startFrequency), this.checkSum(cmd, cmd.length - 1)};
        System.out.println(Tools.bytesToHexString((byte[])cmd));
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            System.out.println(Tools.bytesToHexString((byte[])recv));
        }
        return 0;
    }

    public void setWorkAntenna() {
        byte[] cmd;
        cmd = new byte[]{-96, 4, 1, 116, 0, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
    }

    @Override
    public boolean setOutputPower(int value) {
        byte[] cmd;
        cmd = new byte[]{-96, 4, 1, 118, (byte)value, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        this.read();
        return true;
    }

    @Override
    public List<TagModel> inventoryRealTime() {
        byte[] cmd;
        ArrayList<TagModel> epcList = new ArrayList<TagModel>();
        cmd = new byte[]{-96, 4, 1, -119, 1, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        LogUtils.i("", "send inventory real time***");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            byte[] data;
            int start = 0;
            for (int length = recv.length; length > 0 && recv[start] == -96; length -= data.length) {
                int dataLen = recv[start + 1] & 0xFF;
                data = new byte[dataLen + 2];
                if (data.length > 12 && data.length <= length) {
                    System.arraycopy(recv, start, data, 0, data.length);
                    byte[] epc = new byte[data.length - 9];
                    byte rssi = -1;
                    System.arraycopy(data, 7, epc, 0, data.length - 9);
                    System.arraycopy(data, 2, epc, 0, 1);
                    epcList.add(new TagModel(Tools.bytesToHexString((byte[])epc), rssi));
                }
                start += data.length;
            }
        } else {
            LogUtils.i("realTimeInventory", "\u05b8\ufffd\uecec\u02b1");
        }
        return epcList;
    }

    @Override
    public void selectEPC(byte[] epc) {
        int epcLen = epc.length;
        byte[] cmd = new byte[7 + epcLen];
        cmd[0] = -96;
        cmd[1] = 17;
        cmd[2] = 1;
        cmd[3] = -123;
        cmd[4] = 0;
        cmd[5] = 12;
        System.arraycopy(epc, 0, cmd, 6, epcLen);
        cmd[6 + epcLen] = this.checkSum(cmd, cmd.length - 1);
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv == null) {
            LogUtils.i("selectEPC", "\u05b8\ufffd\uecec\u02b1");
        }
    }

    public byte[] readFrom6C(int memBank, int startAddr, int length) {
        byte[] cmd;
        byte[] data = null;
        cmd = new byte[]{-96, 6, 1, -127, (byte)memBank, (byte)startAddr, (byte)length, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int len = recv.length;
            if (recv[0] != -96) {
                return data;
            }
            byte check = this.checkSum(recv, len - 1);
            if (check != recv[len - 1]) {
                LogUtils.i("read data ", "checksum error");
                return data;
            }
            if (len == 6) {
                LogUtils.i("read data ", "read fail!!");
                return data;
            }
            int dataLen = recv[6] & 0xFF;
            byte readLen = recv[len - 4];
            int epcLen = dataLen - readLen - 4;
            if (dataLen <= readLen || dataLen < epcLen || epcLen < 0) {
                return data;
            }
            data = new byte[readLen + epcLen];
            System.arraycopy(recv, 9, data, 0, epcLen);
            System.arraycopy(recv, 11 + epcLen, data, epcLen, readLen);
        } else {
            LogUtils.i("read data ", "\u05b8\ufffd\uecec\u02b1");
        }
        return data;
    }

    @Override
    public byte[] readFrom6C(int memBank, int startAddr, int length, byte[] password) {
        byte[] data = null;
        byte[] cmd = new byte[12];
        cmd[0] = -96;
        cmd[1] = 10;
        cmd[2] = 1;
        cmd[3] = -127;
        cmd[4] = (byte)memBank;
        cmd[5] = (byte)startAddr;
        cmd[6] = (byte)length;
        if (password.length != 4) {
            LogUtils.e("readFrom6C", "password error");
            return null;
        }
        cmd[7] = password[0];
        cmd[8] = password[1];
        cmd[9] = password[2];
        cmd[10] = password[3];
        cmd[11] = this.checkSum(cmd, cmd.length - 1);
        this.sendToReader(cmd);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int len = recv.length;
            if (recv[0] != -96) {
                return data;
            }
            byte check = this.checkSum(recv, len - 1);
            if (check != recv[len - 1]) {
                LogUtils.i("read data ", "checksum error");
                return data;
            }
            if (len == 6) {
                LogUtils.i("read data ", "read fail!!");
                return data;
            }
            int dataLen = recv[6] & 0xFF;
            byte readLen = recv[len - 4];
            int epcLen = dataLen - readLen - 4;
            if (dataLen <= readLen || dataLen < epcLen || epcLen < 0) {
                return data;
            }
            if (recv.length < epcLen + 9) {
                return data;
            }
            data = new byte[readLen + epcLen];
            System.arraycopy(recv, 9, data, 0, epcLen);
            System.arraycopy(recv, 11 + epcLen, data, epcLen, readLen);
        } else {
            LogUtils.i("read data ", "\u05b8\ufffd\uecec\u02b1");
        }
        return data;
    }

    @Override
    public boolean writeTo6C(byte[] password, int memBank, int wordAdd, int dataLen, byte[] data) {
        boolean writeFlag = false;
        int cmdLen = 12 + (dataLen /= 2) * 2;
        byte[] cmd = new byte[cmdLen];
        cmd[0] = -96;
        cmd[1] = (byte)(cmdLen - 2);
        cmd[2] = 1;
        cmd[3] = -126;
        System.arraycopy(password, 0, cmd, 4, password.length);
        cmd[8] = (byte)memBank;
        cmd[9] = (byte)wordAdd;
        cmd[10] = (byte)dataLen;
        System.arraycopy(data, 0, cmd, 11, data.length);
        cmd[11 + data.length] = this.checkSum(cmd, 11 + data.length);
        this.sendToReader(cmd);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int recvLength = recv.length;
            if (recvLength == 6) {
                return writeFlag;
            }
            if (this.isRecvData(recv) == 0) {
                writeFlag = true;
            }
        } else {
            LogUtils.i("write data", "\u05b8\ufffd\uecec\u02b1");
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.read();
        }
        return writeFlag;
    }

    @Override
    public boolean lock6C(byte[] password, int memBank, int lockType) {
        boolean lockFlag = false;
        byte[] cmd = new byte[11];
        cmd[0] = -96;
        cmd[1] = 9;
        cmd[2] = 1;
        cmd[3] = -125;
        System.arraycopy(password, 0, cmd, 4, password.length);
        cmd[8] = (byte)memBank;
        cmd[9] = (byte)lockType;
        cmd[10] = this.checkSum(cmd, cmd.length - 1);
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            if (recv.length == 6) {
                return lockFlag;
            }
            if (this.isRecvData(recv) == 0) {
                lockFlag = true;
            }
        } else {
            LogUtils.i("Lock..6c", "\ufffd\ufffd\u02b1");
        }
        return lockFlag;
    }

    public boolean kill6C(byte[] password) {
        boolean killFlag = false;
        byte[] cmd = new byte[9];
        cmd[0] = -96;
        cmd[1] = 7;
        cmd[2] = -1;
        cmd[3] = -124;
        System.arraycopy(password, 0, cmd, 4, password.length);
        cmd[8] = this.checkSum(cmd, cmd.length - 1);
        byte[] recv = this.read();
        if (recv != null) {
            if (recv.length == 6) {
                return killFlag;
            }
            if (this.isRecvData(recv) == 0) {
                killFlag = true;
            }
        } else {
            LogUtils.i("Kill ***", "\ufffd\ufffd\u02b1");
        }
        return killFlag;
    }

    public void inventory6B() {
    }

    private byte[] read() {
        int count = 0;
        int index = 0;
        int allCount = 0;
        byte[] resp = null;
        try {
            while (count < 3) {
                count = this.in.available();
                if (index > 50) {
                    return null;
                }
                ++index;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Thread.sleep(50L);
            allCount = this.in.available();
            resp = new byte[allCount];
            LogUtils.i("read allCount****", allCount + "");
            int mcount = 0;
            while (count != 0) {
                byte[] bytes = new byte[2];
                this.in.read(bytes);
                byte length = bytes[1];
                count = 0;
                count = this.in.available();
                LogUtils.i("read count", count + "");
                byte[] data = new byte[length];
                System.arraycopy(bytes, 0, resp, mcount, 2);
                System.arraycopy(data, 0, resp, mcount + 2, length);
                mcount = mcount + 2 + length;
                count = this.in.available();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resp;
    }

    public boolean sendToReader(byte[] cmd) {
        try {
            this.out.write(cmd);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public byte checkSum(byte[] uBuff, int uBuffLen) {
        byte crc = 0;
        for (int i = 0; i < uBuffLen; ++i) {
            crc = (byte)(crc + uBuff[i]);
        }
        crc = (byte)(0xFF & ~crc + 1);
        return crc;
    }

    public int isRecvData(byte[] recv) {
        if (recv.length < 5) {
            return -1;
        }
        String data = Tools.bytesToHexString((byte[])recv);
        if (recv[0] != -96) {
            return -2;
        }
        int recvDataLen = Integer.parseInt(data.substring(2, 4), 16);
        if (recvDataLen != recv.length - 2) {
            return -3;
        }
        byte crc = this.checkSum(recv, recv.length - 1);
        if (crc != recv[recv.length - 1]) {
            return -4;
        }
        return 0;
    }

    @Override
    public void setSensitivity(int value) {
    }

    @Override
    public void close() {
    }

    @Override
    public byte checkSum(byte[] data) {
        return 0;
    }
}

