/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RestrictTo;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FlowLayout
extends ViewGroup {
    private int lineSpacing;
    private int itemSpacing;
    private boolean singleLine = false;

    public FlowLayout(Context context) {
        this(context, null);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.loadFromAttributes(context, attrs);
    }

    @TargetApi(value=21)
    public FlowLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.loadFromAttributes(context, attrs);
    }

    private void loadFromAttributes(Context context, AttributeSet attrs) {
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FlowLayout, 0, 0);
        this.lineSpacing = array.getDimensionPixelSize(R.styleable.FlowLayout_lineSpacing, 0);
        this.itemSpacing = array.getDimensionPixelSize(R.styleable.FlowLayout_itemSpacing, 0);
        array.recycle();
    }

    protected int getLineSpacing() {
        return this.lineSpacing;
    }

    protected void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    protected int getItemSpacing() {
        return this.itemSpacing;
    }

    protected void setItemSpacing(int itemSpacing) {
        this.itemSpacing = itemSpacing;
    }

    protected boolean isSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childTop;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int maxWidth = widthMode == Integer.MIN_VALUE || widthMode == 0x40000000 ? width : Integer.MAX_VALUE;
        int childLeft = this.getPaddingLeft();
        int childBottom = childTop = this.getPaddingTop();
        int childRight = childLeft;
        int maxChildRight = 0;
        int maxRight = maxWidth - this.getPaddingRight();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            int leftMargin = 0;
            int rightMargin = 0;
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams marginLp = (ViewGroup.MarginLayoutParams)lp;
                leftMargin += marginLp.leftMargin;
                rightMargin += marginLp.rightMargin;
            }
            if ((childRight = childLeft + leftMargin + child.getMeasuredWidth()) > maxRight && !this.isSingleLine()) {
                childLeft = this.getPaddingLeft();
                childTop = childBottom + this.lineSpacing;
            }
            childRight = childLeft + leftMargin + child.getMeasuredWidth();
            childBottom = childTop + child.getMeasuredHeight();
            if (childRight > maxChildRight) {
                maxChildRight = childRight;
            }
            childLeft += leftMargin + rightMargin + child.getMeasuredWidth() + this.itemSpacing;
        }
        int finalWidth = FlowLayout.getMeasuredDimension(width, widthMode, maxChildRight);
        int finalHeight = FlowLayout.getMeasuredDimension(height, heightMode, childBottom);
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    private static int getMeasuredDimension(int size, int mode, int childrenEdge) {
        switch (mode) {
            case 0x40000000: {
                return size;
            }
            case -2147483648: {
                return Math.min(childrenEdge, size);
            }
        }
        return childrenEdge;
    }

    protected void onLayout(boolean sizeChanged, int left, int top, int right, int bottom) {
        int childTop;
        if (this.getChildCount() == 0) {
            return;
        }
        boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        int paddingStart = isRtl ? this.getPaddingRight() : this.getPaddingLeft();
        int paddingEnd = isRtl ? this.getPaddingLeft() : this.getPaddingRight();
        int childStart = paddingStart;
        int childBottom = childTop = this.getPaddingTop();
        int maxChildEnd = right - left - paddingEnd;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            int startMargin = 0;
            int endMargin = 0;
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams marginLp = (ViewGroup.MarginLayoutParams)lp;
                startMargin = MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)marginLp);
                endMargin = MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)marginLp);
            }
            int childEnd = childStart + startMargin + child.getMeasuredWidth();
            if (!this.singleLine && childEnd > maxChildEnd) {
                childStart = paddingStart;
                childTop = childBottom + this.lineSpacing;
            }
            childEnd = childStart + startMargin + child.getMeasuredWidth();
            childBottom = childTop + child.getMeasuredHeight();
            if (isRtl) {
                child.layout(maxChildEnd - childEnd, childTop, maxChildEnd - childStart - startMargin, childBottom);
            } else {
                child.layout(childStart + startMargin, childTop, childEnd, childBottom);
            }
            childStart += startMargin + endMargin + child.getMeasuredWidth() + this.itemSpacing;
        }
    }
}

