/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.transition.CanvasUtils;
import androidx.transition.GhostView;
import androidx.transition.GhostViewHolder;
import androidx.transition.R;
import androidx.transition.ViewUtils;

@SuppressLint(value={"ViewConstructor"})
class GhostViewPort
extends ViewGroup
implements GhostView {
    ViewGroup mStartParent;
    View mStartView;
    final View mView;
    int mReferences;
    @Nullable
    private Matrix mMatrix;
    private final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            ViewCompat.postInvalidateOnAnimation((View)GhostViewPort.this);
            if (GhostViewPort.this.mStartParent != null && GhostViewPort.this.mStartView != null) {
                GhostViewPort.this.mStartParent.endViewTransition(GhostViewPort.this.mStartView);
                ViewCompat.postInvalidateOnAnimation((View)GhostViewPort.this.mStartParent);
                GhostViewPort.this.mStartParent = null;
                GhostViewPort.this.mStartView = null;
            }
            return true;
        }
    };

    GhostViewPort(View view) {
        super(view.getContext());
        this.mView = view;
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (GhostViewPort.getGhostView(this.mView) == this) {
            int inverseVisibility = visibility == 0 ? 4 : 0;
            ViewUtils.setTransitionVisibility(this.mView, inverseVisibility);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    void setMatrix(@NonNull Matrix matrix) {
        this.mMatrix = matrix;
    }

    @Override
    public void reserveEndViewTransition(ViewGroup viewGroup, View view) {
        this.mStartParent = viewGroup;
        this.mStartView = view;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        GhostViewPort.setGhostView(this.mView, this);
        this.mView.getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        ViewUtils.setTransitionVisibility(this.mView, 4);
        if (this.mView.getParent() != null) {
            ((View)this.mView.getParent()).invalidate();
        }
    }

    protected void onDetachedFromWindow() {
        this.mView.getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        ViewUtils.setTransitionVisibility(this.mView, 0);
        GhostViewPort.setGhostView(this.mView, null);
        if (this.mView.getParent() != null) {
            ((View)this.mView.getParent()).invalidate();
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        CanvasUtils.enableZ(canvas, true);
        canvas.setMatrix(this.mMatrix);
        ViewUtils.setTransitionVisibility(this.mView, 0);
        this.mView.invalidate();
        ViewUtils.setTransitionVisibility(this.mView, 4);
        this.drawChild(canvas, this.mView, this.getDrawingTime());
        CanvasUtils.enableZ(canvas, false);
    }

    static void copySize(View from, View to) {
        ViewUtils.setLeftTopRightBottom(to, to.getLeft(), to.getTop(), to.getLeft() + from.getWidth(), to.getTop() + from.getHeight());
    }

    static GhostViewPort getGhostView(View view) {
        return (GhostViewPort)view.getTag(R.id.ghost_view);
    }

    static void setGhostView(@NonNull View view, @Nullable GhostViewPort ghostView) {
        view.setTag(R.id.ghost_view, (Object)ghostView);
    }

    static void calculateMatrix(View view, ViewGroup host, Matrix matrix) {
        ViewGroup parent = (ViewGroup)view.getParent();
        matrix.reset();
        ViewUtils.transformMatrixToGlobal((View)parent, matrix);
        matrix.preTranslate((float)(-parent.getScrollX()), (float)(-parent.getScrollY()));
        ViewUtils.transformMatrixToLocal((View)host, matrix);
    }

    static GhostViewPort addGhost(View view, ViewGroup viewGroup, Matrix matrix) {
        GhostViewHolder oldHolder;
        if (!(view.getParent() instanceof ViewGroup)) {
            throw new IllegalArgumentException("Ghosted views must be parented by a ViewGroup");
        }
        GhostViewHolder holder = GhostViewHolder.getHolder(viewGroup);
        GhostViewPort ghostView = GhostViewPort.getGhostView(view);
        int previousRefCount = 0;
        if (ghostView != null && (oldHolder = (GhostViewHolder)ghostView.getParent()) != holder) {
            previousRefCount = ghostView.mReferences;
            oldHolder.removeView((View)ghostView);
            ghostView = null;
        }
        if (ghostView == null) {
            if (matrix == null) {
                matrix = new Matrix();
                GhostViewPort.calculateMatrix(view, viewGroup, matrix);
            }
            ghostView = new GhostViewPort(view);
            ghostView.setMatrix(matrix);
            if (holder == null) {
                holder = new GhostViewHolder(viewGroup);
            } else {
                holder.popToOverlayTop();
            }
            GhostViewPort.copySize((View)viewGroup, (View)holder);
            GhostViewPort.copySize((View)viewGroup, (View)ghostView);
            holder.addGhostView(ghostView);
            ghostView.mReferences = previousRefCount;
        } else if (matrix != null) {
            ghostView.setMatrix(matrix);
        }
        ++ghostView.mReferences;
        return ghostView;
    }

    static void removeGhost(View view) {
        GhostViewPort ghostView = GhostViewPort.getGhostView(view);
        if (ghostView != null) {
            --ghostView.mReferences;
            if (ghostView.mReferences <= 0) {
                GhostViewHolder holder = (GhostViewHolder)ghostView.getParent();
                holder.removeView((View)ghostView);
            }
        }
    }
}

