/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.core.content.res.TypedArrayUtils;
import androidx.transition.PathMotion;
import androidx.transition.Styleable;
import org.xmlpull.v1.XmlPullParser;

public class ArcMotion
extends PathMotion {
    private static final float DEFAULT_MIN_ANGLE_DEGREES = 0.0f;
    private static final float DEFAULT_MAX_ANGLE_DEGREES = 70.0f;
    private static final float DEFAULT_MAX_TANGENT = (float)Math.tan(Math.toRadians(35.0));
    private float mMinimumHorizontalAngle = 0.0f;
    private float mMinimumVerticalAngle = 0.0f;
    private float mMaximumAngle = 70.0f;
    private float mMinimumHorizontalTangent = 0.0f;
    private float mMinimumVerticalTangent = 0.0f;
    private float mMaximumTangent = DEFAULT_MAX_TANGENT;

    public ArcMotion() {
    }

    @SuppressLint(value={"RestrictedApi"})
    public ArcMotion(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Styleable.ARC_MOTION);
        XmlPullParser parser = (XmlPullParser)attrs;
        float minimumVerticalAngle = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"minimumVerticalAngle", (int)1, (float)0.0f);
        this.setMinimumVerticalAngle(minimumVerticalAngle);
        float minimumHorizontalAngle = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"minimumHorizontalAngle", (int)0, (float)0.0f);
        this.setMinimumHorizontalAngle(minimumHorizontalAngle);
        float maximumAngle = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"maximumAngle", (int)2, (float)70.0f);
        this.setMaximumAngle(maximumAngle);
        a.recycle();
    }

    public void setMinimumHorizontalAngle(float angleInDegrees) {
        this.mMinimumHorizontalAngle = angleInDegrees;
        this.mMinimumHorizontalTangent = ArcMotion.toTangent(angleInDegrees);
    }

    public float getMinimumHorizontalAngle() {
        return this.mMinimumHorizontalAngle;
    }

    public void setMinimumVerticalAngle(float angleInDegrees) {
        this.mMinimumVerticalAngle = angleInDegrees;
        this.mMinimumVerticalTangent = ArcMotion.toTangent(angleInDegrees);
    }

    public float getMinimumVerticalAngle() {
        return this.mMinimumVerticalAngle;
    }

    public void setMaximumAngle(float angleInDegrees) {
        this.mMaximumAngle = angleInDegrees;
        this.mMaximumTangent = ArcMotion.toTangent(angleInDegrees);
    }

    public float getMaximumAngle() {
        return this.mMaximumAngle;
    }

    private static float toTangent(float arcInDegrees) {
        if (arcInDegrees < 0.0f || arcInDegrees > 90.0f) {
            throw new IllegalArgumentException("Arc must be between 0 and 90 degrees");
        }
        return (float)Math.tan(Math.toRadians(arcInDegrees / 2.0f));
    }

    @Override
    public Path getPath(float startX, float startY, float endX, float endY) {
        float minimumArcDist2;
        float ex;
        float ey;
        boolean isMovingUpwards;
        Path path = new Path();
        path.moveTo(startX, startY);
        float deltaX = endX - startX;
        float deltaY = endY - startY;
        float h2 = deltaX * deltaX + deltaY * deltaY;
        float dx = (startX + endX) / 2.0f;
        float dy = (startY + endY) / 2.0f;
        float midDist2 = h2 * 0.25f;
        boolean bl = isMovingUpwards = startY > endY;
        if (Math.abs(deltaX) < Math.abs(deltaY)) {
            float eDistY = Math.abs(h2 / (2.0f * deltaY));
            if (isMovingUpwards) {
                ey = endY + eDistY;
                ex = endX;
            } else {
                ey = startY + eDistY;
                ex = startX;
            }
            minimumArcDist2 = midDist2 * this.mMinimumVerticalTangent * this.mMinimumVerticalTangent;
        } else {
            float eDistX = h2 / (2.0f * deltaX);
            if (isMovingUpwards) {
                ex = startX + eDistX;
                ey = startY;
            } else {
                ex = endX - eDistX;
                ey = endY;
            }
            minimumArcDist2 = midDist2 * this.mMinimumHorizontalTangent * this.mMinimumHorizontalTangent;
        }
        float arcDistX = dx - ex;
        float arcDistY = dy - ey;
        float arcDist2 = arcDistX * arcDistX + arcDistY * arcDistY;
        float maximumArcDist2 = midDist2 * this.mMaximumTangent * this.mMaximumTangent;
        float newArcDistance2 = 0.0f;
        if (arcDist2 < minimumArcDist2) {
            newArcDistance2 = minimumArcDist2;
        } else if (arcDist2 > maximumArcDist2) {
            newArcDistance2 = maximumArcDist2;
        }
        if (newArcDistance2 != 0.0f) {
            float ratio2 = newArcDistance2 / arcDist2;
            float ratio = (float)Math.sqrt(ratio2);
            ex = dx + ratio * (ex - dx);
            ey = dy + ratio * (ey - dy);
        }
        float control1X = (startX + ex) / 2.0f;
        float control1Y = (startY + ey) / 2.0f;
        float control2X = (ex + endX) / 2.0f;
        float control2Y = (ey + endY) / 2.0f;
        path.cubicTo(control1X, control1Y, control2X, control2Y, endX, endY);
        return path;
    }
}

