/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.uhfr;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.Log;
import cn.pda.serialport.SerialPort;
import cn.pda.serialport.Tools;
import com.uhf.api.cls.ReadListener;
import com.uhf.api.cls.Reader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UHFRManager {
    private static SerialPort sSerialPort;
    private final String tag = "UHFRManager";
    private static Reader reader;
    private final int[] ants = new int[]{1};
    private final int ant = 1;
    public Reader.deviceVersion dv;
    public static Reader.READER_ERR mErr;
    private static boolean DEBUG;
    private static UHFRManager uhfrManager;
    private static boolean isE710;
    private List<Reader.TAGINFO> listTag = new ArrayList<Reader.TAGINFO>();
    private ReadListener readListener = new ReadListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tagRead(Reader reader, Reader.TAGINFO[] taginfos) {
            List list = UHFRManager.this.listTag;
            synchronized (list) {
                if (taginfos != null && taginfos.length > 0) {
                    Collections.addAll(UHFRManager.this.listTag, taginfos);
                }
            }
        }
    };
    Reader.TAGINFO taginfo = new Reader.TAGINFO(new Reader());
    int count = 0;

    public static void setDebuggable(boolean debuggable) {
        DEBUG = debuggable;
    }

    private void logPrint(String content) {
        if (DEBUG) {
            Log.e((String)"huang,UHFRManager", (String)content);
        }
    }

    private static void logPrint(String tag, String content) {
        if (DEBUG) {
            Log.e((String)("[" + tag + "]->"), (String)content);
        }
    }

    public static UHFRManager getInstance() {
        long enterTime = SystemClock.elapsedRealtime();
        if (uhfrManager == null && UHFRManager.connect()) {
            uhfrManager = new UHFRManager();
        }
        long outTime = SystemClock.elapsedRealtime();
        Log.i((String)"zeng-", (String)("init uhf time: " + (outTime - enterTime)));
        return uhfrManager;
    }

    public boolean close() {
        if (reader != null) {
            reader.CloseReader();
        }
        reader = null;
        new SerialPort().power_5Voff();
        uhfrManager = null;
        return true;
    }

    public String getHardware() {
        String version = null;
        Reader.HardwareDetails val = new Reader.HardwareDetails(reader);
        Reader.READER_ERR er = reader.GetHardwareDetails(val);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            version = "1.1.02." + val.module.value();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connect() {
        isE710 = false;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        SerialPort serialPort = null;
        try {
            new SerialPort().power_5Von();
            Thread.sleep(500L);
            serialPort = new SerialPort(13, 115200, 0);
            String cmd = "5A000101010000EBD5";
            outputStream = serialPort.getOutputStream();
            outputStream.write(Tools.HexString2Bytes(cmd));
            outputStream.flush();
            Thread.sleep(20L);
            byte[] bytes = new byte[128];
            inputStream = serialPort.getInputStream();
            int read = inputStream.read(bytes);
            String retStr = Tools.Bytes2HexString(bytes, read);
            UHFRManager.logPrint("zeng-", "retStr0:" + retStr);
            if (retStr.length() >= 10 && retStr.contains("5A00010101")) {
            } else {
                cmd = "FF00031D0C";
                outputStream.write(Tools.HexString2Bytes(cmd));
                outputStream.flush();
                Thread.sleep(20L);
                read = inputStream.read(bytes);
                retStr = Tools.Bytes2HexString(bytes, read);
                UHFRManager.logPrint("zeng-", "retStr1:" + retStr);
                if (retStr.length() > 40) {
                    isE710 = false;
                } else {
                    serialPort.close(13);
                    serialPort = new SerialPort(13, 921600, 0);
                    outputStream = serialPort.getOutputStream();
                    cmd = "FF00031D0C";
                    outputStream.write(Tools.HexString2Bytes(cmd));
                    outputStream.flush();
                    Thread.sleep(20L);
                    read = inputStream.read(bytes);
                    retStr = Tools.Bytes2HexString(bytes, read);
                    UHFRManager.logPrint("zeng-", "retStr2:" + retStr);
                    if (retStr.length() > 40) {
                        isE710 = true;
                    } else {
                        serialPort = new SerialPort(13, 115200, 0);
                        cmd = "A55A000902000B0D0A";
                        outputStream.write(Tools.HexString2Bytes(cmd));
                        outputStream.flush();
                        Thread.sleep(20L);
                        read = inputStream.read(bytes);
                        retStr = Tools.Bytes2HexString(bytes, read);
                        if (retStr.length() > 10) {
                            UHFRManager.logPrint("connect", "onCreate \u9510\u8fea retStr: " + retStr);
                        }
                    }
                }
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (serialPort != null) {
                    serialPort.close(13);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        reader = new Reader();
        long enterTime = SystemClock.elapsedRealtime();
        Reader.READER_ERR er = isE710 ? reader.InitReader_Notype("/dev/ttyMT1:921600", 1) : reader.InitReader_Notype("/dev/ttyMT1", 1);
        long outTime = SystemClock.elapsedRealtime();
        Log.i((String)"zeng-", (String)("InitReader cusTime: " + (outTime - enterTime)));
        if (er == Reader.READER_ERR.MT_OK_ERR && UHFRManager.connect2()) {
            return true;
        }
        reader.CloseReader();
        new SerialPort().power_5Voff();
        return false;
    }

    private static boolean connect2() {
        long enterTime = SystemClock.elapsedRealtime();
        Reader.Inv_Potls_ST ipst = new Reader.Inv_Potls_ST(reader);
        ArrayList<Reader.SL_TagProtocol> ltp = new ArrayList<Reader.SL_TagProtocol>();
        ltp.add(Reader.SL_TagProtocol.SL_TAG_PROTOCOL_GEN2);
        ipst.potlcnt = ltp.size();
        ipst.potls = new Reader.Inv_Potl[ipst.potlcnt];
        Reader.SL_TagProtocol[] stp = ltp.toArray(new Reader.SL_TagProtocol[ipst.potlcnt]);
        for (int i = 0; i < ipst.potlcnt; ++i) {
            Reader.Inv_Potl ipl = new Reader.Inv_Potl(reader);
            ipl.weight = 30;
            ipl.potl = stp[i];
            ipst.potls[0] = ipl;
        }
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_INVPOTL, (Object)ipst);
        long outTime = SystemClock.elapsedRealtime();
        Log.i((String)"zeng-", (String)("connect2 cusTime: " + (outTime - enterTime)));
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    public static boolean setBaudrate(int baudtrate) {
        Reader.Default_Param dp = new Reader.Default_Param(reader);
        dp.isdefault = false;
        dp.key = Reader.Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD;
        dp.val = baudtrate;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_SAVEINMODULE_BAUD, (Object)dp);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    public Reader.READER_ERR asyncStartReading() {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, null);
        if (isE710) {
            Object[] objs3 = new Object[]{500, 50, 100, 1, 101};
            boolean flag = false;
            try {
                flag = reader.Set_IT_Params(Reader.IT_MODE.IT_MODE_E7, objs3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            UHFRManager.logPrint("Set_IT_Params", "Set_IT_Params = " + flag);
            reader.addReadListener(this.readListener);
            er = reader.AsyncStartReading_IT(Reader.IT_MODE.IT_MODE_E7, this.ants, 1, 0);
            this.logPrint("AsyncStartReading_IT, IT_MODE_E7 result: " + er.toString());
            return er;
        }
        int session = this.getGen2session();
        if (session == 1) {
            return reader.AsyncStartReading(this.ants, 1, 16);
        }
        return reader.AsyncStartReading(this.ants, 1, 0);
    }

    public Reader.READER_ERR asyncStartReading(int option) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, null);
        this.logPrint("asyncStartReading, ParamSet MTR_PARAM_TAG_EMBEDEDDATA result: " + er.toString());
        if (isE710) {
            return reader.AsyncStartReading_IT(Reader.IT_MODE.IT_MODE_E7, this.ants, 1, 0);
        }
        return reader.AsyncStartReading(this.ants, 1, option);
    }

    public Reader.READER_ERR asyncStopReading() {
        if (isE710) {
            Reader.READER_ERR er = reader.AsyncStopReading_IT();
            reader.removeReadListener(this.readListener);
            return er;
        }
        return reader.AsyncStopReading();
    }

    public boolean setInventoryFilter(byte[] fdata, int fbank, int fstartaddr, boolean matching) {
        Reader.TagFilter_ST g2tf = new Reader.TagFilter_ST(reader);
        g2tf.fdata = fdata;
        g2tf.flen = fdata.length * 8;
        g2tf.isInvert = matching ? 0 : 1;
        g2tf.bank = fbank;
        g2tf.startaddr = fstartaddr * 16;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)g2tf);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("setInventoryFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
            return false;
        }
        return true;
    }

    public boolean setCancleInventoryFilter() {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("setCancleInventoryFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reader.TAGINFO> tagInventoryRealTime() {
        ArrayList<Reader.TAGINFO> list = new ArrayList<Reader.TAGINFO>();
        if (isE710) {
            List<Reader.TAGINFO> list2 = this.listTag;
            synchronized (list2) {
                list.addAll(this.listTag);
                this.listTag.clear();
                return list;
            }
        }
        int[] tagcnt = new int[1];
        Reader.READER_ERR er = reader.AsyncGetTagCount(tagcnt);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            mErr = er;
            return null;
        }
        for (int i = 0; i < tagcnt[0]; ++i) {
            Reader.TAGINFO tfs = new Reader.TAGINFO(reader);
            er = reader.AsyncGetNextTag(tfs);
            if (er != Reader.READER_ERR.MT_OK_ERR) continue;
            list.add(tfs);
        }
        return list;
    }

    public boolean stopTagInventory() {
        Reader.READER_ERR er = reader.AsyncStopReading();
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("stopTagInventory, AsyncStopReading result: " + er.toString());
            return false;
        }
        return true;
    }

    public List<Reader.TAGINFO> tagInventoryByTimer(short readtime) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, null);
        this.logPrint("tagInventoryByTimer, ParamSet MTR_PARAM_TAG_EMBEDEDDATA result: " + er.toString());
        ArrayList<Reader.TAGINFO> list = new ArrayList<Reader.TAGINFO>();
        int[] tagcnt = new int[1];
        er = reader.TagInventory_Raw(this.ants, 1, readtime, tagcnt);
        this.logPrint("tagInventoryByTimer, TagInventory_Raw er: " + er.toString() + "; tagcnt[0]=" + tagcnt[0]);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            mErr = er;
            return null;
        }
        for (int i = 0; i < tagcnt[0]; ++i) {
            Reader.TAGINFO tfs = new Reader.TAGINFO(reader);
            er = reader.GetNextTag(tfs);
            if (er != Reader.READER_ERR.MT_OK_ERR) continue;
            list.add(tfs);
        }
        return list;
    }

    public List<Reader.TAGINFO> tagEpcTidInventoryByTimer(short readtime) {
        ArrayList<Reader.TAGINFO> list = new ArrayList<Reader.TAGINFO>();
        Reader.EmbededData_ST edst = new Reader.EmbededData_ST(reader);
        edst.accesspwd = null;
        edst.bank = 2;
        edst.startaddr = 0;
        edst.bytecnt = 12;
        reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, (Object)edst);
        int[] tagcnt = new int[1];
        Reader.READER_ERR er = reader.TagInventory_Raw(this.ants, 1, readtime, tagcnt);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            mErr = er;
            return null;
        }
        for (int i = 0; i < tagcnt[0]; ++i) {
            Reader.TAGINFO tfs = new Reader.TAGINFO(reader);
            er = reader.GetNextTag(tfs);
            if (er != Reader.READER_ERR.MT_OK_ERR) continue;
            list.add(tfs);
        }
        return list;
    }

    public List<Reader.TAGINFO> tagEpcOtherInventoryByTimer(short readtime, int bank, int startaddr, int bytecnt, byte[] accesspwd) {
        ArrayList<Reader.TAGINFO> list = new ArrayList<Reader.TAGINFO>();
        Reader.EmbededData_ST edst = new Reader.EmbededData_ST(reader);
        edst.bank = bank;
        edst.startaddr = startaddr;
        edst.bytecnt = bytecnt;
        edst.accesspwd = accesspwd;
        reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_EMBEDEDDATA, (Object)edst);
        int[] tagcnt = new int[1];
        Reader.READER_ERR er = reader.TagInventory_Raw(this.ants, 1, readtime, tagcnt);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            mErr = er;
            return null;
        }
        for (int i = 0; i < tagcnt[0]; ++i) {
            Reader.TAGINFO tfs = new Reader.TAGINFO(reader);
            er = reader.GetNextTag(tfs);
            if (er != Reader.READER_ERR.MT_OK_ERR) continue;
            list.add(tfs);
        }
        return list;
    }

    public Reader.READER_ERR getTagData(int mbank, int startaddr, int len, @NonNull byte[] rdata, byte[] password, short timeout) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            int trycount = 3;
            do {
                er = reader.GetTagData(1, (char)mbank, startaddr, len, rdata, password, timeout);
            } while (--trycount >= 1 && er != Reader.READER_ERR.MT_OK_ERR);
            if (er != Reader.READER_ERR.MT_OK_ERR) {
                this.logPrint("getTagData, GetTagData result: " + er.toString());
            }
        } else {
            this.logPrint("getTagData, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public byte[] getTagDataByFilter(int mbank, int startaddr, int len, byte[] password, short timeout, byte[] fdata, int fbank, int fstartaddr, boolean matching) {
        Reader.TagFilter_ST g2tf = new Reader.TagFilter_ST(reader);
        g2tf.fdata = fdata;
        g2tf.flen = fdata.length * 8;
        g2tf.isInvert = matching ? 0 : 1;
        g2tf.bank = fbank;
        g2tf.startaddr = fstartaddr * 16;
        byte[] rdata = new byte[len * 2];
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)g2tf);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            er = reader.GetTagData(1, (char)mbank, startaddr, len, rdata, password, timeout);
            if (er == Reader.READER_ERR.MT_OK_ERR) {
                return rdata;
            }
            this.logPrint("getTagDataByFilter, GetTagData result: " + er.toString());
            return null;
        }
        this.logPrint("getTagDataByFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        return null;
    }

    public Reader.READER_ERR writeTagData(char mbank, int startaddress, byte[] data, int datalen, byte[] accesspasswd, short timeout) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            int trycount = 3;
            do {
                er = reader.WriteTagData(1, mbank, startaddress, data, datalen, accesspasswd, timeout);
            } while (--trycount >= 1 && er != Reader.READER_ERR.MT_OK_ERR);
            if (er != Reader.READER_ERR.MT_OK_ERR) {
                this.logPrint("writeTagData, WriteTagData result: " + er.toString());
            }
        } else {
            this.logPrint("writeTagData, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR writeTagDataByFilter(char mbank, int startaddress, byte[] data, int datalen, byte[] accesspasswd, short timeout, byte[] fdata, int fbank, int fstartaddr, boolean matching) {
        Reader.TagFilter_ST g2tf = new Reader.TagFilter_ST(reader);
        g2tf.fdata = fdata;
        g2tf.flen = fdata.length * 8;
        g2tf.isInvert = matching ? 0 : 1;
        g2tf.bank = fbank;
        g2tf.startaddr = fstartaddr * 16;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)g2tf);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            int trycount = 3;
            do {
                er = reader.WriteTagData(1, mbank, startaddress, data, datalen, accesspasswd, timeout);
            } while (--trycount >= 1 && er != Reader.READER_ERR.MT_OK_ERR);
            if (er != Reader.READER_ERR.MT_OK_ERR) {
                this.logPrint("writeTagDataByFilter, WriteTagData result: " + er.toString());
            }
        } else {
            this.logPrint("writeTagDataByFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR writeTagEPC(byte[] data, byte[] accesspwd, short timeout) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        int trycount = 3;
        do {
            er = reader.WriteTagEpcEx(1, data, data.length, accesspwd, timeout);
            if (trycount < 1) break;
            --trycount;
        } while (er != Reader.READER_ERR.MT_OK_ERR);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("writeTagEPC, WriteTagEpcEx result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR writeTagEPCByFilter(byte[] data, byte[] accesspwd, short timeout, byte[] fdata, int fbank, int fstartaddr, boolean matching) {
        Reader.TagFilter_ST g2tf = new Reader.TagFilter_ST(reader);
        g2tf.fdata = fdata;
        g2tf.flen = fdata.length * 8;
        g2tf.isInvert = matching ? 0 : 1;
        g2tf.bank = fbank;
        g2tf.startaddr = fstartaddr * 16;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)g2tf);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            int trycount = 3;
            do {
                er = reader.WriteTagEpcEx(1, data, data.length, accesspwd, timeout);
                if (trycount < 1) break;
                --trycount;
            } while (er != Reader.READER_ERR.MT_OK_ERR);
            if (er != Reader.READER_ERR.MT_OK_ERR) {
                this.logPrint("writeTagEPCByFilter, WriteTagEpcEx result: " + er.toString());
            }
        } else {
            this.logPrint("writeTagEPCByFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR lockTag(Reader.Lock_Obj lockobject, Reader.Lock_Type locktype, byte[] accesspasswd, short timeout) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            er = reader.LockTag(1, (byte)lockobject.value(), (short)locktype.value(), accesspasswd, timeout);
        }
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("lockTag, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR lockTagByFilter(Reader.Lock_Obj lockobject, Reader.Lock_Type locktype, byte[] accesspasswd, short timeout, byte[] fdata, int fbank, int fstartaddr, boolean matching) {
        Reader.TagFilter_ST g2tf = new Reader.TagFilter_ST(reader);
        g2tf.fdata = fdata;
        g2tf.flen = fdata.length * 8;
        g2tf.isInvert = matching ? 0 : 1;
        g2tf.bank = fbank;
        g2tf.startaddr = fstartaddr * 16;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)g2tf);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            er = reader.LockTag(1, (byte)lockobject.value(), (short)locktype.value(), accesspasswd, timeout);
        }
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("lockTagByFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR killTag(byte[] killpasswd, short timeout) {
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            er = reader.KillTag(1, killpasswd, timeout);
        }
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("killTag, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR killTagByFilter(byte[] killpasswd, short timeout, byte[] fdata, int fbank, int fstartaddr, boolean matching) {
        Reader.TagFilter_ST g2tf = new Reader.TagFilter_ST(reader);
        g2tf.fdata = fdata;
        g2tf.flen = fdata.length * 8;
        g2tf.isInvert = matching ? 0 : 1;
        g2tf.bank = fbank;
        g2tf.startaddr = fstartaddr * 16;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)g2tf);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            er = reader.KillTag(1, killpasswd, timeout);
        }
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            this.logPrint("killTagByFilter, ParamSet MTR_PARAM_TAG_FILTER result: " + er.toString());
        }
        return er;
    }

    public Reader.READER_ERR setRegion(Reader.Region_Conf region) {
        return reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)region);
    }

    public Reader.Region_Conf getRegion() {
        Reader.Region_Conf[] rcf2 = new Reader.Region_Conf[1];
        Reader.READER_ERR er = reader.ParamGet(Reader.Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)rcf2);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            return rcf2[0];
        }
        this.logPrint("getRegion, ParamGet MTR_PARAM_FREQUENCY_REGION result: " + er.toString());
        return null;
    }

    public Reader.READER_ERR setPower(int readPower, int writePower) {
        Reader.AntPowerConf antPowerConf = new Reader.AntPowerConf(reader);
        antPowerConf.antcnt = 1;
        Reader.AntPower antPower = new Reader.AntPower(reader);
        antPower.antid = 1;
        antPower.readPower = (short)((short)readPower * 100);
        antPower.writePower = (short)((short)writePower * 100);
        antPowerConf.Powers[0] = antPower;
        return reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_RF_ANTPOWER, (Object)antPowerConf);
    }

    public int[] getPower() {
        int[] powers = new int[2];
        Reader.AntPowerConf apcf2 = new Reader.AntPowerConf(reader);
        Reader.READER_ERR er = reader.ParamGet(Reader.Mtr_Param.MTR_PARAM_RF_ANTPOWER, (Object)apcf2);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            powers[0] = apcf2.Powers[0].readPower / 100;
            powers[1] = apcf2.Powers[0].writePower / 100;
            return powers;
        }
        this.logPrint("getPower, ParamGet MTR_PARAM_RF_ANTPOWER result: " + er.toString());
        return null;
    }

    private int[] sort(int[] array, int len) {
        for (int xIndex = 0; xIndex < len; ++xIndex) {
            for (int yIndex = 0; yIndex < len; ++yIndex) {
                if (array[xIndex] >= array[yIndex]) continue;
                int tmpIntValue = array[xIndex];
                array[xIndex] = array[yIndex];
                array[yIndex] = tmpIntValue;
            }
        }
        return array;
    }

    public boolean setGen2session(boolean isMulti) {
        try {
            Reader.READER_ERR er;
            int[] val = new int[]{-1};
            if (isMulti) {
                val[0] = 1;
                if (isE710) {
                    val[0] = 2;
                }
            } else {
                val[0] = 0;
            }
            return (er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, (Object)val)) == Reader.READER_ERR.MT_OK_ERR;
        }
        catch (Exception var4) {
            return false;
        }
    }

    public boolean setGen2session(int session) {
        try {
            int[] val = new int[]{-1};
            val[0] = session;
            Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, (Object)val);
            return er == Reader.READER_ERR.MT_OK_ERR;
        }
        catch (Exception var4) {
            return false;
        }
    }

    public int getGen2session() {
        int[] val = new int[]{-1};
        Reader.READER_ERR er = reader.ParamGet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, (Object)val);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            UHFRManager.logPrint("pang", "getGen2session = " + val[0]);
            return val[0];
        }
        return -1;
    }

    public int getQvalue() {
        int value = -1;
        return value;
    }

    public int getTarget() {
        int target = -1;
        int[] val = new int[]{-1};
        Reader.READER_ERR er = reader.ParamGet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, (Object)val);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            target = val[0];
        }
        return target;
    }

    public boolean setTarget(int target) {
        boolean flag = false;
        int[] val = new int[]{-1};
        val[0] = target;
        Reader.READER_ERR er = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_TARGET, (Object)val);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            flag = true;
        }
        return flag;
    }

    public String getInfo() {
        Reader.HardwareDetails val = new Reader.HardwareDetails(reader);
        this.dv = new Reader.deviceVersion();
        Reader.GetDeviceVersion((String)"/dev/ttyMT1", (Reader.deviceVersion)this.dv);
        if (reader.GetHardwareDetails(val) == Reader.READER_ERR.MT_OK_ERR) {
            return "module:" + val.module.toString() + "\r\nhard:" + this.dv.hardwareVer + "\r\nsoft:" + this.dv.softwareVer;
        }
        return "";
    }

    public boolean setFastID(boolean isOpenFastTiD) {
        if (isOpenFastTiD) {
            Reader.CustomParam_ST cpara = new Reader.CustomParam_ST(reader);
            cpara.ParamName = "tagcustomcmd/fastid";
            cpara.ParamVal = new byte[1];
            cpara.ParamVal[0] = 1;
            Reader.READER_ERR ret = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_CUSTOM, (Object)cpara);
            return ret == Reader.READER_ERR.MT_OK_ERR;
        }
        Reader.CustomParam_ST cpara = new Reader.CustomParam_ST(reader);
        cpara.ParamName = "tagcustomcmd/fastid";
        cpara.ParamVal = new byte[1];
        Reader.READER_ERR ret = reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_CUSTOM, (Object)cpara);
        return ret == Reader.READER_ERR.MT_OK_ERR;
    }

    static {
        DEBUG = false;
        uhfrManager = null;
        isE710 = false;
    }
}

