/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.LF125K;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import cn.pda.serialport.SerialPort;
import cn.pda.serialport.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Lf125KManager {
    private static Handler handler;
    private boolean runFlag = true;
    private boolean startFlag = false;
    public static int Port;
    public static boolean Hex;
    public static int Power;
    public static int BaudRate;
    private static SerialPort mSerialPort;
    private static InputStream mInputStream;
    private static ReadThread mReadThread;
    public static int LF;

    static {
        Port = 14;
        Hex = false;
        Power = 3;
        BaudRate = 9600;
        LF = 1004;
    }

    public boolean Open(Handler mHandler) {
        this.startFlag = false;
        this.runFlag = true;
        handler = mHandler;
        try {
            mSerialPort = new SerialPort();
            mSerialPort = new SerialPort(Port, BaudRate, 0);
            switch (Power) {
                case 2: {
                    mSerialPort.scaner_poweron();
                    break;
                }
                case 0: {
                    mSerialPort.power3v3on();
                    break;
                }
                case 1: {
                    mSerialPort.power_5Von();
                    break;
                }
                case 3: {
                    mSerialPort.psam_poweron();
                    break;
                }
                case 4: {
                    mSerialPort.rfid_poweron();
                }
            }
            mInputStream = mSerialPort.getInputStream();
            mReadThread = new ReadThread();
            mReadThread.start();
            Log.e((String)"open", (String)(String.valueOf(Port) + ":" + Power + ":" + BaudRate));
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void SetHandler(Handler handler) {
        Lf125KManager.handler = handler;
    }

    public void Pause() {
        this.startFlag = false;
    }

    public void Start() {
        this.startFlag = true;
    }

    public boolean Close() {
        Log.e((String)"125K", (String)("Close" + Port + Power));
        if (mReadThread != null) {
            this.startFlag = false;
            this.runFlag = false;
            mReadThread.interrupt();
        }
        try {
            mInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (mSerialPort != null) {
            mSerialPort.close(Port);
        }
        switch (Power) {
            case 2: {
                mSerialPort.scaner_poweroff();
                break;
            }
            case 0: {
                mSerialPort.power_3v3off();
                break;
            }
            case 1: {
                mSerialPort.power_5Voff();
                break;
            }
            case 3: {
                mSerialPort.psam_poweroff();
                break;
            }
            case 4: {
                mSerialPort.rfid_poweroff();
            }
        }
        return true;
    }

    private String handleData2hex(byte[] data) {
        byte[] idBytesASC = new byte[10];
        byte[] idBytes = new byte[5];
        if (data == null) {
            return null;
        }
        if (data[0] != 2) {
            return null;
        }
        if (data.length > 10) {
            System.arraycopy(data, 1, idBytesASC, 0, 10);
            try {
                String id = new String(idBytesASC, "ASC-II");
                return id;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static String handleData(byte[] data) {
        byte[] idBytes = new byte[6];
        if (data == null) {
            return null;
        }
        if (data[0] != 2) {
            return null;
        }
        if (data.length > 10) {
            System.arraycopy(data, 5, idBytes, 0, 6);
            String id = new String(idBytes);
            int idInt = Integer.parseInt(id, 16);
            id = "" + idInt;
            switch (id.length()) {
                case 9: {
                    id = "0" + id;
                    break;
                }
                case 8: {
                    id = "00" + id;
                    break;
                }
                case 7: {
                    id = "000" + id;
                    break;
                }
                case 6: {
                    id = "0000" + id;
                    break;
                }
                case 5: {
                    id = "00000" + id;
                    break;
                }
            }
            return id;
        }
        return null;
    }

    private static String handleData2d(byte[] data) {
        byte[] idBytes = new byte[10];
        if (data == null) {
            return null;
        }
        if (data[0] != 2) {
            return null;
        }
        if (data.length > 10) {
            System.arraycopy(data, 1, idBytes, 0, 10);
            try {
                String id = new String(idBytes, "ASC-II");
                return id;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static byte[] read() {
        boolean allCount = false;
        byte[] buffer = new byte[128];
        byte[] bytes = new byte[64];
        try {
            int count = mInputStream.available();
            if (count > 0) {
                Log.e((String)"ReadThread", (String)("" + count));
                Thread.sleep(10L);
                int dataSize = mInputStream.available();
                byte[] resp = new byte[dataSize];
                mInputStream.read(resp);
                Log.e((String)"MainActivity ReadThread", (String)Tools.Bytes2HexString(resp, resp.length));
                if (dataSize > 3) {
                    return resp;
                }
            }
            Thread.sleep(10L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean checkByte(byte[] bs) {
        byte[] idBytes = new byte[10];
        System.arraycopy(bs, 1, idBytes, 0, 10);
        byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 64, 65, 66, 67, 68, 69, 70};
        Log.e((String)"idb", (String)Tools.Bytes2HexString(idBytes, idBytes.length));
        byte[] byArray = idBytes;
        int n = idBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (!Lf125KManager.bsContainB(b, bytes)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean bsContainB(byte b, byte[] bs) {
        int i = 0;
        while (i < bs.length) {
            if (b == bs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class ReadThread
    extends Thread {
        int size;
        int available;
        byte[] buffer;
        byte[] respBytes;
        byte[] idBytes = new byte[4];

        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            while (Lf125KManager.this.runFlag) {
                this.buffer = new byte[128];
                if (!Lf125KManager.this.startFlag) continue;
                if (mInputStream == null) {
                    return;
                }
                this.respBytes = Lf125KManager.read();
                if (this.respBytes != null) {
                    String id_hex = Lf125KManager.this.handleData2hex(this.respBytes);
                    String id_d = Lf125KManager.handleData(this.respBytes);
                    if (id_hex != null && Lf125KManager.checkByte(this.respBytes)) {
                        if (Hex) {
                            this.sendMSG(id_hex);
                        } else {
                            this.sendMSG(id_d);
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void sendMSG(String id_d) {
            Bundle bundle = new Bundle();
            bundle.putString("data", id_d);
            Message msg = new Message();
            msg.what = LF;
            msg.setData(bundle);
            handler.sendMessage(msg);
        }
    }
}

