/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.HF;

import cn.pda.serialport.SerialPort;
import com.handheld.HF.Error;
import com.handheld.HF.HfConmmand;
import com.handheld.HF.HfError;
import com.handheld.HF.Iso15693CardInformation;
import com.handheld.HF.Iso15693InventoryInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class HfManager
implements HfConmmand {
    private InputStream is;
    private OutputStream os;
    public static int Port = 14;
    public static int Power = 3;
    public static int BaudRate = 115200;
    private static final byte HEAD_H = 85;
    private static final byte HEAD_L = -86;
    private static final byte END_L = 85;
    private static final byte END_H = -86;
    private static final byte CMD_TYTE_APPL = 68;
    private static final byte CMD_TYTE_RESET = 101;
    private static final byte CMD_TYTE_GET_SYSINFO = 102;
    private static final byte CMD_TYTE_GET_VERSION = 103;
    private static final byte ISO_14443A_INIT = -96;
    private static final byte ISO_14443A_DEINIT = -81;
    private static final byte ISO_14443A_FIND_CARD = -95;
    private static final byte MIFARE_INIT = -32;
    private static final byte MIFARE_DEINIT = -17;
    private static final byte MIFARE_AUTH_A = -31;
    private static final byte MIFARE_AUTH_B = -30;
    private static final byte MIFARE_READ_SINGLE = -27;
    private static final byte MIFARE_WRITE_SINGLE = -26;
    private static final byte ISO_15693_INIT = -48;
    private static final byte ISO_15693_DEINIT = -33;
    private static final byte ISO_15693_INVENTORY = -46;
    private static final byte ISO_15693_GET_PICC = -42;
    private static final byte ISO_15693_READ_SINGLE = -41;
    private static final byte ISO_15693_WRITE_SINGLE = -40;
    public static final int AUTH_A = 0;
    public static final int AUTH_B = 1;
    private SerialPort serialPort;
    private static final int ERROR_INPUT_OUTPUT_STREAM = -2;
    boolean reading = true;

    public HfManager() {
        try {
            this.serialPort = new SerialPort(Port, BaudRate, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (Power) {
            case 2: {
                this.serialPort.scaner_poweron();
                break;
            }
            case 0: {
                this.serialPort.power_3v3on();
                break;
            }
            case 1: {
                this.serialPort.power_5Von();
                break;
            }
            case 3: {
                this.serialPort.psam_poweron();
                break;
            }
            case 4: {
                this.serialPort.rfid_poweron();
            }
        }
        this.is = this.serialPort.getInputStream();
        this.os = this.serialPort.getOutputStream();
        try {
            this.is.read(new byte[16]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] fillContent(byte rspH, byte rspL, byte[] data, int dataLen) {
        byte dataLenH = (byte)(dataLen / 256);
        byte dataLenL = (byte)(dataLen % 256);
        byte[] content = new byte[4 + dataLen];
        content[0] = dataLenH;
        content[1] = dataLenL;
        content[2] = rspH;
        content[3] = rspL;
        if (dataLen > 0) {
            System.arraycopy(data, 0, content, 4, dataLen);
        }
        return content;
    }

    private byte[] genPackage(byte cmdType, byte[] content, int contentLen) {
        byte[] cmdPackage = new byte[5 + contentLen];
        cmdPackage[0] = 85;
        cmdPackage[1] = -86;
        cmdPackage[2] = cmdType;
        System.arraycopy(content, 0, cmdPackage, 3, contentLen);
        cmdPackage[3 + contentLen] = -86;
        cmdPackage[4 + contentLen] = 85;
        return cmdPackage;
    }

    private boolean sendCMD(byte[] cmd) {
        boolean flag = false;
        if (this.os != null) {
            try {
                this.os.write(cmd);
                flag = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return flag;
    }

    private byte[] getResponse(byte cmdType) {
        int size = 0;
        byte[] buffer = new byte[512];
        byte[] temp = new byte[1024];
        int index = 0;
        int count = 0;
        this.reading = true;
        Timer mTimer = new Timer();
        mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                HfManager.this.reading = false;
            }
        }, 500L);
        while (this.reading) {
            try {
                size = this.is.read(buffer);
                if (size <= 0) continue;
                count += size;
                if ((count += size) > 512) {
                    count = 0;
                    Arrays.fill(temp, (byte)0);
                }
                System.arraycopy(buffer, 0, temp, index, size);
                index += size;
                if (count <= 8) continue;
                if (temp[0] == 85 && temp[1] == -86 && temp[2] == cmdType) {
                    int dataLen = (temp[5] & 0xFF) * 256 + temp[6] & 0xFF;
                    if (count < 9 + dataLen || temp[dataLen + 7] != -86 || temp[dataLen + 8] != 85) continue;
                    byte[] dataPackage = new byte[dataLen + 9];
                    System.arraycopy(temp, 0, dataPackage, 0, dataLen + 9);
                    mTimer.cancel();
                    return dataPackage;
                }
                count = 0;
                index = 0;
                Arrays.fill(temp, (byte)0);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private byte[] handleResp(byte[] resp, Error error) {
        int stute = (resp[3] & 0xFF) * 256 + (resp[4] & 0xFF);
        int dataLen = (resp[5] & 0xFF) * 256 + (resp[6] & 0xFF);
        byte[] data = null;
        error.setErrorCode(stute);
        if (stute == 0 && dataLen > 0) {
            data = new byte[dataLen];
            System.arraycopy(resp, 7, data, 0, dataLen);
        }
        return data;
    }

    private int init14443A(Error error) {
        byte[] content = this.fillContent((byte)0, (byte)0, new byte[]{-96}, 1);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] dataPackage = this.getResponse((byte)68);
            if (dataPackage != null) {
                this.handleResp(dataPackage, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return 0;
    }

    private int deInit14443A() {
        HfError error = new HfError();
        byte[] content = this.fillContent((byte)0, (byte)0, new byte[]{-81, 1}, 2);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] dataPackage = this.getResponse((byte)68);
            if (dataPackage != null) {
                this.handleResp(dataPackage, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return 0;
    }

    private int initMifare() {
        HfError error = new HfError();
        byte[] content = this.fillContent((byte)0, (byte)0, new byte[]{-32}, 1);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] dataPackage = this.getResponse((byte)68);
            if (dataPackage != null) {
                this.handleResp(dataPackage, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return 0;
    }

    @Override
    public byte[] SearchCard14443A(Error error) {
        this.init14443A(error);
        byte[] content = this.fillContent((byte)0, (byte)18, new byte[]{-95, 82}, 2);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        byte[] uid = null;
        byte[] dataPackage = null;
        if (this.sendCMD(cmd)) {
            byte[] temp;
            dataPackage = this.getResponse((byte)68);
            if (dataPackage != null && (temp = this.handleResp(dataPackage, error)) != null) {
                if (temp[3] == 1) {
                    uid = new byte[4];
                    System.arraycopy(temp, 7, uid, 0, uid.length);
                } else if (temp[3] == 2) {
                    uid = new byte[7];
                    System.arraycopy(temp, 7, uid, 0, uid.length);
                }
            }
        } else {
            error.setErrorCode(-2);
        }
        this.deInit14443A();
        this.initMifare();
        return uid;
    }

    @Override
    public int auth14443A(int authType, byte[] access, byte[] uid, int sector, Error error) {
        byte[] contentData = new byte[3 + access.length + uid.length];
        byte[] resp = null;
        if (authType == 0) {
            contentData[0] = -31;
        } else if (authType == 1) {
            contentData[0] = -30;
        }
        contentData[1] = (byte)sector;
        System.arraycopy(access, 0, contentData, 2, access.length);
        contentData[2 + access.length] = (byte)uid.length;
        System.arraycopy(uid, 0, contentData, 3 + access.length, uid.length);
        byte[] content = this.fillContent((byte)0, (byte)1, contentData, contentData.length);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            resp = this.getResponse((byte)68);
            if (resp != null) {
                this.handleResp(resp, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return error.getErrorCode();
    }

    @Override
    public byte[] read14443A(int block, Error error) {
        byte[] data = null;
        byte[] content = this.fillContent((byte)0, (byte)18, new byte[]{-27, (byte)block}, 2);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] resp = this.getResponse((byte)68);
            if (resp != null) {
                data = this.handleResp(resp, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return data;
    }

    @Override
    public int write14443A(byte[] writeData, int block, Error error) {
        byte[] contentData = new byte[2 + writeData.length];
        contentData[0] = -26;
        contentData[1] = (byte)block;
        System.arraycopy(writeData, 0, contentData, 2, writeData.length);
        byte[] content = this.fillContent((byte)0, (byte)0, contentData, contentData.length);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] resp = this.getResponse((byte)68);
            if (resp != null) {
                this.handleResp(resp, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return error.getErrorCode();
    }

    private void init15693(Error error) {
        byte[] byArray = new byte[3];
        byArray[0] = -48;
        byArray[2] = -128;
        byte[] content = this.fillContent((byte)0, (byte)4, byArray, 3);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] resp = this.getResponse((byte)68);
            if (resp != null) {
                this.handleResp(resp, error);
            }
        } else {
            error.setErrorCode(-2);
        }
    }

    private void deinit15693(Error error) {
        byte[] byArray = new byte[2];
        byArray[0] = -33;
        byte[] content = this.fillContent((byte)0, (byte)0, byArray, 2);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] resp = this.getResponse((byte)68);
            if (resp != null) {
                this.handleResp(resp, error);
            }
        } else {
            error.setErrorCode(-2);
        }
    }

    @Override
    public List<Iso15693InventoryInfo> findCard15693(Error error) {
        this.deinit15693(error);
        this.init15693(error);
        ArrayList<Iso15693InventoryInfo> listInfo = new ArrayList<Iso15693InventoryInfo>();
        byte[] content = this.fillContent((byte)0, (byte)-1, new byte[]{-46}, 1);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] data;
            byte[] resp = this.getResponse((byte)68);
            if (resp != null && (data = this.handleResp(resp, error)) != null) {
                int cardCount = data[0] & 0xFF;
                while (cardCount > 0) {
                    Iso15693InventoryInfo info = new Iso15693InventoryInfo();
                    info.setFlag(data[10 * (cardCount - 1) + 1]);
                    info.setDsfid(data[10 * (cardCount - 1) + 2]);
                    byte[] uid = new byte[8];
                    System.arraycopy(data, 10 * (cardCount - 1) + 3, uid, 0, 8);
                    --cardCount;
                    info.setUid(uid);
                    listInfo.add(info);
                }
            }
        } else {
            error.setErrorCode(-2);
        }
        return listInfo;
    }

    @Override
    public Iso15693CardInformation getInformation15693(byte[] uid, int flag, Error error) {
        Iso15693CardInformation info = null;
        byte[] contentData = new byte[2 + uid.length];
        contentData[0] = -42;
        contentData[1] = (byte)flag;
        System.arraycopy(uid, 0, contentData, 2, uid.length);
        byte[] content = this.fillContent((byte)0, (byte)15, contentData, contentData.length);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] data;
            byte[] resp = this.getResponse((byte)68);
            if (resp != null && (data = this.handleResp(resp, error)) != null) {
                info = new Iso15693CardInformation();
                info.setFlag(data[0]);
                info.setInformationFlag(data[1]);
                byte[] mUid = new byte[8];
                System.arraycopy(data, 2, mUid, 0, 8);
                info.setUid(mUid);
                info.setDsfid(data[10]);
                info.setAfi(data[11]);
                info.setBlocksCount(data[12]);
                info.setBlockLen(data[13]);
                info.setIC_reference(data[14]);
            }
        } else {
            error.setErrorCode(-2);
        }
        return info;
    }

    @Override
    public byte[] readSingleBlock15693(byte[] uid, int flag, int block, Error error) {
        byte[] readData = null;
        byte[] contentData = new byte[3 + uid.length];
        contentData[0] = -41;
        contentData[1] = (byte)flag;
        System.arraycopy(uid, 0, contentData, 2, uid.length);
        contentData[2 + uid.length] = (byte)block;
        byte[] content = this.fillContent((byte)0, (byte)40, contentData, contentData.length);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] data;
            byte[] resp = this.getResponse((byte)68);
            if (resp != null && (data = this.handleResp(resp, error)) != null) {
                readData = new byte[4];
                System.arraycopy(data, 1, readData, 0, 4);
            }
        } else {
            error.setErrorCode(-2);
        }
        return readData;
    }

    @Override
    public int writeSingleBlock(byte[] uid, int flag, int block, byte[] writeData, Error error) {
        byte[] contentData = new byte[3 + uid.length + writeData.length];
        contentData[0] = -40;
        contentData[1] = (byte)flag;
        System.arraycopy(uid, 0, contentData, 2, uid.length);
        contentData[2 + uid.length] = (byte)block;
        System.arraycopy(writeData, 0, contentData, 3 + uid.length, writeData.length);
        byte[] content = this.fillContent((byte)0, (byte)2, contentData, contentData.length);
        byte[] cmd = this.genPackage((byte)68, content, content.length);
        if (this.sendCMD(cmd)) {
            byte[] resp = this.getResponse((byte)68);
            if (resp != null) {
                byte[] byArray = this.handleResp(resp, error);
            }
        } else {
            error.setErrorCode(-2);
        }
        return error.getErrorCode();
    }

    public void Close() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.serialPort != null) {
            this.serialPort.close(Port);
            switch (Power) {
                case 2: {
                    this.serialPort.scaner_poweroff();
                    break;
                }
                case 0: {
                    this.serialPort.power_3v3off();
                    break;
                }
                case 1: {
                    this.serialPort.power_5Voff();
                    break;
                }
                case 3: {
                    this.serialPort.psam_poweroff();
                    break;
                }
                case 4: {
                    this.serialPort.rfid_poweroff();
                }
            }
        }
    }
}

