/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.Fingerprint;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.util.Log;
import cn.pda.serialport.SerialPort;
import cn.pda.serialport.Tools;
import com.za.android060;
import java.io.DataOutputStream;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;

public class FingerprintManager {
    private Context context;
    private android060 a6 = new android060();
    int DEV_ADDR = -1;
    private int defDeviceType = 5;
    private int IMG_SIZE = 0;
    private char[] pPassword = new char[4];
    private SerialPort mSerialport;
    long time = 0L;

    public boolean Open(boolean isRoot, Context context) {
        this.context = context;
        this.mSerialport = new SerialPort();
        this.mSerialport.rfid_poweron();
        this.mSerialport.power_5Von();
        this.mSerialport.setGPIOlow(141);
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int status = 0;
        if (isRoot) {
            this.LongDunD8800_CheckEuq();
            Log.e((String)"defDeviceType", (String)"defDeviceType...");
            status = this.a6.ZAZOpenDeviceEx(-1, this.defDeviceType, 0, 0, 0, 0);
            status = status == 1 && this.a6.ZAZVfyPwd(this.DEV_ADDR, this.pPassword) == 0 ? 1 : 0;
            this.a6.ZAZSetImageSize(this.IMG_SIZE);
            return status == 1;
        }
        this.time = System.currentTimeMillis();
        int fd = this.getrwusbdevices();
        Log.e((String)"fd", (String)(String.valueOf(fd) + ":" + (System.currentTimeMillis() - this.time)));
        status = this.a6.ZAZOpenDeviceEx(fd, this.defDeviceType, 0, 0, 0, 0);
        Log.e((String)"status", (String)(String.valueOf(status) + ":" + (System.currentTimeMillis() - this.time)));
        status = status == 1 && this.a6.ZAZVfyPwd(this.DEV_ADDR, this.pPassword) == 0 ? 1 : 0;
        this.a6.ZAZSetImageSize(this.IMG_SIZE);
        return status == 1;
    }

    public byte[] GetChara() {
        int nRet = this.a6.ZAZGetImage(this.DEV_ADDR);
        if (nRet == this.a6.PS_OK) {
            this.a6.getClass();
            nRet = this.a6.ZAZGenChar(this.DEV_ADDR, 1);
            if (nRet == this.a6.PS_OK) {
                int[] iTempletLength = new int[2];
                byte[] pTemplet = new byte[512];
                this.a6.getClass();
                nRet = this.a6.ZAZUpChar(this.DEV_ADDR, 1, pTemplet, iTempletLength);
                if (nRet == this.a6.PS_OK) {
                    Log.e((String)"", (String)Tools.Bytes2HexString(pTemplet, pTemplet.length));
                    return pTemplet;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public int MatchFingerprint(byte[] chara_1, byte[] chara_2) {
        this.a6.getClass();
        int nRet = this.a6.ZAZDownChar(this.DEV_ADDR, 1, chara_1, chara_1.length);
        if (nRet == this.a6.PS_OK) {
            int[] iScore;
            this.a6.getClass();
            nRet = this.a6.ZAZDownChar(this.DEV_ADDR, 2, chara_2, chara_2.length);
            if (nRet == this.a6.PS_OK && (nRet = this.a6.ZAZMatch(this.DEV_ADDR, iScore = new int[10])) == this.a6.PS_OK) {
                return iScore[0];
            }
        }
        return 0;
    }

    public boolean DetectFinger() {
        return this.GetChara() != null;
    }

    public Bitmap GetFingerprintImage() {
        int nRet = 0;
        nRet = this.a6.ZAZGetImage(this.DEV_ADDR);
        if (nRet == 0) {
            int[] len = new int[2];
            char[] Image = new char[73728];
            this.a6.ZAZUpImage(this.DEV_ADDR, Image, len);
            String str = "/mnt/sdcard/fingerprint.bmp";
            this.a6.ZAZImgData2BMP(Image, str);
            Bitmap bmpDefaultPic = BitmapFactory.decodeFile((String)str, null);
            return bmpDefaultPic;
        }
        return null;
    }

    public int SearchFingerprint(byte[] chara) {
        int[] id_iscore = new int[1];
        this.a6.getClass();
        int nRet = this.a6.ZAZDownChar(this.DEV_ADDR, 1, chara, chara.length);
        if (nRet == this.a6.PS_OK) {
            this.a6.getClass();
            nRet = this.a6.ZAZHighSpeedSearch(this.DEV_ADDR, 1, 0, 1000, id_iscore);
            if (nRet == this.a6.PS_OK) {
                return id_iscore[0];
            }
        }
        return -1;
    }

    public int GetFreeAddress() {
        int[] iMbNum = new int[10];
        int mRet = this.a6.ZAZTemplateNum(this.DEV_ADDR, iMbNum);
        if (mRet == this.a6.PS_OK) {
            return iMbNum[0];
        }
        return -1;
    }

    public boolean EmptyAllChara() {
        int mRet = this.a6.ZAZEmpty(this.DEV_ADDR);
        return mRet == this.a6.PS_OK;
    }

    public boolean EmptyChara(int addressID) {
        int ret = this.a6.ZAZDelChar(this.DEV_ADDR, addressID, 1);
        return ret == 0;
    }

    public int RegisterFingerprint(byte[] chara_1, byte[] chara_1_more, int min_score) {
        int nextAddress = this.GetFreeAddress();
        int rets = this.MatchFingerprint(chara_1, chara_1_more);
        if (rets < min_score) {
            return -1;
        }
        int nRet = this.a6.ZAZStoreChar(this.DEV_ADDR, 1, nextAddress);
        if (nRet == 0) {
            return nextAddress;
        }
        return -2;
    }

    public boolean Close() {
        byte[] tmp = new byte[]{5, 6, 7};
        int status = this.a6.ZAZCloseDeviceEx();
        if (this.mSerialport != null) {
            this.mSerialport.setGPIOhigh(141);
            this.mSerialport.rfid_poweroff();
            this.mSerialport.power_5Voff();
        }
        return status == 1;
    }

    private int getrwusbdevices() {
        UsbManager mUsbManager = (UsbManager)this.context.getSystemService("usb");
        String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
        HashMap deviceList = mUsbManager.getDeviceList();
        Iterator deviceIterator = deviceList.values().iterator();
        PendingIntent mPermissionIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent("com.android.example.USB_PERMISSION"), (int)0);
        IntentFilter filter = new IntentFilter("com.android.example.USB_PERMISSION");
        BroadcastReceiver mUsbReceiver = null;
        this.context.registerReceiver(mUsbReceiver, filter);
        int fd = -1;
        while (deviceIterator.hasNext()) {
            UsbDevice device = (UsbDevice)deviceIterator.next();
            if (device.getVendorId() != 8457 || 30264 != device.getProductId()) continue;
            mUsbManager.requestPermission(device, mPermissionIntent);
            while (!mUsbManager.hasPermission(device)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!mUsbManager.hasPermission(device)) break;
            if (mUsbManager.openDevice(device) != null) {
                fd = mUsbManager.openDevice(device).getFileDescriptor();
                return fd;
            }
            mUsbManager.openDevice(device).close();
            break;
        }
        return 0;
    }

    private int LongDunD8800_CheckEuq() {
        Process process = null;
        DataOutputStream os = null;
        String path = "/dev/bus/usb/00*/*";
        String path1 = "/dev/bus/usb/00*/*";
        File fpath = new File(path);
        Log.d((String)"*** LongDun D8800 ***", (String)(" check path:" + path));
        String command = "chmod 777 " + path;
        String command1 = "chmod 777 " + path1;
        Log.d((String)"*** LongDun D8800 ***", (String)(" exec command:" + command));
        try {
            process = Runtime.getRuntime().exec("su");
            os = new DataOutputStream(process.getOutputStream());
            os.writeBytes(String.valueOf(command) + "\n");
            os.writeBytes("exit\n");
            os.flush();
            process.waitFor();
            return 1;
        }
        catch (Exception e) {
            Log.d((String)"*** DEBUG ***", (String)("Unexpected error - Here is what I know: " + e.getMessage()));
            return 0;
        }
    }
}

