/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.UHFLonger;

import android.util.Log;
import com.BRMicro.SerialPort;
import com.rfid.uhf.IUhfreader;
import com.uhf.api.cls.Reader;
import java.util.ArrayList;
import java.util.List;

public class UHFLongerManager
implements IUhfreader {
    private Reader reader;
    private SerialPort mSerialport;
    private static UHFLongerManager manager;
    public static final int MEMBANK_RESEVER = 0;
    public static final int MEMBANK_EPC = 1;
    public static final int MEMBANK_TID = 2;
    public static final int MEMBANK_USER = 3;
    public static final int LOCK_MEM_KILL = 0;
    public static final int LOCK_MEM_ACCESS = 1;
    public static final int LOCK_MEM_EPC = 2;
    public static final int LOCK_MEM_TID = 3;
    public static final int LOCK_MEM_USER = 4;
    public static final int UNLOCK = 0;
    public static final int LOCK_PSD = 2;
    public static final int LOCK_PERM = 4;
    private static String serialportPath;
    public static int port;
    private int[] ants = new int[]{1};
    private short timeout = (short)50;
    private int[] tagcnt = new int[1];
    private int ant = 1;
    private short WRtimeout = (short)1000;

    static {
        serialportPath = "/dev/ttyMT1";
        port = 13;
    }

    public UHFLongerManager(String serialPath, int port) throws Exception {
        this.reader = new Reader();
        this.mSerialport = new SerialPort();
        this.mSerialport.zigbeepoweron();
        this.mSerialport.rfidPoweron();
        this.mSerialport.switch2Channel(port);
        Reader.READER_ERR er = this.reader.InitReader_Notype(serialPath, 1);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            throw new Exception("init device fail");
        }
    }

    public static UHFLongerManager getInstance() throws Exception {
        if (manager == null) {
            manager = new UHFLongerManager(serialportPath, port);
        }
        return manager;
    }

    @Override
    public void close() {
        this.debugLog("close()");
        if (manager != null) {
            manager = null;
            this.reader.CloseReader();
            this.mSerialport.zigbeepoweroff();
            this.mSerialport.rfidPoweroff();
        }
    }

    @Override
    public List<String> inventoryRealTime() {
        ArrayList<String> list = null;
        Reader.READER_ERR er = this.reader.TagInventory_Raw(this.ants, this.ants.length, this.timeout, this.tagcnt);
        if (er == Reader.READER_ERR.MT_OK_ERR && this.tagcnt[0] > 0) {
            list = new ArrayList<String>();
            int i = 0;
            while (i < this.tagcnt[0]) {
                Reader.TAGINFO tagInfo = new Reader.TAGINFO(this.reader);
                er = this.reader.GetNextTag(tagInfo);
                if (er == Reader.READER_ERR.MT_OK_ERR) {
                    list.add(Reader.bytes_Hexstr((byte[])tagInfo.EpcId));
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public void open(String serial, int port) {
    }

    @Override
    public boolean selectEPC(byte[] epc) {
        Reader.TagFilter_ST tfst = new Reader.TagFilter_ST(this.reader);
        tfst.bank = 1;
        tfst.fdata = epc;
        tfst.flen = epc.length;
        tfst.isInvert = 0;
        tfst.startaddr = 32;
        Reader.READER_ERR er = this.reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)tfst);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    @Override
    public boolean clearSelect() {
        Reader.READER_ERR er = this.reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
        return false;
    }

    @Override
    public byte[] readData(int memBank, int start, int length, byte[] password) {
        byte[] data = new byte[2 * length];
        Reader.READER_ERR er = this.reader.GetTagData(this.ant, (char)memBank, start, length, data, password, this.WRtimeout);
        if (er == Reader.READER_ERR.MT_OK_ERR) {
            return data;
        }
        return null;
    }

    private void debugLog(String msg) {
        Log.e((String)"UHF READER", (String)msg);
    }

    @Override
    public boolean writeData(int memBank, int start, byte[] password, byte[] wData) {
        Reader.READER_ERR er = this.reader.WriteTagData(this.ant, (char)memBank, start, wData, wData.length, password, this.WRtimeout);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    @Override
    public boolean writeEPC(byte[] newEPC, byte[] password) {
        Reader.READER_ERR er = this.reader.WriteTagEpcEx(this.ant, newEPC, newEPC.length, password, this.WRtimeout);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    @Override
    public boolean writeAccess(byte[] newAccess, byte[] oldAccess) {
        Reader.READER_ERR er = this.reader.WriteTagData(this.ant, '\u0000', 2, newAccess, newAccess.length, oldAccess, this.WRtimeout);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    @Override
    public boolean writeKillPsd(byte[] newKill, byte[] access) {
        Reader.READER_ERR er = this.reader.WriteTagData(this.ant, '\u0000', 0, newKill, newKill.length, access, this.WRtimeout);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    @Override
    public boolean lockTag(int lockType, int lockMem, byte[] access) {
        Reader.Lock_Obj lockobj = Reader.Lock_Obj.LOCK_OBJECT_ACCESS_PASSWD;
        Reader.Lock_Type mlocktype = Reader.Lock_Type.ACCESS_PASSWD_UNLOCK;
        switch (lockMem) {
            case 1: {
                lockobj = Reader.Lock_Obj.LOCK_OBJECT_ACCESS_PASSWD;
                if (lockType == 4) {
                    mlocktype = Reader.Lock_Type.ACCESS_PASSWD_PERM_LOCK;
                    break;
                }
                if (lockType == 2) {
                    mlocktype = Reader.Lock_Type.ACCESS_PASSWD_LOCK;
                    break;
                }
                mlocktype = Reader.Lock_Type.ACCESS_PASSWD_UNLOCK;
                break;
            }
            case 0: {
                lockobj = Reader.Lock_Obj.LOCK_OBJECT_KILL_PASSWORD;
                if (lockType == 4) {
                    mlocktype = Reader.Lock_Type.KILL_PASSWORD_PERM_LOCK;
                    break;
                }
                if (lockType == 2) {
                    mlocktype = Reader.Lock_Type.KILL_PASSWORD_LOCK;
                    break;
                }
                mlocktype = Reader.Lock_Type.KILL_PASSWORD_UNLOCK;
                break;
            }
            case 2: {
                lockobj = Reader.Lock_Obj.LOCK_OBJECT_BANK1;
                if (lockType == 4) {
                    mlocktype = Reader.Lock_Type.BANK1_PERM_LOCK;
                    break;
                }
                if (lockType == 2) {
                    mlocktype = Reader.Lock_Type.BANK1_LOCK;
                    break;
                }
                mlocktype = Reader.Lock_Type.BANK1_UNLOCK;
                break;
            }
            case 3: {
                lockobj = Reader.Lock_Obj.LOCK_OBJECT_BANK2;
                if (lockType == 4) {
                    mlocktype = Reader.Lock_Type.BANK2_PERM_LOCK;
                    break;
                }
                if (lockType == 2) {
                    mlocktype = Reader.Lock_Type.BANK2_LOCK;
                    break;
                }
                mlocktype = Reader.Lock_Type.BANK2_UNLOCK;
                break;
            }
            case 4: {
                lockobj = Reader.Lock_Obj.LOCK_OBJECT_BANK3;
                mlocktype = lockType == 4 ? Reader.Lock_Type.BANK3_PERM_LOCK : (lockType == 2 ? Reader.Lock_Type.BANK3_LOCK : Reader.Lock_Type.BANK3_UNLOCK);
            }
        }
        Reader.READER_ERR er = this.reader.LockTag(this.ant, (byte)lockobj.value(), (short)mlocktype.value(), access, this.WRtimeout);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }

    @Override
    public boolean setOutPower(short value) {
        Reader.AntPowerConf apcf = new Reader.AntPowerConf(this.reader);
        apcf.antcnt = 1;
        Reader.AntPower jaap = new Reader.AntPower(this.reader);
        jaap.antid = 1;
        jaap.readPower = (short)(value * 100);
        jaap.writePower = (short)(value * 100);
        apcf.Powers[0] = jaap;
        Reader.READER_ERR er = this.reader.ParamSet(Reader.Mtr_Param.MTR_PARAM_RF_ANTPOWER, (Object)apcf);
        return er == Reader.READER_ERR.MT_OK_ERR;
    }
}

