package com.pda.scan1dserver;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import android.app.Activity;
import android.app.AlertDialog.Builder;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {
	
	private LinearLayout mMainContainer;
	private ScanConfig scanConfig;
	private Switch openSwitch;
	private Spinner spinnerPrefix;
	private Spinner spinnerSurfix;
	private CheckBox checkVoice;
	private CheckBox checkF1;
	private CheckBox checkF2;
	private CheckBox checkF3;
	private CheckBox checkF4;

	private CheckBox checkF5;
	private CheckBox checkF6;
	private CheckBox checkF7;
	private TextView tvPrefix;
	private TextView tvSurfix;

	private String tabStr;
	private String spaceStr;
	private String enterStr;
	private String noneStr;
	private String otherStr;
	private String tabAndEnterStr;
	private String[] fixArray;
//	private String[] fixArray2;
	private boolean mCreatePurSelect = true;
	private boolean mCreateSurSelect = true;

	private Dialog dialogLoading;
	private Dialog dialogOther;

	/**
	 * ǩ
	 */
	public static final String FLAG_OPEN_SUCCESS = "open_success";
	public static final String FLAG_OPEN_FAIL = "open_fail";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		scanConfig = new ScanConfig(this);
		initView();
	}

	private void initView() {
		mMainContainer = (LinearLayout)findViewById(R.id.main_container);
		tabStr = getResources().getString(R.string.tab);
		spaceStr = getResources().getString(R.string.space);
		enterStr = getResources().getString(R.string.enter);
		noneStr = getResources().getString(R.string.none);
		otherStr = getResources().getString(R.string.other);
		tabAndEnterStr = getResources().getString(R.string.tabAndEnter);
		fixArray = new String[] { tabStr, spaceStr, enterStr, noneStr, otherStr, tabAndEnterStr};
//		fixArray2 = new String[] { "\t", " ", "0A0D", "", "\t0A0D"};
		tvPrefix = (TextView) findViewById(R.id.text_prefix);
		tvSurfix = (TextView) findViewById(R.id.text_surfix);

		openSwitch = (Switch) findViewById(R.id.switch_scan);
		spinnerPrefix = (Spinner) findViewById(R.id.spinner_prefix);
		spinnerSurfix = (Spinner) findViewById(R.id.spinner_surfix);
		checkVoice = (CheckBox) findViewById(R.id.checkBox_voice);
		checkF1 = (CheckBox) findViewById(R.id.checkBox_f1);
		checkF2 = (CheckBox) findViewById(R.id.checkBox_f2);
		checkF3 = (CheckBox) findViewById(R.id.checkBox_f3);
		checkF4 = (CheckBox) findViewById(R.id.checkBox_f4);
		checkF5 = (CheckBox) findViewById(R.id.checkBox_f5);
		checkF6 = (CheckBox) findViewById(R.id.checkBox_f6);
		checkF7 = (CheckBox) findViewById(R.id.checkBox_f7);

//		String surfix = scanConfig.getSurfix();
//		String prefix = scanConfig.getPrefix();
		int surfixIndex = scanConfig.getSurfixIndex();
		int prefixIndex = scanConfig.getPrefixIndex();
//		for (int i = 0; i < fixArray2.length; i++) {
//			if (surfix.equals(fixArray2[i])) {
//				surfixIndex = i;
//			}
//			if (prefix.equals(fixArray2[i])) {
//				prefixIndex = i;
//			}
//		}
//		if (surfixIndex == 3 && !surfix.equals("")) {
//			surfixIndex = 4;
//		}
//		if (prefixIndex == 3 && !prefix.equals("")) {
//			prefixIndex = 4;
//		}
		spinnerPrefix.setAdapter(new ArrayAdapter<String>(this, android.R.layout.simple_spinner_dropdown_item, fixArray));
		spinnerPrefix.setSelection(prefixIndex);
		if (prefixIndex == 4) {
			tvPrefix.setText(scanConfig.getPrefix());
		}
		spinnerSurfix.setAdapter(new ArrayAdapter<String>(this, android.R.layout.simple_spinner_dropdown_item, fixArray));
		spinnerSurfix.setSelection(surfixIndex);
		if (surfixIndex == 4) {
			tvSurfix.setText(scanConfig.getSurfix());
		}
		// set key
		checkF1.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF1(isChecked);
			}
		});

		checkF2.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF2(isChecked);
			}
		});
		checkF3.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF3(isChecked);
			}
		});
		checkF4.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF4(isChecked);
			}
		});

		checkF5.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF5(isChecked);
			}
		});
		checkF6.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF6(isChecked);
			}
		});
		checkF7.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setF7(isChecked);
			}
		});
		checkVoice.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setVoice(isChecked);
			}
		});

		// open dev
		openSwitch.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				// open scan
				if (isChecked) {
					boolean open = scanConfig.isOpen();
					if (open) {
						return;
					}
					createLoaddingDialog();
					Intent toService = new Intent(MainActivity.this, Scan1DService.class);
					toService.addFlags(1693);
					startService(toService);
				} else {
					Intent toKill = new Intent();
					toKill.setAction("android.rfid.KILL_SERVER");
					toKill.putExtra("kill", true);
					sendBroadcast(toKill);
				}
				scanConfig.setOpen(isChecked);

			}
		});

		// prefix
		spinnerPrefix.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
				if (mCreatePurSelect) {
					mCreatePurSelect = false;
					return;
				}
				// try {
				// Field field = AdapterView.class.getDeclaredField("mOldSelectedPosition");
				// field.setAccessible(true); //mOldSelectedPositionɷ
				// field.setInt(spinnerPrefix, AdapterView.INVALID_POSITION);
				// //mOldSelectedPositionֵ
				// } catch (Exception e) {
				// e.printStackTrace();
				// }
				if (fixArray[position].equals(tabStr)) {
					scanConfig.setPrefix("\t");
					scanConfig.setPrefixIndex(position);
					tvPrefix.setText("");
				} else if (fixArray[position].equals(spaceStr)) {
					scanConfig.setPrefix(" ");
					tvPrefix.setText("");
					scanConfig.setPrefixIndex(position);
				} else if (fixArray[position].equals(enterStr)) {
					scanConfig.setPrefix("0A0D");
					tvPrefix.setText("");
					scanConfig.setPrefixIndex(position);
				} else if (fixArray[position].equals(noneStr)) {
					scanConfig.setPrefix("");
					tvPrefix.setText("");
					scanConfig.setPrefixIndex(position);
				} else if (fixArray[position].equals(tabAndEnterStr)) {
					scanConfig.setPrefix("\t0A0D");
					tvPrefix.setText("");
					scanConfig.setPrefixIndex(position);
				} else if (fixArray[position].equals(otherStr)) {
					// dialog input prefix char
					createOtherDialog(position, true);
				}
			}

			@Override
			public void onNothingSelected(AdapterView<?> parent) {
				Log.e("nothing selected", "");

			}
		});

		// surfix
		spinnerSurfix.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
				if (mCreateSurSelect) {
					mCreateSurSelect = false;
					return;
				}
				if (fixArray[position].equals(tabStr)) {
					scanConfig.setSurfix("\t");
					scanConfig.setSurfixIndex(position);
					tvSurfix.setText("");
				} else if (fixArray[position].equals(spaceStr)) {
					scanConfig.setSurfix(" ");
					scanConfig.setSurfixIndex(position);
					tvSurfix.setText("");
				} else if (fixArray[position].equals(enterStr)) {
					scanConfig.setSurfix("0A0D");
					scanConfig.setSurfixIndex(position);
					tvSurfix.setText("");
				} else if (fixArray[position].equals(noneStr)) {
					scanConfig.setSurfix("");
					scanConfig.setSurfixIndex(position);
					tvSurfix.setText("");
				} else if (fixArray[position].equals(tabAndEnterStr)) {
					scanConfig.setSurfix("\t0A0D");
					scanConfig.setSurfixIndex(position);
					tvSurfix.setText("");
				} else if (fixArray[position].equals(otherStr)) {
					// dialog input surfix char
					createOtherDialog(position, false);
				}
			}

			@Override
			public void onNothingSelected(AdapterView<?> parent) {
				// TODO Auto-generated method stub

			}
		});

		openSwitch.setChecked(scanConfig.isOpen());
		checkF1.setChecked(scanConfig.isF1());
		checkF2.setChecked(scanConfig.isF2());
		checkF3.setChecked(scanConfig.isF6());
		checkF4.setChecked(scanConfig.isF7());
		checkF5.setChecked(scanConfig.isF4());
		checkF6.setChecked(scanConfig.isF3());
		checkF7.setChecked(scanConfig.isF5());
		checkVoice.setChecked(scanConfig.isVoice());

	}

	@Override
	protected void onStart() {
		// ע EventBus
		// ж Eventbus Ƿע
		if (!EventBus.getDefault().isRegistered(this)) {
			EventBus.getDefault().register(this);
		}
		super.onStart();
	}

	@Override
	protected void onStop() {
		// ע
		if (EventBus.getDefault().isRegistered(this)) {
			EventBus.getDefault().unregister(this);
		}
		super.onStop();
	}

	@Subscribe(threadMode = ThreadMode.MAIN)
	public void onMessageEvent(final String result) {
		try {
			Thread.sleep(200);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		if (FLAG_OPEN_SUCCESS.equals(result)) {
			showToast(getString(R.string.init_success));
		} else if (FLAG_OPEN_FAIL.equals(result)) {
			showToast(getString(R.string.init_success));
		}
		dialogLoading.cancel();
	};

	// show toast
	private Toast mToast;

	private void showToast(String content) {
		if (mToast == null) {
			mToast = Toast.makeText(MainActivity.this, content, Toast.LENGTH_SHORT);
		} else {
			mToast.setText(content);
		}
		mToast.setGravity(Gravity.CENTER, 0, 0);
		mToast.show();
	}

	// create loading dialog
	private void createLoaddingDialog() {
		Builder builder = new Builder(this);
		View view = LayoutInflater.from(this).inflate(R.layout.dialog_loading, mMainContainer, false);
		builder.setView(view);
		dialogLoading = builder.create();
		dialogLoading.setCancelable(false);
		dialogLoading.show();
	}

	private EditText editUserChar;

	private void createOtherDialog(final int position, final boolean isPrefix) {
		// Input the customized Char
		Builder builder = new Builder(this);
		View view = LayoutInflater.from(this).inflate(R.layout.dialog_others, mMainContainer, false);
		editUserChar = (EditText) view.findViewById(R.id.editText_others);
		builder.setView(view);
		builder.setTitle(getResources().getString(R.string.user_char));
		builder.setNegativeButton(getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int surfixIndex = scanConfig.getSurfixIndex();
				int prefixIndex = scanConfig.getPrefixIndex();
				spinnerSurfix.setSelection(surfixIndex);
				spinnerPrefix.setSelection(prefixIndex);
				dialogOther.cancel();
			}
		});
		builder.setPositiveButton(getResources().getString(R.string.ok), new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				String userChar = editUserChar.getText().toString();
				if (isPrefix) {
					tvPrefix.setText(userChar);
					scanConfig.setPrefix(userChar);
					scanConfig.setPrefixIndex(position);
				} else {
					tvSurfix.setText(userChar);
					scanConfig.setSurfix(userChar);
					scanConfig.setSurfixIndex(position);
				}
				dialogOther.cancel();
			}
		});
		builder.setCancelable(false);

		dialogOther = builder.create();
		// dialogOther.setCancelable(false) ;
		dialogOther.show();
	}
}
