package cn.pda.scan;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;

import org.greenrobot.eventbus.EventBus;

import com.pda.scan1dserver.MainActivity;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import cn.pda.serialport.SerialPort;
import cn.pda.serialport.Tools;

public class ScanThread extends Thread {

	private SerialPort mSerialPort;
	private InputStream is;
	private OutputStream os;
	/* serialport parameter */
	private int port = 0;
	private int baudrate = 9600;
	private int flags = 0;

	private Handler handler;

	public static int SCAN = 1001; // messege recv mode
	public static int SWITCH_INPUT = 1002;

	/**
	 * if throw exception, serialport initialize fail.
	 * 
	 * @throws SecurityException
	 * @throws IOException
	 */
	public ScanThread(Handler handler) throws SecurityException, IOException {
		try {
			Log.e("Huang", "ScanThread >>>>>> new！");
			this.handler = handler;
			mSerialPort = new SerialPort(port, baudrate, flags);

			is = mSerialPort.getInputStream();
			os = mSerialPort.getOutputStream();
			// mSerialPort.scaner_trigoff();
			mSerialPort.scaner_poweron();
			Thread.sleep(500);
			mSerialPort.scaner_trigoff();
			/** clear useless data **/
			byte[] temp = new byte[128];
			is.read(temp);
		} catch (InterruptedException e) {
			e.printStackTrace();
			// 通知主界面，设备打开失败
			EventBus.getDefault().post(MainActivity.FLAG_OPEN_FAIL);
		}
	}

	public void stopScan() {
		if (mSerialPort.scaner_trig_stat() == true) {
			mSerialPort.scaner_trigoff();
		}
	}

	@Override
	public void run() {
		try {
			Log.e("Huang", "ScanThread >>>>>> run！");
			int size = 0;
			byte[] buffer = new byte[4096];
			int available = 0;
			EventBus.getDefault().post(MainActivity.FLAG_OPEN_SUCCESS);
			while (!isInterrupted()) {
				available = is.available();
				if (available > 0) {
					try {
						Thread.sleep(30);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					size = is.read(buffer);
					if (size > 0) {
						sendMessege(buffer, size, SCAN);
						if (mtimer != null) {
							mtimer.cancel();
						}
					}
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		super.run();
	}

	private void sendMessege(byte[] data, int dataLen, int mode) {
		String dataStr = "";
		if (data != null && dataLen > 0) {
			try {
				dataStr = new String(data, 0, dataLen, "UTF-8");
				Log.e("Huang", "data >>>>>> " + Arrays.toString(data));
//				dataStr = Tools.Bytes2HexString(data, dataLen);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		byte[] temp = dataStr.getBytes();
		if (temp.length == 0) {
			Message msg = new Message();
			msg.what = mode;
			handler.sendMessage(msg);
			return;
		}
		Log.e("", Tools.Bytes2HexString(temp, temp.length));
		if (temp[temp.length - 1] == 0x0a || temp[temp.length - 1] == 0x0d) {
			if (temp[temp.length - 2] == 0x0d) {
				dataStr = new String(temp, 0, temp.length - 2);
			} else {
				dataStr = new String(temp, 0, temp.length - 1);
			}
		}
		Bundle bundle = new Bundle();
		bundle.putString("data", dataStr);
		Message msg = new Message();
		msg.what = mode;
		msg.setData(bundle);
		handler.sendMessage(msg);
		mSerialPort.scaner_trigoff();
		// }

	}

	Timer mtimer = null;

	public void scan() {
		mSerialPort.scaner_poweron();
		try {
			Thread.sleep(10);
		} catch (Exception e) {

		}

		if (mtimer != null) {
			mtimer.cancel();
		}
//		mtimer = new Timer();
//		mtimer.schedule(new TimerTask() {
//
//			@Override
//			public void run() {
//				mSerialPort.scaner_trigoff();
//				sendMessege(null, 0, SWITCH_INPUT);
//			}
//		}, 3000);
		if (mSerialPort.scaner_trig_stat() == true) {
			mSerialPort.scaner_trigoff();
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			return;
		}
		mSerialPort.scaner_trigon();
	}

	public void close() {
		Log.e("Huang", "ScanThread >>>>>> close！");
		if (mSerialPort != null) {
			mSerialPort.scaner_poweroff();
			try {
				if (is != null) {
					is.close();
				}
				if (os != null) {
					os.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
			mSerialPort.close(port);
		}
	}

}
