package com.pda.scan1dserver;

import android.R.integer;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.KeyEvent;

public class KeyReceiver extends BroadcastReceiver {

	private String TAG = "KeyReceiver" ;
	private static boolean canScan = true;
	public static long scanTime = 0;
	@Override
	public void onReceive(Context context, Intent intent) {
		int keyCode = intent.getIntExtra("keyCode", 0) ;
		if (keyCode==0) keyCode = intent.getIntExtra("keycode", 0) ;
		boolean keyDown = intent.getBooleanExtra("keyDown", false) ;
		if (!keyDown)  keyDown = intent.getBooleanExtra("keydown", false) ;
		Log.e(TAG, "KEYcODE = " + keyCode + ", Down = " + keyDown);
		ScanConfig config = new ScanConfig(context) ;
		if(keyDown && config.isOpen()&& canScan &&System.currentTimeMillis()-scanTime>5000){
			scanTime = System.currentTimeMillis();
			canScan = false;
			Intent toService = new Intent(context, Scan1DService.class) ;
			switch (keyCode) {
			case KeyEvent.KEYCODE_F1:
				if(config.isF1()){
					context.startService(toService) ;	
				}
//				Intent toBack = new Intent() ;
//				toBack.setAction("android.rfid.INPUT") ;
//				toBack.putExtra("data", "-" ) ;
//				context.sendBroadcast(toBack) ;
				break;
			case KeyEvent.KEYCODE_F2:
				if(config.isF2()){
					context.startService(toService) ;	
				}
				break;
			case KeyEvent.KEYCODE_F3:
				if(config.isF3()){
					context.startService(toService) ;	
				}
				break;
			case KeyEvent.KEYCODE_F4:
				if(config.isF4()){
					context.startService(toService) ;	
				}
				break;
		case KeyEvent.KEYCODE_F5:
			if(config.isF4()){
				context.startService(toService) ;	
			}
			break;
		}
			
			
		}

		if (!keyDown) {
			canScan = true;
		}
//		Intent toActivity = new Intent(context, ConfigActivity.class) ;
//		toActivity.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK) ;
//		context.startActivity(toActivity) ;
	}

}
