package com.example.uhfservice;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;
public class UHFService extends Service {
	private static UHFThread uhfThread  = null;
	private ScanConfig config;
	private String prefixStr ;
	private String surfixStr ;
	private Handler handler = new Handler(){
		public void handleMessage(android.os.Message msg) {
			prefixStr = config.getPrefix() ;
			surfixStr = config.getSurfix() ;
			if(msg.what == UHFThread.UHF){
				String data = msg.getData().getString("data");
				 
				String count = msg.getData().getString("c");
//				Log.e("count", count);
				if(data != null){
					
					if("0A0D".equals(prefixStr)){
						sendToInput("", true) ;
					}else{
						sendToInput(prefixStr, false) ;
					}
					//input 
					sendToInput(data, false) ;
					//input prefix
					if("0A0D".equals(surfixStr)){
						sendToInput("", true) ;
					}else{
						sendToInput(surfixStr, false) ;
					}
					showToast(count);
					if (config.isVoice()) {
					Util.play(1, 0);
				}
				}
			}
		};
	};
	
	

	@Override
	public IBinder onBind(Intent arg0) {
		return null;
	}
	private Toast toast;
	private void showToast(String count){
		if (toast==null) {
			toast = Toast.makeText(UHFService.this, ""+count, Toast.LENGTH_SHORT);
		}else {
			toast.setText(count);
		}
		toast.show();
	}
	@Override
	public void onCreate() {
		config = new ScanConfig(UHFService.this);
		Util.initSoundPool(this);
		IntentFilter filter = new IntentFilter() ;
		filter.addAction("android.rfid.KILL_SERVER") ;
		registerReceiver(killReceiver, filter) ;
		SetScreenReceiver();
		super.onCreate();
		Log.e(TAG, "open");
	}
	@Override
	public void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
		unregisterReceiver(killReceiver) ;

		Log.e(TAG, "close");
	}
	private String TAG = "UHFService";
	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
    	if(uhfThread == null){
    		try {
    			uhfThread = new UHFThread(handler,UHFService.this);
    			uhfThread.start();
				Log.e("Start", "ScanThread start");
			}  catch (Exception e) {
				  Log.e("Start", "ScanThread error");
			}
    	}else {
    		uhfThread.scan();
		}
		return super.onStartCommand(intent, flags, startId);
	}
	public static void Close() {
		if (uhfThread!=null) {
			uhfThread.close();
			uhfThread = null;
		}
	}
	private void sendToInput(String data , boolean enterFlag){
		
		Intent toBack = new Intent() ;
		toBack.setAction("android.rfid.INPUT") ;
		toBack.putExtra("data", data ) ;
		toBack.putExtra("enter", enterFlag) ;
		sendBroadcast(toBack) ;
	}
private BroadcastReceiver killReceiver = new BroadcastReceiver() {
		
		@Override
		public void onReceive(Context context, Intent intent) {
			if(intent.getBooleanExtra("kill2", false)){
				UHFService.this.stopSelf() ;
			}
		}
	};
	//
	private void SetScreenReceiver(){
		IntentFilter mFilter = new IntentFilter();
		mFilter.addAction(Intent.ACTION_SCREEN_OFF);
		mFilter.addAction(Intent.ACTION_SCREEN_ON);
		registerReceiver(mScreenReceiver, mFilter);
	}
	private BroadcastReceiver mScreenReceiver = new BroadcastReceiver(){
		@Override
		public void onReceive(Context arg0, Intent intent) {
			String action = intent.getAction();
			if (action.equals(Intent.ACTION_SCREEN_ON)) {
				if(uhfThread == null){
		    		try {
		    			uhfThread = new UHFThread(handler,UHFService.this);
		    			uhfThread.start();
						Log.e("BroadcastReceiver", "ScanThread start");
					}  catch (Exception e) {
						  Log.e("BroadcastReceiver", "ScanThread error");
					}
		    	}
//				Log.e(TAG, "浜睆");
			}else if(Intent.ACTION_SCREEN_OFF.equals(action)){
				Log.e(TAG, "ACTION_SCREEN_OFF");
				if (uhfThread!=null) {
					uhfThread.close();
					uhfThread = null;
				}
			}
		}
		
	};

}
