package com.example.uhfservice;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
//config scan setting 
public class ScanConfig {
	
	private Context context ;
	
	public ScanConfig(Context context){
		this.context = context ;
	}

	public boolean isOpen() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("open", false);
	}

	public void setOpen(boolean open) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("open", open) ;
		editor.commit() ;
	}

	public String getPrefix() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getString("prefix", "");
	}

	public void setPrefix(String prefix) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putString("prefix", prefix) ;
		editor.commit() ;
	}
	public int getPrefixIndex() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getInt("prefixIndex", 3);
	}

	public void setPrefixIndex(int prefixIndex) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putInt("prefixIndex", prefixIndex) ;
		editor.commit() ;
	}

	public String getSurfix() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getString("surfix", "0A0D");
	}

	public void setSurfix(String surfix) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putString("surfix", surfix) ;
		editor.commit() ;
	}
	public int getSurfixIndex() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getInt("surfixIndex", 2);
	}

	public void setSurfixIndex(int surfixIndex) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putInt("surfixIndex", surfixIndex) ;
		editor.commit() ;
	}
	public boolean isVoice() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("voice", true);
	}

	public void setVoice(boolean voice) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("voice", voice) ;
		editor.commit() ;
	}
	public boolean isRepeat() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("repeat", false);
	}

	public void setRepeat(boolean repeat) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("repeat", repeat) ;
		editor.commit() ;
	}
	public boolean isCirculate() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("circulate", false);
	}

	public void setCirculate(boolean circulate) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("circulate", circulate) ;
		editor.commit() ;
	}
	public boolean isF1() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("f1", true);
	}

	public void setF1(boolean f1) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("f1", f1) ;
		editor.commit() ;
	}

	public boolean isF2() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("f2", true);
	}

	public void setF2(boolean f2) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("f2", f2) ;
		editor.commit() ;
	}

	public boolean isF3() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("f3", true);
	}

	public void setF3(boolean f3) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("f3", f3) ;
		editor.commit() ;
	}

	public boolean isF4() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("f4", true);
	}

	public void setF4(boolean f4) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("f4", f4) ;
		editor.commit() ;
	}
	public boolean isF5() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		return shared.getBoolean("f5", true);
	}

	public void setF5(boolean f5) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putBoolean("f5", f5) ;
		editor.commit() ;
	}
	public int getTime() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		
		return shared.getInt("time", 5);
	}

	public void setTime(int time) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putInt("time", time);
		editor.commit() ;
	}
	public int getPower() {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		
		return shared.getInt("power", 26);
	}

	public boolean setPower(int power) {
		SharedPreferences shared = context.getSharedPreferences("scanConfig", Context.MODE_PRIVATE) ;
		Editor editor = shared.edit() ;
		editor.putInt("power", power);
		editor.commit() ;
		return true;
	}

}
