package com.example;

/*
 * Copyright 2009 Cedric Priscal
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */


import android.util.Log;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {

	private static final String TAG = "SerialPort";

	/*
	 * Do not remove or rename the field mFd: it is used by native method close();
	 */
	private FileDescriptor mFd;
	private FileInputStream mFileInputStream;
	private FileOutputStream mFileOutputStream;
	private boolean trig_on=false;
	public SerialPort(int port, int baudrate, int flags) throws SecurityException, IOException {
		if(port <100)
		{
		mFd = open(port, baudrate);
		if (mFd == null) {
			Log.e(TAG, "native open returns null");
			throw new IOException();
		}
		mFileInputStream = new FileInputStream(mFd);
		mFileOutputStream = new FileOutputStream(mFd);
		}

	}
	public SerialPort() {
		// TODO Auto-generated constructor stub
	}
	public void SerialPort_close(int fd)
    {
    	close(fd);
    }
	// Getters and setters
	public InputStream getInputStream() {
		return mFileInputStream;
	}

	public OutputStream getOutputStream() {
		return mFileOutputStream;
	}

	public void scaner_poweron() {
		scanerpoweron();
		scaner_trigoff();
	}
	public void scaner_poweroff() {
		scanerpoweroff();
		//scaner_trigoff();
	}
	public void scaner_trigon() {
		scanertrigeron();
		trig_on=true;
	}
	public void scaner_trigoff() {
		scanertrigeroff();
		trig_on=false;
	}
	
	public boolean scaner_trig_stat(){
		return trig_on;
	}

	public void string_inject(String str) {
		stringinject(str);
	}
	private native static FileDescriptor open(int port, int baudrate);
	public native void close(int port);
	public native void zigbeepoweron();
	public native void scanerpoweron();
	public native void scanerpoweroff();
	public native void scanertrigeron();
	public native void scanertrigeroff();
	public native void stringinject(String jstr);
	static {
		System.loadLibrary("devapi");
		System.loadLibrary("SerialPort");
	}
	
}
