/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.b;
import com.rscja.deviceapi.entity.ISO15693Entity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.RFIDNotFoundException;
import com.rscja.deviceapi.exception.RFIDReadFailureException;
import com.rscja.utility.StringUtility;

public class RFIDWithISO15693
extends b {
    private static RFIDWithISO15693 a = null;

    protected RFIDWithISO15693() throws ConfigurationException {
    }

    public static synchronized RFIDWithISO15693 getInstance() throws ConfigurationException {
        if (a == null) {
            a = new RFIDWithISO15693();
        }
        return a;
    }

    public synchronized ISO15693Entity inventory() {
        Object object = this.getDeviceAPI().ISO15693_inventory(1, 0);
        if (object[0] != '\u0000') {
            Log.e((String)"RFIDWithISO15693", (String)("inventory() err:" + Character.digit(object[0], 10)));
            return null;
        }
        char[] cArray = new char[8];
        int n = 0;
        while (n < 8) {
            cArray[n] = object[n + 4];
            ++n;
        }
        String string = "";
        if (((char[])object).length > 10) {
            switch (object[10]) {
                case '\u0004': {
                    string = TagType.ICODE2.toString();
                    break;
                }
                case '\u0007': {
                    string = TagType.TI2048.toString();
                    break;
                }
                case '\u0002': {
                    string = TagType.STLRIS64K.toString();
                }
            }
        }
        object = new char[8];
        int n2 = 0;
        while (n2 < 8) {
            object[n2] = cArray[7 - n2];
            ++n2;
        }
        ISO15693Entity iSO15693Entity = new ISO15693Entity(StringUtility.chars2HexString(object, 8), string, cArray);
        object = iSO15693Entity;
        char[] cArray2 = iSO15693Entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_getSystemInformation(8, cArray, 0) : this.getDeviceAPI().ISO15693_getSystemInformation(0, cArray, 0);
        if (cArray2[0] == '\u0000' && cArray2[1] > '\f') {
            object.setAFI(StringUtility.char2HexString(cArray2[12]));
            object.setDESFID(StringUtility.char2HexString(cArray2[11]));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized ISO15693Entity read(int block) throws RFIDReadFailureException {
        void var1_1;
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            return null;
        }
        char[] cArray = iSO15693Entity.getOriginalUID();
        char[] cArray2 = iSO15693Entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_read_sm(8, cArray, cArray.length, block, 1) : this.getDeviceAPI().ISO15693_read_sm(0, cArray, cArray.length, (int)var1_1, 1);
        if (cArray2[0] != '\u0000') {
            Log.e((String)"RFIDWithISO15693", (String)("read() err:" + cArray2[0]));
            throw new RFIDReadFailureException();
        }
        cArray = new char[cArray2[1]];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = cArray2[n + 2];
            ++n;
        }
        iSO15693Entity.setData(StringUtility.chars2HexString(cArray, cArray.length));
        return iSO15693Entity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean write(int block, String hexData) throws RFIDNotFoundException {
        int n;
        int n2;
        char[] cArray;
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            throw new RFIDNotFoundException();
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        char[] cArray2 = new char[4];
        if (cArray.length >= 4) {
            n2 = 0;
            while (n2 < 4) {
                cArray2[n2] = cArray[n2];
                ++n2;
            }
        } else {
            n2 = 4 - cArray.length;
            n = 0;
            while (n < cArray.length) {
                cArray2[n + n2] = cArray[n];
                ++n;
            }
        }
        char[] cArray3 = iSO15693Entity.getOriginalUID();
        n = -1;
        if (iSO15693Entity.getType().equals(TagType.ICODE2.toString())) {
            n = this.getDeviceAPI().ISO15693_write_sm(0, cArray3, 0, block, 1, cArray2, cArray2.length);
        } else if (iSO15693Entity.getType().equals(TagType.TI2048.toString())) {
            n = this.getDeviceAPI().ISO15693_write_sm(4, cArray3, 0, block, 1, cArray2, cArray2.length);
        } else if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
            void var1_1;
            n = this.getDeviceAPI().ISO15693_write_sm(8, cArray3, 0, (int)var1_1, 1, cArray2, cArray2.length);
        }
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO15693", (String)("write() err:" + n));
        return false;
    }

    public synchronized boolean writeAFI(int iAFI) throws RFIDNotFoundException {
        int n;
        char[] cArray = new char[1];
        n = Integer.parseInt(String.valueOf(n), 16);
        int n2 = -1;
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            throw new RFIDNotFoundException();
        }
        if (iSO15693Entity.getType().equals(TagType.ICODE2.toString())) {
            n2 = this.getDeviceAPI().ISO15693_writeAFI(0, cArray, 0, n);
        } else if (iSO15693Entity.getType().equals(TagType.TI2048.toString())) {
            n2 = this.getDeviceAPI().ISO15693_writeAFI(4, cArray, 0, n);
        } else if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
            n2 = this.getDeviceAPI().ISO15693_writeAFI(0, cArray, 0, n);
        }
        if (n2 == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO15693", (String)("writeAFI() err:" + n2));
        return false;
    }

    public synchronized boolean lockAFI() throws RFIDNotFoundException {
        Object object = this.inventory();
        if (object == null) {
            throw new RFIDNotFoundException();
        }
        object = new char[1];
        int n = this.getDeviceAPI().ISO15693_lockAFI(0, (char[])object, 0);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO15693", (String)("LockAFI() err:" + n));
        return false;
    }

    public synchronized boolean writeDSFID(int iDSFID) throws RFIDNotFoundException {
        int n;
        char[] cArray = new char[1];
        n = Integer.parseInt(String.valueOf(n), 16);
        int n2 = -1;
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            throw new RFIDNotFoundException();
        }
        if (iSO15693Entity.getType().equals(TagType.ICODE2.toString())) {
            n2 = this.getDeviceAPI().ISO15693_writeDSFID(0, cArray, 0, n);
        } else if (iSO15693Entity.getType().equals(TagType.TI2048.toString())) {
            n2 = this.getDeviceAPI().ISO15693_writeDSFID(4, cArray, 0, n);
        } else if (iSO15693Entity.getType().equals(TagType.STLRIS64K.toString())) {
            n2 = this.getDeviceAPI().ISO15693_writeDSFID(0, cArray, 0, n);
        }
        if (n2 == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO15693", (String)("writeDSFID() err:" + n2));
        return false;
    }

    public synchronized boolean lockDSFID() throws RFIDNotFoundException {
        char[] cArray = new char[1];
        ISO15693Entity iSO15693Entity = this.inventory();
        if (iSO15693Entity == null) {
            throw new RFIDNotFoundException();
        }
        iSO15693Entity.getType().equals(TagType.STLRIS64K.toString());
        int n = this.getDeviceAPI().ISO15693_lockDSFID(0, cArray, 0);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO15693", (String)("LockDSFID() err:" + n));
        return false;
    }

    public static /* bridge */ /* synthetic */ b getInstance() throws ConfigurationException {
        return RFIDWithISO15693.getInstance();
    }

    public static enum TagType {
        ICODE2(0),
        TI2048(4),
        STLRIS64K(8),
        NUll_(100);

        private final int a;

        public final int getValue() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        private TagType(int value) {
            void var3_3;
            this.a = var3_3;
        }
    }
}

