/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.UHF;

import cn.pda.serialport.SerialPort;
import com.handheld.UHF.CommendManager;
import com.handheld.UHF.NewSendCommendManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class UhfManager
implements CommendManager {
    public static int RESERVE = 0;
    public static int EPC = 1;
    public static int TID = 2;
    public static int USER = 3;
    public static int WorkArea_China2 = 1;
    public static int WorkArea_USA = 2;
    public static int WorkArea_Europe = 3;
    public static int WorkArea_China1 = 4;
    public static int WorkArea_Korea = 6;
    public static final int SENSITIVE_HIHG = 3;
    public static final int SENSITIVE_MIDDLE = 2;
    public static final int SENSITIVE_LOW = 1;
    public static final int SENSITIVE_VERY_LOW = 0;
    private static NewSendCommendManager manager;
    private static SerialPort serialPort;
    public static int Port;
    public static int Power;
    public static int BaudRate;
    private static InputStream is;
    private static OutputStream os;
    private static UhfManager reader;

    static {
        Port = 12;
        Power = 4;
        BaudRate = 115200;
    }

    public static UhfManager getInstance() {
        try {
            serialPort = new SerialPort(Port, BaudRate, 0);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        switch (Power) {
            case 2: {
                serialPort.scaner_poweron();
                break;
            }
            case 0: {
                serialPort.power_3v3on();
                break;
            }
            case 1: {
                serialPort.power_5Von();
                break;
            }
            case 3: {
                serialPort.psam_poweron();
                break;
            }
            case 4: {
                serialPort.rfid_poweron();
            }
        }
        is = serialPort.getInputStream();
        os = serialPort.getOutputStream();
        manager = new NewSendCommendManager(is, os);
        if (reader == null) {
            reader = new UhfManager();
        }
        return reader;
    }

    @Override
    public boolean setBaudrate() {
        return manager.setBaudrate();
    }

    @Override
    public byte[] getFirmware() {
        return manager.getFirmware();
    }

    @Override
    public boolean setOutputPower(int value) {
        return manager.setOutputPower(value);
    }

    @Override
    public List<byte[]> inventoryRealTime() {
        return manager.inventoryRealTime();
    }

    @Override
    public void selectEPC(byte[] epc) {
        manager.selectEPC(epc);
    }

    @Override
    public byte[] readFrom6C(int memBank, int startAddr, int length, byte[] accessPassword) {
        return manager.readFrom6C(memBank, startAddr, length, accessPassword);
    }

    @Override
    public boolean writeTo6C(byte[] password, int memBank, int startAddr, int dataLen, byte[] data) {
        return manager.writeTo6C(password, memBank, startAddr, dataLen, data);
    }

    @Override
    public void setSensitivity(int value) {
        manager.setSensitivity(value);
    }

    @Override
    public boolean lock6C(byte[] password, int memBank, int lockType) {
        return manager.lock6C(password, memBank, lockType);
    }

    @Override
    public void close() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
        if (serialPort != null) {
            switch (Power) {
                case 2: {
                    serialPort.scaner_poweroff();
                    break;
                }
                case 0: {
                    serialPort.power3v3off();
                    break;
                }
                case 1: {
                    serialPort.power_5Voff();
                    break;
                }
                case 3: {
                    serialPort.psam_poweroff();
                    break;
                }
                case 4: {
                    serialPort.rfid_poweroff();
                }
            }
            serialPort.close(Port);
            serialPort = null;
        }
        if (reader != null) {
            reader = null;
        }
    }

    @Override
    public byte checkSum(byte[] data) {
        return manager.checkSum(data);
    }

    @Override
    public int setFrequency(int startFrequency, int freqSpace, int freqQuality) {
        return manager.setFrequency(startFrequency, freqSpace, freqQuality);
    }

    public int setWorkArea(int area) {
        return manager.setWorkArea(area);
    }

    public List<byte[]> inventoryMulti() {
        return manager.inventoryMulti();
    }

    public void stopInventoryMulti() {
        manager.stopInventoryMulti();
    }

    public int getFrequency() {
        return manager.getFrequency();
    }

    public int unSelect() {
        return manager.unSelectEPC();
    }

    public void setRecvParam(int mixer_g, int if_g, int trd) {
        manager.setRecvParam(mixer_g, if_g, trd);
    }
}

