package com.scan.service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;

import com.hsm.barcode.DecodeResult;
import com.hsm.barcode.Decoder;
import com.hsm.barcode.DecoderConfigValues.SymbologyID;
import com.hsm.barcode.DecoderException;
import com.hsm.barcode.SymbologyConfig;
import com.scan.service.config.ScanConfig;
import com.scan.service.util.Tools;
import com.scan.service.util.Util;

public class ScanService extends Service {
	
	private static final int INIT_OK = 1 ;
	private static final int  INIT_FAIL = -1 ;
	
	private Decoder mDecoder ;  // scan inital
	private DecodeResult mDecodeResult;  //scan result
	
	private String TAG = "ScanService"; //DEBUG
	
	private String charSetName = "utf-8";
	
	private boolean running = false ;// scaner open flag
	
	
	private KillReceiver killReceiver ;//广播接受者用于接受打开和关闭的广播
	
//	private SwicthMethod swM ;//切换输入法
	
	public static final  String ACTION_CLOSE_SCAN = "colseScan";
	
	public static final  String ACTION_START_SCAN = "startScan";
	
	private final int MSG_SCAN = 1009 ;
	
	private boolean othreRequest = false ; //是否有其他程序请求服务
	private ScanConfig scanConfig ;
	private String prefixStr ;
	private String surfixStr ;
	
	private String result = "" ;
	
	private Handler mHandler = new Handler(){
		public void handleMessage(android.os.Message msg) {
			prefixStr = scanConfig.getPrefix() ;
			surfixStr = scanConfig.getSurfix() ;
			if(msg.what == MSG_SCAN){
				
					//input prefix
					sendToInput(prefixStr, false) ;
					/*pang 20160905
					if("\r\n".equals(prefixStr)){
						sendToInput("", true) ;
					}else{
						sendToInput(prefixStr, false) ;
					}
					*/
					//input barcode
					sendToInput(result, false) ;
					//input prefix
					/*
					if("\r\n".equals(surfixStr)){
						sendToInput("", true) ;
					}else{
						sendToInput(surfixStr, false) ;
					}
					*/
					Log.e("surfix -- ", "tab = " + scanConfig.isTab() + ";  enter = " + scanConfig.isEnter() );
					sendToInput(surfixStr, false) ;
					//add tab or enter
					if(scanConfig.isTab()){
						sendToInput("\t", false) ;
					}
					if(scanConfig.isEnter()){
						sendToInput("", true) ;
					}
					if(scanConfig.isVoice()){
					Util.play(1, 0) ;
					}
			}
			
		};
	};

	
	private void sendToInput(String data , boolean enterFlag){
		Intent toBack = new Intent() ;
		toBack.setAction("android.rfid.INPUT") ;
		toBack.putExtra("data", data ) ;
		toBack.putExtra("enter", enterFlag) ;
		sendBroadcast(toBack) ;
	}
	
	
	@Override
	public IBinder onBind(Intent intent) {
		othreRequest = true ; 
		return aidlScan;
	}
	
	
	private boolean isOpen ;
	@Override
	public void onCreate() {
//		config = new Config(this);
		//注册广播接受者
		scanConfig = new ScanConfig(this) ;
		killReceiver  = new KillReceiver();
		IntentFilter filter = new IntentFilter();
		filter.addAction(ACTION_CLOSE_SCAN);
		filter.addAction(ACTION_START_SCAN);
		registerReceiver(killReceiver, filter);
		super.onCreate();
	}
	
	@Override
	public void unbindService(ServiceConnection conn) {
		othreRequest = false ; 
		super.unbindService(conn);
	}
	
	@Override
	public void onDestroy() {
		if(killReceiver != null){
			unregisterReceiver(killReceiver);
		}
	
		super.onDestroy();
	}
	
	private long startTime = 0L;
	

	
	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		//如果有其他程序请求则不启动服务
		if(!othreRequest){
			synchronized (aidlScan) {
				try{
					if(!running){
//						swM.getDefualtInputM() ;//获取默认输入法
						running = true ;
						scanning = false ;
						aidlScan.init();
						aidlScan.setOnResultListener(new IScanResult() {
							
							@Override
							public IBinder asBinder() {
								// TODO Auto-generated method stub
								return null;
							}
							
							@Override
							public void onListener(String barcode)
									throws RemoteException {
								result = barcode ;
								Message msg = new Message() ;
								msg.what = MSG_SCAN ;
								Bundle bundle = new Bundle() ;
								bundle.putString("data", result) ;
								msg.setData(bundle) ;
								mHandler.sendMessage(msg) ;
							}
						});
					}else{
						//200ms内的操作不做处理
						startTime = System.currentTimeMillis();
						aidlScan.scan();	
//						}

					}
					}catch(Exception e){
						
					}
			}

		}

		return super.onStartCommand(intent, flags, startId);
	}
	
	private  AidlIscan aidlScan = new AidlIscan();
	
	private boolean scanning = false ;
	//远程调用接口
	class AidlIscan extends IScan.Stub{
		private IScanResult iResultLister ;
		
		private Thread scanThread = null ;//扫描线程
		
		private Runnable scanRun = new Runnable() {
			
			@Override
			public synchronized void run() {
				if(mDecoder != null){
					scanning = true ;
					try {//ɨ��
						boolean is = mDecoder.callbackKeepGoing();
//						LogUtil.LogE("callbackKeepGoing", "" + is);
						Thread.sleep(50) ;
						//扫描，超时为5秒
//						mDecoder.waitForDecodeTwo(5000, mDecodeResult);
						mDecoder.waitForDecode(5000) ;
						if(mDecoder.getBarcodeData() != null && mDecoder.getBarcodeLength() > 0){
							//获取最后一张图片并保存
//							getLastImg() ;
							//�ص�
							if(iResultLister != null){
								Log.e("barcode", "barcode = " + mDecoder.getBarcodeData() );
								//HEX
								byte[] barCode = mDecoder.getBarcodeByteData() ;
								String bar = Tools.Bytes2HexString(barCode, barCode.length)  ;
								//正常
								bar = new String(barCode) ;
								//将结果回调
								iResultLister.onListener(bar);
								
							}
//							scanning = false ;
						}
						//减慢速度
						Thread.sleep(50) ;
						scanning = false ;
					} catch (DecoderException e) {
//						swM.retoreMethod();
						//出现异常停止扫描
						try {
							Thread.sleep(100) ;
						} catch (InterruptedException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
						e.printStackTrace();
						
						scanning = false ;
					} catch (RemoteException e) {
						//输入法恢复
//						swM.retoreMethod();
						scanning = false ;
//						LogUtil.SaveException("scan()", e.toString()) ;
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				
			}
		};
		@Override//初始化
		public int init() throws RemoteException {
			mDecoder = new Decoder();
			mDecodeResult = new DecodeResult();
			try {
				mDecoder.connectDecoderLibrary();
				//打开所有码制,(只打开QR码)
				mDecoder.enableSymbology(SymbologyID.SYM_ALL);
				
//				mDecoder.enableSymbology(SymbologyID.SYM_QR);
//				mDecoder.enableSymbology(SymbologyID.SYM_PDF417);
//				mDecoder.enableSymbology(SymbologyID.SYM_EAN13);
//				mDecoder.enableSymbology(SymbologyID.SYM_CODE128) ;
				
//				mDecoder.enableSymbology(SymbologyID.SYM_DATAMATRIX);
//				mDecoder.enableSymbology(SymbologyID.SYM_UPCA);
//				mDecoder.enableSymbology(SymbologyID.SYM_CHINAPOST);
				
//				mDecoder.enableSymbology(SymbologyID.SYM_CODE39);
//				mDecoder.enableSymbology(SymbologyID.SYM_CODE128);
//				mDecoder.enableSymbology(SymbologyID.SYM_EAN8);
//				mDecoder.enableSymbology(SymbologyID.SYM_CODE32);
				//打开EAN13码校验
				SymbologyConfig config = new SymbologyConfig(SymbologyID.SYM_EAN13);
				config.Flags = 5 ;
				config.Mask = 1 ;
				mDecoder.setSymbologyConfig(config);
//				//设置解码窗口模式
//				mDecoder.setDecodeWindowMode(DecodeWindowShowWindow.DECODE_WINDOW_SHOW_WINDOW_WHITE) ;
//				//设置灯光模式
//				mDecoder.setLightsMode(LightsMode.ILLUM_AIM_ON);
				try {
					mDecoder.startScanning();
					Thread.sleep(50);
					mDecoder.stopScanning();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
//					LogUtil.SaveException("scan()", e.toString()) ;
				}

			} catch (DecoderException e) {
//				LogUtil.SaveException("init()", e.toString()) ;
				e.printStackTrace();
				return INIT_FAIL;
			}
			return INIT_OK;
		}

		
		@Override
		public void close() throws RemoteException {
			running = false ;
			if(mDecoder != null){
				try {
					mDecoder.disconnectDecoderLibrary();
					mDecoder = null ;
				} catch (DecoderException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
//					LogUtil.SaveException("close()", e.toString()) ;
				}
			}
			
		}

		@Override
		public void scan() throws RemoteException {
//			mDecoder.
			if(!scanning){
				if(scanThread != null ){
					//线程不为null强制中断
					scanThread.interrupt() ;
					scanThread = null ;
				}
				//创建单线程
				scanThread = new Thread(scanRun);
				scanThread.start() ;
			}
			
		}

		@Override
		public void setOnResultListener(IScanResult iLister)
				throws RemoteException {
			
			iResultLister = iLister;
		}

		@Override
		public void setChar(String charSetName) throws RemoteException {
			ScanService.this.charSetName = charSetName ;
			
		}
		
	}
	
	boolean isOpening = false ;// 如果程序正在打开，则不能马上关闭
	/**
	 * 用于接收关闭信息
	 * @author pang
	 *
	 */
	private class KillReceiver extends BroadcastReceiver{

		@Override
		public void onReceive(Context context, Intent intent) {
//			Log.e("KillReceiver", "KillReceiver ");
			try{
			if(intent.getAction().equals(ACTION_CLOSE_SCAN)){
//				Log.e("KillReceiver", "KillReceiver=== CLOSE");
				if(aidlScan != null){
						aidlScan.close();
						running = false ;
				}
			}
			} catch (RemoteException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
//				LogUtil.SaveException("KillReceiver()", e.toString()) ;
			}
			
		}
		
	}
	

}
