package com.scan.service;

import java.io.IOException;

import com.scan.service.config.ScanConfig;
import com.scan.service.util.Util;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import cn.pda.scan.ScanThread;

public class Scan1DService extends Service {
	
	private ScanThread scan = null;
	
	private ScanConfig scanConfig ;
	private String prefixStr ;
	private String surfixStr ;
	
	private Handler mHandler = new Handler(){
		public void handleMessage(android.os.Message msg) {
			prefixStr = scanConfig.getPrefix() ;
			surfixStr = scanConfig.getSurfix() ;
			if(msg.what == ScanThread.SCAN){
				String data = msg.getData().getString("data");
				Log.e(TAG, data) ;
				//input prefix
				sendToInput(prefixStr, false) ;
//				if("\r\n".equals(prefixStr)){
//					sendToInput("", true) ;
//				}else{
//					sendToInput(prefixStr, false) ;
//				}
				//input barcode
				sendToInput(data, false) ;
				//input prefix
//				if("\r\n".equals(surfixStr)){
//					sendToInput("", true) ;
//				}else{
//					sendToInput(surfixStr, false) ;
//				}
				
				sendToInput(surfixStr, false) ;
				
				Log.e("surfix -- ", "tab = " + scanConfig.isTab() + ";  enter = " + scanConfig.isEnter() );
				sendToInput(surfixStr, false) ;
				//add tab or enter
				if(scanConfig.isTab()){
					sendToInput("\t", false) ;
				}
				if(scanConfig.isEnter()){
					sendToInput("", true) ;
				}
				if(scanConfig.isVoice()){
					Util.play(1, 0) ;
				}
			}
		};
	};

	private String TAG = "Scan1DService" ;
	

	@Override
	public IBinder onBind(Intent intent) {
		
		return null;
	}
	
	@Override
	public void onCreate() {
		scanConfig = new ScanConfig(this) ;
		Util.initSoundPool(this) ;
		IntentFilter filter = new IntentFilter() ;
		filter.addAction("android.rfid.KILL_SERVER") ;
		registerReceiver(killReceiver, filter) ;
		super.onCreate();
	}
	
	@Override
	public void onDestroy() {
		unregisterReceiver(killReceiver) ;
		super.onDestroy();
	}
	
	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		Log.e(TAG, "+++ onstart command++++") ;
		if(scan == null){
			try {
				scan = new ScanThread(mHandler) ;
				scan.start();
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else{
			scan.scan() ;
		}
		return super.onStartCommand(intent, flags, startId);
	}
	
	
	private void sendToInput(String data , boolean enterFlag){
		Intent toBack = new Intent() ;
		toBack.setAction("android.rfid.INPUT") ;
		toBack.putExtra("data", data ) ;
		toBack.putExtra("enter", enterFlag) ;
		sendBroadcast(toBack) ;
	}
	
	
	private BroadcastReceiver killReceiver = new BroadcastReceiver() {
		
		@Override
		public void onReceive(Context context, Intent intent) {
			if(intent.getBooleanExtra("kill", false)){
				if(scan != null){
					scan.close() ;
					scan = null ;
				}
				Scan1DService.this.stopSelf() ;
			}
		}
	};

}
